﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using BTS.Backlog;

namespace ExcelBacklogAddIn
{
    public partial class FormSelectProject : Form
    {
        public int SelectedIndex
        {
            get
            {
                return comboBoxSelectProject.SelectedIndex;
            }
        }

        public FormSelectProject( SelectProject selectProject )
        {
            InitializeComponent();

            foreach ( Project project in selectProject.ProjectList ) {
                comboBoxSelectProject.Items.Add( project.Name );
            }

            comboBoxSelectProject.SelectedIndex = selectProject.SelectedIndex;
        }

        private void buttonOK_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }

    public class SelectProject
    {
        public Project[] ProjectList
        {
            get;
            set;
        }

        public int SelectedIndex
        {
            get;
            set;
        }

        public SelectProject( List<Project> projectList, int selectedIndex )
        {
            ProjectList = new Project[projectList.Count];
            for ( int i = 0; i < ProjectList.Length; ++i ) {
                ProjectList[i] = projectList[i];
            }

            SelectedIndex = selectedIndex;
        }
    }
}
