﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class 課題のテスト
    {
        Project project;

        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
            Backlog.Connect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
            project = new Project( プロジェクト情報.デフォルトプロジェクトID );
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
            Backlog.Close();
        }

        [SetUp]
        public void SetUp()
        {
        }

        [TearDown]
        public void TearDown()
        {
        }

        [Test]
        public void 全ての課題が取得できる()
        {
            List<Issue> issues = project.GetIssues();

            Assert.AreEqual( issues.Count, project.CountIssue() );
        }

        [Test]
        public void 課題が登録できること()
        {
            Issue issue = new Issue();
            issue.Summary = "単体テストで登録テスト";
            issue.Priority = "高";
            issue.Component = new string[] { "２つめのカテゴリー" };
            issue.Version = new string[] { "Webで追加したバージョン" };
            issue.Milestone = new string[] { "Webで追加したバージョン", "Webで追加したマイルストーン" };
            issue.ResolutionId = 2;

            Issue createdIssue = project.CreateIssue( issue );

            Assert.AreEqual( createdIssue.Summary, issue.Summary );
        }

        [Test]
        public void 間違ったカテゴリーで課題を登録すると登録できるがカテゴリーは反映されない()
        {
            Issue issue = new Issue();
            issue.Summary = "単体テストで登録テスト";
            issue.Component = new string[] { "存在しないカテゴリー" };

            Issue createdIssue = project.CreateIssue( issue );

            Assert.AreEqual( createdIssue.Summary, issue.Summary );
        }

        [Test]
        public void 課題が変更できること()
        {
            Issue issue = project.GetIssues()[0];
            issue.Description += "単体テストで変更テスト\n";

            issue.Update( "こめんと" );

            Issue updatedIssue = new Issue( issue.Id );

            Assert.AreEqual( updatedIssue.Description, issue.Description );
        }
    }
}
