#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <signal.h>
#include "client.h"

void	exit (int status);


char	destination[] = {"auth.d-star.info"};
int	dstSocket;
int	udpSocket;
struct	sockaddr_in	udpAddr;

void CloseSocket()
{
        if(dstSocket!=0){
                close(dstSocket);
                dstSocket=0;
        }
        exit(0);
}

void	test_loop(void)
{
	int	n;
	char	buf[100];
	memset (buf, 0x20, 100);

	for (n = 0 ; n < 100 ; n++)
	{
		sprintf (buf, "TEST %d",n);
                sendto (udpSocket, buf, 100, 0,
                	(struct sockaddr *)&udpAddr, sizeof(udpAddr));
		usleep(20000);
	}
        sendto (udpSocket, "end       ", 10, 0,
		(struct sockaddr *)&udpAddr, sizeof(udpAddr));
}

void	test_loop_recv(void)
{
	char	buf[100];
	int	length;

	while (1)
	{
		length = sizeof(struct sockaddr_in);
		recvfrom (udpSocket, buf, 100, 0, (struct sockaddr *)&udpAddr, &length);
		printf ("%10.10s\n",buf);
		if (memcmp(buf, "end       ",10) == 0) break; 
	}
}

int main(int argc, const char **argv){

        int     ret;
        int     width;
        int     n;
	int	k;
	unsigned int	Port;
        fd_set  readOk,Mask;
        struct  timeval timeout;

	// IP アドレス，ソケット，sockaddr_in 構造体
	struct sockaddr_in dstAddr;
	struct	repMsg	reqConMsg;

	//struct sockaddr_in addr;
 	struct hostent *hp;
  	char   buf[256];
	int    numrcv;

        signal(SIGINT,CloseSocket);
        signal(SIGTERM,CloseSocket);

	config (argc, (char **)argv);

	//sockaddr_in 構造体のセット
	bzero((char *)&dstAddr, sizeof(dstAddr));
	dstAddr.sin_family = AF_INET;
	dstAddr.sin_port = htons(trust_port);
  
	hp = gethostbyname(destination);
	bcopy(hp->h_addr, &dstAddr.sin_addr, hp->h_length);

	//ソケットの生成
	dstSocket = socket(AF_INET, SOCK_STREAM, 0);
	udpSocket = socket(AF_INET, SOCK_DGRAM, 0);

	//接続
	if (connect(dstSocket, (struct sockaddr *)&dstAddr, sizeof(dstAddr)) < 0){
	printf("%s に接続できませんでした\n",destination);
	return(-1);
	}

	printf("%s に接続しました\n",destination);

	//パケットの受信
	numrcv = recv(dstSocket, buf, 255, 0);
	buf[numrcv] = 0x00;
	printf("%s",buf);

	//コールサインの送信
	for (n = 0 ; n < 8 ; n++)
	{
		client_call[n] = toupper (client_call[n]);
	}
	send (dstSocket, client_call, 8, 0);

        //パケットの受信
        numrcv = recv(dstSocket, buf,  255, 0);
        buf[numrcv] = 0x00;
	printf ("%s",buf);

        //パスワードの送信
        send (dstSocket, client_password, strlen(client_password), 0);

        //ポート番号リクエスト　パケットの受信
        numrcv = recv(dstSocket, buf, 255, 0);
        buf[numrcv] = 0x00;
        printf("%s",buf);

	sprintf (buf, "%0d\0", client_port);
	//ポート番号の送信
        send (dstSocket, buf, strlen(buf), 0);

        memset (&udpAddr, 0, sizeof(struct sockaddr_in));
        udpAddr.sin_family = AF_INET;
        udpAddr.sin_port = htons(client_port);
        udpAddr.sin_addr.s_addr = htonl(INADDR_ANY);
        ret = bind(udpSocket, (struct sockaddr *)&udpAddr, sizeof(udpAddr));

        FD_ZERO(&Mask);
        FD_SET(dstSocket,&Mask);
        FD_SET(0,&Mask);
        width = dstSocket + 1;

	while (1){
		readOk = Mask;
		timeout.tv_sec = 0;
		timeout.tv_usec = 500000;
		switch(select (width, (fd_set *)&readOk, NULL, NULL, &timeout))
		{
	
			case -1:
				break;
			case 0:
				break;
			default:
				if(FD_ISSET(dstSocket, &readOk))
				{
                        		//パケットの受信
                        		numrcv = recv(dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
					if (numrcv <= 0)
                                        {
                                                reqConMsg.reqType = ReqEnd;
                                                send (dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
                                                close(dstSocket);
                                                return(0);
                                        }
                        		if (reqConMsg.reqType == Ack)
                        		{
                                		printf ("%2.2x %8.8s %s %d\n", 
							reqConMsg.reqType, reqConMsg.ackConnect.call, 
							inet_ntoa (reqConMsg.ackConnect.ip),
							reqConMsg.ackConnect.port);
						udpAddr.sin_addr = reqConMsg.ackConnect.ip;
						udpAddr.sin_port = htons(reqConMsg.ackConnect.port);
						udpAddr.sin_family = AF_INET;
						ret = sendto (udpSocket, "\0\0\0\0UDP hole punching SRC", 25, 0, 
							(struct sockaddr *)&udpAddr, sizeof(udpAddr));
                                                udpAddr.sin_addr = reqConMsg.ackConnect.ip;
                                                udpAddr.sin_port = htons(reqConMsg.ackConnect.port);
                                                udpAddr.sin_family = AF_INET;
                                                ret = sendto (udpSocket, "\0\0\0\0UDP hole punching SRC", 25, 0,
                                                        (struct sockaddr *)&udpAddr, sizeof(udpAddr));

						test_loop();
                        		}
                        		else if (reqConMsg.reqType == ReqConnect)
                        		{
                                		printf ("%2.2x %8.8s %s %d\n", reqConMsg.reqConnect.protocol, 
							reqConMsg.reqConnect.YourCall, 
							inet_ntoa(reqConMsg.reqConnect.ip),
							reqConMsg.reqConnect.port);
						udpAddr.sin_family = AF_INET;
						udpAddr.sin_port = htons(reqConMsg.reqConnect.port);
						udpAddr.sin_addr = reqConMsg.reqConnect.ip;
                                                sendto (udpSocket, "\0\0\0\0UDP hole punching DST", 25, 0,
                                                        (struct sockaddr *)&udpAddr, sizeof(udpAddr));
                                                udpAddr.sin_family = AF_INET;
                                                udpAddr.sin_port = htons(reqConMsg.reqConnect.port);
                                                udpAddr.sin_addr = reqConMsg.reqConnect.ip;
                                                sendto (udpSocket, "\0\0\0\0UDP hole punching DST", 25, 0,
                                                        (struct sockaddr *)&udpAddr, sizeof(udpAddr));
						test_loop_recv();
                        		}
				}
				else if(FD_ISSET(0, &readOk))
				{
                			fgets(buf, 255, stdin);
                			if (memcmp (buf, "end", 3) == 0)
					{
						reqConMsg.reqType = ReqEnd;
        					send (dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
        					close(dstSocket);
        					return(0);
					}
                			memcpy (reqConMsg.reqConnect.Rpt2Call, buf, 32);
                			reqConMsg.reqConnect.port =  Port;
                			reqConMsg.reqConnect.protocol = 0;
                			reqConMsg.reqType = 0;
		
                			//パケットの送信
                			send (dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
				}
				break;
		}
  	}
}


