/*

*/

/* reqType      */
#define         NoEntry         0x00
#define         ReqConnect      0x01
#define         Ack             0x02
#define         Nak             0x03            /* Busy */
#define         ReqEnd          0xff


/* protocol     */
#define         ICOM    0x00
#define         DPlus   0x01
#define         DCS     0x02
#define         G3      0x03    /* New System */


#define RespNULL        0x00
#define RespAck         0x03
#define RespBusy        0x02
#define RespNoRoute     0x01


/* reqType	*/
#define		NoEntry		0x00
#define		ReqConnect	0x01
#define		Ack		0x02
#define		Nak		0x03
#define		PortEntry	0x04
#define		ReqEnd		0xff


/* protocol	*/
#define		ICOM	0x00
#define		DPlus	0x01
#define		DCS	0x02

#define timercmp(a, b, CMP) \
 (((a)->tv_sec == (b)->tv_sec) ? \
  ((a)->tv_usec CMP (b)->tv_usec) : \
  ((a)->tv_sec CMP (b)->tv_sec))

#define timeradd(a, b, result) \
  do { \
    (result)->tv_sec = (a)->tv_sec + (b)->tv_sec; \
    (result)->tv_usec = (a)->tv_usec + (b)->tv_usec; \
    if ((result)->tv_usec >= 1000000) \
      { \
        ++(result)->tv_sec; \
        (result)->tv_usec -= 1000000; \
      } \
  } while (0)


struct	repMsg
{
	unsigned char		reqType;		/* 0x00: NoEntry     */
							/* 0x01: ReqConnect  */
							/* 0x02: Ack	     */
							/* 0x03: Nak	     */
							/* 0x04: PortEntry   */
							/* 0xff: ReqEnd      */
	union {
		struct
		{
        		char            protocol;       /* 0: ICOM   */
                      			                /* 1: DPlus  */
                                        		/* 2: DCS    */
                        char            Rpt2Call[8];
                        char            Rpt1Call[8];
                        char            YourCall[8];
                        char            MyCall[8];
			char		trustname[8];
			struct	in_addr	ip;
			in_port_t	port;
		} reqConnect;
		struct
		{
                        char            protocol;       /* 0: ICOM   */
                                                        /* 1: DPlus  */
                                                        /* 2: DCS    */
                        char            Rpt2Call[8];
                        char            Rpt1Call[8];
                        char            YourCall[8];
                        char            MyCall[8];
                        char            reserve[7];
			unsigned char	RespFlags;
                        struct  in_addr ip;
                        in_port_t       port;
		} ackConnect;
	};
};

struct packet{
        unsigned char   ID[4];                          /* DSVT */
        unsigned char   flags[2];
        unsigned char   reserve[2];
        struct
        {
                unsigned char   B_ID;                   /* 0x20 */
                unsigned char   DestID;                 /* 0x00 */
                unsigned char   SrcID;                  /* 0x01 */
                unsigned char   SrcTermID;              /* 0x02 */
                unsigned char   PacketID[2];
                unsigned char   seq;
        } B_header;
        union {
                        struct
			{
				unsigned char	flags[3];
				char		Rpt2Call[8];
				char		Rpt1Call[8];
				char		YourCall[8];
				char		MyCall[8];
				char		MyCall2[4];
				unsigned char	crc[2];
			} header;
                        char    voice[12];
                        char    lastframe[15];
        };
} ;


struct  {
        struct  in_addr ip;
        in_port_t       port;
        struct  packet  dv;
} RelayPacket;


unsigned int	trust_port;
unsigned int	db_port;
unsigned int	client_port;
char		client_call[8];
char		client_password[64];
char		TrustDomainName[128];
char		TrustDbDomainName[128];
char		CallerCall[8];
int		NakCount;


