/* Sega ST-V (Sega Titan Video)

built to run the rom test mode only, don't consider anything here too accurate ;-)
we only run 1 sh2, not both, vidhrdw is just made to display bios text, interrupts
are mostly not done, most smpc commands not done, no scu / dsp stuff, no sound, you
get the idea ;-) 40ghz pc recommended once driver is finished

any rom which has a non-plain loaded rom at 0x2200000 (or 0x2000000, i think it
recognises a cart at either) appears to fail its self check, reason unknown, the roms
are almost certainly not bad its a mystery.

this hardware comes above hell on the great list of hellish things as far as emulation goes anyway ;-)

Preliminary Memory map:
0x00000000, 0x0007ffff  BIOS ROM
0x00080000, 0x000fffff  Unused
0x00100000, 0x00100080  SMPC
0x00100080, 0x0017ffff  Unused
0x00180000, 0x0018ffff  Back Up Ram
0x00190000, 0x001fffff  Unused
0x00200000, 0x002fffff  Work Ram-L
0x00300000, 0x00ffffff  Unused
0x01000000, 0x01000003  MINIT
0x01000004, 0x017fffff  Unused
0x01800000, 0x01800003  SINIT
0x01800004, 0x01ffffff  Unused
0x02000000, 0x03ffffff  A-BUS CS0
0x04000000, 0x04ffffff  A-BUS CS1
0x05000000, 0x057fffff  A-BUS DUMMY
0x05800000, 0x058fffff  A-BUS CS2
0x05900000, 0x059fffff  Unused
0x05a00000, 0x05b00ee3  Sound Region
0x05b00ee4, 0x05bfffff  Unused
0x05c00000, 0x05cbffff  VDP 1
0x05cc0000, 0x05cfffff  Unused
0x05d00000, 0x05d00017  VDP 1 regs
0x05d00018, 0x05dfffff  Unused
0x05e00000, 0x05e7ffff  VDP2
0x05e80000, 0x05efffff  VDP2 Extra RAM,accessible thru the VRAMSZ register
0x05f00000, 0x05f00fff  VDP2 Color RAM
0x05f01000, 0x05f7ffff  Unused
0x05f80000  0x05f8011f  VDP2 regs
0x05f80120, 0x05fdffff  Unused
0x05fe0000, 0x05fe00cf  SCU regs
0x05fe00d0, 0x05ffffff  Unused
0x06000000, 0x060fffff  Work Ram-H
0x06100000, 0x07ffffff  Unused

*the unused locations aren't known if they are really unused or not,needs verification...

*/
/*
Current games status:
- Hanagumi Taisen Columns
\-Boots and graphics are mostly OK.Playable.

- Prikura Daisakusen
\-Boots OK and works OK,needs the Sound CPU kludge to bypass initial test.
  Seems playable if the sprites,tiles positioning and priority will be fixed.
  Update:there's currently a *strange* compile bug with this which causes the DMA
  to behave strangely,I believe it's something to do with the I/O...

- Shienryu
\-Boots OK,needs Sound CPU kludge to bypass initial test.
  Sprite list missing from VDP1 vram,dunno why.

- Power Instinct 3 - Groove on Fight
\-Needs sound CPU kludge to be triggered,but breaks soon after that with a credit 2 msg
  shown on screen and some random graphics at the top of the screen.Irq mask registers
  clears A-bus and SCSP irqs...

- Shanghai - The Great Wall
\-Hangs when executing his specific code due to M68000 issues.It puts a bitmap format in
VDP2 then it expect something on which we haven't investigated yet...
0609FADA: MOV.L   @R5,R2
0609FADC: MOV.W   @R2,R0 ;$25a00800,then $25a00810
0609FADE: EXTU.W  R0,R0
0609FAE0: TST     R0,R0
0609FAE2: BF      $0609FADA

- The others:
\-Some of them shows a Sega logo in the Gfx decode,then they hangs,maybe because they're
waiting a response from the slave cpu or an A-bus IRQ or both.Some of these games have an
IC13 rom,which fails the rom test because it's likely that it's mapped in a
non-straight way,the games that have one of them usually do their first load at $2061ffc
and this means that in the current rom loading they points to a 0xffff opcode
(only the first 0x40000 of rom seems valid code)...
*/

#include "driver.h"
#include "machine/eeprom.h"

extern data32_t* stv_vdp2_regs;
extern data32_t* stv_vdp2_vram;
extern data32_t* stv_vdp2_cram;

/**************************************************************************************/
/*to be added into a stv Header file,remember to remove all the static...*/

static data8_t *smpc_ram;
//static void stv_dump_ram(void);

static data32_t* stv_workram_l;
static data32_t* stv_workram_h;
static data32_t* stv_scu;
static data32_t* ioga;
static data16_t* scsp_regs;

int stv_vblank;
/*SMPC stuff*/

/*SCU stuff*/
static int 	  timer_0;				/* Counter for Timer 0 irq*/
/*Maybe add these in a struct...*/
static UINT32 scu_src_0,		/* Source DMA lv 0 address*/
			  scu_src_1,		/* lv 1*/
			  scu_src_2,		/* lv 2*/
			  scu_dst_0,		/* Destination DMA lv 0 address*/
			  scu_dst_1,		/* lv 1*/
			  scu_dst_2,		/* lv 2*/
			  scu_size_0,		/* Transfer DMA size lv 0*/
			  scu_size_1,		/* lv 1*/
			  scu_size_2,		/* lv 2*/
			  scu_src_add_0,	/* Source Addition for DMA lv 0*/
			  scu_src_add_1,	/* lv 1*/
			  scu_src_add_2,	/* lv 2*/
			  scu_dst_add_0,	/* Destination Addition for DMA lv 0*/
			  scu_dst_add_1,	/* lv 1*/
			  scu_dst_add_2;	/* lv 2*/
static void dma_direct_lv0(void);	/*DMA level 0 direct transfer function*/
static void dma_direct_lv1(void);   /*DMA level 1 direct transfer function*/
static void dma_direct_lv2(void);   /*DMA level 2 direct transfer function*/
static void dma_indirect_lv0(void); /*DMA level 0 indirect transfer function*/
static void dma_indirect_lv1(void); /*DMA level 1 indirect transfer function*/
static void dma_indirect_lv2(void); /*DMA level 2 indirect transfer function*/
/* SCSP stuff*/
static UINT8 SCSP_reset;

/*VDP1 stuff*/

/* SMPC
 System Manager and Peripheral Control

*/
/* SMPC Addresses

00
01 -w  Input Register 0 (IREG)
02
03 -w  Input Register 1
04
05 -w  Input Register 2
06
07 -w  Input Register 3
08
09 -w  Input Register 4
0a
0b -w  Input Register 5
0c
0d -w  Input Register 6
0e
0f
10
11
12
13
14
15
16
17
18
19
1a
1b
1c
1d
1e
1f -w  Command Register (COMREG)
20
21 r-  Output Register 0 (OREG)
22
23 r-  Output Register 1
24
25 r-  Output Register 2
26
27 r-  Output Register 3
28
29 r-  Output Register 4
2a
2b r-  Output Register 5
2c
2d r-  Output Register 6
2e
2f r-  Output Register 7
30
31 r-  Output Register 8
32
33 r-  Output Register 9
34
35 r-  Output Register 10
36
37 r-  Output Register 11
38
39 r-  Output Register 12
3a
3b r-  Output Register 13
3c
3d r-  Output Register 14
3e
3f r-  Output Register 15
40
41 r-  Output Register 16
42
43 r-  Output Register 17
44
45 r-  Output Register 18
46
47 r-  Output Register 19
48
49 r-  Output Register 20
4a
4b r-  Output Register 21
4c
4d r-  Output Register 22
4e
4f r-  Output Register 23
50
51 r-  Output Register 24
52
53 r-  Output Register 25
54
55 r-  Output Register 26
56
57 r-  Output Register 27
58
59 r-  Output Register 28
5a
5b r-  Output Register 29
5c
5d r-  Output Register 30
5e
5f r-  Output Register 31
60
61 r-  SR
62
63 rw  SF
64
65
66
67
68
69
6a
6b
6c
6d
6e
6f
70
71
72
73
74
75 rw PDR1
76
77 rw PDR2
78
79 -w DDR1
7a
7b -w DDR2
7c
7d -w IOSEL2/1
7e
7f -w EXLE2/1
*/
UINT8 IOSEL1;
UINT8 IOSEL2;
UINT8 EXLE1;
UINT8 EXLE2;
UINT8 PDR1;
UINT8 PDR2;

#define SH2_DIRECT_MODE_PORT_1 IOSEL1 = 1
#define SH2_DIRECT_MODE_PORT_2 IOSEL2 = 1
#define SMPC_CONTROL_MODE_PORT_1 IOSEL1 = 0
#define SMPC_CONTROL_MODE_PORT_2 IOSEL2 = 0

static UINT8 stv_SMPC_r8 (int offset)
{
//	logerror ("8-bit SMPC Read from Offset %02x Returns %02x\n", offset, smpc_ram[offset]);
	if (offset == 0x75)//PDR1 read
		return readinputport(0);

	if (offset == 0x77)//PDR2 read
		return readinputport(1);

	return smpc_ram[offset];
}

static void stv_SMPC_w8 (int offset, UINT8 data)
{
//	logerror ("8-bit SMPC Write to Offset %02x with Data %02x\n", offset, data);
	smpc_ram[offset] = data;

	if(offset == 0x75)
	{
		/*
			ACTIVE LOW
			bit 2(0x04) - EEPROM Chip enable
			bit 3(0x08) - EEPROM clock
			bit 4(0x10) - EEPROM data
		*/
		PDR1 = (data & 0x60);
	}

	if(offset == 0x77)
	{
		/*
			ACTIVE LOW
			bit 4(0x10) - Enable Sound System
		*/
		//usrintf_showmessage("PDR2 = %02x",smpc_ram[0x77]);
		if(!(smpc_ram[0x77] & 0x10))
		{
			logerror("SMPC: M68k on\n");
			cpu_set_reset_line(2, PULSE_LINE);
			cpu_set_halt_line(2, CLEAR_LINE);
		}
		else
		{
			logerror("SMPC: M68k off\n");
			cpu_set_halt_line(2, ASSERT_LINE);
		}

		PDR2 = (data & 0x60);
	}

	if(offset == 0x7d)
	{
		if(smpc_ram[0x7d] & 1)
			SH2_DIRECT_MODE_PORT_1;
		else
			SMPC_CONTROL_MODE_PORT_1;

		if(smpc_ram[0x7d] & 2)
			SH2_DIRECT_MODE_PORT_2;
		else
			SMPC_CONTROL_MODE_PORT_2;
	}

	if(offset == 0x7f)
	{
		//enable PAD irq & VDP2 external latch for port 1/2
		EXLE1 = smpc_ram[0x7f] & 1 ? 1 : 0;
		EXLE2 = smpc_ram[0x7f] & 2 ? 1 : 0;
	}

	if (offset == 0x1f)
	{
		switch (data)
		{
			case 0x00:
				logerror ("SMPC: Master ON\n");
				smpc_ram[0x5f]=0x00;
				break;
			//in theory 0x01 is for Master OFF,but obviously is not used.
			case 0x02:
				logerror ("SMPC: Slave ON\n");
				smpc_ram[0x5f]=0x02;
	//			cpu_set_halt_line(1,CLEAR_LINE);
				break;
			case 0x03:
				logerror ("SMPC: Slave OFF\n");
				smpc_ram[0x5f]=0x03;
				cpu_set_halt_line(1,ASSERT_LINE);
				break;
			case 0x06:
				logerror ("SMPC: Sound ON\n");
				/* wrong? */
				smpc_ram[0x5f]=0x06;
				cpu_set_reset_line(2, PULSE_LINE);
				cpu_set_halt_line(2, CLEAR_LINE);
				break;
			case 0x07:
				logerror ("SMPC: Sound OFF\n");
				smpc_ram[0x5f]=0x07;
				break;
			/*CD (SH-1) ON/OFF,guess that this is needed for Sports Fishing games...*/
			//case 0x08:
			//case 0x09:
			case 0x0d:
				logerror ("SMPC: System Reset\n");
				smpc_ram[0x5f]=0x0d;
				cpu_set_reset_line(0, PULSE_LINE);
				break;
			case 0x0e:
				logerror ("SMPC: Change Clock to 352\n");
				smpc_ram[0x5f]=0x0e;
				cpu_set_nmi_line(0,PULSE_LINE); // ff said this causes nmi, should we set a timer then nmi?
				break;
			case 0x0f:
				logerror ("SMPC: Change Clock to 320\n");
				smpc_ram[0x5f]=0x0f;
				cpu_set_nmi_line(0,PULSE_LINE); // ff said this causes nmi, should we set a timer then nmi?
				break;
			/*"Interrupt Back"*/
			case 0x10:
				logerror ("SMPC: Status Acquire\n");
				smpc_ram[0x5f]=0x10;
				/*This is for RTC,cartridge code and similar stuff...*/
				if(!(stv_scu[40] & 0x0080)) /*System Manager(SMPC) irq*/
					cpu_set_irq_line_and_vector(0, 8, HOLD_LINE , 0x47);
			break;
			/* RTC write*/
			case 0x16:
				logerror("SMPC: RTC write\n");
				smpc_ram[0x2f] = smpc_ram[0x0d];
				smpc_ram[0x2d] = smpc_ram[0x0b];
				smpc_ram[0x2b] = smpc_ram[0x09];
				smpc_ram[0x29] = smpc_ram[0x07];
				smpc_ram[0x27] = smpc_ram[0x05];
				smpc_ram[0x25] = smpc_ram[0x03];
				smpc_ram[0x23] = smpc_ram[0x01];
				smpc_ram[0x5f]=0x16;
			break;
			/* SMPC memory setting*/
			case 0x17:
				logerror ("SMPC: memory setting\n");
				smpc_ram[0x5f]=0x17;
			break;
			case 0x18:
				logerror ("SMPC: NMI request\n");
				smpc_ram[0x5f]=0x18;
				/*NMI is unconditionally requested for the Sound CPU?*/
				cpu_set_nmi_line(2,PULSE_LINE);
				break;
			case 0x19:
				logerror ("SMPC: NMI Enable\n");
				smpc_ram[0x5f]=0x19;
				SCSP_reset = 1;
				break;
			case 0x1a:
				logerror ("SMPC: NMI Disable\n");
				smpc_ram[0x5f]=0x1a;
				SCSP_reset = 0;
				break;
			//default:
			//	logerror ("SMPC: Unhandled Command %02x\n",data);
		}

		// we've processed the command, clear status flag
		smpc_ram[0x63] = 0x00;
		/*We have to simulate the timing of each command somehow...*/
	}
}


static READ32_HANDLER ( stv_SMPC_r32 )
{
	int byte = 0;
	int readdata = 0;
	/* registers are all byte accesses, convert here */
	offset = offset << 2; // multiply offset by 4

	if (!(mem_mask & 0xff000000))	{ byte = 0; readdata = stv_SMPC_r8(offset+byte) << 24; }
	if (!(mem_mask & 0x00ff0000))	{ byte = 1; readdata = stv_SMPC_r8(offset+byte) << 16; }
	if (!(mem_mask & 0x0000ff00))	{ byte = 2; readdata = stv_SMPC_r8(offset+byte) << 8;  }
	if (!(mem_mask & 0x000000ff))	{ byte = 3; readdata = stv_SMPC_r8(offset+byte) << 0;  }

	return readdata;
}


static WRITE32_HANDLER ( stv_SMPC_w32 )
{
	int byte = 0;
	int writedata = 0;
	/* registers are all byte accesses, convert here so we can use the data more easily later */
	offset = offset << 2; // multiply offset by 4

	if (!(mem_mask & 0xff000000))	{ byte = 0; writedata = data >> 24; }
	if (!(mem_mask & 0x00ff0000))	{ byte = 1; writedata = data >> 16; }
	if (!(mem_mask & 0x0000ff00))	{ byte = 2; writedata = data >> 8;  }
	if (!(mem_mask & 0x000000ff))	{ byte = 3; writedata = data >> 0;  }

	writedata &= 0xff;

	offset += byte;

	stv_SMPC_w8(offset,writedata);
}


/*
(Preliminary) explaination about this:
VBLANK-OUT is used at the start of the vblank period.It also sets the timer zero
variable to 0.
If the Timer Compare register is zero too,the Timer 0 irq is triggered.

HBLANK-IN is used at the end of each scanline except when in VBLANK-IN/OUT periods.

The timer 0 is also incremented by one at each HBLANK and checked with the value
of the Timer Compare register;if equal,the timer 0 irq is triggered here too.
Notice that the timer 0 compare register can be more than the VBLANK maximum range,in
this case the timer 0 irq is simply never triggered.This is a known Sega Saturn/ST-V "bug".

VBLANK-IN is used at the end of the vblank period.

SCU register[36] is the timer zero compare register.
SCU register[40] is for IRQ masking.
*/

/* to do, update bios idle skips so they work better with this arrangement.. */

static INTERRUPT_GEN( stv_interrupt )
{
	if(cpu_getiloops() == 224)
	{
		timer_0 = 0;
		if(timer_0 == (stv_scu[36] & 0x1ff))
		{
			if(!(stv_scu[40] & 8))/*Timer 0*/
			{
				cpu_set_irq_line_and_vector(0, 0xc, HOLD_LINE, 0x43 );
				return;
			}
		}


		if(!(stv_scu[40] & 2))/*VBLANK-OUT*/
		{
			cpu_set_irq_line_and_vector(0, 0xe, HOLD_LINE , 0x41);
			stv_vblank = 0;
		}

	}
	else if(cpu_getiloops() <= 223 && cpu_getiloops() >= 1)/*Correct?*/
	{
		timer_0++;
		if(timer_0 == (stv_scu[36] & 0x1ff))
		{
			if(!(stv_scu[40] & 8))/*Timer 0*/
			{
				cpu_set_irq_line_and_vector(0, 0xc, HOLD_LINE, 0x43 );
				return;
			}
		}

		/*TODO:use this *at the end* of the draw line.*/
		if(!(stv_scu[40] & 4))/*HBLANK-IN*/
			cpu_set_irq_line_and_vector(0, 0xd, HOLD_LINE , 0x42);
	}
	else if(cpu_getiloops() == 0)
	{
		if(!(stv_scu[40] & 1))/*VBLANK-IN*/
		{
			cpu_set_irq_line_and_vector(0, 0xf, HOLD_LINE , 0x40);
			stv_vblank = 1;
		}
	}
}

/*
I/O overview:
	PORT-A  1st player inputs
	PORT-B  2nd player inputs
	PORT-C  system input
	PORT-D  system output
	PORT-E  I/O 1
	PORT-F  I/O 2
	PORT-G  I/O 3
	PORT-AD AD-Stick inputs?(Fake for now...)
	SERIAL COM

offsets:
	0h PORT-A
	0l PORT-B
	1h PORT-C
	1l PORT-D
	2h PORT-E
	2l PORT-F (extra button layout)
	3h PORT-G
	3l
	4h PORT-SEL
	4l
	5h SERIAL COM WRITE
	5l
	6h SERIAL COM READ
	6l
	7h
	7l PORT-AD
*/
static UINT8 port_ad[] =
{
	0xcc,0xb2,0x99,0x7f,0x66,0x4c,0x33,0x19
};

UINT8 port_sel;

#define HI_WORD_ACCESS (mem_mask & 0x00ff0000) == 0
#define LO_WORD_ACCESS (mem_mask & 0x000000ff) == 0

READ32_HANDLER ( stv_io_r32 )
{
	static int i= -1;
//	logerror("(PC=%08X): I/O r %08X & %08X\n", activecpu_get_pc(), offset*4, mem_mask);

	switch(offset)
	{
		case 0:
		return (readinputport(2) << 16) | (readinputport(3));
		case 1:
		return (readinputport(4) << 16) | (ioga[1]);
		case 2:
		/*Needs more work once that groovef works and it could be that this is bit wise
		  rather than value wise...*/
		switch(port_sel)
		{
			case 0x77:	return (readinputport(5) << 16) | (readinputport(6));
			case 0x67:	return 0xffffffff;/**/
			case 0x20:  return 0xffff0000 | (ioga[2] & 0xffff);
			case 0x10:  return ((ioga[2] & 0xffff) << 16) | 0xffff;
			case 0x60:  return 0xffffffff;/**/
			default:
			//usrintf_showmessage("offs: 2 %02x",port_sel);
			return 0xffffffff;
		}
		break;
		case 3:
		switch(port_sel)
		{
			case 0x60:  return ((ioga[2] & 0xffff) << 16) | 0xffff;
			default:
			//usrintf_showmessage("offs: 3 %02x",port_sel);
			return 0xffffffff;
		}
		break;
		case 6:
		switch(port_sel)
		{
			case 0x60:  return ioga[5];
			default:
			//usrintf_showmessage("offs: 6 %02x",port_sel);
			return 0xffffffff;
		}
		break;
		case 7:
		i++;
		if(i > 7) { i = 0; }
		return port_ad[i];
		default:
		return ioga[offset];
	}
}

WRITE32_HANDLER ( stv_io_w32 )
{
	//logerror("(PC=%08X): I/O w %08X = %08X & %08X\n", activecpu_get_pc(), offset*4, data, mem_mask);

	switch(offset)
	{
		case 1:
			if(LO_WORD_ACCESS)
			{
				ioga[1] = (data) & 0xff;
				coin_counter_w(0,~data & 0x01);
				coin_counter_w(1,~data & 0x02);
				coin_lockout_w(0,~data & 0x04);
				coin_lockout_w(1,~data & 0x08);
				/*
				other bits reserved
				*/
			}
		break;
		case 2:
			if(HI_WORD_ACCESS)
				ioga[2] = data >> 16;
			else if(LO_WORD_ACCESS)
				ioga[2] = data;
		break;
		case 3:
			if(HI_WORD_ACCESS)
				ioga[3] = data;
		break;
		case 4:
			if(HI_WORD_ACCESS)
				port_sel = (data & 0xffff0000) >> 16;
		break;
		case 5:
			if(HI_WORD_ACCESS)
				ioga[5] = data;
		break;
	}
}

/*
READ32_HANDLER (read_cart)
{
	usrintf_showmessage("read cart address %08x",0x02200000+offset*4);
	return 0xff;
}
*/


/*

SCU Handling

*/

/**********************************************************************************
SCU Register Table
offset,relative address
Registers are in long words.
===================================================================================
0     0000	Level 0 DMA Set Register
1     0004
2     0008
3     000c
4     0010
5     0014
6     0018
7     001c
8     0020	Level 1 DMA Set Register
9     0024
10    0028
11    002c
12    0030
13    0034
14    0038
15    003c
16    0040	Level 2 DMA Set Register
17    0044
18    0048
19    004c
20    0050
21    0054
22    0058
23    005c
24    0060	DMA Forced Stop
25    0064
26    0068
27    006c
28    0070	DMA Status Register
29    0074
30    0078
31    007c
32    0080	DSP Program Control Port
33    0084	DSP Program RAM Data Port
34    0088	DSP Data RAM Address Port
35    008c	DSP Data RAM Data Port
36    0090	Timer 0 Compare Register
37    0094	Timer 1 Set Data Register
38    0098	Timer 1 Mode Register
39    009c	<Free>
40    00a0	Interrupt Mask Register
41    00a4	Interrupt Status Register
42    00a8	A-Bus Interrupt Acknowledge
43    00ac	<Free>
44    00b0	A-Bus Set Register
45    00b4
46    00b8	A-Bus Refresh Register
47    00bc  <Free>
48    00c0
49    00c4	SCU SDRAM Select Register
50    00c8	SCU Version Register
51    00cc	<Free>
52    00cf
**********************************************************************************/
/*
DMA TODO:
-Verify if there are any kind of bugs,do clean-ups,use better comments
 and macroize for better reading...
-Add timings(but how fast are each DMA?).
-Add level priority & DMA status register.
-Add DMA start factor conditions that are different than 7.
-Add byte data type transfer.
*/

#define DIRECT_MODE(_lv_)			(!(stv_scu[5+(_lv_*8)] & 0x01000000))
#define INDIRECT_MODE(_lv_)			  (stv_scu[5+(_lv_*8)] & 0x01000000)

READ32_HANDLER( stv_scu_r32 )
{
	/*TODO: write only registers must return 0...*/
	return stv_scu[offset];
}

WRITE32_HANDLER( stv_scu_w32 )
{
	COMBINE_DATA(&stv_scu[offset]);

	switch(offset)
	{
		/*LV 0 DMA*/
		case 0:	scu_src_0  = ((stv_scu[0] & 0x07ffffff) >> 0); break;
		case 1:	scu_dst_0  = ((stv_scu[1] & 0x07ffffff) >> 0); break;
		case 2: scu_size_0 = ((stv_scu[2] & 0x000fffff) >> 0); break;
		case 3:
		/*Read address add value for DMA lv 0*/
		if(stv_scu[3] & 0x100)
			scu_src_add_0 = 4;
		else
			scu_src_add_0 = 0;

		/*Write address add value for DMA lv 0*/
		switch(stv_scu[3] & 7)
		{
			case 0: scu_dst_add_0 = 2;   break;
			case 1: scu_dst_add_0 = 4;   break;
			case 2: scu_dst_add_0 = 8;   break;
			case 3: scu_dst_add_0 = 16;  break;
			case 4: scu_dst_add_0 = 32;  break;
			case 5: scu_dst_add_0 = 64;  break;
			case 6: scu_dst_add_0 = 128; break;
			case 7: scu_dst_add_0 = 256; break;
		}
		break;
		case 4:
/*
-stv_scu[4] bit 0 is DMA starting factor.
	Used when the start factor is 7.Toggle after execution.
-stv_scu[4] bit 8 is DMA Enable bit.
	This is an execution mask flag.
-stv_scu[5] bit 0,bit 1 and bit 2 is DMA starting factor.
	It must be 7 for this specific condition.
-stv_scu[5] bit 24 is Indirect Mode/Direct Mode (0/1).
*/
		if(stv_scu[4] & 1 && ((stv_scu[5] & 7) == 7) && stv_scu[4] & 0x100)
		{
			if(DIRECT_MODE(0))
				dma_direct_lv0();
			else
				dma_indirect_lv0();

			stv_scu[4]^=1;//disable starting factor.
		}
		break;
		case 5:
		if(INDIRECT_MODE(0))
			logerror("Indirect Mode DMA lv 0 set\n");

		/*Start factor enable bits,bit 2,bit 1 and bit 0*/
		if(!(stv_scu[5] & 7))
			logerror("Start factor chosen for lv 0 = %d\n",stv_scu[5] & 7);
		break;
		/*LV 1 DMA*/
		case 8:	 scu_src_1  = ((stv_scu[8] &  0x07ffffff) >> 0);  break;
		case 9:	 scu_dst_1  = ((stv_scu[9] &  0x07ffffff) >> 0);  break;
		case 10: scu_size_1 = ((stv_scu[10] & 0x00001fff) >> 0);  break;
		case 11:
		/*Read address add value for DMA lv 1*/
		if(stv_scu[11] & 0x100)
			scu_src_add_1 = 4;
		else
			scu_src_add_1 = 0;

		/*Write address add value for DMA lv 1*/
		switch(stv_scu[11] & 7)
		{
			case 0: scu_dst_add_1 = 2;   break;
			case 1: scu_dst_add_1 = 4;   break;
			case 2: scu_dst_add_1 = 8;   break;
			case 3: scu_dst_add_1 = 16;  break;
			case 4: scu_dst_add_1 = 32;  break;
			case 5: scu_dst_add_1 = 64;  break;
			case 6: scu_dst_add_1 = 128; break;
			case 7: scu_dst_add_1 = 256; break;
		}
		break;
		case 12:
		if(stv_scu[12] & 1 && ((stv_scu[13] & 7) == 7) && stv_scu[12] & 0x100)
		{
			if(DIRECT_MODE(1))
				dma_direct_lv1();
			else
				dma_indirect_lv1();

			stv_scu[12]^=1;
		}
		break;
		case 13:
		if(INDIRECT_MODE(1))
			logerror("Indirect Mode DMA lv 1 set\n");

		if(!(stv_scu[13] & 7))
			logerror("Start factor chosen for lv 1 = %d\n",stv_scu[13] & 7);
		break;
		/*LV 2 DMA*/
		case 16: scu_src_2  = ((stv_scu[16] & 0x07ffffff) >> 0);  break;
		case 17: scu_dst_2  = ((stv_scu[17] & 0x07ffffff) >> 0);  break;
		case 18: scu_size_2 = ((stv_scu[18] & 0x00001fff) >> 0);  break;
		case 19:
		/*Read address add value for DMA lv 2*/
		if(stv_scu[19] & 0x100)
			scu_src_add_2 = 4;
		else
			scu_src_add_2 = 0;

		/*Write address add value for DMA lv 2*/
		switch(stv_scu[19] & 7)
		{
			case 0: scu_dst_add_2 = 2;   break;
			case 1: scu_dst_add_2 = 4;   break;
			case 2: scu_dst_add_2 = 8;   break;
			case 3: scu_dst_add_2 = 16;  break;
			case 4: scu_dst_add_2 = 32;  break;
			case 5: scu_dst_add_2 = 64;  break;
			case 6: scu_dst_add_2 = 128; break;
			case 7: scu_dst_add_2 = 256; break;
		}
		break;
		case 20:
		if(stv_scu[20] & 1 && ((stv_scu[21] & 7) == 7) && stv_scu[20] & 0x100)
		{
			if(DIRECT_MODE(2))
				dma_direct_lv2();
			else
				dma_indirect_lv2();

			stv_scu[20]^=1;
		}
		break;
		case 21:
		if(INDIRECT_MODE(2))
			logerror("Indirect Mode DMA lv 2 set\n");

		if(!(stv_scu[21] & 7))
			logerror("Start factor chosen for lv 0 = %d\n",stv_scu[21] & 7);
		break;
		case 36: logerror("timer 0 compare data = %03x\n",stv_scu[36]);break;
		case 40:
		/*An interrupt is masked when his specific bit is 1.*/
		/*Are bit 16-bit 31 for External A-Bus irq mask like the status register?*/
/*
"uncommon" irq mask sets:
  0xb17c (hanagumi) <reserved> is used?
  0xd7fc (prikura & shienryu)
  0xdffc (prikura)
  0x57fc (prikura)
  bit 31 (shanhigw)
  0x53454741 (all games at startup)?
  0xf17c (rsgun)
  0xf1ff (rsgun)
  0x717c (rsgun)
  0x00000080 (rsgun)?
  0xfff4 (dnmtdeka)
  0x7ffe (vfremix,twcup98)
  0x7ffc (twcup98)
*/
		/*Take out the common settings to keep logging quiet.*/
		if(stv_scu[40] != 0xfffffffe &&
		   stv_scu[40] != 0xfffffffc &&
		   stv_scu[40] != 0xffffffff)
		{
			logerror("IRQ mask reg set %08x = %d%d%d%d|%d%d%d%d|%d%d%d%d|%d%d%d%d\n",
			stv_scu[offset],
			stv_scu[offset] & 0x8000 ? 1 : 0, /*A-Bus irq*/
			stv_scu[offset] & 0x4000 ? 1 : 0, /*<reserved>*/
			stv_scu[offset] & 0x2000 ? 1 : 0, /*Sprite draw end irq(VDP1)*/
			stv_scu[offset] & 0x1000 ? 1 : 0, /*Illegal DMA irq*/
			stv_scu[offset] & 0x0800 ? 1 : 0, /*Lv 0 DMA end irq*/
			stv_scu[offset] & 0x0400 ? 1 : 0, /*Lv 1 DMA end irq*/
			stv_scu[offset] & 0x0200 ? 1 : 0, /*Lv 2 DMA end irq*/
			stv_scu[offset] & 0x0100 ? 1 : 0, /*Pad irq*/
			stv_scu[offset] & 0x0080 ? 1 : 0, /*System Manager(SMPC) irq*/
			stv_scu[offset] & 0x0040 ? 1 : 0, /*Snd req*/
			stv_scu[offset] & 0x0020 ? 1 : 0, /*DSP irq end*/
			stv_scu[offset] & 0x0010 ? 1 : 0, /*Timer 1 irq*/
			stv_scu[offset] & 0x0008 ? 1 : 0, /*Timer 0 irq*/
			stv_scu[offset] & 0x0004 ? 1 : 0, /*HBlank-IN*/
			stv_scu[offset] & 0x0002 ? 1 : 0, /*VBlank-OUT*/
			stv_scu[offset] & 0x0001 ? 1 : 0);/*VBlank-IN*/
		}
		break;
		case 41:
		/*This is never triggered...*/
		logerror("IRQ status reg set:%08x\n",stv_scu[41]);
		break;
		case 42: /*A-Bus IRQ ACK*/ break;
		case 49: /*This sets the SDRAM size*/ break;
		default: logerror("Warning: unused SCU reg set %d = %08x\n",offset,data);
	}
}


static void dma_direct_lv0()
{
	logerror("DMA lv 0 transfer START\n"
			 "Start %08x End %08x Size %04x\n",scu_src_0,scu_dst_0,scu_size_0);
	logerror("Start Add %04x Destination Add %04x\n",scu_src_add_0,scu_dst_add_0);

	for (; scu_size_0 > 0; scu_size_0-=scu_dst_add_0)
	{
		if(scu_dst_add_0 == 2)
			cpu_writemem16bew_word(scu_dst_0,cpu_readmem16bew_word(scu_src_0));
		else
			cpu_writemem32bedw_dword(scu_dst_0,cpu_readmem32bedw_dword(scu_src_0));

		scu_dst_0+=scu_dst_add_0;
		scu_src_0+=scu_src_add_0;
	}
	logerror("DMA transfer END\n");
	if(!(stv_scu[40] & 0x800))/*Lv 0 DMA end irq*/
		cpu_set_irq_line_and_vector(0, 5, HOLD_LINE , 0x4b);
}

static void dma_direct_lv1()
{
	logerror("DMA lv 1 transfer START\n"
			 "Start %08x End %08x Size %04x\n",scu_src_1,scu_dst_1,scu_size_1);
	logerror("Start Add %04x Destination Add %04x\n",scu_src_add_1,scu_dst_add_1);

	for (; scu_size_1 > 0; scu_size_1-=scu_dst_add_1)
	{
		if(scu_dst_add_1 == 2)
			cpu_writemem16bew_word(scu_dst_1,cpu_readmem16bew_word(scu_src_1));
		else
			cpu_writemem32bedw_dword(scu_dst_1,cpu_readmem32bedw_dword(scu_src_1));

		scu_dst_1+=scu_dst_add_1;
		scu_src_1+=scu_src_add_1;
	}
	logerror("DMA transfer END\n");
	if(!(stv_scu[40] & 0x400))/*Lv 1 DMA end irq*/
		cpu_set_irq_line_and_vector(0, 6, HOLD_LINE , 0x4a);
}

static void dma_direct_lv2()
{
	logerror("DMA lv 2 transfer START\n"
			 "Start %08x End %08x Size %04x\n",scu_src_2,scu_dst_2,scu_size_2);
	logerror("Start Add %04x Destination Add %04x\n",scu_src_add_2,scu_dst_add_2);

	for (; scu_size_2 > 0; scu_size_2-=scu_dst_add_2)
	{
		if(scu_dst_add_2 == 2)
			cpu_writemem16bew_word(scu_dst_2,cpu_readmem16bew_word(scu_src_2));
		else
			cpu_writemem32bedw_dword(scu_dst_2,cpu_readmem32bedw_dword(scu_src_2));

		scu_dst_2+=scu_dst_add_2;
		scu_src_2+=scu_src_add_2;
	}

	logerror("DMA transfer END\n");
	if(!(stv_scu[40] & 0x200))/*Lv 2 DMA end irq*/
		cpu_set_irq_line_and_vector(0, 6, HOLD_LINE , 0x49);
}

static void dma_indirect_lv0()
{
	/*Helper to get out of the cycle*/
	UINT8 job_done = 0;
	/*temporary storage for the transfer data*/
	UINT32 tmp_src;

	do{
		tmp_src = scu_dst_0;

		/*Thanks for Runik of Saturnin for pointing this out...*/
		scu_size_0 = cpu_readmem32bedw_dword(scu_dst_0);
		scu_src_0 =  cpu_readmem32bedw_dword(scu_dst_0+8);
		scu_dst_0 =  cpu_readmem32bedw_dword(scu_dst_0+4);

		/*Indirect Mode end factor*/
		if(scu_src_0 & 0x80000000)
			job_done = 1;

		logerror("DMA lv 0 indirect mode transfer START\n"
			 	 "Start %08x End %08x Size %04x\n",scu_src_0,scu_dst_0,scu_size_0);
		logerror("Start Add %04x Destination Add %04x\n",scu_src_add_0,scu_dst_add_0);

		//guess,but I believe it's right.
		scu_src_0 &=0x07ffffff;
		scu_dst_0 &=0x07ffffff;
		scu_size_0 &=0xfff;

		for (; scu_size_0 > 0; scu_size_0-=scu_dst_add_0)
		{
			if(scu_dst_add_0 == 2)
				cpu_writemem16bew_word(scu_dst_0,cpu_readmem16bew_word(scu_src_0));
			else
				cpu_writemem32bedw_dword(scu_dst_0,cpu_readmem32bedw_dword(scu_src_0));

			scu_dst_0+=scu_dst_add_0;
			scu_src_0+=scu_src_add_0;
		}

		scu_dst_0 = tmp_src+0xc;

	}while(job_done == 0);

	if(!(stv_scu[40] & 0x800))/*Lv 0 DMA end irq*/
		cpu_set_irq_line_and_vector(0, 5, HOLD_LINE , 0x4b);
}

static void dma_indirect_lv1()
{
	/*Helper to get out of the cycle*/
	UINT8 job_done = 0;
	/*temporary storage for the transfer data*/
	UINT32 tmp_src;

	do{
		tmp_src = scu_dst_1;

		/*Thanks for Runik of Saturnin for pointing this out...*/
		scu_size_1 = cpu_readmem32bedw_dword(scu_dst_1);
		scu_src_1 =  cpu_readmem32bedw_dword(scu_dst_1+8);
		scu_dst_1 =  cpu_readmem32bedw_dword(scu_dst_1+4);

		/*Indirect Mode end factor*/
		if(scu_src_1 & 0x80000000)
			job_done = 1;

		logerror("DMA lv 1 indirect mode transfer START\n"
			 	 "Start %08x End %08x Size %04x\n",scu_src_1,scu_dst_1,scu_size_1);
		logerror("Start Add %04x Destination Add %04x\n",scu_src_add_1,scu_dst_add_1);

		//guess,but I believe it's right.
		scu_src_1 &=0x07ffffff;
		scu_dst_1 &=0x07ffffff;
		scu_size_1 &=0x1fff;

		for (; scu_size_1 > 0; scu_size_1-=scu_dst_add_1)
		{
			if(scu_dst_add_1 == 2)
				cpu_writemem16bew_word(scu_dst_1,cpu_readmem16bew_word(scu_src_1));
			else
				cpu_writemem32bedw_dword(scu_dst_1,cpu_readmem32bedw_dword(scu_src_1));

			scu_dst_1+=scu_dst_add_1;
			scu_src_1+=scu_src_add_1;
		}

		scu_dst_1 = tmp_src+0xc;

	}while(job_done == 0);

	if(!(stv_scu[40] & 0x400))/*Lv 1 DMA end irq*/
		cpu_set_irq_line_and_vector(0, 6, HOLD_LINE , 0x4a);
}

static void dma_indirect_lv2()
{
	/*Helper to get out of the cycle*/
	UINT8 job_done = 0;
	/*temporary storage for the transfer data*/
	UINT32 tmp_src;

	do{
		tmp_src = scu_dst_2;

		/*Thanks for Runik of Saturnin for pointing this out...*/
		scu_size_2 = cpu_readmem32bedw_dword(scu_dst_2);
		scu_src_2 =  cpu_readmem32bedw_dword(scu_dst_2+8);
		scu_dst_2 =  cpu_readmem32bedw_dword(scu_dst_2+4);

		/*Indirect Mode end factor*/
		if(scu_src_2 & 0x80000000)
			job_done = 1;

		logerror("DMA lv 2 indirect mode transfer START\n"
			 	 "Start %08x End %08x Size %04x\n",scu_src_2,scu_dst_2,scu_size_2);
		logerror("Start Add %04x Destination Add %04x\n",scu_src_add_2,scu_dst_add_2);

		//guess,but I believe it's right.
		scu_src_2 &=0x07ffffff;
		scu_dst_2 &=0x07ffffff;
		scu_size_2 &=0x1fff; // hanagumi needs at least this or sprites vanish during special moves

		for (; scu_size_2 > 0; scu_size_2-=scu_dst_add_2)
		{
			if(scu_dst_add_2 == 2)
				cpu_writemem16bew_word(scu_dst_2,cpu_readmem16bew_word(scu_src_2));
			else
				cpu_writemem32bedw_dword(scu_dst_2,cpu_readmem32bedw_dword(scu_src_2));

			scu_dst_2+=scu_dst_add_2;
			scu_src_2+=scu_src_add_2;
		}

		scu_dst_2 = tmp_src+0xc;

	}while(job_done == 0);

	if(!(stv_scu[40] & 0x200))/*Lv 2 DMA end irq*/
		cpu_set_irq_line_and_vector(0, 6, HOLD_LINE , 0x49);
}



WRITE32_HANDLER( stv_sh2_soundram_w )
{
	data8_t *SNDRAM = memory_region(REGION_CPU3);

	if (!(mem_mask & 0xff000000)) SNDRAM[offset*4+1] = (data & 0xff000000)>>24;
	if (!(mem_mask & 0x00ff0000)) SNDRAM[offset*4+0] = (data & 0x00ff0000)>>16;
	if (!(mem_mask & 0x0000ff00)) SNDRAM[offset*4+3] = (data & 0x0000ff00)>>8;
	if (!(mem_mask & 0x000000ff)) SNDRAM[offset*4+2] = (data & 0x000000ff)>>0;
}

READ32_HANDLER( stv_sh2_soundram_r )
{
	data8_t *SNDRAM = memory_region(REGION_CPU3);

	if ((activecpu_get_pc()==0x6014298) && (offset*4 == 0x07ac))
	{
		logerror("hanagumi hang skip! 6014298\n");
		return 0x01010101;
	}

	if ((activecpu_get_pc()==0x60142fe) && (offset*4 == 0x07ac))
	{
		logerror("hanagumi hang skip! 60142fe\n");
		return 0x01010101;
	}

	return  (SNDRAM[offset*4+1]<<24) | (SNDRAM[offset*4+0]<<16) | (SNDRAM[offset*4+3]<<8) | (SNDRAM[offset*4+2]<<0);

}

static READ32_HANDLER( stv_scsp_regs_r32 )
{
	return scsp_regs[offset*2+1]<<16 | scsp_regs[offset*2+0]<<0;
}

static WRITE32_HANDLER( stv_scsp_regs_w32 )
{
	if (!(mem_mask & 0xffff0000)) scsp_regs[offset*2+1] = (data & 0xffff0000)>>16;
	if (!(mem_mask & 0x0000ffff)) scsp_regs[offset*2+0] = (data & 0x0000ffff)>>0;
}

static READ16_HANDLER( stv_scsp_regs_r16 )
{
	return scsp_regs[offset];
}

static WRITE16_HANDLER( stv_scsp_regs_w16 )
{
	COMBINE_DATA(&scsp_regs[offset]);
}

/* communication,SLAVE CPU acquires data from the MASTER CPU and triggers an irq.  *
 * Enter into Radiant Silver Gun specific menu for a test...                       */
static WRITE32_HANDLER( minit_w )
{
	logerror("MINIT write at %08x = %08x\n",activecpu_get_pc(),data);
}

extern WRITE32_HANDLER ( stv_vdp2_vram_w );
extern READ32_HANDLER ( stv_vdp2_vram_r );

extern WRITE32_HANDLER ( stv_vdp2_cram_w );
extern READ32_HANDLER ( stv_vdp2_cram_r );

extern WRITE32_HANDLER ( stv_vdp2_regs_w );
extern READ32_HANDLER ( stv_vdp2_regs_r );

extern VIDEO_START ( stv_vdp2 );
extern VIDEO_UPDATE( stv_vdp2 );

extern READ32_HANDLER( stv_vdp1_regs_r );
extern WRITE32_HANDLER( stv_vdp1_regs_w );
extern READ32_HANDLER ( stv_vdp1_vram_r );
extern WRITE32_HANDLER ( stv_vdp1_vram_w );

static READ32_HANDLER( stv_workram_h_mirror_r )
{
	offset = offset & ((0x0100000/4)-1);
	return stv_workram_h[offset];
}


static MEMORY_READ32_START( stv_master_readmem )
	{ 0x00000000, 0x0007ffff, MRA32_ROM },   // bios
	{ 0x00100000, 0x0010007f, stv_SMPC_r32 },/*SMPC*/
	{ 0x00180000, 0x0018ffff, MRA32_RAM },	 /*Back up RAM*/

	{ 0x00200000, 0x002fffff, MRA32_RAM },
	{ 0x00400000, 0x0040001f, stv_io_r32 },

	{ 0x02000000, 0x04ffffff, MRA32_BANK1 }, // cartridge
//	{ 0x02200000, 0x04ffffff, read_cart }, // cartridge
	{ 0x05000000, 0x058fffff, MRA32_RAM },

	/* Sound */
	{ 0x05a00000, 0x05afffff, stv_sh2_soundram_r },
	{ 0x05b00000, 0x05b00fff, stv_scsp_regs_r32 },

	/* VDP1 */
	/*0x05c00000-0x05c7ffff VRAM*/
	/*0x05c80000-0x05c9ffff Frame Buffer 0*/
	/*0x05ca0000-0x05cbffff Frame Buffer 1*/
	/*0x05d00000-0x05d7ffff VDP1 Regs */
	{ 0x05c00000, 0x05cbffff, stv_vdp1_vram_r },
	{ 0x05d00000, 0x05d0001f, stv_vdp1_regs_r },

	/* VDP2 when VRAMSZ is 0*/
//	{ 0x5e00000 , 0x5e1ffff, a0_vdp2_r },
//	{ 0x5e20000 , 0x5e3ffff, a1_vdp2_r },
//	{ 0x5e40000 , 0x5e5ffff, b0_vdp2_r },
//	{ 0x5e60000 , 0x5e7ffff, b1_vdp2_r },


	{ 0x5e00000 , 0x5efffff, stv_vdp2_vram_r },
	{ 0x5f00000 , 0x5f7ffff, stv_vdp2_cram_r },
	{ 0x5f80000 , 0x5fbffff, stv_vdp2_regs_r },

	/* VDP2 when VRAMSZ is 1*/
	/*0x5e00000-0x5e3ffff A0*/
	/*0x5e40000-0x5e7ffff A1*/
	/*0x5e80000-0x5ecffff B0*/
	/*0x5ed0000-0x5efffff B1*/
//	{ 0x05e00000, 0x05e7ffff, MRA32_RAM },
//	{ 0x05f00000, 0x05f0ffff, stv_palette_r }, /* CRAM */
//	{ 0x05f80000, 0x05fbffff, stv_vdp2_regs_r32 }, /* REGS */
	{ 0x05fe0000, 0x05fe00cf, stv_scu_r32 },

	{ 0x06000000, 0x060fffff, MRA32_RAM },
	{ 0x06100000, 0x07ffffff, stv_workram_h_mirror_r }, // hanagumi reads the char select 1p icon and timer gfx from here ..
MEMORY_END

static MEMORY_WRITE32_START( stv_master_writemem )
	{ 0x00000000, 0x0007ffff, MWA32_ROM },
	{ 0x00100000, 0x0010007f, stv_SMPC_w32 },

	{ 0x00180000, 0x0018ffff, MWA32_RAM },

	{ 0x00200000, 0x002fffff, MWA32_RAM, &stv_workram_l },
	{ 0x00400000, 0x0040001f, stv_io_w32 ,&ioga },
	{ 0x01000000, 0x01000003, minit_w },
	{ 0x02000000, 0x04ffffff, MWA32_ROM },
	{ 0x05000000, 0x058fffff, MWA32_RAM },

	/* Sound */
	{ 0x05a00000, 0x05afffff, stv_sh2_soundram_w },
	{ 0x05b00000, 0x05b00fff, stv_scsp_regs_w32 },

	/* VDP1 */
	{ 0x05c00000, 0x05cbffff, stv_vdp1_vram_w },
	{ 0x05d00000, 0x05d0001f, stv_vdp1_regs_w },

	{ 0x5e00000 , 0x5efffff, stv_vdp2_vram_w },
	{ 0x5f00000 , 0x5f7ffff, stv_vdp2_cram_w },
	{ 0x5f80000 , 0x5fbffff, stv_vdp2_regs_w },

	{ 0x05fe0000, 0x05fe00cf, stv_scu_w32 },

	{ 0x06000000, 0x060fffff, MWA32_RAM, &stv_workram_h },
//	{ 0x06100000, 0x07ffffff, MWA32_NOP },
MEMORY_END

static MEMORY_READ32_START( stv_slave_readmem )
	{ 0x00000000, 0x0007ffff, MRA32_ROM },   // bios
	{ 0x02000000, 0x04ffffff, MRA32_BANK1 }, // cartridge
MEMORY_END

static MEMORY_WRITE32_START( stv_slave_writemem )
	{ 0x00000000, 0x0007ffff, MWA32_ROM },
	{ 0x02000000, 0x04ffffff, MWA32_ROM },
MEMORY_END

static MEMORY_READ16_START( sound_readmem )
	{ 0x000000, 0x0fffff, MRA16_BANK2 },
	{ 0x100000, 0x100fff, stv_scsp_regs_r16 },
MEMORY_END

static MEMORY_WRITE16_START( sound_writemem )
	{ 0x000000, 0x0fffff, MWA16_BANK2 },	/*actually SDRAM*/
	{ 0x100000, 0x100fff, stv_scsp_regs_w16 },
MEMORY_END

#define STV_PLAYER_INPUTS(_n_, _b1_, _b2_, _b3_, _b4_) \
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_##_b1_         | IPF_PLAYER##_n_ ) \
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_##_b2_         | IPF_PLAYER##_n_ ) \
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_##_b3_         | IPF_PLAYER##_n_ ) \
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_##_b4_         | IPF_PLAYER##_n_ ) \
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_PLAYER##_n_ ) \
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_PLAYER##_n_ ) \
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_PLAYER##_n_ ) \
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_PLAYER##_n_ )

INPUT_PORTS_START( stv )
	PORT_START
	PORT_DIPNAME( 0x01, 0x01, "PDR1" )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START
	PORT_DIPNAME( 0x01, 0x01, "PDR2" )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	PORT_START
	STV_PLAYER_INPUTS(1, BUTTON1, BUTTON2, BUTTON3, BUTTON4)

	PORT_START
	STV_PLAYER_INPUTS(2, BUTTON1, BUTTON2, BUTTON3, BUTTON4)
/*
	PORT_START
	STV_PLAYER_INPUTS(3, BUTTON1, BUTTON2, BUTTON3, BUTTON4)

	PORT_START
	STV_PLAYER_INPUTS(4, BUTTON1, BUTTON2, BUTTON3, BUTTON4)
*/

	PORT_START
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BITX(0x04, IP_ACTIVE_LOW, IPT_SERVICE, "Test", KEYCODE_F2, IP_JOY_NONE )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_SERVICE1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BITX(0x40, IP_ACTIVE_LOW, IPT_SERVICE, "1P Push Switch", KEYCODE_7, IP_JOY_NONE )
	PORT_BITX(0x80, IP_ACTIVE_LOW, IPT_SERVICE, "2P Push Switch", KEYCODE_8, IP_JOY_NONE )

	/*This might be unused,but we never know...*/
	PORT_START
	PORT_DIPNAME( 0x01, 0x01, "3" )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	/*Extra button layout,used by Power Instinct 3*/
	PORT_START
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON4  | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON5  | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON6  | IPF_PLAYER1 )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON4  | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON5  | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_BUTTON6  | IPF_PLAYER2 )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

INPUT_PORTS_END

/*

06013AE8: MOV.L   @($D4,PC),R5
06013AEA: MOV.L   @($D8,PC),R0
06013AEC: MOV.W   @R5,R5
06013AEE: MOV.L   @R0,R0
06013AF0: AND     R10,R5
06013AF2: TST     R0,R0
06013AF4: BTS     $06013B00
06013AF6: EXTS.W  R5,R5
06013B00: EXTS.W  R5,R5
06013B02: TST     R5,R5
06013B04: BF      $06013B0A
06013B06: TST     R4,R4
06013B08: BT      $06013AE8

   (loops for 375868 instructions)

*/


static READ32_HANDLER( stv_speedup_r )
{
	if (activecpu_get_pc()==0x60154b4) cpu_spinuntil_int(); // bios menus..

	return stv_workram_h[0x0335d0/4];
}

static READ32_HANDLER( stv_speedup2_r )
{
	if (activecpu_get_pc()==0x6013af0) cpu_spinuntil_int(); // for use in japan

	return stv_workram_h[0x0335bc/4];
}

DRIVER_INIT ( stv )
{
	unsigned char *ROM = memory_region(REGION_USER1);
	cpu_setbank(1,&ROM[0x000000]);

	/* we allocate the memory here so its easier to share between cpus */
	smpc_ram = auto_malloc (0x80);
	stv_scu = auto_malloc (0x100);
	scsp_regs = auto_malloc (0x1000);

/* idle skip bios? .. not 100% sure this is safe .. we'll see */
	install_mem_read32_handler(0, 0x60335d0, 0x60335d3, stv_speedup_r );
	install_mem_read32_handler(0, 0x60335bc, 0x60335bf, stv_speedup2_r );
}

static READ32_HANDLER( shienryu_speedup_r )
{
	if (activecpu_get_pc()==0x060041C8) cpu_spinuntil_int(); // after you enable the sound cpu ...
	return stv_workram_h[0x0ae8e0/4];
}


DRIVER_INIT(shienryu)
{
	install_mem_read32_handler(0, 0x60ae8e0, 0x60ae8e3, shienryu_speedup_r ); // after you enable sound cpu

	init_stv();
}

static READ32_HANDLER( prikura_speedup_r )
{
	if (activecpu_get_pc()==0x6018642) cpu_spinuntil_int(); // after you enable the sound cpu ...
	return stv_workram_h[0x0b9228/4];
}


DRIVER_INIT(prikura)
{
/*
 06018640: MOV.B   @R14,R0  // 60b9228
 06018642: TST     R0,R0
 06018644: BF      $06018640

    (loops for 263473 instructions)
*/
	install_mem_read32_handler(0, 0x60b9228, 0x60b922b, prikura_speedup_r );

	init_stv();
}


static READ32_HANDLER( hanagumi_speedup_r )
{
	if (activecpu_get_pc()==0x06010162) cpu_spinuntil_int(); // title logos

	return stv_workram_h[0x94188/4];
}


DRIVER_INIT(hanagumi)
{
/*
	06013E1E: NOP
	0601015E: MOV.L   @($6C,PC),R3
	06010160: MOV.L   @R3,R0  (6094188)
	06010162: TST     R0,R0
	06010164: BT      $0601015A
	0601015A: JSR     R14
	0601015C: NOP
	06013E20: MOV.L   @($34,PC),R3
	06013E22: MOV.B   @($00,R3),R0
	06013E24: TST     R0,R0
	06013E26: BT      $06013E1C
	06013E1C: RTS
	06013E1E: NOP

   (loops for 288688 instructions)
*/
   	install_mem_read32_handler(0, 0x6094188, 0x609418b, hanagumi_speedup_r );

  	init_stv();
}



static MACHINE_INIT( stv )
{

	unsigned char *SH2ROM = memory_region(REGION_USER1);
	unsigned char *SNDRAM = memory_region(REGION_CPU3);
	cpu_setbank(1,&SH2ROM[0x000000]);
	cpu_setbank(2,&SNDRAM[0x000000]);

	// don't let the slave cpu and the 68k go anywhere
	cpu_set_halt_line(1, ASSERT_LINE);
	cpu_set_halt_line(2, ASSERT_LINE);

	timer_0 = 0;
}

static struct GfxLayout tiles8x8x4_layout =
{
	8,8,
	RGN_FRAC(1,1),
	4,
	{ 0, 1, 2, 3 },
	{ 0, 4, 8, 12, 16, 20, 24, 28 },
	{ 0*32, 1*32, 2*32, 3*32, 4*32, 5*32, 6*32, 7*32 },
	32*8
};

static struct GfxLayout tiles16x16x4_layout =
{
	16,16,
	RGN_FRAC(1,1),
	4,
	{ 0, 1, 2, 3 },
	{ 0, 4, 8, 12, 16, 20, 24, 28,
	  32*8+0, 32*8+4, 32*8+8, 32*8+12, 32*8+16, 32*8+20, 32*8+24, 32*8+28,

	  },
	{ 0*32, 1*32, 2*32, 3*32, 4*32, 5*32, 6*32, 7*32,
	  32*16, 32*17,32*18, 32*19,32*20,32*21,32*22,32*23

	  },
	32*32
};

static struct GfxLayout tiles8x8x8_layout =
{
	8,8,
	RGN_FRAC(1,1),
	8,
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0, 8, 16, 24, 32, 40, 48, 56 },
	{ 0*64, 1*64, 2*64, 3*64, 4*64, 5*64, 6*64, 7*64 },
	64*8
};

static struct GfxLayout tiles16x16x8_layout =
{
	16,16,
	RGN_FRAC(1,1),
	8,
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0, 8, 16, 24, 32, 40, 48, 56,
	64*8+0, 65*8, 66*8, 67*8, 68*8, 69*8, 70*8, 71*8

	},
	{ 0*64, 1*64, 2*64, 3*64, 4*64, 5*64, 6*64, 7*64,
	64*16, 64*17, 64*18, 64*19, 64*20, 64*21, 64*22, 64*23
	},
	128*16
};




static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &tiles8x8x4_layout,   0x00, 0x80  },
	{ REGION_GFX1, 0, &tiles16x16x4_layout,   0x00, 0x80  },
	{ REGION_GFX1, 0, &tiles8x8x8_layout,   0x00, 0x10  },
	{ REGION_GFX1, 0, &tiles16x16x8_layout,   0x00, 0x10  },

	/* vdp1 .. pointless but .. */
//	{ REGION_GFX5, 0, &tiles8x8x4_layout,   0x00, 0x100  },
//	{ REGION_GFX5, 0, &tiles8x8x8_layout,   0x00, 0x20  },
//	{ REGION_GFX5, 0, &tiles16x16x4_layout,   0x00, 0x100  },
//	{ REGION_GFX5, 0, &tiles16x16x8_layout,   0x00, 0x20  },

	{ -1 } /* end of array */
};

static MACHINE_DRIVER_START( stv )

	/* basic machine hardware */
	MDRV_CPU_ADD(SH2, 28000000) // 28MHz
	MDRV_CPU_MEMORY(stv_master_readmem,stv_master_writemem)
	MDRV_CPU_VBLANK_INT(stv_interrupt,264)/*264 lines,224 display lines*/

	/* basic machine hardware */
	MDRV_CPU_ADD(SH2, 28000000) // 28MHz
	MDRV_CPU_MEMORY(stv_slave_readmem,stv_slave_writemem)
	/* how do the interrupts work..from other cpu? */

	MDRV_CPU_ADD(M68000, 12000000)
	MDRV_CPU_MEMORY(sound_readmem,sound_writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	MDRV_MACHINE_INIT(stv)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(128*8, 64*8)
	MDRV_VISIBLE_AREA(0*8, 352-1, 0*8, 32*8-1)
	MDRV_PALETTE_LENGTH(0x10000/4)
	MDRV_GFXDECODE(gfxdecodeinfo)

	MDRV_VIDEO_START(stv_vdp2)
	MDRV_VIDEO_UPDATE(stv_vdp2)

MACHINE_DRIVER_END

/* the roms marked as bad almost certainly aren't bad, theres some very weird
   mirroring going on, or maybe its meant to transfer the rom data to the region it
   tests from rearranging it a bit (dma?)

   comments merely indicate the status the rom gets in the rom check at the moment

*/

/*

there appears to only be one main cartridge layout, just some having different positions populated if you use the ic named in
the test mode you have the following

some of the rom names were using something else and have been renamed to match test mode, old extension left in comments

( add 0x2000000 for real memory map location )

0x0000000 - 0x01fffff IC13 Header can be read from here .. *IC13 ALWAYS fails on the games if they have one, something weird going on
0x0200000 - 0x03fffff IC7  .. or here (some games have both ic7 and ic13 but the header is in ic13 in these cases)
0x0400000 - 0x07fffff IC2
0x0800000 - 0x0bfffff IC3
0x0c00000 - 0x0ffffff IC4
0x1000000 - 0x13fffff IC5
0x1400000 - 0x17fffff IC6
0x1800000 - 0x1bfffff IC1
0x1c00000 - 0x1ffffff IC8
0x2000000 - 0x23fffff IC9
0x2400000 - 0x27fffff IC10
0x2800000 - 0x2bfffff IC11
0x2c00000 - 0x2ffffff IC12

*/


ROM_START( stvbios )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
ROM_END


ROM_START( astrass )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* bios */
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr20825.13",                0x0000000, 0x0100000, 0x94a9ad8f ) // ic13 bad?! (was .24)
	ROM_LOAD16_WORD_SWAP( "mpr20827.2",     0x0400000, 0x0400000, 0x65cabbb3 ) // good (was .12)
	ROM_LOAD16_WORD_SWAP( "mpr20828.3",     0x0800000, 0x0400000, 0x3934d44a ) // good (was .13)
	ROM_LOAD16_WORD_SWAP( "mpr20829.4",     0x0c00000, 0x0400000, 0x814308c3 ) // good (was .14)
	ROM_LOAD16_WORD_SWAP( "mpr20830.5",     0x1000000, 0x0400000, 0xff97fd19 ) // good (was .15)
	ROM_LOAD16_WORD_SWAP( "mpr20831.6",     0x1400000, 0x0400000, 0x4408e6fb ) // good (was .16)
	ROM_LOAD16_WORD_SWAP( "mpr20826.1",     0x1800000, 0x0400000, 0xbdc4b941 ) // good (was .17)
	ROM_LOAD16_WORD_SWAP( "mpr20832.8",     0x1c00000, 0x0400000, 0xaf1b0985 ) // good (was .18s)
	ROM_LOAD16_WORD_SWAP( "mpr20833.9",     0x2000000, 0x0400000, 0xcb6af231 ) // good (was .19s)
ROM_END

ROM_START( bakubaku )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* bios */
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fpr17969.13",               0x0000000, 0x0100000, 0xbee327e5 ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr17970.2",    0x0400000, 0x0400000, 0xbc4d6f91 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17971.3",    0x0800000, 0x0400000, 0xc780a3b3 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17972.4",    0x0c00000, 0x0400000, 0x8f29815a ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17973.5",    0x1000000, 0x0400000, 0x5f6e0e8b ) // good
ROM_END

ROM_START( colmns97 )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0xc00000, REGION_USER1, 0 ) /* SH2 code */
	/* it tests .13 at 0x000000 - 0x1fffff but reports as bad even if we put the rom there */
	ROM_LOAD( "fpr19553.13",    0x000000, 0x100000, 0xd4fb6a5e ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr19554.2",     0x400000, 0x400000, 0x5a3ebcac ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19555.3",     0x800000, 0x400000, 0x74f6e6b8 ) // good
ROM_END

ROM_START( cotton2 )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr20122.7",    0x0200000, 0x0200000, 0xd616f78a ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20117.2",    0x0400000, 0x0400000, 0x893656ea ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20118.3",    0x0800000, 0x0400000, 0x1b6a1d4c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20119.4",    0x0c00000, 0x0400000, 0x5a76e72b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20120.5",    0x1000000, 0x0400000, 0x7113dd7b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20121.6",    0x1400000, 0x0400000, 0x8c8fd521 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20116.1",    0x1800000, 0x0400000, 0xd30b0175 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20123.8",    0x1c00000, 0x0400000, 0x35f1b89f ) // good
ROM_END

ROM_START( cottonbm )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1c00000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr21075.7",    0x0200000, 0x0200000, 0x200b58ba ) // good
	ROM_LOAD16_WORD_SWAP( "mpr21070.2",    0x0400000, 0x0400000, 0x56c0bf1d ) // good
	ROM_LOAD16_WORD_SWAP( "mpr21071.3",    0x0800000, 0x0400000, 0x2bb18df2 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr21072.4",    0x0c00000, 0x0400000, 0x7c7cb977 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr21073.5",    0x1000000, 0x0400000, 0xf2e5a5b7 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr21074.6",    0x1400000, 0x0400000, 0x6a7e7a7b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr21069.1",    0x1800000, 0x0400000, 0x6a28e3c5 ) // good
ROM_END

ROM_START( decathlt )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr18967.13",               0x0000000, 0x0100000, 0xc0446674 ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr18968.2",    0x0400000, 0x0400000, 0x11a891de ) // good (was .1)
	ROM_LOAD16_WORD_SWAP( "mpr18969.3",    0x0800000, 0x0400000, 0x199cc47d ) // good (was .2)
	ROM_LOAD16_WORD_SWAP( "mpr18970.4",    0x0c00000, 0x0400000, 0x8b7a509e ) // good (was .3)
	ROM_LOAD16_WORD_SWAP( "mpr18971.5",    0x1000000, 0x0400000, 0xc87c443b ) // good (was .4)
	ROM_LOAD16_WORD_SWAP( "mpr18972.6",    0x1400000, 0x0400000, 0x45c64fca ) // good (was .5)
ROM_END

ROM_START( diehard )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
  // must use USA
	ROM_REGION32_BE( 0x1800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fpr19119.13",               0x0000000, 0x0100000, 0xde5c4f7c ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr19115.2",    0x0400000, 0x0400000, 0x6fe06a30 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19116.3",    0x0800000, 0x0400000, 0xaf9e627b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19117.4",    0x0c00000, 0x0400000, 0x74520ff1 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19118.5",    0x1000000, 0x0400000, 0x2c9702f0 ) // good
ROM_END

ROM_START( dnmtdeka )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fpr19114.13",               0x0000000, 0x0100000, 0x1fd22a5f ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr19115.2",    0x0400000, 0x0400000, 0x6fe06a30 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19116.3",    0x0800000, 0x0400000, 0xaf9e627b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19117.4",    0x0c00000, 0x0400000, 0x74520ff1 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19118.5",    0x1000000, 0x0400000, 0x2c9702f0 ) // good
ROM_END

ROM_START( ejihon )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr18137.13",               0x0000000, 0x0080000, 0x151aa9bc ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr18138.2",    0x0400000, 0x0400000, 0xf5567049 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18139.3",    0x0800000, 0x0400000, 0xf36b4878 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18140.4",    0x0c00000, 0x0400000, 0x228850a0 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18141.5",    0x1000000, 0x0400000, 0xb51eef36 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18142.6",    0x1400000, 0x0400000, 0xcf259541 ) // good
ROM_END

ROM_START( elandore )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr21307.7",    0x0200000, 0x0200000, 0x966ad472 ) // good (was .11s)
	ROM_LOAD16_WORD_SWAP( "mpr21301.2",    0x0400000, 0x0400000, 0x1a23b0a0 ) // good (was .12)
	ROM_LOAD16_WORD_SWAP( "mpr21302.3",    0x0800000, 0x0400000, 0x1c91ca33 ) // good (was .13)
	ROM_LOAD16_WORD_SWAP( "mpr21303.4",    0x0c00000, 0x0400000, 0x07b2350e ) // good (was .14)
	ROM_LOAD16_WORD_SWAP( "mpr21304.5",    0x1000000, 0x0400000, 0xcfea52ae ) // good (was .15)
	ROM_LOAD16_WORD_SWAP( "mpr21305.6",    0x1400000, 0x0400000, 0x46cfc2a2 ) // good (was .16)
	ROM_LOAD16_WORD_SWAP( "mpr21306.1",    0x1800000, 0x0400000, 0x87a5929c ) // good (was .17)
	ROM_LOAD16_WORD_SWAP( "mpr21308.8",    0x1c00000, 0x0400000, 0x336ec1a4 ) // good (was .18s)
ROM_END

ROM_START( ffreveng )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1c00000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "opr21872.7",   0x0200000, 0x0200000, 0x32d36fee ) // good (was .11s)
	ROM_LOAD16_WORD_SWAP( "mpr21873.2",   0x0400000, 0x0400000, 0xdac5bd98 ) // good (was .12)
	ROM_LOAD16_WORD_SWAP( "mpr21874.3",   0x0800000, 0x0400000, 0x0a7be2f1 ) // good (was .13)
	ROM_LOAD16_WORD_SWAP( "mpr21875.4",   0x0c00000, 0x0400000, 0xccb75029 ) // good (was .14)
	ROM_LOAD16_WORD_SWAP( "mpr21876.5",   0x1000000, 0x0400000, 0xbb92a7fc ) // good (was .15)
	ROM_LOAD16_WORD_SWAP( "mpr21877.6",   0x1400000, 0x0400000, 0xc22a4a75 ) // good (was .16)
	ROM_LOAD16_WORD_SWAP( "opr21878.1",   0x1800000, 0x0200000, 0x2ea4a64d ) // good (was .17)
ROM_END

/* set system to 1 player to test rom */
ROM_START( fhboxers )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	/* maybe there is some banking on this one, or the roms are in the wrong places */
	ROM_REGION32_BE( 0x2400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fr18541a.13",               0x0000000, 0x0100000, 0x8c61a17c ) // ic13 bad?! (header is read from here, not ic7 even if both are populated on this board)
	ROM_LOAD16_WORD_SWAP( "mpr18538.7",    0x0200000, 0x0200000, 0x7b5230c5 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18533.2",    0x0400000, 0x0400000, 0x7181fe51 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18534.3",    0x0800000, 0x0400000, 0xc87ef125 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18535.4",    0x0c00000, 0x0400000, 0x929a64cf ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18536.5",    0x1000000, 0x0400000, 0x51b9f64e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18537.6",    0x1400000, 0x0400000, 0xc364f6a7 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18532.1",    0x1800000, 0x0400000, 0x39528643 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18539.8",    0x1c00000, 0x0400000, 0x62b3908c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18540.9",    0x2000000, 0x0400000, 0x4c2b59a4 ) // good
ROM_END

/* set system to 1 player to test rom */
ROM_START( findlove )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x3000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr20424.13",               0x0000000, 0x0100000, 0x4e61fa46 ) // ic13 bad?! (header is read from here, not ic7 even if both are populated on this board)
	ROM_LOAD16_WORD_SWAP( "mpr20431.7",    0x0200000, 0x0200000, 0xea656ced ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20426.2",    0x0400000, 0x0400000, 0x897d1747 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20427.3",    0x0800000, 0x0400000, 0xa488a694 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20428.4",    0x0c00000, 0x0400000, 0x4353b3b6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20429.5",    0x1000000, 0x0400000, 0x4f566486 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20430.6",    0x1400000, 0x0400000, 0xd1e11979 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20425.1",    0x1800000, 0x0400000, 0x67f104c4 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20432.8",    0x1c00000, 0x0400000, 0x79fcdecd ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20433.9",    0x2000000, 0x0400000, 0x82289f29 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20434.10",   0x2400000, 0x0400000, 0x85c94afc ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20435.11",   0x2800000, 0x0400000, 0x263a2e48 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20436.12",   0x2c00000, 0x0400000, 0xe3823f49 ) // good
ROM_END

ROM_START( finlarch )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "finlarch.13",               0x0000000, 0x0100000, 0x4505fa9e ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr18257.2",    0x0400000, 0x0400000, 0x137fdf55 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18258.3",    0x0800000, 0x0400000, 0xf519c505 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18259.4",    0x0c00000, 0x0400000, 0x5cabc775 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18260.5",    0x1000000, 0x0400000, 0xf5b92082 ) // good
ROM_END


ROM_START( gaxeduel )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr17766.13",               0x0000000, 0x0080000, 0xa83fcd62 ) // ic13 bad?!
	ROM_LOAD16_WORD_SWAP( "mpr17768.2",    0x0400000, 0x0400000, 0xd6808a7d ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17769.3",    0x0800000, 0x0400000, 0x3471dd35 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17770.4",    0x0c00000, 0x0400000, 0x06978a00 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17771.5",    0x1000000, 0x0400000, 0xaea2ea3b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17772.6",    0x1400000, 0x0400000, 0xb3dc0e75 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17767.1",    0x1800000, 0x0400000, 0x9ba1e7b1 ) // good
ROM_END

ROM_START( grdforce )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr20844.7",    0x0200000, 0x0200000, 0x283e7587 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20839.2",    0x0400000, 0x0400000, 0xfacd4dd8 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20840.3",    0x0800000, 0x0400000, 0xfe0158e6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20841.4",    0x0c00000, 0x0400000, 0xd87ac873 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20842.5",    0x1000000, 0x0400000, 0xbaebc506 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20843.6",    0x1400000, 0x0400000, 0x263e49cc ) // good
ROM_END

ROM_START( groovef )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr19820.7",    0x0200000, 0x0100000, 0xe93c4513 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19815.2",    0x0400000, 0x0400000, 0x1b9b14e6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19816.3",    0x0800000, 0x0400000, 0x83f5731c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19817.4",    0x0c00000, 0x0400000, 0x525bd6c7 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19818.5",    0x1000000, 0x0400000, 0x66723ba8 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19819.6",    0x1400000, 0x0400000, 0xee8c55f4 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19814.1",    0x1800000, 0x0400000, 0x8f20e9f7 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19821.8",    0x1c00000, 0x0400000, 0xf69a76e6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19822.9",    0x2000000, 0x0200000, 0x5e8c4b5f ) // good
ROM_END

ROM_START( hanagumi )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x3000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_FILL(                              0x0000000, 0x0200000, 0xfffffff )
	ROM_LOAD16_WORD_SWAP( "mpr20143.7",    0x0200000, 0x0100000, 0x7bfc38d0 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20138.2",    0x0400000, 0x0400000, 0xfdcf1046 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20139.3",    0x0800000, 0x0400000, 0x7f0140e5 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20140.4",    0x0c00000, 0x0400000, 0x2fa03852 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20141.5",    0x1000000, 0x0400000, 0x45d6d21b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20142.6",    0x1400000, 0x0400000, 0xe38561ec ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20137.1",    0x1800000, 0x0400000, 0x181d2688 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20144.8",    0x1c00000, 0x0400000, 0x235b43f6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20145.9",    0x2000000, 0x0400000, 0xaeaac7a1 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20146.10",   0x2400000, 0x0400000, 0x39bab9a2 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20147.11",   0x2800000, 0x0400000, 0x294ab997 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20148.12",   0x2c00000, 0x0400000, 0x5337ccb0 ) // good
ROM_END

ROM_START( introdon )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1c00000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr18937.13",               0x0000000, 0x0080000, 0x1f40d766 ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr18944.7",    0x0200000, 0x0100000, 0xf7f75ce5 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18939.2",    0x0400000, 0x0400000, 0xef95a6e6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18940.3",    0x0800000, 0x0400000, 0xcabab4cd ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18941.4",    0x0c00000, 0x0400000, 0xf4a33a20 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18942.5",    0x1000000, 0x0400000, 0x8dd0a446 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18943.6",    0x1400000, 0x0400000, 0xd8702a9e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18938.1",    0x1800000, 0x0400000, 0x580ecb83 ) // good
ROM_END

/* set system to 1 player to test rom */
ROM_START( kiwames )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr18737.13",               0x0000000, 0x0080000, 0xcfad6c49 ) // bad
	ROM_LOAD16_WORD_SWAP( "mpr18738.2",    0x0400000, 0x0400000, 0x4b3c175a ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18739.3",    0x0800000, 0x0400000, 0xeb41fa67 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18740.4",    0x0c00000, 0x0200000, 0x9ca7962f ) // good
ROM_END

ROM_START( maruchan )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr20416.13",               0x0000000, 0x0100000, 0x8bf0176d ) // bad
	ROM_LOAD16_WORD_SWAP( "mpr20417.2",    0x0400000, 0x0400000, 0x636c2a08 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20418.3",    0x0800000, 0x0400000, 0x3f0d9e34 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20419.4",    0x0c00000, 0x0400000, 0xec969815 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20420.5",    0x1000000, 0x0400000, 0xf2902c88 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20421.6",    0x1400000, 0x0400000, 0xcd0b477c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20422.1",    0x1800000, 0x0400000, 0x66335049 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20423.8",    0x1c00000, 0x0400000, 0x2bd55832 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20443.9",    0x2000000, 0x0400000, 0x8ac288f5 ) // good
ROM_END

/* set system to 1 player to test rom */
ROM_START( myfairld )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr21000.7",    0x0200000, 0x0200000, 0x2581c560 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20995.2",    0x0400000, 0x0400000, 0x1bb73f24 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20996.3",    0x0800000, 0x0400000, 0x993c3859 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20997.4",    0x0c00000, 0x0400000, 0xf0bf64a4 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20998.5",    0x1000000, 0x0400000, 0xd3b19786 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20999.6",    0x1400000, 0x0400000, 0x82e31f25 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20994.1",    0x1800000, 0x0400000, 0xa69243a0 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr21001.8",    0x1c00000, 0x0400000, 0x95fbe549 ) // good
ROM_END

ROM_START( othellos )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr20967.7",    0x0200000, 0x0200000, 0xefc05b97 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20963.2",    0x0400000, 0x0400000, 0x2cc4f141 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20964.3",    0x0800000, 0x0400000, 0x5f5cda94 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20965.4",    0x0c00000, 0x0400000, 0x37044f3e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20966.5",    0x1000000, 0x0400000, 0xb94b83de ) // good
ROM_END

ROM_START( pblbeach )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr18852.13",               0x0000000, 0x0080000, 0xd12414ec ) // bad
	ROM_LOAD16_WORD_SWAP( "mpr18853.2",    0x0400000, 0x0400000, 0xb9268c97 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18854.3",    0x0800000, 0x0400000, 0x3113c8bc ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18855.4",    0x0c00000, 0x0400000, 0xdaf6ad0c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18856.5",    0x1000000, 0x0400000, 0x214cef24 ) // good
ROM_END

ROM_START( prikura )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr19337.7",    0x0200000, 0x0200000, 0x76f69ff3 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19333.2",    0x0400000, 0x0400000, 0xeb57a6a6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19334.3",    0x0800000, 0x0400000, 0xc9979981 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19335.4",    0x0c00000, 0x0400000, 0x9e000140 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19336.5",    0x1000000, 0x0400000, 0x2363fa4b ) // good
ROM_END

ROM_START( puyosun )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr19531.13",               0x0000000, 0x0080000, 0xac81024f ) // bad
	ROM_RELOAD ( 0x0080000, 0x0080000 )
	ROM_RELOAD ( 0x0100000, 0x0080000 )
	ROM_RELOAD ( 0x0180000, 0x0080000 )
	ROM_RELOAD ( 0x0200000, 0x0080000 )
	ROM_RELOAD ( 0x0280000, 0x0080000 )
	ROM_RELOAD ( 0x0300000, 0x0080000 )
	ROM_RELOAD ( 0x0380000, 0x0080000 )
	ROM_LOAD16_WORD_SWAP( "mpr19533.2",    0x0400000, 0x0400000, 0x17ec54ba ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19534.3",    0x0800000, 0x0400000, 0x820e4781 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19535.4",    0x0c00000, 0x0400000, 0x94fadfa4 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19536.5",    0x1000000, 0x0400000, 0x5765bc9c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19537.6",    0x1400000, 0x0400000, 0x8b736686 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19532.1",    0x1800000, 0x0400000, 0x985f0c9d ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19538.8",    0x1c00000, 0x0400000, 0x915a723e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19539.9",    0x2000000, 0x0400000, 0x72a297e5 ) // good
ROM_END

ROM_START( rsgun )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr20958.7",   0x0200000, 0x0200000, 0xcbe5a449 ) // good (was .11s)
	ROM_LOAD16_WORD_SWAP( "mpr20959.2",   0x0400000, 0x0400000, 0xa953330b ) // good (was .12)
	ROM_LOAD16_WORD_SWAP( "mpr20960.3",   0x0800000, 0x0400000, 0xb5ab9053 ) // good (was .13)
	ROM_LOAD16_WORD_SWAP( "mpr20961.4",   0x0c00000, 0x0400000, 0x0e06295c ) // good (was .14)
	ROM_LOAD16_WORD_SWAP( "mpr20962.5",   0x1000000, 0x0400000, 0xf1e6c7fc ) // good (was .15)
ROM_END

ROM_START( sandor )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2c00000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "sando-r.13",               0x0000000, 0x0100000, 0xfe63a239 ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr18635.8",   0x1c00000, 0x0400000, 0x441e1368 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18636.9",   0x2000000, 0x0400000, 0xfff1dd80 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18637.10",  0x2400000, 0x0400000, 0x83aced0f ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18638.11",  0x2800000, 0x0400000, 0xcaab531b ) // good
ROM_END

ROM_START( sassisu )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1c00000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr20542.13",               0x0000000, 0x0100000, 0x0e632db5 ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr20544.2",    0x0400000, 0x0400000, 0x661fff5e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20545.3",    0x0800000, 0x0400000, 0x8e3a37be ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20546.4",    0x0c00000, 0x0400000, 0x72020886 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20547.5",    0x1000000, 0x0400000, 0x8362e397 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20548.6",    0x1400000, 0x0400000, 0xe37534d9 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20543.1",    0x1800000, 0x0400000, 0x1f688cdf ) // good
ROM_END

/* set to 1 player to test */
ROM_START( seabass )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "seabassf.13",               0x0000000, 0x0100000, 0x6d7c39cc ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr20551.2",    0x0400000, 0x0400000, 0x9a0c6dd8 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20552.3",    0x0800000, 0x0400000, 0x5f46b0aa ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20553.4",    0x0c00000, 0x0400000, 0xc0f8a6b6 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20554.5",    0x1000000, 0x0400000, 0x215fc1f9 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20555.6",    0x1400000, 0x0400000, 0x3f5186a9 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20550.1",    0x1800000, 0x0400000, 0x083e1ca8 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20556.8",    0x1c00000, 0x0400000, 0x1fd70c6c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20557.9",    0x2000000, 0x0400000, 0x3c9ba442 ) // good
ROM_END

ROM_START( shanhigw )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x0800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr18341.7",    0x0200000, 0x0200000, 0xcc5e8646 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18340.2",    0x0400000, 0x0200000, 0x8db23212 ) // good
ROM_END

ROM_START( shienryu )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x0c00000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr19631.7",    0x0200000, 0x0200000, 0x3a4b1abc ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19632.2",    0x0400000, 0x0400000, 0x985fae46 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19633.3",    0x0800000, 0x0400000, 0xe2f0b037 ) // good
ROM_END

ROM_START( sleague )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
 // must use USA
	ROM_REGION32_BE( 0x3000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr18777.13",               0x0000000, 0x0080000, 0x8d180866 ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr18778.8",    0x1c00000, 0x0400000, 0x25e1300e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18779.9",    0x2000000, 0x0400000, 0x51e2fabd ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18780.10",   0x2400000, 0x0400000, 0x8cd4dd74 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18781.11",   0x2800000, 0x0400000, 0x13ee41ae ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18782.12",   0x2c00000, 0x0200000, 0x9be2270a ) // good
ROM_END

ROM_START( sokyugrt )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fpr19188.13",               0x0000000, 0x0100000, 0x45a27e32 ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr19189.2",    0x0400000, 0x0400000, 0x0b202a3e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19190.3",    0x0800000, 0x0400000, 0x1777ded8 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19191.4",    0x0c00000, 0x0400000, 0xec6eb07b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19192.5",    0x1000000, 0x0200000, 0xcb544a1e ) // good
ROM_END

/* set to 1 player to test */
ROM_START( sss )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr21488.13",               0x0000000, 0x0080000, 0x71c9def1 ) // ic13 bad (was .24)
	ROM_LOAD16_WORD_SWAP( "mpr21489.2",    0x0400000, 0x0400000, 0x4c85152b ) // ic2 good (was .12)
	ROM_LOAD16_WORD_SWAP( "mpr21490.3",    0x0800000, 0x0400000, 0x03da67f8 ) // ic3 good (was .13)
	ROM_LOAD16_WORD_SWAP( "mpr21491.4",    0x0c00000, 0x0400000, 0xcf7ee784 ) // ic4 good (was .14)
	ROM_LOAD16_WORD_SWAP( "mpr21492.5",    0x1000000, 0x0400000, 0x57753894 ) // ic5 good (was .15)
	ROM_LOAD16_WORD_SWAP( "mpr21493.6",    0x1400000, 0x0400000, 0xefb2d271 ) // ic6 good (was .16)
ROM_END

ROM_START( suikoenb )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fpr17834.13",               0x0000000, 0x0100000, 0x746ef686 ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr17836.2",    0x0400000, 0x0400000, 0x55e9642d ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17837.3",    0x0800000, 0x0400000, 0x13d1e667 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17838.4",    0x0c00000, 0x0400000, 0xf9e70032 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17839.5",    0x1000000, 0x0400000, 0x1b2762c5 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17840.6",    0x1400000, 0x0400000, 0x0fd4c857 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17835.1",    0x1800000, 0x0400000, 0x77f5cb43 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17841.8",    0x1c00000, 0x0400000, 0xf48beffc ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17842.9",    0x2000000, 0x0400000, 0xac8deed7 ) // good
ROM_END

ROM_START( twcup98 )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr20819.13",    0x0000000, 0x0100000, 0xd930dfc8 ) // ic13 bad (was .24)
	ROM_LOAD16_WORD_SWAP( "mpr20821.2",    0x0400000, 0x0400000, 0x2d930d23 ) // ic2 good (was .12)
	ROM_LOAD16_WORD_SWAP( "mpr20822.3",    0x0800000, 0x0400000, 0x8b33a5e2 ) // ic3 good (was .13)
	ROM_LOAD16_WORD_SWAP( "mpr20823.4",    0x0c00000, 0x0400000, 0x6e6d4e95 ) // ic4 good (was .14)
	ROM_LOAD16_WORD_SWAP( "mpr20824.5",    0x1000000, 0x0400000, 0x4cf18a25 ) // ic5 good (was .15)
ROM_END

ROM_START( vfkids )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x3000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fpr18914.13",               0x0000000, 0x0100000, 0xcd35730a ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr18916.4",    0x0c00000, 0x0400000, 0x4aae3ddb ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18917.5",    0x1000000, 0x0400000, 0xedf6edc3 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18918.6",    0x1400000, 0x0400000, 0xd3a95036 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18915.1",    0x1800000, 0x0400000, 0x09cc38e5 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18919.8",    0x1c00000, 0x0400000, 0x4ac700de ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18920.9",    0x2000000, 0x0400000, 0x0106e36c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18921.10",   0x2400000, 0x0400000, 0xc23d51ad ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18922.11",   0x2800000, 0x0400000, 0x99d0ab90 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr18923.12",   0x2c00000, 0x0400000, 0x30a41ae9 ) // good
ROM_END

ROM_START( vfremix )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1c00000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr17944.13",               0x0000000, 0x0100000, 0xa5bdc560 ) // ic13 bad
	ROM_LOAD16_WORD_SWAP( "mpr17946.2",    0x0400000, 0x0400000, 0x4cb245f7 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17947.3",    0x0800000, 0x0400000, 0xfef4a9fb ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17948.4",    0x0c00000, 0x0400000, 0x3e2b251a ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17949.5",    0x1000000, 0x0400000, 0xb2ecea25 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17950.6",    0x1400000, 0x0400000, 0x5b1f981d ) // good
	ROM_LOAD16_WORD_SWAP( "mpr17945.1",    0x1800000, 0x0200000, 0x03ede188 ) // good
ROM_END

/* set to 1 player to test */
ROM_START( vmahjong )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr19620.7",    0x0200000, 0x0200000, 0xc98de7e5 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19615.2",    0x0400000, 0x0400000, 0xc62896da ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19616.3",    0x0800000, 0x0400000, 0xf62207c7 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19617.4",    0x0c00000, 0x0400000, 0xab667e19 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19618.5",    0x1000000, 0x0400000, 0x9782ceee ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19619.6",    0x1400000, 0x0400000, 0x0b76866c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19614.1",    0x1800000, 0x0400000, 0xb83b3f03 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr19621.8",    0x1c00000, 0x0400000, 0xf92616b3 ) // good
ROM_END

ROM_START( winterht )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "fpr20108.13",    0x0000000, 0x0100000, 0x1ef9ced0 ) // bad
	ROM_LOAD16_WORD_SWAP( "mpr20110.2",    0x0400000, 0x0400000, 0x238ef832 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20111.3",    0x0800000, 0x0400000, 0xb0a86f69 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20112.4",    0x0c00000, 0x0400000, 0x3ba2b49b ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20113.5",    0x1000000, 0x0400000, 0x8c858b41 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20114.6",    0x1400000, 0x0400000, 0xb723862c ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20109.1",    0x1800000, 0x0400000, 0xc1a713b8 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20115.8",    0x1c00000, 0x0400000, 0xdd01f2ad ) // good
ROM_END

ROM_START( znpwfv )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2800000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD( "epr20398.13",    0x0000000, 0x0100000, 0x3fb56a0b ) // bad
	ROM_LOAD16_WORD_SWAP( "mpr20400.2",    0x0400000, 0x0400000, 0x1edfbe05 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20401.3",    0x0800000, 0x0400000, 0x99e98937 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20402.4",    0x0c00000, 0x0400000, 0x4572aa60 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20403.5",    0x1000000, 0x0400000, 0x26a8e13e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20404.6",    0x1400000, 0x0400000, 0x0b70275d ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20399.1",    0x1800000, 0x0400000, 0xc178a96e ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20405.8",    0x1c00000, 0x0400000, 0xf53337b7 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20406.9",    0x2000000, 0x0400000, 0xb677c175 ) // good
	ROM_LOAD16_WORD_SWAP( "mpr20407.10",   0x2400000, 0x0400000, 0x58356050 ) // good
ROM_END

ROM_START( danchih )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x1400000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD16_WORD_SWAP( "mpr21974.7",    0x0200000, 0x0200000, 0xe7472793)
	ROM_LOAD16_WORD_SWAP( "mpr21970.2",    0x0400000, 0x0400000, 0x34dd7f4d)
	ROM_LOAD16_WORD_SWAP( "mpr21971.3",    0x0800000, 0x0400000, 0x8995158c)
	ROM_LOAD16_WORD_SWAP( "mpr21972.4",    0x0c00000, 0x0400000, 0x68a39090)
	ROM_LOAD16_WORD_SWAP( "mpr21973.5",    0x1000000, 0x0400000, 0xb0f23f14)
ROM_END

ROM_START( mausuke )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x2000000, REGION_USER1, 0 ) /* SH2 code */
	ROM_LOAD(             "ic13.bin",      0x0000000, 0x0100000, 0xb456f4cd)
	ROM_LOAD16_WORD_SWAP( "mcj-00.2",      0x0400000, 0x0200000, 0x4eeacd6f)
	ROM_LOAD16_WORD_SWAP( "mcj-01.3",      0x0800000, 0x0200000, 0x365a494b)
	ROM_LOAD16_WORD_SWAP( "mcj-02.4",      0x0c00000, 0x0200000, 0x8b8e4931)
	ROM_LOAD16_WORD_SWAP( "mcj-03.5",      0x1000000, 0x0200000, 0x9015a0e7)
	ROM_LOAD16_WORD_SWAP( "mcj-04.6",      0x1400000, 0x0200000, 0x9d1beaee)
	ROM_LOAD16_WORD_SWAP( "mcj-05.1",      0x1800000, 0x0200000, 0xa7626a82)
	ROM_LOAD16_WORD_SWAP( "mcj-06.8",      0x1c00000, 0x0200000, 0x1ab8e90e)
ROM_END

/* acclaim game, not a standard cart ... */
ROM_START( batmanfr )
	ROM_REGION( 0x080000, REGION_CPU1, 0 ) /* SH2 code */ \
	ROM_LOAD16_WORD_SWAP( "epr19730.ic8",   0x000000, 0x080000, 0xd0e0889d ) /* jp */ \
	ROM_REGION( 0x080000, REGION_CPU2, 0 ) /* SH2 code */ \
	ROM_COPY( REGION_CPU1,0,0,0x080000) \
	ROM_REGION( 0x100000, REGION_CPU3, 0 ) /* 68000 code */ \
	ROM_REGION( 0x100000, REGION_GFX1, 0 ) /* VDP2 GFX */ \
	ROM_REGION( 0x100000, REGION_GFX2, 0 ) /* VDP1 GFX */ \
	ROM_REGION32_BE( 0x3000000, REGION_USER1, 0 ) /* SH2 code */
	/* the batman forever rom test is more useless than most, i'm not really sure how
	   the roms should map, it doesn't even appear to test enough roms nor the right sizes!
	   everything fails for now
       range      tested as
	   040 - 04f  ic2
	   0c0 - 0ff  ic4
	   180 - 1bf  ic1
	   1c0 - 1ff  ic8
	   200 - 20f  ic9
	   2c0 - 2df  ic12
	   000 - ?    ic13

	   */
	ROM_LOAD16_BYTE( "350-mpa1.u19",    0x0000000, 0x0100000, 0x2a5a8c3a)
	ROM_LOAD16_BYTE( "350-mpa1.u16",    0x0000001, 0x0100000, 0x735e23ab)
	ROM_LOAD16_WORD_SWAP( "gfx0.u1",    0x0400000, 0x0400000, 0xa82d0b7e)
	ROM_LOAD16_WORD_SWAP( "gfx1.u3",    0x0c00000, 0x0400000, 0xa41e55d9)
	ROM_LOAD16_WORD_SWAP( "gfx2.u5",    0x1800000, 0x0400000, 0x4c1ebeb7)
	ROM_LOAD16_WORD_SWAP( "gfx3.u8",    0x1c00000, 0x0400000, 0xf679a3e7)
	ROM_LOAD16_WORD_SWAP( "gfx4.u12",   0x0800000, 0x0400000, 0x52d95242)
	ROM_LOAD16_WORD_SWAP( "gfx5.u15",   0x2000000, 0x0400000, 0xe201f830)
	ROM_LOAD16_WORD_SWAP( "gfx6.u18",   0x2c00000, 0x0400000, 0xc6b381a3)

	/* it also has an extra adsp sound board, i guess this isn't tested */
	ROM_REGION( 0x080000, REGION_USER2, 0 ) /* ADSP code */
	ROM_LOAD( "350snda1.u52",   0x000000, 0x080000, 0x9027e7a0)

	ROM_REGION( 0x800000, REGION_USER3, 0 ) /* Sound */
	ROM_LOAD( "snd0.u48",   0x000000, 0x200000, 0x02b1927c)
	ROM_LOAD( "snd1.u49",   0x200000, 0x200000, 0x58b18eda)
	ROM_LOAD( "snd2.u50",   0x400000, 0x200000, 0x51d626d6)
	ROM_LOAD( "snd3.u51",   0x600000, 0x200000, 0x31af26ae)
ROM_END

/* Playable */
GAMEX( 1998, hanagumi,  stvbios, stv, stv,  hanagumi,  ROT0, "Sega", "Hanagumi Taisen Columns - Sakura Wars", GAME_NO_SOUND | GAME_IMPERFECT_GRAPHICS )

/* Doing Something.. but not much enough yet */
GAMEX( 1996, prikura,   stvbios, stv, stv,  prikura,   ROT0, "Atlus",    "Prikura Daisakusen", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, shanhigw,  stvbios, stv, stv,  stv,       ROT0, "Sunsoft / Activision", "Shanghai - The Great Wall / Shanghai Triple Threat", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1997, shienryu,  stvbios, stv, stv,  shienryu,  ROT0, "Warashi",  "Shienryu", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, groovef,   stvbios, stv, stv,  stv,       ROT0, "Atlus",    "Power Instinct 3 - Groove On Fight", GAME_NO_SOUND | GAME_NOT_WORKING )

/* not working */

//GBX   YEAR, NAME,      PARENT,  BIOS,    MACH,INP,  INIT,MONITOR
GAME( 1996, stvbios,   0,       stv, stv,  stv,       ROT0, "Sega",    "Sega Taitan Video Game System (ST-V) Bios" )
GAMEX( 1998, astrass,   stvbios, stv, stv,  stv,       ROT0, "Sunsoft",  "Astra SuperStars", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, bakubaku,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Baku Baku Animal", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, batmanfr,  stvbios, stv, stv,  stv,       ROT0, "Acclaim",  "Batman Forever", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, colmns97,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Columns 97", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1997, cotton2,   stvbios, stv, stv,  stv,       ROT0, "Success",  "Cotton 2", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, cottonbm,  stvbios, stv, stv,  stv,       ROT0, "Success",  "Cotton Boomerang", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1999, danchih,   stvbios, stv, stv,  stv,       ROT0, "Altron (distributed by Tecmo)", "Danchi de Hanafuda", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, decathlt,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Decathlete", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, diehard,   stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Die Hard Arcade (US)", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, dnmtdeka,  diehard, stv, stv,  stv,       ROT0, "Sega", 	   "Dynamite Deka (Japan)", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, ejihon,    stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Ejihon Tantei Jimusyo", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, elandore,  stvbios, stv, stv,  stv,       ROT0, "Sai-Mate", "Fighting Dragon Legend Elan Doree", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1999, ffreveng,  stvbios, stv, stv,  stv,       ROT0, "Capcom",   "Final Fight Revenge", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, fhboxers,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Funky Head Boxers", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, findlove,  stvbios, stv, stv,  stv,       ROT0, "Daiki",	   "Find Love", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, finlarch,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Final Arch (Japan)", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1994, gaxeduel,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Golden Axe - The Duel", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, grdforce,  stvbios, stv, stv,  stv,       ROT0, "Success",  "Guardian Force", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, introdon,  stvbios, stv, stv,  stv,       ROT0, "Sunsoft / Success", "Karaoke Quiz Intro Don Don!", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, kiwames,   stvbios, stv, stv,  stv,       ROT0, "Athena",   "Pro Mahjong Kiwame S", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1997, maruchan,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Maru-Chan de Goo!", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, mausuke,   stvbios, stv, stv,  stv,       ROT0, "Data East","Mausuke no Ojama the World", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, myfairld,  stvbios, stv, stv,  stv,       ROT0, "Micronet", "Virtual Mahjong 2 - My Fair Lady", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, othellos,  stvbios, stv, stv,  stv,       ROT0, "Tsukuda Original",	"Othello Shiyouyo", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, pblbeach,  stvbios, stv, stv,  stv,       ROT0, "T&E Soft", "Pebble Beach - The Great Shot", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, puyosun,   stvbios, stv, stv,  stv,       ROT0, "Compile",  "Puyo Puyo Sun", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, rsgun,     stvbios, stv, stv,  stv,       ROT0, "Treasure", "Radiant Silvergun", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, sandor,    stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Sando-R", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, sassisu,   stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Taisen Tanto-R 'Sasshissu!'", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, seabass,   stvbios, stv, stv,  stv,       ROT0, "A Wave inc. (Able license)", "Sea Bass Fishing", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, sleague,   stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Super Major League (US)", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, sokyugrt,  stvbios, stv, stv,  stv,       ROT0, "Raizing",  "Soukyugurentai / Terra Diver", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, sss,       stvbios, stv, stv,  stv,       ROT0, "Victor / Cave / Capcom", "Steep Slope Sliders", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, suikoenb,  stvbios, stv, stv,  stv,       ROT0, "Data East","Suikoenbu", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1998, twcup98,   stvbios, stv, stv,  stv,       ROT0, "Tecmo",    "Tecmo World Cup '98", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, vfkids,    stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Virtua Fighter Kids", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, vfremix,   stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Virtua Fighter Remix", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1997, vmahjong,  stvbios, stv, stv,  stv,       ROT0, "Micronet", "Virtual Mahjong", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1997, winterht,  stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Winter Heat", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1997, znpwfv,    stvbios, stv, stv,  stv,       ROT0, "Sega", 	   "Zen Nippon Pro-Wrestling Featuring Virtua", GAME_NO_SOUND | GAME_NOT_WORKING )

/* there are probably a bunch of other games (some fishing games with cd-rom,Print Club 2 etc.) */
