/*

macs.c - Multi Amenity Cassette System

processor seems to be ST0016 (z80 based) from SETA

around 0x3700 of the bios (when interleaved) contains the ram test text


----- Game Notes -----

Kisekae Mahjong  (c)1995 I'MAX
Kisekae Hanafuda (c)1995 I'MAX
Seimei-Kantei-Meimei-Ki Cult Name (c)1996 I'MAX

KISEKAE -- info

* DIP SWITCH *

                      | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 |
-------------------------------------------------------
 P2 Level |  Normal   |off|off|                       |
          |   Weak    |on |off|                       |
          |  Strong   |off|on |                       |
          |Very strong|on |on |                       |
-------------------------------------------------------
 P2 Points|  Normal   |       |off|off|               |
          |  Easy     |       |on |off|               |
          |  Hard     |       |off|on |               |
          | Very hard |       |on |on |               |
-------------------------------------------------------
 P1       |  1000pts  |               |off|           |
 points   |  2000pts  |               |on |           |
-------------------------------------------------------
  Auto    |   Yes     |                   |off|       |
  tumo    |   No      |                   |on |       |
-------------------------------------------------------
  Not     |           |                       |off|   |
  Used    |           |                       |on |   |
-------------------------------------------------------
  Tumo    |   Long    |                           |off|
  time    |   Short   |                           |on |
-------------------------------------------------------

* at slotA -> DIP SW3
     slotB -> DIP SW4


*/

#include "driver.h"

static MEMORY_READ_START( readmem )
/*	{ 0x0000, 0x7fff, MRA_BANK1 } */
MEMORY_END

static MEMORY_WRITE_START( writemem )
/*	{ 0x0000, 0x7fff, MWA_BANK1 } */
MEMORY_END

INPUT_PORTS_START( macs )
INPUT_PORTS_END

VIDEO_START(macs)
{
	return 0;
}

VIDEO_UPDATE(macs)
{

}

static MACHINE_DRIVER_START( macs )
	/* basic machine hardware */
	MDRV_CPU_ADD(Z80,8000000)		 /* ? what processor ? MHz */
	MDRV_CPU_MEMORY(readmem,writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER )
	MDRV_SCREEN_SIZE(1024, 1024)
	MDRV_VISIBLE_AREA(0, 1024-1, 0, 1024-1)
	MDRV_PALETTE_LENGTH(1024 + 1)

	MDRV_VIDEO_START(macs)
	MDRV_VIDEO_UPDATE(macs)
MACHINE_DRIVER_END

static DRIVER_INIT ( macs )
{
	cpu_setbank( 1, memory_region( REGION_USER1 ) );
}


 

ROM_START( macsbios )
	ROM_REGION( 0x10000, REGION_CPU1, 0 ) 
	ROM_REGION( 0x100000, REGION_USER1, 0 ) 
	ROM_LOAD16_BYTE( "macsos_l.u43", 0x00000, 0x80000, 0x0b5aed5e) 
	ROM_LOAD16_BYTE( "macsos_h.u44", 0x00001, 0x80000, 0x538b68e4)
	ROM_REGION( 0x400000, REGION_USER2, 0 ) // Slot A
	ROM_REGION( 0x400000, REGION_USER3, 0 ) // Slot B
ROM_END

ROM_START( kisekaem )
	ROM_REGION( 0x10000, REGION_CPU1, 0 ) 
	ROM_REGION( 0x100000, REGION_USER1, 0 ) 
	ROM_LOAD16_BYTE( "macsos_l.u43", 0x00000, 0x80000, 0x0b5aed5e) 
	ROM_LOAD16_BYTE( "macsos_h.u44", 0x00001, 0x80000, 0x538b68e4)

	ROM_REGION( 0x400000, REGION_USER2, 0 ) // Slot A
	ROM_LOAD16_BYTE( "am-mj.u8", 0x000000, 0x100000, 0x3cf85151)
	ROM_LOAD16_BYTE( "am-mj.u7", 0x000001, 0x100000, 0x4b645354)
	ROM_LOAD16_BYTE( "am-mj.u6", 0x200000, 0x100000, 0x23b3aa24)
	ROM_LOAD16_BYTE( "am-mj.u5", 0x200001, 0x100000, 0xb4d53e29)

	ROM_REGION( 0x400000, REGION_USER3, 0 ) // Slot B
ROM_END

ROM_START( kisekaeh )
	ROM_REGION( 0x10000, REGION_CPU1, 0 ) 
	ROM_REGION( 0x100000, REGION_USER1, 0 ) 
	ROM_LOAD16_BYTE( "macsos_l.u43", 0x00000, 0x80000, 0x0b5aed5e) 
	ROM_LOAD16_BYTE( "macsos_h.u44", 0x00001, 0x80000, 0x538b68e4)

	ROM_REGION( 0x400000, REGION_USER2, 0 ) // Slot A
	ROM_LOAD16_BYTE( "kh-u8.bin", 0x000000, 0x100000, 0x601b9e6a)
	ROM_LOAD16_BYTE( "kh-u7.bin", 0x000001, 0x100000, 0x8f6e4bb3)
	ROM_LOAD16_BYTE( "kh-u6.bin", 0x200000, 0x100000, 0x8e700204)
	ROM_LOAD16_BYTE( "kh-u5.bin", 0x200001, 0x100000, 0x709bf7c8)

	ROM_REGION( 0x400000, REGION_USER3, 0 ) // Slot B
ROM_END

ROM_START( cultname ) // uses printer
	ROM_REGION( 0x10000, REGION_CPU1, 0 ) 
	ROM_REGION( 0x100000, REGION_USER1, 0 ) 
	ROM_LOAD16_BYTE( "macsos_l.u43", 0x00000, 0x80000, 0x0b5aed5e) 
	ROM_LOAD16_BYTE( "macsos_h.u44", 0x00001, 0x80000, 0x538b68e4)

	ROM_REGION( 0x400000, REGION_USER2, 0 ) // Slot A
	ROM_LOAD16_BYTE( "cult-d0.u8", 0x000000, 0x100000, 0x394bc1a6)
	ROM_LOAD16_BYTE( "cult-d1.u7", 0x000001, 0x100000, 0xf628133b)
	ROM_LOAD16_BYTE( "cult-d2.u6", 0x200000, 0x100000, 0xc5521bc6)
	ROM_LOAD16_BYTE( "cult-d3.u5", 0x200001, 0x100000, 0x4325b09b)

	ROM_REGION( 0x400000, REGION_USER3, 0 ) // Slot B
	ROM_LOAD16_BYTE( "cult-g0.u8", 0x000000, 0x100000, 0xf5ab977b)
	ROM_LOAD16_BYTE( "cult-g1.u7", 0x000001, 0x100000, 0x32ae15a4)
	ROM_LOAD16_BYTE( "cult-g2.u6", 0x200000, 0x100000, 0x30ed056d)
	ROM_LOAD16_BYTE( "cult-g3.u5", 0x200001, 0x100000, 0xfe58b418)
ROM_END

/* these are listed as MACS2 sub-boards, is it the same? */

ROM_START( yuka )
	ROM_REGION( 0x10000, REGION_CPU1, 0 ) 
	ROM_REGION( 0x100000, REGION_USER1, 0 ) 
	ROM_LOAD16_BYTE( "macsos_l.u43", 0x00000, 0x80000, 0x0b5aed5e) 
	ROM_LOAD16_BYTE( "macsos_h.u44", 0x00001, 0x80000, 0x538b68e4)
//	ROM_LOAD16_BYTE( "macsos2_l.u43", 0x00000, 0x80000, NO_DUMP) 
//	ROM_LOAD16_BYTE( "macsos2_h.u44", 0x00001, 0x80000, NO_DUMP)

	ROM_REGION( 0x400000, REGION_USER2, 0 ) // Slot A
	ROM_LOAD16_BYTE( "yu-ka_1.u8", 0x000000, 0x100000, 0xbccd1b15)
	ROM_LOAD16_BYTE( "yu-ka_3.u7", 0x000001, 0x100000, 0x45b8263e)
	ROM_LOAD16_BYTE( "yu-ka_2.u6", 0x200000, 0x100000, 0xc3c5728b)
	ROM_LOAD16_BYTE( "yu-ka_4.u5", 0x200001, 0x100000, 0x7e391ee6)

	ROM_REGION( 0x400000, REGION_USER3, 0 ) // Slot B
ROM_END

ROM_START( yujan )
	ROM_REGION( 0x10000, REGION_CPU1, 0 ) 
	ROM_REGION( 0x100000, REGION_USER1, 0 ) 
	ROM_LOAD16_BYTE( "macsos_l.u43", 0x00000, 0x80000, 0x0b5aed5e) 
	ROM_LOAD16_BYTE( "macsos_h.u44", 0x00001, 0x80000, 0x538b68e4)
//	ROM_LOAD16_BYTE( "macsos2_l.u43", 0x00000, 0x80000, NO_DUMP) 
//	ROM_LOAD16_BYTE( "macsos2_h.u44", 0x00001, 0x80000, NO_DUMP)

	ROM_REGION( 0x400000, REGION_USER2, 0 ) // Slot A
	ROM_LOAD16_BYTE( "yu-jan_1.u8", 0x000000, 0x100000, 0xfeeeee6a)
	ROM_LOAD16_BYTE( "yu-jan_3.u7", 0x000001, 0x100000, 0x1c1d6997)
	ROM_LOAD16_BYTE( "yu-jan_2.u6", 0x200000, 0x100000, 0x2f4a8d4b)
	ROM_LOAD16_BYTE( "yu-jan_4.u5", 0x200001, 0x100000, 0x226df87b)

	ROM_REGION( 0x400000, REGION_USER3, 0 ) // Slot B
ROM_END

GAMEX( 1995, macsbios, 0,        macs, macs, macs, ROT0, "I'Max", "Multi Amenity Cassette System BIOS", NOT_A_DRIVER | GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, kisekaem, macsbios, macs, macs, macs, ROT0, "I'Max", "Kisekae Mahjong", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1995, kisekaeh, macsbios, macs, macs, macs, ROT0, "I'Max", "Kisekae Hanafuda", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1996, cultname, macsbios, macs, macs, macs, ROT0, "I'Max", "Seimei-Kantei-Meimei-Ki Cult Name", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1999, yuka,     macsbios, macs, macs, macs, ROT0, "Yubis / T.System", "Yu-Ka", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 1999, yujan,    macsbios, macs, macs, macs, ROT0, "Yubis / T.System", "Yu-Jan", GAME_NO_SOUND | GAME_NOT_WORKING )
