//============================================================
//
//	video.h - Win32 implementation of MAME video routines
//
//============================================================

#ifndef __WIN_VIDEO__
#define __WIN_VIDEO__


//============================================================
//	PARAMETERS
//============================================================

// maximum video size
#define MAX_VIDEO_WIDTH			1600
#define MAX_VIDEO_HEIGHT		1200

#ifdef UI_COLOR_DISPLAY
enum
{
	FONT_COLOR_BLANK = 0,
	FONT_COLOR_NORMAL,
	FONT_COLOR_BLANK_INVERSE,
	FONT_COLOR_NORMAL_INVERSE,
	BUTTON_COLOR_RED,
	BUTTON_COLOR_YELLOW,
	BUTTON_COLOR_GREEN,
	BUTTON_COLOR_BLUE,
	BUTTON_COLOR_PURPLE,
	BUTTON_COLOR_PINK,
	BUTTON_COLOR_AQUA,
	CURSOR_COLOR,
	MAX_COLORTABLE
};
#endif



//============================================================
//	GLOBAL VARIABLES
//============================================================

// current frameskip/autoframeskip settings
extern int			frameskip;
extern int			autoframeskip;

// speed throttling
extern int			throttle;

// palette lookups
extern UINT8		palette_lookups_invalid;
extern UINT32 		palette_16bit_lookup[];
extern UINT32 		palette_32bit_lookup[];

// rotation
extern UINT8		blit_flipx;
extern UINT8		blit_flipy;
extern UINT8		blit_swapxy;

#ifdef UI_COLOR_DISPLAY
// palette rgb (0x00bbggrr)
extern UINT32		ui_colortable[MAX_COLORTABLE][3];
#endif



//============================================================
//	PROTOTYPES
//============================================================

void win_orient_rect(struct rectangle *rect);
void win_disorient_rect(struct rectangle *rect);

#endif
