#####################################################################
# make SUFFIX=32

# don't create gamelist.txt
TEXTS = gamelist.txt

#--------------------------------------------------------------------
# remove pedantic
$(OBJ)/ui/%.o: src/ui/%.c
	@echo Compiling $<...
	@sjisfix $< check
	$(CC) $(CDEFS) $(CFLAGS) -c $< -o $@
	@sjisfix $< delete
#--------------------------------------------------------------------

OBJDIRS += $(OBJ)/ui

# only OS specific output files and rules
OSOBJS += \
        $(OBJ)/ui/MAME32.o \
        $(OBJ)/ui/M32Util.o \
        $(OBJ)/ui/DirectInput.o \
        $(OBJ)/ui/DIJoystick.o \
        $(OBJ)/ui/DirectDraw.o \
        $(OBJ)/ui/file.o \
        $(OBJ)/ui/Directories.o \
        $(OBJ)/ui/mzip.o \
        $(OBJ)/ui/audit32.o \
        $(OBJ)/ui/ColumnEdit.o \
        $(OBJ)/ui/Screenshot.o \
        $(OBJ)/ui/TreeView.o \
        $(OBJ)/ui/Splitters.o \
        $(OBJ)/ui/Bitmask.o \
        $(OBJ)/ui/DataMap.o \
        $(OBJ)/ui/dxdecode.o \
        $(OBJ)/ui/Win32ui.o \
        $(OBJ)/ui/Properties.o \
        $(OBJ)/ui/ChildOutputStream.o \
        $(OBJ)/ui/options.o \
        $(OBJ)/ui/help.o


#--------------------------------------------------------------------
# add resource file
ifdef JAPANESE
OSOBJS += $(OBJ)/ui/mame32j.res
else
OSOBJS += $(OBJ)/ui/mame32e.res
endif
#--------------------------------------------------------------------

#####################################################################
# compiler

#
# Preprocessor Definitions
#

#--------------------------------------------------------------------
DEFS += -DDIRECTSOUND_VERSION=0x0700 \
        -DDIRECTINPUT_VERSION=0x0700 \
        -DDIRECTDRAW_VERSION=0x0700 \
        -DWINVER=0x0400 \
        -D_WIN32_IE=0x0400 \
        -D_WIN32_WINNT=0x0400 \
        -DWIN32 \
        -UWINNT \
	-DCLIB_DECL=__cdecl \
	-DDECL_SPEC= \
        -DZEXTERN=extern

DEFS += -DEXTRA_FOLDER \
        -DSHOW_UNAVAILABLE_FOLDER \
        -DCPS_FOLDER \
        -DSOURCE_FOLDER \
        -DDRIVERS_COLUMN \
	-DDIRECT3D_EFFECT \
#--------------------------------------------------------------------

#####################################################################
# Resources

#--------------------------------------------------------------------
RCDEFS = -DNDEBUG -D_WIN32_IE=0x0400

ifdef JAPANESE
  RC  = @brcc32
  RC2 = @windres
  RCFLAGS = -r -I./ui
else
  RC  = @windres
  RCFLAGS = -O coff --include-dir src/ui
endif

ifdef JAPANESE
  $(OBJ)/ui/%.res: src/ui/%.rc
	@echo Compiling resources $<...
	$(RC) $(RCDEFS) $(RCFLAGS) -Fo$(OBJ)/ui/mame32j.res $<
	$(RC2) -I res -O coff -i $(OBJ)/ui/mame32j.res -o $@
else
  $(OBJ)/ui/%.res: src/ui/%.rc
	@echo Compiling resources $<...
	$(RC) $(RCDEFS) $(RCFLAGS) -o $@ -i $<
endif
#--------------------------------------------------------------------

#####################################################################
# Linker

LIBS += -lkernel32 \
        -lshell32 \
        -lcomctl32 \
        -lcomdlg32 \
        -ladvapi32 \
        -lhtmlhelp

# use -mconsole for romcmp
LDFLAGS += -mwindows

#####################################################################

