/******************************************************************************

  driver.c

  The list of all available drivers. Drivers have to be included here to be
  recognized by the executable.

  To save some typing, we use a hack here. This file is recursively #included
  twice, with different definitions of the DRIVER() macro. The first one
  declares external references to the drivers; the second one builds an array
  storing all the drivers.

******************************************************************************/

#include "driver.h"


#ifndef DRIVER_RECURSIVE

/* The "root" driver, defined so we can have &driver_##NAME in macros. */
struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

#endif

#ifdef TINY_COMPILE

extern struct GameDriver TINY_NAME;

const struct GameDriver *drivers[] =
{
	TINY_POINTER,
	0	/* end of array */
};

#else

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) extern struct GameDriver driver_##NAME;
#define TESTDRIVER(NAME) extern struct GameDriver driver_##NAME;
#include "taitodriver.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#undef TESTDRIVER
#define DRIVER(NAME) &driver_##NAME,
#define TESTDRIVER(NAME)
const struct GameDriver *drivers[] =
{
#include "taitodriver.c"
	0	/* end of array */
};

#else	/* DRIVER_RECURSIVE */


	/* Taito "Qix hardware" games */
	DRIVER( qix )		/* LK  (c) 1981 Taito America Corporation */
	DRIVER( qixa )		/* LK  (c) 1981 Taito America Corporation */
	DRIVER( qixb )		/* LK  (c) 1981 Taito America Corporation */
	DRIVER( qix2 )		/* ??  (c) 1981 Taito America Corporation */
	DRIVER( sdungeon )	/* SD  (c) 1981 Taito America Corporation */
	DRIVER( elecyoyo )	/* YY  (c) 1982 Taito America Corporation */
	DRIVER( elecyoy2 )	/* YY  (c) 1982 Taito America Corporation */
	DRIVER( kram )		/* KS  (c) 1982 Taito America Corporation */
	DRIVER( kram2 )		/* KS  (c) 1982 Taito America Corporation */
	DRIVER( zookeep )	/* ZA  (c) 1982 Taito America Corporation */
	DRIVER( zookeep2 )	/* ZA  (c) 1982 Taito America Corporation */
	DRIVER( zookeep3 )	/* ZA  (c) 1982 Taito America Corporation */
	DRIVER( slither )	/* (c) 1982 Century II */
	DRIVER( slithera )	/* (c) 1982 Century II */

	/* Taito SJ System games */
	DRIVER( spaceskr )	/* EB  (c) 1981 Taito Corporation */
	DRIVER( junglek )	/* KN  (c) 1982 Taito Corporation */
	DRIVER( junglkj2 )	/* KN  (c) 1982 Taito Corporation */
	DRIVER( jungleh )	/* KN  (c) 1982 Taito America Corporation */
	DRIVER( junglhbr )	/* KN  (c) 1982 Taito do Brasil */
	DRIVER( piratpet )	/* KN  (c) 1982 Taito America Corporation */
	DRIVER( alpine )	/* RH  (c) 1982 Taito Corporation */
	DRIVER( alpinea )	/* RH  (c) 1982 Taito Corporation */
	DRIVER( timetunl )	/* UN  (c) 1982 Taito Corporation */
	DRIVER( wwestern )	/* WW  (c) 1982 Taito Corporation */
	DRIVER( wwester1 )	/* WW  (c) 1982 Taito Corporation */
	DRIVER( frontlin )	/* FL  (c) 1982 Taito Corporation */
	DRIVER( elevator )	/* EA  (c) 1983 Taito Corporation */
	DRIVER( elevatob )	/* bootleg */
	DRIVER( tinstar )	/* A10 (c) 1983 Taito Corporation */
	DRIVER( waterski )	/* A03 (c) 1983 Taito Corporation */
	DRIVER( bioatack )	/* AA8 (c) 1983 Taito Corporation + Fox Video Games license */
	DRIVER( hwrace )	/* AC4 (c) 1983 Taito Corporation */
	DRIVER( sfposeid )	/* A14 (c) 1984 Taito Corporation */
TESTDRIVER( kikstart )	/* A20 */

	/* other Taito games */
	DRIVER( crbaloon )	/* CL  (c) 1980 Taito Corporation */
	DRIVER( crbalon2 )	/* CL  (c) 1980 Taito Corporation */
	DRIVER( grchamp )	/* GM  (c) 1981 Taito Corporation */
	DRIVER( bking )		/* DM  (c) 1982 Taito Corporation */
	DRIVER( bking2 )	/* AD6 (c) 1983 Taito Corporation */
TESTDRIVER( josvolly )	/* ??? (c) 1983 Taito Corporation */
	DRIVER( gsword )	/* ??? (c) 1984 Taito Corporation */
	DRIVER( lkage )		/* A54 (c) 1984 Taito Corporation */
	DRIVER( lkageb )	/* bootleg */
	DRIVER( lkageb2 )	/* bootleg */
	DRIVER( lkageb3 )	/* bootleg */
TESTDRIVER( msisaac )	/* A34 (c) 1985 Taito Corporation */
	DRIVER( retofinv )	/* A37 (c) 1985 Taito Corporation */
	DRIVER( retofin1 )	/* bootleg */
	DRIVER( retofin2 )	/* bootleg */
	DRIVER( fightrol )	/* (c) 1983 Taito */
	DRIVER( rollrace )	/* (c) 1983 Williams */
	DRIVER( vsgongf )	/* (c) 1984 Kaneko */
	DRIVER( undoukai )	/* A17 (c) 1984 Taito */
	DRIVER( 40love )	/* A30 (c) 1984 Taito */
	DRIVER( tsamurai )	/* A35 (c) 1985 Taito */
	DRIVER( tsamura2 )	/* A35 (c) 1985 Taito */
	DRIVER( nunchaku )	/* ??? (c) 1985 Taito */
	DRIVER( yamagchi )	/* A38 (c) 1985 Taito */
	DRIVER( m660 )      /* ??? (c) 1986 Taito America Corporation */
	DRIVER( m660j )     /* ??? (c) 1986 Taito Corporation (Japan) */
	DRIVER( m660b )     /* bootleg */
	DRIVER( alphaxz )   /* ??? (c) 1986 Ed/Wood Place */
	DRIVER( buggychl )	/* A22 (c) 1984 Taito Corporation */
	DRIVER( buggycht )	/* A22 (c) 1984 Taito Corporation + Tefri license */
	DRIVER( flstory )	/* A45 (c) 1985 Taito Corporation */
	DRIVER( flstoryj )	/* A45 (c) 1985 Taito Corporation (Japan) */
	DRIVER( onna34ro )	/* A52 (c) 1985 Taito Corporation (Japan) */
	DRIVER( onna34ra )	/* A52 (c) 1985 Taito Corporation (Japan) */
	DRIVER( gladiatr )	/* ??? (c) 1986 Taito America Corporation (US) */
	DRIVER( ogonsiro )	/* ??? (c) 1986 Taito Corporation (Japan) */
TESTDRIVER( benberob )	/* A26 */
TESTDRIVER( halleys )	/* A62 */
TESTDRIVER( halleysc )	/* A62 */
TESTDRIVER( halleycj )	/* A62 */
	DRIVER( lsasquad )	/* A64 (c) 1986 Taito Corporation / Taito America (dip switch) */
	DRIVER( storming )	/* A64 (c) 1986 Taito Corporation */
	DRIVER( tokio )		/* A71 1986 */
	DRIVER( tokiob )	/* bootleg */
	DRIVER( bublbobl )	/* A78 (c) 1986 Taito Corporation */
	DRIVER( bublbobr )	/* A78 (c) 1986 Taito America Corporation + Romstar license */
	DRIVER( bubbobr1 )	/* A78 (c) 1986 Taito America Corporation + Romstar license */
	DRIVER( boblbobl )	/* bootleg */
	DRIVER( sboblbob )	/* bootleg */
	DRIVER( missb2 )	/* bootleg on enhanced hardware */
	DRIVER( kikikai )	/* A85 (c) 1986 Taito Corporation */
	DRIVER( kicknrun )	/* A87 (c) 1986 Taito Corporation */
	DRIVER( mexico86 )	/* bootleg (Micro Research) */
	DRIVER( darius )	/* A96 (c) 1986 Taito Corporation Japan (World) */
	DRIVER( dariusj )	/* A96 (c) 1986 Taito Corporation (Japan) */
	DRIVER( dariuso )	/* A96 (c) 1986 Taito Corporation (Japan) */
	DRIVER( dariuse )	/* A96 (c) 1986 Taito Corporation (Japan) */
	DRIVER( rastan )	/* B04 (c) 1987 Taito Corporation Japan (World) */
	DRIVER( rastanu )	/* B04 (c) 1987 Taito America Corporation (US) */
	DRIVER( rastanu2 )	/* B04 (c) 1987 Taito America Corporation (US) */
	DRIVER( rastsaga )	/* B04 (c) 1987 Taito Corporation (Japan)*/
	DRIVER( topspeed )	/* B14 (c) 1987 Taito Corporation Japan (World) */
	DRIVER( topspedu )	/* B14 (c) 1987 Taito America Corporation (US) */
	DRIVER( fullthrl )	/* B14 (c) 1987 Taito Corporation (Japan) */
	DRIVER( opwolf )	/* B20 (c) 1987 Taito America Corporation (US) */
	DRIVER( opwolfb )	/* bootleg */
	DRIVER( othunder )	/* B67 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( othundu )	/* B67 (c) 1988 Taito America Corporation (US) */
	DRIVER( rainbow )	/* B22 (c) 1987 Taito Corporation */
	DRIVER( rainbowo )	/* B22 (c) 1987 Taito Corporation */
	DRIVER( rainbowe )	/* B39 (c) 1988 Taito Corporation */
	DRIVER( jumping )	/* bootleg */
	DRIVER( arkanoid )	/* A75 (c) 1986 Taito Corporation Japan (World) */
	DRIVER( arknoidu )	/* A75 (c) 1986 Taito America Corporation + Romstar license (US) */
	DRIVER( arknoidj )	/* A75 (c) 1986 Taito Corporation (Japan) */
	DRIVER( arkbl2 )	/* bootleg */
	DRIVER( arkbl3 )	/* bootleg */
	DRIVER( paddle2 )	/* bootleg */
	DRIVER( arkatayt )	/* bootleg */
	DRIVER( arkblock )	/* bootleg */
	DRIVER( arkbloc2 )	/* bootleg */
	DRIVER( arkangc )	/* bootleg */
	DRIVER( arkatour )	/* ??? (c) 1987 Taito America Corporation + Romstar license (US) */
	DRIVER( superqix )	/* B03 1987 */
	DRIVER( sqixbl )	/* bootleg? but (c) 1987 */
	DRIVER( exzisus )	/* B23 (c) 1987 Taito Corporation (Japan) */
	DRIVER( minivadr )	/* D26 cabinet test board */
	DRIVER( volfied )	/* C04 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( volfiedu )	/* C04 (c) 1989 Taito America Corporation (US) */
	DRIVER( volfiedj )	/* C04 (c) 1989 Taito Corporation (Japan) */
	DRIVER( bonzeadv )	/* B41 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( bonzeadu )	/* B41 (c) 1988 Taito America Corporation (US) */
	DRIVER( jigkmgri )	/* B41 (c) 1988 Taito Corporation (Japan)*/
	DRIVER( asuka )		/* ??? (c) 1988 Taito Corporation (Japan) */
	DRIVER( mofflott )	/* C17 (c) 1989 Taito Corporation (Japan) */
	DRIVER( cadash )	/* C21 (c) 1989 Taito Corporation Japan */
	DRIVER( cadashj )	/* C21 (c) 1989 Taito Corporation */
	DRIVER( cadashu )	/* C21 (c) 1989 Taito America Corporation */
	DRIVER( cadashi )	/* C21 (c) 1989 Taito Corporation Japan */
	DRIVER( cadashf )	/* C21 (c) 1989 Taito Corporation Japan */
	DRIVER( galmedes )	/* (c) 1992 Visco (Japan) */
	DRIVER( earthjkr )	/* (c) 1993 Visco (Japan) */
	DRIVER( eto )		/* (c) 1994 Visco (Japan) */
	DRIVER( wgp )		/* C32 (c) 1989 Taito America Corporation (US) */
	DRIVER( wgpj )		/* C32 (c) 1989 Taito Corporation (Japan) */
	DRIVER( wgpjoy )	/* C32 (c) 1989 Taito Corporation (Japan) */
	DRIVER( wgpjoya )	/* C32 (c) 1989 Taito Corporation (Japan) */
	DRIVER( wgp2 )		/* C73 (c) 1990 Taito Corporation (Japan) */
	DRIVER( slapshot )	/* D71 (c) 1994 Taito Corporation (Japan) */

	/* Taito multi-screen games */
	DRIVER( ninjaw )	/* B31 (c) 1987 Taito Corporation Japan (World) */
	DRIVER( ninjawj )	/* B31 (c) 1987 Taito Corporation (Japan) */
	DRIVER( darius2 )	/* C07 (c) 1989 Taito Corporation (Japan) */
	DRIVER( darius2d )	/* C07 (c) 1989 Taito Corporation (Japan) */
	DRIVER( drius2do )	/* C07 (c) 1989 Taito Corporation (Japan) */
	DRIVER( warriorb )	/* D24 (c) 1991 Taito Corporation (Japan) */

	/* Taito "X"-system games */
	DRIVER( superman )	/* B61 (c) 1988 Taito Corporation */
	DRIVER( twinhawk )	/* B87 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( twinhwku )	/* B87 (c) 1989 Taito America Corporation (US) */
	DRIVER( daisenpu )	/* B87 (c) 1989 Taito Corporation (Japan) */
	DRIVER( gigandes )	/* (c) 1989 East Technology */
	DRIVER( ballbros )	/* no copyright notice */

	/* Taito "tnzs" hardware */
	DRIVER( plumppop )	/* A98 (c) 1987 Taito Corporation (Japan) */
	DRIVER( extrmatn )	/* B06 (c) 1987 World Games */
	DRIVER( arknoid2 )	/* B08 (c) 1987 Taito Corporation Japan (World) */
	DRIVER( arknid2u )	/* B08 (c) 1987 Taito America Corporation + Romstar license (US) */
	DRIVER( arknid2j )	/* B08 (c) 1987 Taito Corporation (Japan) */
	DRIVER( drtoppel )	/* B19 (c) 1987 Taito Corporation (Japan) */
	DRIVER( kageki )	/* B35 (c) 1988 Taito America Corporation + Romstar license (US) */
	DRIVER( kagekij )	/* B35 (c) 1988 Taito Corporation (Japan) */
	DRIVER( chukatai )	/* B44 (c) 1988 Taito Corporation (Japan) */
	DRIVER( tnzs )		/* B53?(c) 1988 Taito Corporation (Japan) (new logo) */
	DRIVER( tnzsb )		/* bootleg but Taito Corporation Japan (World) (new logo) */
	DRIVER( tnzs2 )		/* B53?(c) 1988 Taito Corporation Japan (World) (old logo) */
	DRIVER( insectx )	/* B97 (c) 1989 Taito Corporation Japan (World) */

	/* Taito L-System games */
	DRIVER( raimais )	/* B36 (c) 1988 Taito Corporation (Japan) */
	DRIVER( kurikint )	/* B42 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( kurikinu )	/* B42 (c) 1988 Taito America Corporation (US) */
	DRIVER( kurikinj )	/* B42 (c) 1988 Taito Corporation (Japan) */
	DRIVER( kurikina )	/* B42 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( fhawk )		/* B70 (c) 1988 Taito Corporation (Japan) */
	DRIVER( plotting )	/* B96 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( champwr )	/* C01 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( champwru )	/* C01 (c) 1989 Taito America Corporation (US) */
	DRIVER( champwrj )	/* C01 (c) 1989 Taito Corporation (Japan) */
	DRIVER( puzznic )	/* C20 (c) 1989 Taito Corporation (Japan) */
	DRIVER( horshoes )	/* C47 (c) 1990 Taito America Corporation (US) */
	DRIVER( palamed )	/* C63 (c) 1990 Taito Corporation (Japan) */
	DRIVER( cachat )	/* ??? (c) 1993 Taito Corporation (Japan) */
	DRIVER( tubeit )	/* ??? no copyright message */
	DRIVER( cubybop )	/* ??? no copyright message */
	DRIVER( plgirls )	/* (c) 1992 Hot-B. */
	DRIVER( plgirls2 )	/* (c) 1993 Hot-B. */

	/* Taito H-System games */
	DRIVER( syvalion )	/* B51 (c) 1988 Taito Corporation (Japan) */
	DRIVER( recordbr )	/* B56 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( dleague )	/* C02 (c) 1990 Taito Corporation (Japan) */

	/* Taito B-System games */
	DRIVER( masterw )	/* B72 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( nastar )	/* B81 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( nastarw )	/* B81 (c) 1988 Taito America Corporation (US) */
	DRIVER( rastsag2 )	/* B81 (c) 1988 Taito Corporation (Japan) */
	DRIVER( rambo3 )	/* B93 (c) 1989 Taito Europe Corporation (Europe) */
	DRIVER( rambo3ae )	/* B93 (c) 1989 Taito Europe Corporation (Europe) */
	DRIVER( rambo3a )	/* B93 (c) 1989 Taito America Corporation (US) */
	DRIVER( crimec )	/* B99 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( crimecu )	/* B99 (c) 1989 Taito America Corporation (US) */
	DRIVER( crimecj )	/* B99 (c) 1989 Taito Corporation (Japan) */
	DRIVER( tetrist )	/* C12 (c) 1989 Sega Enterprises,Ltd. (Japan) */
	DRIVER( viofight )	/* C16 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( ashura )	/* C43 (c) 1990 Taito Corporation (Japan) */
	DRIVER( ashurau )	/* C43 (c) 1990 Taito America Corporation (US) */
	DRIVER( hitice )	/* C59 (c) 1990 Williams (US) */
	DRIVER( sbm )		/* C69 (c) 1990 Taito Corporation (Japan) */
	DRIVER( selfeena )	/* ??? (c) 1991 East Technology */
	DRIVER( silentd )	/* ??? (c) 1992 Taito Corporation Japan (World) */
	DRIVER( silentdj )	/* ??? (c) 1992 Taito Corporation (Japan) */
	DRIVER( ryujin )	/* ??? (c) 1993 Taito Corporation (Japan) */
	DRIVER( qzshowby )	/* D72 (c) 1993 Taito Corporation (Japan) */
	DRIVER( pbobble )	/* ??? (c) 1994 Taito Corporation (Japan) */
	DRIVER( spacedx )	/* D89 (c) 1994 Taito Corporation (US) */
	DRIVER( spacedxj )	/* D89 (c) 1994 Taito Corporation (Japan) */
	DRIVER( spacedxo )	/* D89 (c) 1994 Taito Corporation (Japan) */

	/* Taito Z-System games */
	DRIVER( contcirc )	/* B33 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( contcrcu )	/* B33 (c) 1987 Taito America Corporation (US) */
	DRIVER( chasehq )	/* B52 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( chasehqj )	/* B52 (c) 1988 Taito Corporation (Japan) */
TESTDRIVER( enforce )	/* B58 (c) 1988 Taito Corporation (Japan) */
	DRIVER( nightstr )	/* B91 (c) 1989 Taito America Corporation (US) */
	DRIVER( sci )		/* C09 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( scia )		/* C09 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( sciu )		/* C09 (c) 1989 Taito America Corporation (US) */
	DRIVER( bshark )	/* C34 (c) 1989 Taito America Corporation (US) */
	DRIVER( bsharkj )	/* C34 (c) 1989 Taito Corporation (Japan) */
	DRIVER( aquajack )	/* B77 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( aquajckj )	/* B77 (c) 1990 Taito Corporation (Japan) */
	DRIVER( spacegun )	/* C57 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( dblaxle )	/* C78 (c) 1991 Taito America Corporation (US) */
	DRIVER( pwheelsj )	/* C78 (c) 1991 Taito Corporation (Japan) */

	/* Taito Air System games */
TESTDRIVER( topland )	/* B62 (c) 1988 Taito Coporation Japan (World) */
TESTDRIVER( ainferno )	/* C45 (c) 1990 Taito America Corporation (US) */

	/* enhanced Z-System hardware games */
	DRIVER( gunbustr )	/* D27 (c) 1992 Taito Corporation (Japan) */
	DRIVER( superchs )	/* D46 (c) 1992 Taito America Corporation (US) */
	DRIVER( undrfire )	/* D67 (c) 1993 Taito Coporation Japan (World) */

	/* Taito F2 games */
	DRIVER( finalb )	/* B82 (c) 1988 Taito Corporation Japan (World) */
	DRIVER( finalbj )	/* B82 (c) 1988 Taito Corporation (Japan) */
	DRIVER( dondokod )	/* B95 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( dondokdu )	/* B95 (c) 1989 Taito America Corporation (US) */
	DRIVER( dondokdj )	/* B95 (c) 1989 Taito Corporation (Japan) */
	DRIVER( megab )		/* C11 (c) 1989 Taito Corporation Japan (World) */
	DRIVER( megabj )	/* C11 (c) 1989 Taito Corporation (Japan) */
	DRIVER( thundfox )	/* C28 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( thndfoxu )	/* C28 (c) 1990 Taito America Corporation (US) */
	DRIVER( thndfoxj )	/* C28 (c) 1990 Taito Corporation (Japan) */
	DRIVER( cameltry )	/* C38 (c) 1989 Taito America Corporation (US) */
	DRIVER( camltrua )	/* C38 (c) 1989 Taito America Corporation (US) */
	DRIVER( cameltrj )	/* C38 (c) 1989 Taito Corporation (Japan) */
	DRIVER( qtorimon )	/* C41 (c) 1990 Taito Corporation (Japan) */
	DRIVER( liquidk )	/* C49 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( liquidku )	/* C49 (c) 1990 Taito America Corporation (US) */
	DRIVER( mizubaku )	/* C49 (c) 1990 Taito Corporation (Japan) */
	DRIVER( quizhq )	/* C53 (c) 1990 Taito Corporation (Japan) */
	DRIVER( ssi )		/* C64 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( majest12 )	/* C64 (c) 1990 Taito Corporation (Japan) */
	DRIVER( gunfront )	/* C71 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( gunfronj )	/* C71 (c) 1990 Taito Corporation (Japan) */
	DRIVER( growl )		/* C74 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( growlu )	/* C74 (c) 1990 Taito America Corporation (US) */
	DRIVER( runark )	/* C74 (c) 1990 Taito Corporation (Japan) */
	DRIVER( mjnquest )	/* C77 (c) 1990 Taito Corporation (Japan) */
	DRIVER( mjnquesb )	/* C77 (c) 1990 Taito Corporation (Japan) */
	DRIVER( footchmp )	/* C80 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( hthero )	/* C80 (c) 1990 Taito Corporation (Japan) */
	DRIVER( euroch92 )	/*     (c) 1992 Taito Corporation Japan (World) */
	DRIVER( koshien )	/* C81 (c) 1990 Taito Corporation (Japan) */
	DRIVER( yuyugogo )	/* C83 (c) 1990 Taito Corporation (Japan) */
	DRIVER( ninjak )	/* C85 (c) 1990 Taito Corporation Japan (World) */
	DRIVER( ninjakj )	/* C85 (c) 1990 Taito Corporation (Japan) */
	DRIVER( solfigtr )	/* C91 (c) 1991 Taito Corporation Japan (World) */
	DRIVER( qzquest )	/* C92 (c) 1991 Taito Corporation (Japan) */
	DRIVER( pulirula )	/* C98 (c) 1991 Taito Corporation Japan (World) */
	DRIVER( pulirulj )	/* C98 (c) 1991 Taito Corporation (Japan) */
	DRIVER( metalb )	/* D16? (c) 1991 Taito Corporation Japan (World) */
	DRIVER( metalbj )	/* D12 (c) 1991 Taito Corporation (Japan) */
	DRIVER( qzchikyu )	/* D19 (c) 1991 Taito Corporation (Japan) */
	DRIVER( yesnoj )	/* D20 (c) 1992 Taito Corporation (Japan) */
	DRIVER( deadconx )	/* D28 (c) 1992 Taito Corporation Japan (World) */
	DRIVER( deadconj )	/* D28 (c) 1992 Taito Corporation (Japan) */
	DRIVER( dinorex )	/* D39 (c) 1992 Taito Corporation Japan (World) */
	DRIVER( dinorexj )	/* D39 (c) 1992 Taito Corporation (Japan) */
	DRIVER( dinorexu )	/* D39 (c) 1992 Taito America Corporation (US) */
	DRIVER( qjinsei )	/* D48 (c) 1992 Taito Corporation (Japan) */
	DRIVER( qcrayon )	/* D55 (c) 1993 Taito Corporation (Japan) */
	DRIVER( qcrayon2 )	/* D63 (c) 1993 Taito Corporation (Japan) */
	DRIVER( driftout )	/* (c) 1991 Visco */
	DRIVER( driveout )	/* bootleg */

	/* Taito F3 games */
	DRIVER( ringrage )	/* D21 (c) 1992 Taito Corporation Japan (World) */
	DRIVER( ringragj )	/* D21 (c) 1992 Taito Corporation (Japan) */
	DRIVER( ringragu )	/* D21 (c) 1992 Taito America Corporation (US) */
	DRIVER( arabianm )	/* D29 (c) 1992 Taito Corporation Japan (World) */
	DRIVER( arabiamj )	/* D29 (c) 1992 Taito Corporation (Japan) */
	DRIVER( arabiamu )	/* D29 (c) 1992 Taito America Corporation (US) */
	DRIVER( ridingf )	/* D34 (c) 1992 Taito Corporation Japan (World) */
	DRIVER( ridefgtj )	/* D34 (c) 1992 Taito Corporation (Japan) */
	DRIVER( ridefgtu )	/* D34 (c) 1992 Taito America Corporation (US) */
	DRIVER( gseeker )	/* D40 (c) 1992 Taito Corporation Japan (World) */
	DRIVER( gseekerj )	/* D40 (c) 1992 Taito Corporation (Japan) */
	DRIVER( gseekeru )	/* D40 (c) 1992 Taito America Corporation (US) */
	DRIVER( hthero93 )	/* D49 (c) 1992 Taito Corporation (Japan) */
	DRIVER( cupfinal )	/* D49 (c) 1993 Taito Corporation Japan (World) */
	DRIVER( trstar )	/* D53 (c) 1993 Taito Corporation Japan (World) */
	DRIVER( trstarj )	/* D53 (c) 1993 Taito Corporation (Japan) */
	DRIVER( prmtmfgt )	/* D53 (c) 1993 Taito Corporation (US) */
	DRIVER( trstaro )	/* D53 (c) 1993 Taito Corporation (World) */
	DRIVER( trstaroj )	/* D53 (c) 1993 Taito Corporation (Japan) */
	DRIVER( prmtmfgo )	/* D53 (c) 1993 Taito Corporation (US) */
	DRIVER( gunlock )	/* D66 (c) 1993 Taito Corporation Japan (World) */
	DRIVER( rayforcj )	/* D66 (c) 1993 Taito Corporation (Japan) */
	DRIVER( rayforce )	/* D66 (c) 1993 Taito America Corporation (US) */
	DRIVER( scfinals )	/* D68 (c) 1993 Taito Corporation Japan (World) */
	DRIVER( dungeonm )	/* D69 (c) 1993 Taito Corporation Japan (World) */
	DRIVER( lightbr )	/* D69 (c) 1993 Taito Corporation (Japan) */
	DRIVER( dungenmu )	/* D69 (c) 1993 Taito America Corporation (US) */
	DRIVER( kaiserkn )	/* D84 (c) 1994 Taito Corporation Japan (World) */
	DRIVER( kaiserkj )	/* D84 (c) 1994 Taito Corporation (Japan) */
	DRIVER( gblchmp )	/* D84 (c) 1994 Taito America Corporation (US) */
	DRIVER( dankuga )	/* D84? (c) 1994 Taito Corporation (Japan) */
	DRIVER( dariusg )	/* D87 (c) 1994 Taito Corporation Japan (World) */
	DRIVER( dariusgj )	/* D87 (c) 1994 Taito Corporation (Japan) */
	DRIVER( dariusgu )	/* D87 (c) 1994 Taito America Corporation (US) */
	DRIVER( dariusgx )	/* D87 (c) 1994 Taito Corporation */
	DRIVER( bublbob2 )	/* D90 (c) 1994 Taito Corporation Japan (World) */
	DRIVER( bubsympe )	/* D90 (c) 1994 Taito Corporation Japan (Europe) */
	DRIVER( bubsympu )	/* D90 (c) 1994 Taito America Corporation (US) */
	DRIVER( bubsymph )	/* D90 (c) 1994 Taito Corporation (Japan) */
	DRIVER( spcinvdj )	/* D93 (c) 1994 Taito Corporation (Japan) */
	DRIVER( pwrgoal )	/* D94 (c) 1995 Taito Corporation Japan (World) */
	DRIVER( hthero95 )	/* D94 (c) 1995 Taito Corporation (Japan) */
	DRIVER( hthro95u )	/* D94 (c) 1995 Taito America Corporation (US) */
	DRIVER( qtheater )	/* D95 (c) 1994 Taito Corporation (Japan) */
	DRIVER( elvactr )	/* E02 (c) 1994 Taito Corporation Japan (World) */
	DRIVER( elvactrj )	/* E02 (c) 1994 Taito Corporation (Japan) */
	DRIVER( elvact2u )	/* E02 (c) 1994 Taito America Corporation (US) */
	DRIVER( spcinv95 )	/* E06 (c) 1995 Taito Corporation Japan (World) */
	DRIVER( spcnv95u )	/* E06 (c) 1995 Taito America Corporation (US) */
	DRIVER( akkanvdr )	/* E06 (c) 1995 Taito Corporation (Japan) */
	DRIVER( twinqix )	/* ??? (c) 1995 Taito America Corporation (US) */
	DRIVER( quizhuhu )	/* E08 (c) 1995 Taito Corporation (Japan) */
	DRIVER( pbobble2 )	/* E10 (c) 1995 Taito Corporation Japan (World) */
	DRIVER( pbobbl2j )	/* E10 (c) 1995 Taito Corporation (Japan) */
	DRIVER( pbobbl2u )	/* E10 (c) 1995 Taito America Corporation (US) */
	DRIVER( pbobbl2x )	/* E10 (c) 1995 Taito Corporation (Japan) */
	DRIVER( gekirido )	/* E11 (c) 1995 Taito Corporation (Japan) */
	DRIVER( ktiger2 )	/* E15 (c) 1995 Taito Corporation (Japan) */
	DRIVER( bubblem )	/* E21 (c) 1995 Taito Corporation Japan (World) */
	DRIVER( bubblemj )	/* E21 (c) 1995 Taito Corporation (Japan) */
	DRIVER( cleopatr )	/* E28 (c) 1996 Taito Corporation (Japan) */
	DRIVER( pbobble3 )	/* E29 (c) 1996 Taito Corporation (World) */
	DRIVER( pbobbl3u )	/* E29 (c) 1996 Taito Corporation (US) */
	DRIVER( pbobbl3j )	/* E29 (c) 1996 Taito Corporation (Japan) */
	DRIVER( arkretrn )	/* E36 (c) 1997 Taito Corporation (Japan) */
	DRIVER( kirameki )	/* E44 (c) 1997 Taito Corporation (Japan) */
	DRIVER( puchicar )	/* E46 (c) 1997 Taito Corporation (Japan) */
	DRIVER( pbobble4 )	/* E49 (c) 1997 Taito Corporation (World) */
	DRIVER( pbobbl4j )	/* E49 (c) 1997 Taito Corporation (Japan) */
	DRIVER( pbobbl4u )	/* E49 (c) 1997 Taito Corporation (US) */
	DRIVER( popnpop )	/* E51 (c) 1997 Taito Corporation (World) */
	DRIVER( popnpopj )	/* E51 (c) 1997 Taito Corporation (Japan) */
	DRIVER( popnpopu )	/* E51 (c) 1997 Taito Corporation (US) */
	DRIVER( landmakr )	/* E61 (c) 1998 Taito Corporation (Japan) */



#endif	/* DRIVER_RECURSIVE */

#endif	/* TINY_COMPILE */
