/******************************************************************************

  driver.c

  The list of all available drivers. Drivers have to be included here to be
  recognized by the executable.

  To save some typing, we use a hack here. This file is recursively #included
  twice, with different definitions of the DRIVER() macro. The first one
  declares external references to the drivers; the second one builds an array
  storing all the drivers.

******************************************************************************/

#include "driver.h"


#ifndef DRIVER_RECURSIVE

/* The "root" driver, defined so we can have &driver_##NAME in macros. */
struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

#endif

#ifdef TINY_COMPILE

extern struct GameDriver TINY_NAME;

const struct GameDriver *drivers[] =
{
	TINY_POINTER,
	0	/* end of array */
};

#else

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) extern struct GameDriver driver_##NAME;
#define TESTDRIVER(NAME) extern struct GameDriver driver_##NAME;
#include "segadriver.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#undef TESTDRIVER
#define DRIVER(NAME) &driver_##NAME,
#define TESTDRIVER(NAME)
const struct GameDriver *drivers[] =
{
#include "segadriver.c"
	0	/* end of array */
};

#else	/* DRIVER_RECURSIVE */

	/* Sega G-80 vector games */
	DRIVER( spacfury )	/* (c) 1981 */
	DRIVER( spacfura )	/* no copyright notice */
	DRIVER( zektor )	/* (c) 1982 */
	DRIVER( tacscan )	/* (c) */
	DRIVER( elim2 )		/* (c) 1981 Gremlin */
	DRIVER( elim2a )	/* (c) 1981 Gremlin */
	DRIVER( elim4 )		/* (c) 1981 Gremlin */
	DRIVER( startrek )	/* (c) 1982 */

	/* Sega G-80 raster games */
	DRIVER( astrob )	/* (c) 1981 */
	DRIVER( astrob2 )	/* (c) 1981 */
	DRIVER( astrob1 )	/* (c) 1981 */
	DRIVER( 005 )		/* (c) 1981 */
	DRIVER( monsterb )	/* (c) 1982 */
	DRIVER( spaceod )	/* (c) 1981 */
	DRIVER( pignewt )	/* (c) 1983 */
	DRIVER( pignewta )	/* (c) 1983 */
	DRIVER( sindbadm )	/* 834-5244 (c) 1983 Sega */

	/* Sega "Zaxxon hardware" games */
	DRIVER( zaxxon )	/* (c) 1982 */
	DRIVER( zaxxon2 )	/* (c) 1982 */
	DRIVER( zaxxonb )	/* bootleg */
	DRIVER( szaxxon )	/* (c) 1982 */
	DRIVER( futspy )	/* (c) 1984 */
	DRIVER( razmataz )	/* modified 834-0213, 834-0214 (c) 1983 */
	DRIVER( ixion )		/* (c) 1983 */
	DRIVER( congo )		/* 605-5167 (c) 1983 */
	DRIVER( tiptop )	/* 605-5167 (c) 1983 */

	/* Sega System 1 / System 2 games */
	DRIVER( starjack )	/* 834-5191 (c) 1983 (S1) */
	DRIVER( starjacs )	/* (c) 1983 Stern (S1) */
	DRIVER( regulus )	/* 834-5328(c) 1983 (S1) */
	DRIVER( reguluso )	/* 834-5328(c) 1983 (S1) */
	DRIVER( regulusu )	/* 834-5328(c) 1983 (S1) */
	DRIVER( upndown )	/* (c) 1983 (S1) */
	DRIVER( upndownu )	/* (c) 1983 (S1) */
	DRIVER( mrviking )	/* 834-5383 (c) 1984 (S1) */
	DRIVER( mrvikngj )	/* 834-5383 (c) 1984 (S1) */
	DRIVER( swat )		/* 834-5388 (c) 1984 Coreland / Sega (S1) */
	DRIVER( flicky )	/* (c) 1984 (S1) */
	DRIVER( flickyo )	/* (c) 1984 (S1) */
	DRIVER( wmatch )	/* (c) 1984 (S1) */
	DRIVER( bullfgt )	/* 834-5478 (c) 1984 Sega / Coreland (S1) */
	DRIVER( thetogyu )	/* 834-5478 (c) 1984 Sega / Coreland (S1) */
	DRIVER( spatter )	/* 834-5583 (c) 1984 (S1) */
	DRIVER( pitfall2 )	/* 834-5627 [1985?] reprogrammed, (c) 1984 Activision (S1) */
	DRIVER( pitfallu )	/* 834-5627 [1985?] reprogrammed, (c) 1984 Activision (S1) */
	DRIVER( seganinj )	/* 834-5677 (c) 1985 (S1) */
	DRIVER( seganinu )	/* 834-5677 (c) 1985 (S1) */
	DRIVER( nprinces )	/* 834-5677 (c) 1985 (S1) */
	DRIVER( nprincso )	/* 834-5677 (c) 1985 (S1) */
	DRIVER( nprincsu )	/* 834-5677 (c) 1985 (S1) */
	DRIVER( nprincsb )	/* bootleg? (S1) */
	DRIVER( imsorry )	/* 834-5707 (c) 1985 Coreland / Sega (S1) */
	DRIVER( imsorryj )	/* 834-5707 (c) 1985 Coreland / Sega (S1) */
	DRIVER( teddybb )	/* 834-5712 (c) 1985 (S1) */
	DRIVER( teddybbo )	/* 834-5712 (c) 1985 (S1) */
	DRIVER( hvymetal )	/* 834-5745 (c) 1985 (S2?) */
	DRIVER( myhero )	/* 834-5755 (c) 1985 (S1) */
	DRIVER( sscandal )	/* 834-5755 (c) 1985 Coreland / Sega (S1) */
	DRIVER( myherok )	/* 834-5755 (c) 1985 Coreland / Sega (S1) */
TESTDRIVER( shtngmst )	/* 834-5719/5720 (c) 1985 (S2) */
	DRIVER( chplft )	/* 834-5795 (c) 1985, (c) 1982 Dan Gorlin (S2) */
	DRIVER( chplftb )	/* 834-5795 (c) 1985, (c) 1982 Dan Gorlin (S2) */
	DRIVER( chplftbl )	/* bootleg (S2) */
	DRIVER( 4dwarrio )	/* 834-5918 (c) 1985 Coreland / Sega (S1) */
	DRIVER( brain )		/* (c) 1986 Coreland / Sega (S2?) */
	DRIVER( raflesia )	/* 834-5753 (c) 1985 Coreland / Sega (S1) */
	DRIVER( raflsiau )	/* 834-5753 (c) 1985 Coreland / Sega (S1) */
	DRIVER( wboy )		/* 834-5984 (c) 1986 + Escape license (S1) */
	DRIVER( wboyo )		/* 834-5984 (c) 1986 + Escape license (S1) */
	DRIVER( wboy2 )		/* 834-5984 (c) 1986 + Escape license (S1) */
	DRIVER( wboy2u )	/* 834-5984 (c) 1986 + Escape license (S1) */
	DRIVER( wboy3 )		/* 834-5984 (c) 1986 + Escape license (S1) */
	DRIVER( wboyu )		/* 834-5753 (? maybe a conversion) (c) 1986 + Escape license (S1) */
	DRIVER( wbdeluxe )	/* (c) 1986 + Escape license (S1) */
TESTDRIVER( gardia )	/* 834-6119 (S2?) */
TESTDRIVER( gardiab )	/* bootleg */
	DRIVER( noboranb )	/* bootleg */
	DRIVER( blockgal )	/* 834-6303 (S1) */
	DRIVER( blckgalb )	/* bootleg */
	DRIVER( tokisens )	/* (c) 1987 (from a bootleg board) (S2) */
	DRIVER( wbml )		/* bootleg (S2) */
	DRIVER( wbmljo )	/* (c) 1987 Sega/Westone (S2) */
	DRIVER( wbmljb )	/* (c) 1987 Sega/Westone (S2) */
	DRIVER( wbmlb )		/* bootleg? (S2) */
TESTDRIVER( dakkochn )	/* 836-6483? (S2) */
TESTDRIVER( ufosensi )	/* 834-6659 (S2) */
/*
other System 1 / System 2 games:

WarBall
Sanrin Sanchan
DokiDoki Penguin Land *not confirmed
*/

	/* Sega System E games (Master System hardware) */
	DRIVER( hangonjr )	/* (c) 1985 */
	DRIVER( transfrm )	/* 834-5803 (c) 1986 */
	DRIVER( astrofl )	/* 834-5803 (c) 1986 */
	DRIVER( ridleofp )	/* (c) 1986 Sega / Nasco */
TESTDRIVER( fantzn2 )
TESTDRIVER( opaopa )
TESTDRIVER( tetrisse )

	/* other Sega 8-bit games */
	DRIVER( turbo )		/* (c) 1981 Sega */
	DRIVER( turboa )	/* (c) 1981 Sega */
	DRIVER( turbob )	/* (c) 1981 Sega */
	DRIVER( subroc3d )	/* (c) 1982 Sega */
	DRIVER( buckrog )	/* (c) 1982 Sega */
	DRIVER( buckrogn )	/* (c) 1982 Sega */
TESTDRIVER( kopunch )	/* 834-0103 (c) 1981 Sega */
	DRIVER( suprloco )	/* (c) 1982 Sega */
	DRIVER( appoooh )	/* (c) 1984 Sega */
	DRIVER( bankp )		/* (c) 1984 Sega */
	DRIVER( dotrikun )	/* cabinet test board */
	DRIVER( dotriku2 )	/* cabinet test board */
TESTDRIVER( spcpostn )	/* (c) 1986 Sega / Nasco" */
	DRIVER( angelkds )	/* 833-6599 (c) 1988 Sega / Nasco? */

	/* Sega System 16 games */
	// Not working
	DRIVER( alexkidd )	/* (c) 1986 (protected) */
	DRIVER( aliensya )	/* (c) 1987 (protected) */
	DRIVER( aliensyb )	/* (c) 1987 (protected) */
	DRIVER( aliensyj )	/* (c) 1987 (protected. Japan) */
	DRIVER( astorm )	/* (c) 1990 (protected) */
	DRIVER( astorm2p )	/* (c) 1990 (protected 2 Players) */
	DRIVER( auraila )	/* (c) 1990 Sega / Westone (protected) */
	DRIVER( bayrouta )	/* (c) 1989 (protected) */
	DRIVER( bayrtbl1 )	/* (c) 1989 (protected) (bootleg) */
	DRIVER( bayrtbl2 )	/* (c) 1989 (protected) (bootleg) */
	DRIVER( enduror )	/* (c) 1985 (protected) */
	DRIVER( eswat )		/* (c) 1989 (protected) */
	DRIVER( fpoint )	/* (c) 1989 (protected) */
	DRIVER( goldnaxb )	/* (c) 1989 (protected) */
	DRIVER( goldnaxc )	/* (c) 1989 (protected) */
	DRIVER( goldnaxj )	/* (c) 1989 (protected. Japan) */
	DRIVER( jyuohki )	/* (c) 1988 (protected. Altered Beast Japan) */
	DRIVER( moonwalk )	/* (c) 1990 (protected) */
	DRIVER( moonwlka )	/* (c) 1990 (protected) */
	DRIVER( passsht )	/* (protected) */
	DRIVER( sdioj )		/* (c) 1987 (protected. Japan) */
	DRIVER( shangon )	/* (c) 1992 (protected) */
	DRIVER( shinobia )	/* (c) 1987 (protected) */
	DRIVER( shinobib )	/* (c) 1987 (protected) */
	DRIVER( tetris )	/* (c) 1988 (protected) */
	DRIVER( tetrisa )	/* (c) 1988 (protected) */
	DRIVER( wb3a )		/* (c) 1988 Sega / Westone (protected) */

TESTDRIVER( aceattac )	/* (protected) */
TESTDRIVER( afighter )	/* (protected) */
	DRIVER( bloxeed )	/* (protected) */
TESTDRIVER( cltchitr )	/* (protected) */
TESTDRIVER( cotton )	/* (protected) */
TESTDRIVER( cottona )	/* (protected) */
TESTDRIVER( ddcrew )	/* (protected) */
TESTDRIVER( dunkshot )	/* (protected) */
TESTDRIVER( exctleag )  /* (protected) */
TESTDRIVER( lghost )	/* (protected) */
TESTDRIVER( loffire )	/* (protected) */
TESTDRIVER( mvp )		/* (protected) */
TESTDRIVER( ryukyu )	/* (protected) */
TESTDRIVER( suprleag )  /* (protected) */
TESTDRIVER( thndrbld )	/* (protected) */
TESTDRIVER( thndrbdj )  /* (protected?) */
TESTDRIVER( toutrun )	/* (protected) */
TESTDRIVER( toutruna )	/* (protected) */

	// Working
	DRIVER( aburner )	/* (c) 1987 */
	DRIVER( aburner2 )  /* (c) 1987 */
	DRIVER( alexkida )	/* (c) 1986 */
	DRIVER( aliensyn )	/* (c) 1987 */
	DRIVER( altbeas2 )	/* (c) 1988 */
	DRIVER( altbeast )	/* (c) 1988 */
	DRIVER( astormbl )	/* bootleg */
	DRIVER( atomicp )	/* (c) 1990 Philko */
	DRIVER( aurail )	/* (c) 1990 Sega / Westone */
	DRIVER( bayroute )	/* (c) 1989 Sunsoft / Sega */
	DRIVER( bodyslam )	/* (c) 1986 */
	DRIVER( dduxbl )	/* (c) 1989 (Datsu bootleg) */
	DRIVER( dumpmtmt )	/* (c) 1986 (Japan) */
	DRIVER( endurob2 )	/* (c) 1985 (Beta bootleg) */
	DRIVER( endurobl )	/* (c) 1985 (Herb bootleg) */
	DRIVER( eswatbl )	/* (c) 1989 (but bootleg) */
	DRIVER( fantzone )	/* (c) 1986 */
	DRIVER( fantzono )	/* (c) 1986 */
	DRIVER( fpointbl )	/* (c) 1989 (Datsu bootleg) */
	DRIVER( goldnabl )	/* (c) 1989 (bootleg) */
	DRIVER( goldnaxa )	/* (c) 1989 */
	DRIVER( goldnaxe )	/* (c) 1989 */
	DRIVER( hangon )	/* (c) 1985 */
	DRIVER( hwchamp )	/* (c) 1987 */
	DRIVER( mjleague )	/* (c) 1985 */
	DRIVER( moonwlkb )	/* bootleg */
	DRIVER( outrun )	/* (c) 1986 (bootleg)*/
	DRIVER( outruna )	/* (c) 1986 (bootleg) */
	DRIVER( outrunb )	/* (c) 1986 (protected beta bootleg) */
	DRIVER( passht4b )	/* bootleg */
	DRIVER( passshtb )	/* bootleg */
	DRIVER( quartet )	/* (c) 1986 */
	DRIVER( quartet2 )	/* (c) 1986 */
	DRIVER( quartetj )	/* (c) 1986 */
	DRIVER( riotcity )	/* (c) 1991 Sega / Westone */
	DRIVER( sdi )		/* (c) 1987 */
	DRIVER( shangonb )	/* (c) 1992 (but bootleg) */
	DRIVER( sharrier )	/* (c) 1985 */
	DRIVER( shdancbl )	/* (c) 1989 (but bootleg) */
	DRIVER( shdancer )	/* (c) 1989 */
	DRIVER( shdancrj )	/* (c) 1989 */
	DRIVER( shinobi )	/* (c) 1987 */
	DRIVER( shinobl )	/* (c) 1987 (but bootleg) */
	DRIVER( tetrisbl )	/* (c) 1988 (but bootleg) */
	DRIVER( timscanr )	/* (c) 1987 */
	DRIVER( toryumon )	/* (c) 1995 */
	DRIVER( tturf )		/* (c) 1989 Sega / Sunsoft */
	DRIVER( tturfbl )	/* (c) 1989 (Datsu bootleg) */
	DRIVER( tturfu )	/* (c) 1989 Sega / Sunsoft */
	DRIVER( wb3 )		/* (c) 1988 Sega / Westone */
	DRIVER( wb3bl )		/* (c) 1988 Sega / Westone (but bootleg) */
	DRIVER( wrestwar )	/* (c) 1989 */

/*
Sega System 24 game list
Apr.1988 Hot Rod
Oct.1988 Scramble Spirits
Nov.1988 Gain Ground
Apr.1989 Crack Down
Aug.1989 Jumbo Ozaki Super Masters
Jun.1990 Bonanza Bros.
Dec.1990 Rough Racer
Feb.1991 Quiz Syukudai wo Wasuremashita
Jul.1991 Dynamic C.C.
Dec.1991 Quiz Rouka ni Tattenasai
Dec.1992 Tokorosan no MahMahjan
May.1993 Quiz Mekurumeku Story
May.1994 Tokorosan no MahMahjan 2
Sep.1994 Quiz Ghost Hunter
*/

	/* Sega System 32 games */
TESTDRIVER( ga2 )

	/* Deniam games */
	/* they run on Sega System 16 video hardware */
	DRIVER( logicpro )	/* (c) 1996 Deniam */
	DRIVER( karianx )	/* (c) 1996 Deniam */
	DRIVER( logicpr2 )	/* (c) 1997 Deniam (Japan) */
/*
Deniam is a Korean company (http://deniam.co.kr).

Game list:
Title            System     Date
---------------- ---------- ----------
GO!GO!           deniam-16b 1995/10/11
Logic Pro        deniam-16b 1996/10/20
Karian Cross     deniam-16b 1997/04/17
LOTTERY GAME     deniam-16c 1997/05/21
Logic Pro 2      deniam-16c 1997/06/20
Propose          deniam-16c 1997/06/21
BOMULEUL CHAJARA SEGA ST-V  1997/04/11
*/

	/* System C games */
	DRIVER( bloxeedc )	/* (c) 1989 Sega / Elorg*/
	DRIVER( columns )	/* (c) 1990 Sega */
	DRIVER( columnsj )	/* (c) 1990 Sega */
	DRIVER( columns2 )	/* (c) 1990 Sega */

	/* System C-2 games */
	DRIVER( borench )	/* (c) 1990 Sega */
	DRIVER( tfrceac )	/* (c) 1990 Sega / Technosoft */
	DRIVER( tfrceacj )	/* (c) 1990 Sega / Technosoft */
	DRIVER( tfrceacb )	/* bootleg */
	DRIVER( tantr )		/* (c) 1992 Sega */
	DRIVER( tantrbl )	/* bootleg */
	DRIVER( tantrbl2 )	/* bootleg */
	DRIVER( puyopuyo )	/* (c) 1992 Sega / Compile */
	DRIVER( puyopuya )	/* (c) 1992 Sega / Compile */
	DRIVER( puyopuyb )	/* bootleg */
	DRIVER( ichidant )	/* (c) 1994 Sega */
	DRIVER( ichidnte )	/* (c) 1994 Sega */
	DRIVER( stkclmns )	/* (c) 1994 Sega */
	DRIVER( puyopuy2 )	/* (c) 1994 Compile + Sega license */
	DRIVER( potopoto )	/* (c) 1994 Sega */
	DRIVER( zunkyou )	/* (c) 1994 Sega */

	/* Sega ST-V games */
DRIVER( stvbios )
DRIVER( astrass )
DRIVER( bakubaku )
DRIVER( colmns97 )
DRIVER( cotton2 )
DRIVER( cottonbm )
DRIVER( decathlt )
DRIVER( diehard )
DRIVER( dnmtdeka )
DRIVER( ejihon )
DRIVER( elandore )
DRIVER( ffreveng )
DRIVER( fhboxers )
DRIVER( findlove )
DRIVER( finlarch )
DRIVER( gaxeduel )
DRIVER( grdforce )
DRIVER( groovef )
DRIVER( hanagumi )
DRIVER( introdon )
DRIVER( kiwames )
DRIVER( maruchan )
DRIVER( myfairld )
DRIVER( othellos )
DRIVER( pblbeach )
DRIVER( prikura )
DRIVER( puyosun )
DRIVER( rsgun )
DRIVER( sandor )
DRIVER( sassisu )
DRIVER( seabass )
DRIVER( shanhigw )
DRIVER( shienryu )
DRIVER( sleague )
DRIVER( sokyugrt )
DRIVER( sss )
DRIVER( suikoenb )
DRIVER( twcup98 )
DRIVER( vfkids )
DRIVER( vfremix )
DRIVER( vmahjong )
DRIVER( winterht )
DRIVER( znpwfv )


#endif	/* DRIVER_RECURSIVE */

#endif	/* TINY_COMPILE */
