/*************************************************
		KOF2001 Patch

	    Written by Siome and JUN

    Special thanks to http://start.at/m1fix
*************************************************/

#define PATCH_END (-1)

#include "driver.h"
#include "kof2001_p1.c"
#include "kof2001_p2.c"
#include "kof2001_m1.c"

static void neogeo_kof2001_p1_patch(void)
{
	data8_t *mem8 = memory_region(REGION_CPU1);
	int i = 0;

	while (kof2001_p1_address[i] != PATCH_END)
	{
		mem8[kof2001_p1_address[i]] = kof2001_p1_data[i];
		i++;
	}
}


static void neogeo_kof2001_p2_patch(void)
{
	data8_t *mem8 = memory_region(REGION_CPU1) + 0x100000L;
	int i = 0;

	while (kof2001_p2_address[i] != PATCH_END)
	{
		mem8[kof2001_p2_address[i]] = kof2001_p2_data[i];
		i++;
	}
}


static void neogeo_kof2001_m1_patch(void)
{
	data8_t *mem8 = memory_region(REGION_CPU2);
	int i = 0;

	while (kof2001_m1_address[i] != PATCH_END)
	{
		mem8[kof2001_m1_address[i]] = kof2001_m1_data[i];
		i++;
	}
}


void neogeo_kof2001_patch(void)
{
	neogeo_kof2001_p1_patch();
	neogeo_kof2001_p2_patch();
	neogeo_kof2001_m1_patch();
}
