/******************************************************************************

  driver.c

  The list of all available drivers. Drivers have to be included here to be
  recognized by the executable.

  To save some typing, we use a hack here. This file is recursively #included
  twice, with different definitions of the DRIVER() macro. The first one
  declares external references to the drivers; the second one builds an array
  storing all the drivers.

******************************************************************************/

#include "driver.h"


#ifndef DRIVER_RECURSIVE

/* The "root" driver, defined so we can have &driver_##NAME in macros. */
struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

#endif

#ifdef TINY_COMPILE

extern struct GameDriver TINY_NAME;

const struct GameDriver *drivers[] =
{
	TINY_POINTER,
	0	/* end of array */
};

#else

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) extern struct GameDriver driver_##NAME;
#define TESTDRIVER(NAME) extern struct GameDriver driver_##NAME;
#include "kanekodriver.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#undef TESTDRIVER
#define DRIVER(NAME) &driver_##NAME,
#define TESTDRIVER(NAME)
const struct GameDriver *drivers[] =
{
#include "kanekodriver.c"
	0	/* end of array */
};

#else	/* DRIVER_RECURSIVE */


	/* Kaneko "AX System" games */
	DRIVER( berlwall )	/* (c) 1991 Kaneko */
	DRIVER( berlwalt )	/* (c) 1991 Kaneko */
	DRIVER( mgcrystl )	/* (c) 1991 Kaneko (World) */
	DRIVER( mgcrystj )	/* (c) 1991 Kaneko + distributed by Atlus (Japan) */
	DRIVER( blazeon )	/* (c) 1992 Atlus */
	DRIVER( sandscrp )	/* (c) 1992 Face */
DRIVER( bakubrkr )
DRIVER( shogwarr )
DRIVER( brapboys )
	DRIVER( gtmr )		/* (c) 1994 Kaneko */
	DRIVER( gtmre )		/* (c) 1994 Kaneko */
	DRIVER( gtmrusa )	/* (c) 1994 Kaneko (US) */
	DRIVER( gtmr2 )		/* (c) 1995 Kaneko */

	/* Kaneko "Super Nova System" games */
	DRIVER( galpani4 )	/* (c) 1996 Kaneko (Japan) */
	DRIVER( galpanis )	/* (c) 1997 Kaneko (Japan) */
	DRIVER( sengekis )	/* (c) 1997 Kaneko / Warashi (Japan) */
DRIVER( sarukani )	/* (c) 1997 Kaneko (Japan) */
	DRIVER( cyvern )	/* (c) 1998 Kaneko (Japan) */
	DRIVER( galpans2 )	/* (c) 1999 Kaneko (Japan) */
	DRIVER( panicstr )	/* (c) 1999 Kaneko (Japan) */
	DRIVER( senknow )	/* (c) 1999 Kaneko (Japan) */
DRIVER( gutsn )
	DRIVER( puzzloop )	/* (c) 1998 Mitchell (Japan) */
	DRIVER( puzloopj )	/* (c) 1998 Mitchell (Japan) */
	DRIVER( jjparads )	/* (c) 1996 Electro Design Co. (Japan) */
	DRIVER( jjparad2 )	/* (c) 1997 Electro Design Co. (Japan) */
	DRIVER( ryouran )	/* (c) 1998 Electro Design Co. (Japan) */
	DRIVER( teljan )	/* (c) 1999 Electro Design Co. (Japan) */


	/* other Kaneko games */
	DRIVER( airbustr )	/* (c) 1990 Kaneko + Namco */
	DRIVER( airbustj )	/* (c) 1990 Kaneko + Namco (Japan) */
	DRIVER( galpanic )	/* (c) 1990 Kaneko */
DRIVER( galpani2 )	/* (c) 1993 Kaneko */

#endif	/* DRIVER_RECURSIVE */

#endif	/* TINY_COMPILE */
