/*********************************************************************

  usrintrf.h

  Functions used to handle MAME's crude user interface.

*********************************************************************/

#ifndef USRINTRF_H
#define USRINTRF_H

struct DisplayText
{
	const char *text;	/* 0 marks the end of the array */
	int color;	/* see #defines below */
	int x;
	int y;
};

#define UI_COLOR_NORMAL 0	/* white on black text */
#define UI_COLOR_INVERSE 1	/* black on white text */

#define SEL_BITS 12		/* main menu selection mask */
#define SEL_BITS2 4		/* submenu selection masks */
#define SEL_MASK ((1<<SEL_BITS)-1)
#define SEL_MASK2 ((1<<SEL_BITS2)-1)

#ifdef COMMAND_LIST
#define SCR_PAGE_MASK  0xffffff
#define SCR_NEXT_PAGE  0x1000000
#define SCR_PREV_PAGE  0x10000000
#endif

extern UINT8 ui_dirty;

struct GfxElement *builduifont(void);
void pick_uifont_colors(void);
void displaytext(struct mame_bitmap *bitmap,const struct DisplayText *dt);
void ui_text(struct mame_bitmap *bitmap,const char *buf,int x,int y);
void ui_drawbox(struct mame_bitmap *bitmap,int leftx,int topy,int width,int height);
#ifdef JMAME
int ui_displaymessagewindow(struct mame_bitmap *bitmap,const char *text);
#else
void ui_displaymessagewindow(struct mame_bitmap *bitmap,const char *text);
#endif
void ui_displaymenu(struct mame_bitmap *bitmap,const char **items,const char **subitems,char *flag,int selected,int arrowize_subitem);
int showcopyright(struct mame_bitmap *bitmap);
int showgamewarnings(struct mame_bitmap *bitmap);
void set_ui_visarea (int xmin, int ymin, int xmax, int ymax);

void init_user_interface(void);
int handle_user_interface(struct mame_bitmap *bitmap);

void ui_show_fps_temp(double seconds);

int onscrd_active(void);
int setup_active(void);

void switch_ui_orientation(struct mame_bitmap *bitmap);
void switch_debugger_orientation(struct mame_bitmap *bitmap);
void switch_true_orientation(struct mame_bitmap *bitmap);

void CLIB_DECL usrintf_showmessage(const char *text,...);
void CLIB_DECL usrintf_showmessage_secs(int seconds, const char *text,...);

#endif
