/***************************************************************************

	ui_font.h

	function for dealing with a Japanese character sequence.

****************************************************************************/

#ifndef UI_FONT_H
#define UI_FONT_H

#ifdef COMMAND_LIST
#define iszen1(c)  (((c) >= 0x81 && (c) <= 0x9f) | ((c) >= 0xe0 && (c) <= 0xfc))
#define iszen2(c)  ((c) >= 0x40 && (c) <= 0xfc && (c) != 0x7f)
#define ishkana(c) ((c) >= 0xa0 && (c) <= 0xdf)
#endif

int uifont_buildfont(void);
void uifont_freefont(void);
int uifont_decodechar(unsigned char *s, unsigned short *code);
int uifont_drawfont(struct mame_bitmap *bitmap, const char *s,
                    int sx, int sy, int color);

#endif
