/******************************************************************************

  driver.c

  The list of all available drivers. Drivers have to be included here to be
  recognized by the executable.

  To save some typing, we use a hack here. This file is recursively #included
  twice, with different definitions of the DRIVER() macro. The first one
  declares external references to the drivers; the second one builds an array
  storing all the drivers.

******************************************************************************/

#include "driver.h"


#ifndef DRIVER_RECURSIVE

/* The "root" driver, defined so we can have &driver_##NAME in macros. */
struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

#endif

#ifdef TINY_COMPILE

extern struct GameDriver TINY_NAME;

const struct GameDriver *drivers[] =
{
	TINY_POINTER,
	0	/* end of array */
};

#else

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) extern struct GameDriver driver_##NAME;
#define TESTDRIVER(NAME) extern struct GameDriver driver_##NAME;
#include "rockndriver.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#undef TESTDRIVER
#define DRIVER(NAME) &driver_##NAME,
#define TESTDRIVER(NAME)
const struct GameDriver *drivers[] =
{
#include "rockndriver.c"
	0	/* end of array */
};

#else	/* DRIVER_RECURSIVE */

/*This files rockndriver.c! So, Rock'n Games ONLY! */

DRIVER(rockn) /* Rock'n Tread */
DRIVER(rockna) /* Rock'n Tread Alt Ver. */
DRIVER(rockn2) /* Rock'n Tread 2 */
DRIVER(rockn3) /* Rock'n 3 */
DRIVER(rockn4) /* Rock'n 4 */
DRIVER(rocknms) /* Rock'n Mega Session */
DRIVER(rocknmsm1) /* Rock'n Mega Session (1st Moniter Only) */

#endif	/* DRIVER_RECURSIVE */

#endif	/* TINY_COMPILE */
