/******************************************************************************

  driver.c

  The list of all available drivers. Drivers have to be included here to be
  recognized by the executable.

  To save some typing, we use a hack here. This file is recursively #included
  twice, with different definitions of the DRIVER() macro. The first one
  declares external references to the drivers; the second one builds an array
  storing all the drivers.

******************************************************************************/

#include "driver.h"


#ifndef DRIVER_RECURSIVE

/* The "root" driver, defined so we can have &driver_##NAME in macros. */
struct GameDriver driver_0 =
{
	__FILE__,
	0,
	"",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	NOT_A_DRIVER
};

#endif

#ifdef TINY_COMPILE

extern struct GameDriver TINY_NAME;

const struct GameDriver *drivers[] =
{
	TINY_POINTER,
	0	/* end of array */
};

#else

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) extern struct GameDriver driver_##NAME;
#define TESTDRIVER(NAME) extern struct GameDriver driver_##NAME;
#include "ataridriver.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#undef TESTDRIVER
#define DRIVER(NAME) &driver_##NAME,
#define TESTDRIVER(NAME)
const struct GameDriver *drivers[] =
{
#include "ataridriver.c"
	0	/* end of array */
};

#else	/* DRIVER_RECURSIVE */


	/* Atari b/w games */
	/* Tank 8 */  		/* ??????			1976/04 [6800] */
	DRIVER( copsnrob )	/* 005625			1976/07 [6502] */
	DRIVER( flyball )	/* 005629			1976/07 [6502] */
	DRIVER( sprint2 )	/* 005922			1976/11 [6502] */
	DRIVER( nitedrvr )	/* 006321			1976/10 [6502] */
	DRIVER( dominos )	/* 007305			1977/01 [6502] */
	DRIVER( triplhnt )	/* 008422-008791	1977/04 [6800] */
	/* Sprint 8 */		/* ??????			1977/05 [6800] */
	DRIVER( dragrace )	/* 008505-008521	1977/06 [6800] */
	DRIVER( poolshrk )	/* 006281			1977/06 [6800] */
	/* Starship One */	/* 007513-007531	1977/07 [6502] */
	DRIVER( superbug )	/* 009115-009467	1977/09 [6800] */
	DRIVER( canyon )	/* 009493-009504	1977/10 [6502] */
	DRIVER( canbprot )	/* 009493-009504	1977/10 [6502] */
	DRIVER( destroyr )	/* 030131-030136	1977/10 [6800] */
	/* Sprint 4 */		/* 008716			1977/12 [6502] */
	DRIVER( sprint1 )	/* 006443			1978/01 [6502] */
	DRIVER( ultratnk )	/* 009801			1978/02 [6502] */
	/* Sky Raider */	/* 009709			1978/03 [6502] */
	/* Tourn. Table */	/* 030170			1978/03 [6507] */
	DRIVER( avalnche )	/* 030574			1978/04 [6502] */
	DRIVER( firetrk )	/* 030926			1978/06 [6808] */
	DRIVER( skydiver )	/* 009787			1978/06 [6800] */
	/* Smokey Joe */	/* 030926			1978/07 [6502] */
	DRIVER( sbrkout )	/* 033442-033455	1978/09 [6502] */
	DRIVER( atarifb )	/* 033xxx			1978/10 [6502] */
	DRIVER( atarifb1 )	/* 033xxx			1978/10 [6502] */
	DRIVER( orbit )		/* 033689-033702	1978/11 [6800] */
	DRIVER( videopin )	/* 034253-034267	1979/02 [6502] */
	DRIVER( atarifb4 )	/* 034754			1979/04 [6502] */
	DRIVER( subs )		/* 033714			1979/05 [6502] */
	DRIVER( bsktball )	/* 034756-034766	1979/05 [6502] */
	DRIVER( abaseb )	/* 034711-034738	1979/06 [6502] */
	DRIVER( abaseb2 )	/* 034711-034738	1979/06 [6502] */
	DRIVER( montecar )	/* 035763-035780	1980/04 [6502] */
	DRIVER( soccer )	/* 035222-035260	1980/04 [6502] */

	/* Atari "Missile Command hardware" games */
	DRIVER( missile )	/* 035820-035825	(c) 1980 */
	DRIVER( missile2 )	/* 035820-035825	(c) 1980 */
	DRIVER( suprmatk )	/* 					(c) 1980 + (c) 1981 Gencomp */

	/* Atari vector games */
	DRIVER( llander )	/* 0345xx			no copyright notice */
	DRIVER( llander1 )	/* 0345xx			no copyright notice */
	DRIVER( asteroid )	/* 035127-035145	(c) 1979 */
	DRIVER( asteroi1 )	/* 035127-035145	no copyright notice */
	DRIVER( asteroib )	/* (bootleg) */
	DRIVER( astdelux )	/* 0351xx			(c) 1980 */
	DRIVER( astdelu1 )	/* 0351xx			(c) 1980 */
	DRIVER( bzone )		/* 0364xx			(c) 1980 */
	DRIVER( bzone2 )	/* 0364xx			(c) 1980 */
	DRIVER( bzonec )	/* 0364xx			(c) 1980 */
TESTDRIVER( bradley )	/*     ??			(c) 1980 */
	DRIVER( redbaron )	/* 036995-037007	(c) 1980 */
	DRIVER( tempest )	/* 136002			(c) 1980 */
	DRIVER( tempest1 )	/* 136002			(c) 1980 */
	DRIVER( tempest2 )	/* 136002			(c) 1980 */
	DRIVER( temptube )	/* (hack) */
	DRIVER( spacduel )	/* 136006			(c) 1980 */
	DRIVER( gravitar )	/* 136010			(c) 1982 */
	DRIVER( gravitr2 )	/* 136010			(c) 1982 */
	DRIVER( gravp )		/* (proto)			(c) 1982 */
	DRIVER( lunarbat )	/* (proto)			(c) 1982 */
	DRIVER( quantum )	/* 136016			(c) 1982 */	/* made by Gencomp */
	DRIVER( quantum1 )	/* 136016			(c) 1982 */	/* made by Gencomp */
	DRIVER( quantump )	/* 136016			(c) 1982 */	/* made by Gencomp */
	DRIVER( bwidow )	/* 136017			(c) 1982 */
	DRIVER( starwars )	/* 136021			(c) 1983 */
	DRIVER( starwar1 )	/* 136021			(c) 1983 */
	DRIVER( mhavoc )	/* 136025			(c) 1983 */
	DRIVER( mhavoc2 )	/* 136025			(c) 1983 */
	DRIVER( mhavocp )	/* 136025			(c) 1983 */
	DRIVER( mhavocrv )	/* (hack) */
	DRIVER( alphaone )	/* (proto)          (c) 1983 */
	DRIVER( alphaona )	/* (proto)          (c) 1983 */
	DRIVER( esb )		/* 136031			(c) 1985 */

	/* Atari "Centipede hardware" games */
	DRIVER( warlords )	/* 037153-037159	(c) 1980 */
	DRIVER( centiped )	/* 136001			(c) 1980 */
	DRIVER( centipd2 )	/* 136001			(c) 1980 */
	DRIVER( centipdb )	/* (bootleg) */
	DRIVER( centipb2 )	/* (bootleg) */
	DRIVER( magworm )	/* (bootleg) */
	DRIVER( milliped )	/* 136013			(c) 1982 */
	DRIVER( qwakprot )	/* (proto)			(c) 1982 */

	/* misc Atari games */
	DRIVER( tunhunt )	/* 136000			(c) 1981 */
	DRIVER( liberatr )	/* 136012			(c) 1982 */
TESTDRIVER( liberat2 )	/* 136012			(c) 1982 */
	DRIVER( foodf )		/* 136020			(c) 1982 */	/* made by Gencomp */
	DRIVER( ccastles )	/* 136022			(c) 1983 */
	DRIVER( ccastle3 )	/* 136022			(c) 1983 */
	DRIVER( ccastle2 )	/* 136022			(c) 1983 */
	DRIVER( cloak )		/* 136023			(c) 1983 */
	DRIVER( cloud9 )	/* (proto)			(c) 1983 */
	DRIVER( jedi )		/* 136030			(c) 1984 */

	/* Atari System 1 games */
	DRIVER( peterpak )	/* 136028			(c) 1984 */
	DRIVER( marble )	/* 136033			(c) 1984 */
	DRIVER( marble2 )	/* 136033			(c) 1984 */
	DRIVER( marble3 )	/* 136033			(c) 1984 */
	DRIVER( marble4 )	/* 136033			(c) 1984 */
	DRIVER( indytemp )	/* 136036			(c) 1985 */
	DRIVER( indytem2 )	/* 136036			(c) 1985 */
	DRIVER( indytem3 )	/* 136036			(c) 1985 */
	DRIVER( indytem4 )	/* 136036			(c) 1985 */
	DRIVER( indytemd )	/* 136036           (c) 1985 */
	DRIVER( roadrunn )	/* 136040			(c) 1985 */
	DRIVER( roadblst )	/* 136048			(c) 1986, 1987 */
	DRIVER( roadbls2 )	/* 136048			(c) 1986, 1987 */

	/* Atari System 2 games */
	DRIVER( paperboy )	/* 136034			(c) 1984 */
	DRIVER( ssprint )	/* 136042			(c) 1986 */
	DRIVER( csprint )	/* 136045			(c) 1986 */
	DRIVER( 720 )		/* 136047			(c) 1986 */
	DRIVER( 720b )		/* 136047			(c) 1986 */
	DRIVER( apb )		/* 136051			(c) 1987 */
	DRIVER( apb2 )		/* 136051			(c) 1987 */

	/* Atari polygon games */
	DRIVER( irobot )	/* 136029			(c) 1983 */
	DRIVER( harddriv )	/* 136052			(c) 1988 */
TESTDRIVER( harddrvc )	/* 136068			(c) 1990 */
	DRIVER( stunrun )	/* 136070			(c) 1989 */
	DRIVER( stunrnp )	/* (proto)			(c) 1989 */
TESTDRIVER( racedriv )	/* 136077			(c) 1990 */
TESTDRIVER( racedrvc )	/* 136077			(c) 1990 */
TESTDRIVER( steeltal )	/* 136087			(c) 1990 */
TESTDRIVER( steeltdb )	/* 136087			(c) 1990 */
TESTDRIVER( hdrivair )	/* (proto) */
TESTDRIVER( hdrivaip )	/* (proto) */

	/* later Atari games */
	DRIVER( gauntlet )	/* 136037			(c) 1985 */
	DRIVER( gauntir1 )	/* 136037			(c) 1985 */
	DRIVER( gauntir2 )	/* 136037			(c) 1985 */
	DRIVER( gaunt2p )	/*     ??			(c) 1985 */
	DRIVER( gaunt2 )	/* 136043			(c) 1986 */
	DRIVER( vindctr2 )	/*     ??			(c) 1988 */
	DRIVER( xybots )	/* 136054			(c) 1987 */
	DRIVER( blstroid )	/* 136057			(c) 1987 */
	DRIVER( blstroi2 )	/* 136057			(c) 1987 */
	DRIVER( blsthead )	/* (proto)			(c) 1987 */
	DRIVER( vindictr )	/* 136059			(c) 1988 */
	DRIVER( vindicta )	/* 136059			(c) 1988 */
	DRIVER( toobin )	/* 136061			(c) 1988 */
	DRIVER( toobin2 )	/* 136061			(c) 1988 */
	DRIVER( toobinp )	/* (proto)			(c) 1988 */
	DRIVER( cyberbal )	/* 136064			(c) 1989 */
	DRIVER( cyberba2 )	/* 136064			(c) 1989 */
	DRIVER( atetcktl )	/* 136066			(c) 1989 */
	DRIVER( atetckt2 )	/* 136066			(c) 1989 */
	DRIVER( atetris )	/* 136066			(c) 1988 */
	DRIVER( atetrisa )	/* 136066			(c) 1988 */
	DRIVER( atetrisb )	/* (bootleg) */
	DRIVER( eprom )		/* 136069			(c) 1989 */
	DRIVER( eprom2 )	/* 136069			(c) 1989 */
	DRIVER( skullxbo )	/* 136072			(c) 1989 */
	DRIVER( skullxb2 )	/* 136072			(c) 1989 */
	DRIVER( cyberbt )	/* 136073			(c) 1989 */
	DRIVER( badlands )	/* 136074			(c) 1989 */
	DRIVER( klax )		/* 136075			(c) 1989 */
	DRIVER( klax2 )		/* 136075			(c) 1989 */
	DRIVER( klax3 )		/* 136075			(c) 1989 */
	DRIVER( klaxj )		/* 136075			(c) 1989 (Japan) */
	DRIVER( klaxd )		/* 136075			(c) 1989 (Germany) */
	DRIVER( klaxp1 )	/* prototype */
	DRIVER( klaxp2 )	/* prototype */
	DRIVER( thunderj )	/* 136076			(c) 1990 */
	DRIVER( cyberb2p )	/*     ??			(c) 1989 */
	DRIVER( hydra )		/* 136079			(c) 1990 */
	DRIVER( hydrap )	/* (proto)			(c) 1990 */
	DRIVER( pitfight )	/* 136081			(c) 1990 */
	DRIVER( pitfigh3 )	/* 136081			(c) 1990 */
	DRIVER( pitfighb )	/* bootleg */
	DRIVER( rampart )	/* 136082			(c) 1990 */
	DRIVER( ramprt2p )	/* 136082			(c) 1990 */
	DRIVER( rampartj )	/* 136082			(c) 1990 (Japan) */
	DRIVER( shuuz )		/* 136083			(c) 1990 */
	DRIVER( shuuz2 )	/* 136083			(c) 1990 */
	DRIVER( batman )	/* 136085			(c) 1991 */
TESTDRIVER( roadriot )	/* 136089			(c) 1991 */
TESTDRIVER( roadriop )	/* 136089			(c) 1991 */
	DRIVER( offtwall )	/* 136090			(c) 1991 */
	DRIVER( offtwalc )	/* 136090			(c) 1991 */
TESTDRIVER( guardian )	/* 136092			(c) 1992 */
	DRIVER( relief )	/* 136093			(c) 1992 */
	DRIVER( relief2 )	/* 136093			(c) 1992 */
	DRIVER( arcadecl )	/* (proto)			(c) 1992 */
	DRIVER( sparkz )	/* (proto)			(c) 1992 */
TESTDRIVER( motofren )	/* 136094			(c) 1992 */
TESTDRIVER( spclords )	/* 136095			(c) 1992 */
TESTDRIVER( spclorda )	/* 136095			(c) 1992 */
	DRIVER( rrreveng )	/*     ??			(c) 1993 */
	DRIVER( beathead )	/* (proto)			(c) 1993 */
TESTDRIVER( tmek )		/* 136100			(c) 1994 */
TESTDRIVER( tmekprot )	/* 136100			(c) 1994 */
	DRIVER( primrage )	/* 136102			(c) 1994 */
	DRIVER( primrag2 )	/* 136102			(c) 1994 */
	/* Area 51 */		/* 136105			(c) 1995 */

	/* ATARI PONG DRIVERS */
	DRIVER( pong )	/* ATARI */

#endif	/* DRIVER_RECURSIVE */

#endif	/* TINY_COMPILE */
