#include <math.h>

#define TABLESIZE 256
#define SUBBIT    7

#define SUBINDEX  (1 << SUBBIT) //256
#define I_PI (TABLESIZE * SUBINDEX /2)
#define I_HPI (TABLESIZE * SUBINDEX/4)

//int(sin( (pi / 2) * index/128 ) * 32768 + 0.5)
//-360/0/360  -> -32768/0/32768 0x8000/0/0x8000
//-1.0/0/1.0  ->  32768/0/32768 0x8000/0/0x8000
const unsigned short int sin_table[TABLESIZE+2] = {
     0,   201,   402,   603,   804,  1005,  1206,  1407,
  1608,  1809,  2009,  2210,  2411,  2611,  2811,  3012,
  3212,  3412,  3612,  3812,  4011,  4211,  4410,  4609,
  4808,  5007,  5205,  5404,  5602,  5800,  5998,  6195,
  6393,  6590,  6787,  6983,  7180,  7376,  7571,  7767,
  7962,  8157,  8351,  8546,  8740,  8933,  9127,  9319,
  9512,  9704,  9896, 10088, 10279, 10469, 10660, 10850,
 11039, 11228, 11417, 11605, 11793, 11980, 12167, 12354,
 12540, 12725, 12910, 13095, 13279, 13463, 13646, 13828,
 14010, 14192, 14373, 14553, 14733, 14912, 15091, 15269,
 15447, 15624, 15800, 15976, 16151, 16326, 16500, 16673,
 16846, 17018, 17190, 17361, 17531, 17700, 17869, 18037,
 18205, 18372, 18538, 18703, 18868, 19032, 19195, 19358,
 19520, 19681, 19841, 20001, 20160, 20318, 20475, 20632,
 20788, 20943, 21097, 21251, 21403, 21555, 21706, 21856,
 22006, 22154, 22302, 22449, 22595, 22740, 22884, 23028,
 23170, 23312, 23453, 23593, 23732, 23870, 24008, 24144,
 24279, 24414, 24548, 24680, 24812, 24943, 25073, 25202,
 25330, 25457, 25583, 25708, 25833, 25956, 26078, 26199,
 26320, 26439, 26557, 26674, 26791, 26906, 27020, 27133,
 27246, 27357, 27467, 27576, 27684, 27791, 27897, 28002,
 28106, 28209, 28311, 28411, 28511, 28610, 28707, 28803,
 28899, 28993, 29086, 29178, 29269, 29359, 29448, 29535,
 29622, 29707, 29792, 29875, 29957, 30038, 30118, 30196,
 30274, 30350, 30425, 30499, 30572, 30644, 30715, 30784,
 30853, 30920, 30986, 31050, 31114, 31177, 31238, 31298,
 31357, 31415, 31471, 31527, 31581, 31634, 31686, 31737,
 31786, 31834, 31881, 31927, 31972, 32015, 32058, 32099,
 32138, 32177, 32214, 32251, 32286, 32319, 32352, 32383,
 32413, 32442, 32470, 32496, 32522, 32546, 32568, 32590,
 32610, 32629, 32647, 32664, 32679, 32693, 32706, 32718,
 32729, 32738, 32746, 32753, 32758, 32762, 32766, 32767,
 32768, 0
};

const unsigned short int asin_table[TABLESIZE+2] = {
     0,    41,    81,   122,   163,   204,   245,   285,
   326,   367,   408,   449,   490,   531,   572,   613,
   654,   695,   736,   777,   818,   860,   901,   942,
   984,  1025,  1067,  1108,  1150,  1192,  1234,  1276,
  1318,  1360,  1402,  1444,  1487,  1529,  1572,  1615,
  1658,  1700,  1744,  1787,  1830,  1874,  1917,  1961,
  2005,  2049,  2093,  2137,  2182,  2226,  2271,  2316,
  2362,  2407,  2453,  2498,  2544,  2591,  2637,  2684,
  2731,  2778,  2825,  2873,  2921,  2969,  3018,  3066,
  3116,  3165,  3215,  3265,  3315,  3366,  3417,  3469,
  3521,  3573,  3626,  3679,  3733,  3787,  3842,  3898,
  3953,  4010,  4067,  4124,  4183,  4242,  4301,  4362,
  4423,  4485,  4548,  4612,  4676,  4742,  4809,  4877,
  4946,  5017,  5089,  5162,  5237,  5314,  5393,  5473,
  5556,  5642,  5730,  5821,  5916,  6014,  6117,  6225,
  6338,  6459,  6589,  6730,  6885,  7061,  7269,  7540,
  8192
}

const unsigned short int atan_table[TABLESIZE+2] = {
     0,    41,    81,   122,   163,   204,   244,   285,
   326,   366,   407,   447,   487,   528,   568,   608,
   649,   689,   729,   769,   808,   848,   888,   927,
   967,  1006,  1045,  1084,  1123,  1162,  1201,  1239,
  1278,  1316,  1354,  1392,  1430,  1468,  1505,  1542,
  1580,  1617,  1654,  1690,  1727,  1763,  1799,  1835,
  1871,  1907,  1942,  1977,  2012,  2047,  2082,  2117,
  2151,  2185,  2219,  2253,  2286,  2319,  2352,  2385,
  2418,  2451,  2483,  2515,  2547,  2578,  2610,  2641,
  2672,  2703,  2734,  2764,  2794,  2824,  2854,  2884,
  2913,  2942,  2971,  3000,  3029,  3057,  3085,  3113,
  3141,  3169,  3196,  3223,  3250,  3277,  3303,  3330,
  3356,  3382,  3408,  3433,  3459,  3484,  3509,  3534,
  3558,  3583,  3607,  3631,  3655,  3679,  3702,  3726,
  3749,  3772,  3795,  3817,  3840,  3862,  3884,  3906,
  3928,  3949,  3971,  3992,  4013,  4034,  4055,  4076,
  4096,  0
}

    
const unsigned char sin_div_table[TABLESIZE+2] = {
   201,   201,   201,   201,   201,   201,   201,   201,
   201,   200,   201,   201,   200,   200,   201,   200,
   200,   200,   200,   199,   200,   199,   199,   199,
   199,   198,   199,   198,   198,   198,   197,   198,
   197,   197,   196,   197,   196,   195,   196,   195,
   195,   194,   195,   194,   193,   194,   192,   193,
   192,   192,   192,   191,   190,   191,   190,   189,
   189,   189,   188,   188,   187,   187,   187,   186,
   185,   185,   185,   184,   184,   183,   182,   182,
   182,   181,   180,   180,   179,   179,   178,   178,
   177,   176,   176,   175,   175,   174,   173,   173,
   172,   172,   171,   170,   169,   169,   168,   168,
   167,   166,   165,   165,   164,   163,   163,   162,
   161,   160,   160,   159,   158,   157,   157,   156,
   155,   154,   154,   152,   152,   151,   150,   150,
   148,   148,   147,   146,   145,   144,   144,   142,
   142,   141,   140,   139,   138,   138,   136,   135,
   135,   134,   132,   132,   131,   130,   129,   128,
   127,   126,   125,   125,   123,   122,   121,   121,
   119,   118,   117,   117,   115,   114,   113,   113,
   111,   110,   109,   108,   107,   106,   105,   104,
   103,   102,   100,   100,    99,    97,    96,    96,
    94,    93,    92,    91,    90,    89,    87,    87,
    85,    85,    83,    82,    81,    80,    78,    78,
    76,    75,    74,    73,    72,    71,    69,    69,
    67,    66,    64,    64,    63,    61,    60,    59,
    58,    56,    56,    54,    53,    52,    51,    49,
    48,    47,    46,    45,    43,    43,    41,    39,
    39,    37,    37,    35,    33,    33,    31,    30,
    29,    28,    26,    26,    24,    22,    22,    20,
    19,    18,    17,    15,    14,    13,    12,    11,
     9,     8,     7,     5,     4,     4,     1,     1,
     0,     0
};

typedef struct {
    unsigned short int value;
    unsigned char sign;
} set_value;

set_value int_sin( short int value ){
    unsigned short int ix;
    unsigned char subix;

    set_value ret;
    
//    ix = (int)(((float)(I_PI)  / (float)(count_half_value))*x); //Pʕϊ
    ix = value;
    
//    printf("ix :%5d \n",ix);
    
    ret.sign = ((ix & I_PI) > 0);              //3,4یł sign = ix > 32767
//    printf("sign sign=%d %d ix=%d I_PI=%d\n", ret.sign, ((ix & I_PI) > 0), ix , I_PI);
    ix &= (I_PI - 1);              //1,2یɌ ix   = ix & 32767
    if(ix > I_HPI) ix = I_PI - ix; //1یɌ     ix > 16384 ix = 32768 - ix
    
//    printf("ix :%5d \n",ix);

    ix      <<= 2;
//   printf("ix :%5d \n",ix);

    subix   =   ix & (SUBINDEX - 1);   //`⊮ɗpTuCfbNX
    ix      >>= SUBBIT;                 //e[uԍɕϊ

//    printf("debug ix :%5d \n",ix);
//    printf("debug subix :%5d \n",subix);

    //`⊮
    //tval = ((float)(sin_table[ix])* (SUBINDEX - subix))
    //        + ((float)sin_table[ix+1] * subix);
    //
    //     = ((float)(sin_table[ix])* (SUBINDEX)
    //       +subix*((float)sin_table[ix+1]-(float)(sin_table[ix]))
    //ret =  sin_table[ix];
    //ret += ( (sin_div_table[ix]*subix) >> SUBBIT );
    ret.value =   (sin_div_table[ix]*subix);
    ret.value +=  SUBINDEX/2;
    ret.value >>= SUBBIT;
    ret.value +=  sin_table[ix];
    
    return ret;
//    retvalue[1] = ret;
//    return (sign ? -tval : tval) / ((float)(SUBINDEX * 65535));
}

set_value int_cos( short int value ){
    return int_sin(value+0x2000);
}
    
set_value int_asin( set_value set ){
    unsigned short int ix;
    unsigned int   subix;

    ix = set.value;
    
    ret.sign = ((ix & I_PI) > 0);              //3,4یł sign = ix > 32767
    printf("sign sign=%d %d ix=%d I_PI=%d\n", ret.sign, ((ix & I_PI) > 0), ix , I_PI);
    ix &= (I_PI - 1);              //1,2یɌ ix   = ix & 32767
    if(ix > I_HPI) ix = I_PI - ix; //1یɌ     ix > 16384 ix = 32768 - ix
    
//    printf("ix :%5d \n",ix);

    ix      <<= 2;
//   printf("ix :%5d \n",ix);

    subix   =   ix & (SUBINDEX - 1);   //`⊮ɗpTuCfbNX
    ix      >>= SUBBIT;                 //e[uԍɕϊ

//    printf("debug ix :%5d \n",ix);
//    printf("debug subix :%5d \n",subix);

    //`⊮
    //tval = ((float)(sin_table[ix])* (SUBINDEX - subix))
    //        + ((float)sin_table[ix+1] * subix);
    //
    //     = ((float)(sin_table[ix])* (SUBINDEX)
    //       +subix*((float)sin_table[ix+1]-(float)(sin_table[ix]))
    //ret =  sin_table[ix];
    //ret += ( (sin_div_table[ix]*subix) >> SUBBIT );
    ret.value =   (sin_div_table[ix]*subix);
    ret.value +=  SUBINDEX/2;
    ret.value >>= SUBBIT;
    ret.value +=  sin_table[ix];
    
    return ret;
//    retvalue[1] = ret;
//    return (sign ? -tval : tval) / ((float)(SUBINDEX * 65535));
}

    test(){
    float deg = 0.0;
    set_value ret;
    for( deg=0.0; deg < 480.0 ; deg+=1.0 ){
        ret = int_sin( (deg*32768.0)/360.0 );
        printf("%4.1f sign = %02x deg =  %5d \n", deg, ret.sign, ret.value );
    }
}

//Bet Ori RA  -5.24231-> 78.63465/360*32768->7158
//        Dec -8.20167-> -8.20167/360*32768->-747->0xFD15
//t 9:49:51->9.83083*15->147.4625/360*32768->13422
// t-RA=13422-7158=6264
