#ifndef _HERMIT_TARGET_ETH_H_
#define _HERMIT_TARGET_ETH_H_

#include <arch/eth.h>

typedef enum _eth_proc_mode{
  ARP_WAIT,
  IP_WAIT,
}eth_proc_mode;

typedef enum _eth_protocol_id{
  ETH_PROTOCOL_IP = 0x0800,
  ETH_PROTOCOL_ARP = 0x0806,
  ETH_PROTOCOL_IPV6 = 0x86dd,
}eth_protocol_id;

#define ETH_FRAME_LEN 14
typedef struct _eth_frame{
  unsigned char dmac[6];//destination address
  unsigned char smac[6];//source address
  unsigned short protocol;
}eth_frame;

extern const unsigned char broadcast_ipaddr[4];
extern const unsigned char broadcast_mac[6];

extern unsigned char eth_ipaddr[4];
extern unsigned char eth_mac[6];


void enable_phy_module(void);
void disable_phy_module(void);
int eth_send(eth_frame *ethfr, const void *pfr, const unsigned int pfrlen);
int eth_recv(eth_frame **ethfr, void **pbuf, unsigned int *pbuflen, 
	     int *timeout);
int eth_rxbuf_free(const int idx);
int eth_proc(const int mode, void **pbuf, unsigned int *pbuflen);


typedef struct _hwif_eth{
  void (*enable_phy_module)(void);
  void (*disable_phy_module)(void);
  int (*eth_send)(const eth_frame *ethfr,
			 const void *pfr,
			 const unsigned int pfrlen);
  int (*eth_recv)(const unsigned char *mac,
			 eth_frame **ethfr,
			 void **pbuf,
			 unsigned int *pbuflen,
			 int *timeout);
  int (*eth_rxbuf_free)(const int idx);
  int (*eth_init)(const unsigned char *mac);
  unsigned char eth_ipaddr[4];
  unsigned char eth_mac[6];
}hwif_eth;

int register_hwif_eth(hwif_eth *hwif);

#endif

