/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.net {
	import __AS3__.vec.Vector;
	
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.NetStatusEvent;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	
	import jp.sourceforge.aramaki.events.PeerChangeGroupEvent;
	import jp.sourceforge.aramaki.events.PeerEvent;
	import jp.sourceforge.aramaki.events.PeerIdEvent;
	import jp.sourceforge.aramaki.events.PeerMessageEvent;
	
	/**
	 * 接続イベント
	 * @eventType flash.events.Event.CONNECT
	 */
	[Event(name="connect",type="flash.events.Event")]
	
	/**
	 * 接続失敗イベント
	 * @eventType flash.events.ErrorEvent.ERROR
	 */
	[Event(name="error",type="flash.events.ErrorEvent")]
	
	/**
	 * 切断イベント
	 * @eventType flash.events.Event.CLOSE
	 */
	[Event(name="close",type="flash.events.Event")]
	
	/**
	 * グループが変更されたときに呼ばれる
	 * @eventType jp.sourceforge.aramaki.events.PeerChangeGroupEvent.PEER_CHANGE_GROUP
	 */
	[Event(name="peerChangeGroup",type="jp.sourceforge.aramaki.events.PeerChangeGroupEvent")]
	
	/**
	 * ピア接続イベント
	 * @eventType jp.sourceforge.aramaki.events.PeerEvent.CONNECT
	 */
	[Event(name="peerConnect",type="jp.sourceforge.aramaki.events.PeerEvent")]
	
	/**
	 * ピア切断イベント
	 * @eventType jp.sourceforge.aramaki.events.PeerEvent.CLOSE
	 */
	[Event(name="peerClose",type="jp.sourceforge.aramaki.events.PeerEvent")]
	 
	/**
	 * ネットワーククラス
	 */
	public class Network extends EventDispatcher {
		/**
		 * デベロッパーキー
		 */
		private const DEVELOPPER_KEY:String = "6ea6f12c8cca3fc6293596f3-1724aff91113";
		/**
		 * Adobe Stratusへの接続用NetConnection
		 */
		private var netConnection:NetConnection;
		/**
		 * メッセージを受信したときコールバックメソッドが呼び出されるオブジェクト
		 */
		public var client:Object={};
		/**
		 * @private
		 */
		private var _peers:Vector.<Peer>=new Vector.<Peer>;
		/**
		 * 接続が完了していないピアのリスト
		 */
		private var unconnectedPeers:Vector.<Peer>=new Vector.<Peer>;
		/**
		 * @private
		 */
		private var _group:String="__default_group__";
		/**
		 * ピア管理クラス
		 */
		private var peerManager:PeerManager;
		/**
		 * 接続受付ストリーム
		 */
		private var listenerStream:NetStream;
		
		/**
		 * ピアのリスト
		 */
		public function get peers():Vector.<Peer> {
			return _peers;
		}
		
		/**
		 * 自分が属するグループ
		 * 
		 * @default "__default_group__"
		 */
		public function get group():String {
			return _group;
		}
		
		/**
		 * @private
		 */
		public function set group(value:String):void {
			
			_group=value;
			
			//グループの変更をほかのピアに通知
			for each(var peer:Peer in _peers) {
				peer.notifyChangeGroup(value);
			}
		}
				
		/**
		 * ネットワークへ接続
		 * 
		 * netConnectionを作成しStratusへ接続
		 */
		public function connect():void {
			netConnection=new NetConnection;
			netConnection.maxPeerConnections=0xffff;
			netConnection.addEventListener(NetStatusEvent.NET_STATUS,netConnectionNetStatusHandler);
			netConnection.connect("rtmfp://stratus.adobe.com/"+DEVELOPPER_KEY);
		}
		
		/**
		 * NetConnectionのNetStatusEventハンドラ
		 */
		private function netConnectionNetStatusHandler(event:NetStatusEvent):void {
			trace("Network: NetConnection:"+event.info.code);
			
			switch(event.info.code) {
				case "NetConnection.Connect.Success": {
					//Stratusへ接続完了
					peerManager=new PeerManager;
					peerManager.addEventListener(Event.CONNECT,peerManagerConnectHandler);
					peerManager.addEventListener(Event.CLOSE,peerManagerCloseHandler);
					peerManager.addEventListener(ErrorEvent.ERROR,peerManagerConnectFailedHandler);
					peerManager.addEventListener(PeerIdEvent.PEER_CONNECT,peerManagerPeerConnectHandler);
					peerManager.addEventListener(PeerIdEvent.PEER_CLOSE,peerManagerPeerCloseHandler);
					peerManager.connect(netConnection.nearID);
					
					break;
				}
				case "NetConnection.Connect.Failed": {
					//Stratusへの接続に失敗
					dispose();
					
					dispatchEvent(new ErrorEvent(ErrorEvent.ERROR,false,false,"Stratusへの接続に失敗しました。"));
					
					break;
				}
				case "NetConnection.Connect.Closed": {
					//Startusから切断
					dispose();
					
					dispatchEvent(new Event(Event.CLOSE));
					
					break;
				}
			}
		}
		
		/**
		 * ピア管理サーバー接続完了イベントハンドラ
		 */
		private function peerManagerConnectHandler(event:Event):void {
			createListenerStream();
			
			dispatchEvent(event);
		}
		
		/**
		 * ピア管理サーバーへの接続に失敗
		 */
		private function peerManagerConnectFailedHandler(event:ErrorEvent):void {
			dispose();
			
			dispatchEvent(event);
		}
		
		/**
		 * ピア管理サーバーから切断
		 */
		private function peerManagerCloseHandler(event:Event):void {
			dispose();
			
			dispatchEvent(event);
		}
		
		/**
		 * 後始末
		 */
		private function dispose():void {
			if (peerManager) {
				peerManager.removeEventListener(Event.CONNECT,peerManagerConnectCompleteHandler);
				//peerManager.removeEventListener(Event.CLOSE,peerm
				peerManager.close();
			}
			
			if (listenerStream) {
				listenerStream.close();
				listenerStream=null;
			}
			
			if (netConnection) {
				netConnection.removeEventListener(NetStatusEvent.NET_STATUS,netConnectionNetStatusHandler);
				netConnection.close();
				netConnection=null;
			}
		}
		
		/**
		 * ピアへの接続が完了
		 */
		private function peerConnectHandler(event:PeerEvent):void {
			var peer:Peer=event.peer;
			
			unconnectedPeers.splice(unconnectedPeers.indexOf(peer),1);
			_peers.push(peer);
			
			peer.notifyChangeGroup(_group);
			
			dispatchEvent(event);
		}
		
		/**
		 * ピアからの切断が完了
		 */
		private function peerCloseHandler(event:PeerEvent):void {
			_peers.splice(_peers.indexOf(event.peer),1);
			
			dispatchEvent(event);
		}
		
		/**
		 * メッセージを受信したとき呼ばれる
		 * コールバックオブジェクトのメソッドを呼び出す
		 */
		private function peerMessageHandler(event:PeerMessageEvent):void {
			event.args.unshift(event.peer);
			(client[event.handlerName] as Function).apply(client,event.args);
		} 
		
		/**
		 * 接続受付ストリームを作成
		 */
		private function createListenerStream():void {
			listenerStream=new NetStream(netConnection,NetStream.DIRECT_CONNECTIONS);
			listenerStream.client={onPeerConnect:onPeerConnect};
			listenerStream.publish("listener");
		}
		
		/**
		 * 接続受付ストリームに接続された
		 */
		private function onPeerConnect(subscriber:NetStream):Boolean {
			var p:Peer=new Peer;
			initPeer(p);
			p.accept(netConnection,subscriber.farID);
			
			return true;
		}
		
		/**
		 * ピアの設定
		 * 
		 * @param peer 設定するピア
		 */
		private function initPeer(peer:Peer):void {
			peer.addEventListener(PeerEvent.PEER_CONNECT,peerConnectHandler);
			peer.addEventListener(PeerEvent.PEER_CLOSE,peerCloseHandler);
			peer.addEventListener(PeerMessageEvent.PEER_MESSAGE,peerMessageHandler);
			peer.addEventListener(PeerChangeGroupEvent.PEER_CHANGE_GROUP,dispatchEvent);
			peer.addEventListener(PeerEvent.PEER_CONNECT_FAILED,peerConnectFailedHandler);
			unconnectedPeers.push(peer);
		}
		
		/**
		 * 接続を閉じる
		 */
		public function close():void {
			netConnection.close();
		}
		
		/**
		 * すべてのピアへメッセージを送信
		 * @param handlerName ハンドラの名前
		 * @param args ハンドラの引数
		 */ 
		public function sendToAll(handlerName:String,...args):void {
			args.unshift(handlerName);
			
			for each(var peer:Peer in _peers) {
				peer.send.apply(peer,args);
			}
		}
		
		/**
		 * 同じグループのピアへメッセージを送信
		 * @param handlerName ハンドラの名前
		 * @param args ハンドラの引数
		 */
		public function sendToGroup(handlerName:String,...args):void {
			args.unshift(handlerName);
			
			for each(var peer:Peer in _peers) {
				if (peer.group==_group) peer.send.apply(peer,args);
			}
		}
	}
}