/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.events {
	import flash.events.Event;
	import flash.media.Microphone;

	public class PeerIdEvent extends Event {
		/**
		 * ピア接続要求イベント
		 * 
		 * @eventType peerConnect
		 */
		public static const PEER_CONNECT:String="peerConnect";
		/**
		 * ピア切断イベント
		 * 
		 * @eventType peerClose
		 */
		public static const PEER_CLOSE:String="peerClose"; 
		/**
		 * @private
		 */
		private var _id:String;
		
		/**
		 * @param id ピアのID
		 */
		public function PeerIdEvent(type:String,bubbles:Boolean=false,cancelable:Boolean=false,id:String=null) {
			super(type,bubbles,cancelable);
			_id=id;
		}
		
		/**
		 * ピアのID
		 */
		public function get id():String {
			return _id;
		}
		
		/**
		 * @inheritDoc
		 */
		public override function clone():Event {
			return new PeerIdEvent(type,bubbles,cancelable,_id);
		}
		
		/**
		 * @inheritDoc
		 */
		public override function toString():String {
			return formatToString("PeerIdEvent","type","bubbles","cancelable","eventPhase","_id"); 
		}
	}
}