/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.events {
	import flash.events.Event;
	
	import jp.sourceforge.aramaki.net.Peer;
	
	/**
	 * グループ変更イベント
	 */
	public class PeerChangeGroupEvent extends PeerEvent {
		/**
		 * グループ変更イベント
		 * @eventType peerChangeGroup
		 */
		public static const PEER_CHANGE_GROUP:String="peerChangeGroup";
		/**
		 * @private
		 */
		private var _group:String;
		
		/**
		 * @param id グループが変わったピアのID
		 * @param group グループ
		 */
		public function PeerChangeGroupEvent(type:String,bubbles:Boolean=false,cancelable:Boolean=false,peer:Peer=null,group:String=null) {			
			super(type,bubbles,cancelable,peer);
			
			_group=group;
		}
		
		/**
		 * グループ
		 */
		public function get group():String {
			return _group;
		}
		
		/**
		 * @inheritDoc
		 */
		public override function clone():Event {
			return new PeerChangeGroupEvent(type,bubbles,cancelable,_peer,_group);
		}
		
		/**
		 * @inheritDoc
		 */
		public override function toString():String {
			return formatToString("PeerEvent","type","bubbles","cancelable","eventPhase","_peer","_group"); 
		}
	}
}