<?php
	//ブートストラップスクリプト
	
	//定数
	//ノードリストのファイル名
	define("FILENAME_NODE_LIST","nodelist.txt");
	
	switch($_GET["mode"]) {
	case "get":
		getNode();
		break;
	case "add":
		addNode();
		break;
	default:
		header("Content-Type: text/html");
		print <<< EOM
<html>
<head>
<title>荒巻オンライン3 ブートストラップスクリプト</title>
</head>
<body>
<h1>荒巻オンライン3 ブートストラップスクリプト</h1>
　　|l| |　|l| |<br>
　　_,,..,,,,_<br>
　./ ﾟ 3　 `ヽｰっ<br>
　l　ﾟ ll ⊃　⌒_つ<br>
 ）`'ｰ---‐'''''"（_<br>
　⌒）　　　（⌒　　　ﾋﾞﾀｰﾝ
</body>
</html>
EOM;
	}
	
	//初期ノードを取得
	function getNode() {
		header("Content-Type: text/plain");
		
		//ノードリストを開く
		$fp=fopen(FILENAME_NODE_LIST,"r+b");
		
		//ロック
		if (flock($fp,LOCK_EX)) {
			if (!filesize(FILENAME_NODE_LIST)) {
				//ノードリストが空
				//ロックを解除して閉じる
				flock($fp,LOCK_UN);
				fclose($fp);
				exit();
			}
			
			//ノードリストを読み込む
			$nodeList=fread($fp,filesize(FILENAME_NODE_LIST));
			//配列に変換
			$nodeList=explode("\n",$nodeList);
			
			//接続できるノードを探す
			foreach($nodeList as $i => $node) {
				if (checkNode($node)) {
					//ノードに接続できた
					//初期ノードを返す
					echo($node);
					
					break;
				} else {
					//接続できなかった
					//ノードリストから削除
					unset($nodeList[$i]);
				}
			}
			
			//ノードリストをクリア
			rewind($fp);
			ftruncate($fp,0);
			
			//ノードリストを書き込む
			fwrite($fp,implode("\n",$nodeList));
			
			//ロックを解除して閉じる
			flock($fp,LOCK_UN);
			fclose($fp);
		} else {
			//ロック失敗
			fclose($fp);
			error();
		}
	}

	//ノードリストに追加
	function addNode() {
		header("Content-Type: text/plain");
		header("Content-Length: 0");
		
		//ノードリストを開く
		$fp=fopen(FILENAME_NODE_LIST,"ab");
		
		//ノードリストをロック
		if (flock($fp,LOCK_EX)) {
			//ノードリストに追加
			fwrite($fp,$_SERVER["REMOTE_ADDR"].":".$_GET["port"]."\n");
			
			//ロックを解除して閉じる
			flock($fp,LOCK_UN);
			fclose($fp);
		} else {
			//ロック失敗
			fclose($fp);
			error();
		}
	}

	//エラー終了
	function error() {
		echo("error");
		exit();
	}
	
	//接続テスト
	function checkNode($node) {
		//ホスト/ポートに分割
		list($host,$port)=explode(":",$node,2);
		
		//接続　タイムアウトは3秒
		$fp=@fsockopen($host,$port,$errno,$errstr,3);
		
		if ($fp) {
			//接続成功
			fclose($fp);
		    return true;
		} else {
			//接続失敗
		    return false;
		}
	}
?>
