/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "Map.h"
#include "tinyxml.h"
#include "AramakiOnline.h"

Map::Map(const wxString &mapXmlFileName) {
	TiXmlDocument mapXml(mapXmlFileName.fn_str());
	TiXmlElement *rootElement;
	const char *hitTestModelPath;

	this->mapXmlFileName=mapXmlFileName;

	//マップXMLをロード
	if (!mapXml.LoadFile()) goto error;

	rootElement=mapXml.RootElement();
	if (!rootElement) goto error;

	//当たり判定用モデルデータへのパスを取得
	if (!(hitTestModelPath=rootElement->Attribute("hitTestModel"))) goto error;
	hitTestModel=new Model(wxString::FromUTF8(hitTestModelPath));

	for (TiXmlElement *element=rootElement->FirstChildElement();element;element=element->NextSiblingElement()) {
		//フレーム情報を読み込む
		Frame frame;
		const char *modelPath;

		//フレーム数を取得
		if (element->QueryIntAttribute("length",&frame.length)!=TIXML_SUCCESS) goto error;

		//表示用モデルデータへのパスを取得
		if (!(modelPath=element->Attribute("model"))) goto error;

		frame.model=new Model(wxString::FromUTF8(modelPath));
		frame.count=frame.length;

		frameQueue.push_back(frame);
	}

	return;
error:
	wxLogFatalError(mapXmlFileName+wxT("のロードに失敗"));
}

void Map::render() {
	//フレームを描画
	frameQueue.front().model->render();
	frameQueue.front().count--;

	//表示時間切れ
	if (!frameQueue.front().count) {
		//次のフレームに切り替え
		frameQueue.push_back(frameQueue.front());
		frameQueue.pop_front();

		//表示時間をリセット
		frameQueue.front().count=frameQueue.front().length;
	}
}
