/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "AramakiOnline.h"
#include "MainFrame.h"
#include <wx/socket.h>
#include <wx/url.h>
#include <wx/sstream.h>

IMPLEMENT_APP(AramakiOnline)

bool AramakiOnline::checkUpdate() {
	//バージョンチェック
	wxURL url(wxT("http://backeros.if.land.to/lastestVersion"));
	wxInputStream *inputStream=url.GetInputStream();
	wxString lastestVersion;
	wxStringOutputStream outputStream(&lastestVersion);

	if (!url.IsOk()||!inputStream) {
		wxMessageBox(wxT("バージョンチェックに失敗しました"),wxT("荒巻オンライン"),wxICON_ERROR);
		return true;
	}

	//最新バージョンを取得
	inputStream->Read(outputStream);

	delete inputStream;

	if (lastestVersion!=VERSION) {
		//最新版を検出
		wxMessageBox(wxT("新しいバージョンが見つかりました。\nアップデートしてください。"),wxT("荒巻オンライン"),wxICON_INFORMATION);

		//ダウンロードページを開く
		wxLaunchDefaultBrowser(wxT("http://backeros.if.land.to/index.php?%B9%D3%B4%AC%A5%AA%A5%F3%A5%E9%A5%A4%A5%F33#download"));

		return false;
	}

	return true;
}

bool AramakiOnline::OnInit() {
	//すべてのイメージハンドラを有効に
	wxInitAllImageHandlers();

	//ソケットを初期化
	wxSocketBase::Initialize();

	if (!checkUpdate()) return false;

	//メインフレームを作成
	MainFrame *mainFrame=&MainFrame::getInstance();

	//表示しメインフレームに設定
	mainFrame->Show(true);
	SetTopWindow(mainFrame);

	return true;
}
