/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXTPOLYGON_H_
#define TEXTPOLYGON_H_

#include "Texture.h"
#include <wx/wx.h>
#include "Point3d.h"

//文字表示クラス
class TextPolygon {
	//テクスチャ
	Texture *texture;
	//テキスト
	wxString text;
	//フォント
	wxFont font;
	//文字の端のテクスチャ座標
	double textureRight,textureBottom;
	//透過フラグ
	bool transparent;
	//文字色
	wxColour textColor;
	//背景色
	wxColour backgroundColor;

	//テキストをテクスチャに変換
	void generateTextTexture();

	TextPolygon(const TextPolygon &);
	void operator=(const TextPolygon &);
protected:
	//位置
	Point3d position;
	//頂点
	double width,height;
public:
	TextPolygon() : texture(NULL),transparent(false),textColor(*wxBLACK),backgroundColor(*wxWHITE),width(0),height(0) {};

	virtual ~TextPolygon();
	//描画
	virtual void draw() const;

	inline const Point3d &getPosition() const {
		return position;
	}

	inline void setPosition(const Point3d &_value) {
		position=_value;
	}

	inline const wxString &getText() const {
		return text;
	}

	inline void setText(const wxString &_value) {
		text=_value;
		generateTextTexture();
	}

	inline const wxFont &getFont() const {
		return font;
	}

	inline void setFont(const wxFont &_value) {
		font=_value;
		generateTextTexture();
	}

	inline double getWidth() const {
		return width;
	}

	inline double getHeight() const {
		return height;
	}

	inline const wxColour &getTextColor() const {
		return textColor;
	}

	inline void setTextColor(const wxColour &_value) {
		textColor=_value;
	}

	inline const wxColour &getBackgroundColor() const {
		return backgroundColor;
	}

	inline void setBackgroundColor(const wxColour &_value) {
		backgroundColor=_value;
	}

	inline bool isTransparent() const {
		return transparent;
	}

	inline void setTransparent(bool _value) {
		transparent=_value;
	}
};

#endif /* TEXTPOLYGON_H_ */
