/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MYCHARACTER_H_
#define MYCHARACTER_H_

#include "P2PNetwork.h"
#include "Character.h"
#include "Map.h"
#include "Point3d.h"
#include "Face.h"

class Map;
class P2PNetwork;

class MyCharacter : public Character,wxEvtHandler {
	static const int ID_SEND_POSITION_TIMER=1;

	//向き
	int direction;
	//乗っている面
	Face currentFace;
	//ネットワーク
	P2PNetwork &network;
	//マップ
	Map &map;
	//位置送信用タイマー
	wxTimer sendPositionTimer;
	//位置変更フラグ
	bool changedPosition;

	//位置を補正
	void correctPosition(Point3d &position,const Point3d &oldPosition);

	DECLARE_EVENT_TABLE()
public:
	MyCharacter(P2PNetwork &network,Map &map);
	//左旋回
	void turnLeft();
	//右旋回
	void turnRight();
	//前進
	void goAhead();
	//後退
	void goBack();
	//位置が変更されていたら送信
	void onSendPositionTimer(wxTimerEvent &event);

	void setPosition(const Point3d &_value);

	inline int getDirection() const {
		return direction;
	}

	inline void setDirection(int _value) {
		direction=_value;
	}

	void setMessage(const wxString &_value);
	void setName(const wxString &_value);

	inline const Map &getMap() const {
		return map;
	}
};

#endif /*MYCHARACTER_H_*/
