/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINFRAME_H_
#define MAINFRAME_H_

#include <wx/wxprec.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#ifndef WX_PRECOMP
#  include <wx/wx.h>
#endif

#include <wx/tglbtn.h>

#include "World.h"
#include "Canvas.h"
#include "MyCharacter.h"
#include "AramakiOnline.h"
#include "MessageTextCtrl.h"
#include "LoginDialog.h"

class Canvas;
class World;

class MainFrame : public wxFrame {
	//ボタンのID
	static const int ID_SEND_BUTTON=1;
	static const int ID_TOPMOST_BUTTON=2;
	static const int ID_SE_ENABLE_BUTTON=3;
	static const int ID_LOGOUT_BUTTON=4;
	static const int ID_MESSAGE_TEXT=5;

	//サイザー
	wxBoxSizer *sizer,*subSizer;
	//キャンバス
	Canvas *canvas;
	//メッセージエディタ
	MessageTextCtrl *messageText;
	//送信ボタン、ログアウトボタン
	wxButton *sendButton,*logoutButton;
	//最前面表示ボタン
	wxToggleButton *topmostButton;
	//効果音有効ボタン
	wxToggleButton *seEnableButton;
	//ログ
	wxTextCtrl *logText;

	World *world;
	//ログイン中フラグ
	bool loggingIn;

	//発言
	void onClickSendButton(wxCommandEvent &event);
	//最前面表示
	void onToggleTopmostButton(wxCommandEvent &event);
	//効果音
	void onToggleSeEnableButton(wxCommandEvent &event);
	//ログアウト
	void onClickLogoutButton(wxCommandEvent &event);
	void login();
	void logout();
	void onClose(wxCloseEvent &event);
	//TABが押された
	void onTabDown(wxCommandEvent &event);

	DECLARE_EVENT_TABLE()
public:
	MainFrame();

	inline World &getWorld() const {
		return *world;
	}

	inline bool isLoggingIn() const {
		return loggingIn;
	}

	inline void setFocusToMessageText() {
		messageText->SetFocus();
	}

	inline void appendLog(const wxString &name,const wxString &message) {
		if (!logText->IsEmpty()) logText->AppendText(wxT("\n"));
		wxString logMessage=name+wxT("：")+message;
		logMessage.Replace(wxT("\n"),wxEmptyString,true);
		logText->AppendText(logMessage);
	}
};

inline World &getWorld() {
	return getMainFrame().getWorld();
}

inline bool isLoggingIn() {
	return getMainFrame().isLoggingIn();
}

#endif /*MAINFRAME_H_*/
