﻿using System;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using NaGet.Packages;
using NaGet.Packages.Install;

namespace AppliStation
{
	/// <summary>
	/// Description of PackageUninstallConfirmForm.
	/// </summary>
	public partial class PackageUninstallConfirmForm : Form
	{
		private InstalledPackage uninstallPackage;
		
		public InstalledPackage UninstallPackage {
			get { return uninstallPackage; }
			set {
				uninstallPackage = value;
				
				label2.Text = string.Format("{0}({1})", uninstallPackage.Name, uninstallPackage.Version);
				label2.Font = new Font(SystemFonts.DefaultFont.FontFamily, SystemFonts.DefaultFont.Size*1.5f);
				
				Icon icon = AppliStation.Util.GUIUtils.GetIconForPackage(uninstallPackage);
				if (icon != null) {
					iconLabel.Image = icon.ToBitmap();
					iconLabel.Size = icon.Size;
				}
			}
		}

		public PackageUninstallConfirmForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			// 管理者権限で動いているならばrunasが必要にはならないので表示しない
			if (NaGet.Utils.IsAdministrators()) {
				runasCheckBox.Checked = false;
				runasCheckBox.Visible = false;
			}
		}
		
		#region runas関連
		
		/// <summary>
		/// runasで実行するか否か
		/// </summary>
		public bool UseRunas {
			set {
				runasCheckBox.Checked = (! NaGet.Utils.IsAdministrators()) && value;
				
				updateUseRunas();
			}
			get {
				return runasCheckBox.Checked;
			}
		}
		
		/// <summary>
		/// 選択されたパッケージを調査して、Runasを使うべきかいなかを返す
		/// </summary>
		public bool GetShouldUseRunas()
		{
			if (NaGet.Utils.IsAdministrators()) {
				// 管理者権限で動いている場合は不要
				return false;	
			}
			
			return (uninstallPackage.Type != InstallerType.ARCHIVE)
				&& (uninstallPackage.Type != InstallerType.ITSELF);
		}
		
		void RunasCheckBoxCheckedChanged(object sender, EventArgs e)
		{
			updateUseRunas();
		}
		
		private void updateUseRunas()
		{
			AppliStation.Util.NativeMethods.Button_SetElevationRequiredState(okButton, UseRunas);
		}
		
		#endregion

	}
}
