﻿using System;
using System.Collections.Generic;
using System.Threading;
using NUnit.Framework;

using NaGet.Tasks;

namespace test_na_get_lib
{
	[TestFixture]
	public class TaskTest
	{
		[Test]
		public void Running()
		{
			ATaskForTest task = new ATaskForTest();
			task.isRunning = true;
			Assert.AreEqual(true, task.Running);
			task.isRunning = false;
			Assert.AreEqual(false, task.Running);
		}
		
		[Test]
		public void Done()
		{
			ATaskForTest task = new ATaskForTest();
			task.isDone = true;
			Assert.AreEqual(true, task.Done);
			task.isDone = false;
			Assert.AreEqual(false, task.Done);
		}
		
		[Test]
		public void Cancelable()
		{
			ATaskForTest task = new ATaskForTest();
			Assert.AreEqual(false, task.Cancelable);
		}
		
		[Test]
		public void Cancel()
		{
			ATaskForTest task = new ATaskForTest();
			Assert.AreEqual(false, task.Cancel());
		}
		
		[Test]
		public void Run()
		{
			List<TaskEventArgs> eventlist = new List<TaskEventArgs>();
			ATaskForTest task = new ATaskForTest();
			task.TaskEventRaised += delegate (object sender, TaskEventArgs e) {
				Assert.AreEqual(task, sender);
				eventlist.Add(e);
			};

			bool threadChecked = false;
			(new Thread(
				delegate() {
					Thread.Sleep(10);
					Assert.AreEqual(true, task.isRunning);
					threadChecked = true;
				})
			).Start();
			task.Run();
			Assert.AreEqual(true, threadChecked); // スレッド内のパス確認
			Assert.AreEqual(false, task.isRunning);
			Assert.AreEqual(true, task.isDone);
			
			Assert.AreEqual(TaskEventType.STARTED,		eventlist[0].Type);
			Assert.AreEqual(TaskEventType.PING,		eventlist[1].Type);
			Assert.AreEqual(TaskEventType.COMPLETED,	eventlist[2].Type);
			Assert.AreEqual("STARTED",		eventlist[0].TaskMessage);
			Assert.AreEqual("PING",		eventlist[1].TaskMessage);
			Assert.AreEqual("COMPLETED",	eventlist[2].TaskMessage);
		}
		
		#region テスト用派生クラス
		
		private class ATaskForTest : Task
		{
			internal bool isRunning = false;
			
			internal bool isDone = false;
			
			public override bool Running {
				get {
					return isRunning;
				}
			}
			
			public override bool Done {
				get {
					return isDone;
				}
			}
			
			public override void Run()
			{
				isRunning = true;
				RaiseTaskSetEvent(TaskEventType.STARTED, TaskEventType.STARTED.ToString(), 0);
				
				Thread.Sleep(10);
				RaiseTaskSetEvent(TaskEventType.PING, TaskEventType.PING.ToString(), 50);
				Thread.Sleep(10);
				
				RaiseTaskSetEvent(TaskEventType.COMPLETED, TaskEventType.COMPLETED.ToString(), 100);
				isRunning = false;
				isDone = true;
			}
			
		}
		
		#endregion
		
	}
}
