/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * // This .rs code was used to generate the 32-bit and 64-bit versions of the
 * // bitcode shown below. It is left in here for reference, as many of the
 * // variables are used in the the script tests.
 *
 * #include "shared.rsh"
 *
 * // types
 * typedef struct Point2 {
 *     int x;
 *     int y;
 * } Point_2;
 *
 * // variables
 * int var_int;
 * long var_long;
 * float var_float;
 * double var_double;
 * rs_allocation var_allocation;
 * uint32_t var_uint32_t;
 * Point_2 var_point2;
 * int *var_int_ptr;
 *
 * // invoke
 * void function() {
 *     var_int = 1;
 *     var_long = 2;
 *     var_float = 3.0f;
 *     var_double = 4.0;
 *     var_uint32_t = 5;
 *     var_point2.x = 6;
 *     var_point2.y = 7;
 * }
 *
 * // invokeV
 * void functionV(int arg) {
 *     var_int = arg;
 * }
 *
 * // set bound buffer
 * void setBuffer(int dim) {
 *     int i;
 *     for (i = 0; i < dim; ++i) {
 *         var_int_ptr[i] = 5;
 *     }
 * }
 *
 * // set allocation
 * void setAllocation(int dim) {
 *     int x;
 *     for (x = 0; x < dim; ++x) {
 *         rsSetElementAt_uchar(var_allocation, 7, x);
 *     }
 * }
 *
 * // forEach
 * uchar RS_KERNEL increment(uchar in) {
 *     return in+1;
 * }
 *
 * // reduction
 * #pragma rs reduce(summation) accumulator(sumAccumulator) combiner(sumCombiner)
 *
 * static void sumAccumulator(int* accum, int val) {
 *     *accum += val;
 * }
 *
 * static void sumCombiner(int* accum, const int *val) {
 *     *accum += *val;
 * }
 */

#include "VtsHalRenderscriptV1_0TargetTest.h"

// bitcode slots
const int mExportVarIdx_var_int = 0;
const int mExportVarIdx_var_long = 1;
const int mExportVarIdx_var_float = 2;
const int mExportVarIdx_var_double = 3;
const int mExportVarIdx_var_allocation = 4;
const int mExportVarIdx_var_uint32_t = 5;
const int mExportVarIdx_var_point2 = 6;
const int mExportVarIdx_var_int_ptr = 7;
// bitcode invoke slots
//const int mExportForEachIdx_root = 0;
const int mExportForEachIdx_increment = 1;
// bitcode reduce slots
const int mExportReduceIdx_summation = 0;
// bitcode invoke slots
const int mExportFuncIdx_function = 0;
const int mExportFuncIdx_functionV = 1;
const int mExportFuncIdx_setBuffer = 2;
const int mExportFuncIdx_setAllocation = 3;

// bitcode
#ifndef __LP64__

const int8_t bitCode[] = {
     -34,  -64,   23,   11,    0,    0,    0,    0,   44,    0,    0,    0,   -8,   12,    0,    0,
       0,    0,    0,    0,   -1,   -1,   -1,   -1,    0,    0,    0,    0,    1,   64,    4,    0,
      96,    9,    0,    0,    2,   64,    4,    0,    3,    0,    0,    0,   66,   67,  -64,  -34,
      33,   12,    0,    0,   59,    3,    0,    0,    1,   16,    0,    0,   18,    0,    0,    0,
       7, -127,   35, -111,   65,  -56,    4,   73,    6,   16,   50,   57, -110,    1, -124,   12,
      37,    5,    8,   25,   30,    4, -117,   98, -128,   24,   69,    2,   66, -110,   11,   66,
     -60,   16,   50,   20,   56,    8,   24,   73,   10,   50,   68,   36,   72,   10, -112,   33,
      35,  -60,   82, -128,   12,   25,   33,  114,   36,    7,  -56, -120,   17,   98,  -88,  -96,
     -88,   64,  -58,  -16,    1,    0,    0,    0,   73,   24,    0,    0,   34,    0,    0,    0,
      11, -124,   -1,   -1,   -1,   -1,   31,  -64,   96, -127,  -16,   -1,   -1,   -1,   -1,    3,
      24,   44,   32, -124,  -32,   -1,   -1,   -1,   -1,    7,   96, -127,    1,    4,   65,  -16,
      -1,   -1,   -1,   -1,    3,   24,   45,   32,    2,   16,    4,   65,   16,   36,   -2,   -1,
      -1,   -1,  127,    0, -125,    5,   70,    0, -126,   32,    8, -126, -124,    0, -126,   32,
       8, -126,  -60,   -1,   -1,   -1,   -1,   15,   96,  -80,   64,   -8,   -1,   -1,   -1,   -1,
       1,   88,   64,    4,   32,    8, -126,   32,   72,   -4,   -1,   -1,   -1,   -1,    0, -122,
     -62,    2,   34,    0,   65,   16,    4,   65,  -30,   -1,   -1,   -1,   -1,    7,   48,   20,
      22,   16,   66,  -16,   -1,   -1,   -1,   -1,    3,   24,   44,   32,    2,  -32,   -1,   -1,
      -1,   -1,    7,   48,    0,    0,    0,    0, -119,   32,    0,    0,   36,    0,    0,    0,
      50,   34, -120,    9,   32,  100, -123,    4,   19,   35,  -92, -124,    4,   19,   35,  -29,
    -124,  -95, -112,   20,   18,   76, -116, -116,   11, -124,  -60,   76,   16, -100,  -63,   28,
       1,   24,   16,   48,   71,    0,   10,   36,  -52,    0,   16,   49,    4,   64,  -58,   53,
     -46,   20,   81,  -62,  -28,  -89,   14,  -46,   76,   54,   18,    0, -128,   16,   10,  -18,
    -110,  -90, -120,   18,   38,   63, -110,  126,   96,   89,   28,    1, -104,   16,  -89,  -15,
     -17,   28,    5,    1,   45,  115,    4,    8,   53,  -28, -116,    0, -108,    0,  -94,  -88,
       8,   16,   64,   83,    6,    0, -123, -128,  -86,    6,   32,  -85,    8,   77,   67,   88,
      25,  -96,    0,   32,  -83,   12,   80,   16,   16,   87,    4, -120,   33,  -49,    4,    0,
    -127,   69, -128,   66,   18,    7,    2,  -26,    8, -126,   41,    0,    0,    0,    0,    0,
      19,  -80,  112, -112, -121,  118,  -80, -121,   59,  104,    3,  119,  120,    7,  119,   40,
    -121,   54,   96, -121,  116,  112, -121,  122,  -64, -121,   54,   56,    7,  119,  -88, -121,
     114,    8,    7,  113,   72, -121,   13,  100,   80,   14,  109,    0,   15,  122,   48,    7,
     114,  -96,    7,  115,   32,    7,  109, -112,   14,  118,   64,    7,  122,   96,    7,  116,
     -48,    6,  -10,   16,    7,  114, -128,    7,  122,   96,    7,  116,  -96,    7,  113,   32,
       7,  120,  -48,    6,  -18,   48,    7,  114,  -48,    6,  -77,   96,    7,  116,  -96,  -13,
      64, -120,    4,   50,   66,  100,    4,  -40,  -95,    4,    0, -122,   12,    0,    0,    4,
     -64,   14,  101,    0,   54, -124,    0,    0,   32,    0,  118,   40,    5,  -48,   33,    3,
       0,    0,    1,  -80,   67,   57,    0,   15,   33,    0,    0,    8, -128,   29,   74,    0,
      96,  -56,    0,    0,   64,    0,  -20,   80,   18,  -32,   67,    6,    0,    0,    2,   96,
    -121,  -94,    0,   28,   50,    0,    0,   16,    0,  100,   96, -128,  -37,  -95,   60,   64,
      24,    0,    3,    0,    0,    1,  -80,   67,  121,    0,   49,    0,    6,    0,    0,    2,
      96, -120,   34,    1,    0,   16,    0,    0,    0,    4,   67,   20,   10,    0, -128,    0,
       0,    0,   32,   24,  -94,   80,    0,    0,    4,    0,    0,    0,  -63,   16, -123,    2,
       0,   64,    0,    0,    0,    8, -122,   40,   23,   16,    0,    3,    0,    0,   64,   48,
      68,  -55,    0,    0,   32,    0,    0,    0, -126,   33,  -54,    6,    0,   67,    1,    0,
       0,    0,   12,   81,   58,    0,   24,   12,    0,    0,    0,   96, -120,   34,    1,    0,
      32,    0,    0,    0,    4,   67, -108,   15,    8, -128,    3,    0,    0,   32,   24,  -94,
    -116,    1,    0,    0,    8,    0,    0,   64,   48,   68,   25,    3,    0,    0,   16,    0,
       0, -128,   96, -120,   50,    6,    0,    0,   36,    0,    0,    0,   65,   22,    8,    0,
      12,    0,    0,    0,   50,   30, -104,   24,   25,   17,   76, -112, -116,    9,   38,   71,
     -58,    4,   67,    2,   70,    0,   74,  -96,   16,   72,   24,    1,  -96,   96,    4, -128,
    -120,   17,    0,   50,   70,    0,    8,   25,    1,  -96,  101,    4, -128,   28,  -37,   13,
     -62,  -74, -117,    0,  121,   24,    0,    0,  -13,    0,    0,    0,   26,    3,   76, -112,
      70,    2,   19,   52,   68,    0,   48,   42,  119,   99,  104,   97,  114,   95,  115,  105,
     122,  101,   67,    4,   32,   27,   98,    0,   24,   25,    4,   64,  -58,  -90,   45,  -51,
     -19,  -85,  -52,  -83,  -82,  -19,  107,   46,   77,  -81,  108, -120,    1,   96,  100,   64,
       0,   25,   -7,   32,  -56, -115,   76,  -18,   45, -115,   12,  100, -116,   45,  -52,  -19,
      12,  -60,  -82,   76,  110,   46,  -19,  -51,   13,  100,  -58,    5,  -57,   69,  -26,  -90,
    -122,    6,    7,    6,    4,    4,   69,   44,  108,  -82, -116,   12,  -28,  -51,   13, -124,
    -119,  -55,  -86,    9,  100,  -58,    5,  -57,   69,  -26,  -90, -122,    6,    7,   38,  101,
    -120,   64,    6,    6,   15,  -69,   50,  -71,  -71,  -76,   55,   55,    6,   49,   67,    8,
      50,   64,  -56,   32,   97,  -92,   22,  102,   23,  -10,    5,   23,   54,  -74,   22,  118,
      86,  -10,  -27,   22,  -42,   86,  -58,  105,  -20,  -83,  -51,   37,  -52, -115,   76,  -18,
      45, -115,  -52,   69,  110,  -50, -123,  -82,  108, -114,  110,    8,   65,    6,   11,   25,
      48,   60,  -20,  -62,  -28,  -66,  -46,  -36,  -24,   24,  -44,   12,   33,  -56,  -64,   33,
    -125, -121, -120,   93, -104,  -36,   23,  -37, -101,  -37,   25,    3, -101,   33,    4,   25,
      68,  100,   32,   49,  -79,   11, -109,   -5,   50,   99,  123,   11,  -93,   27,   66, -112,
       1,   69,    6,    9,   21,  -69,   48,  -71,   47,  -78,  -73,   58,   49,  -74,   50,    6,
      50,   67,    8,   50,  -80,  -56,  -32,  -94,   99,   23,   38,   -9,   21,  -58,  -58,  -10,
      54,   22,   70, -105,  -10,  -26,   70,   65,    6,  102,    8,   65,    6,   25,   25,  104,
     100,  -20,  -62,  -28,  -66,  -22,  -46,  -36,  -24,  102,  100,  -66,  -24,   24,  -28,   12,
      33,  -56, -128,   35, -125, -114, -118,   93, -104,  -36,   23,  -36,   91, -102,   27,  -99,
      12,   13,  -88,  -73,   52,   55,   58, -103,   33,    4,   25,  124,  100,    0,    6,   92,
     -20,  -62,  -28,  -66,  -46,  -36,  -24,  -66,  -32,  -24,  -28,   72,  -88,  -92,  -71,  -47,
      13,   33,  -56,   64,   12,  -56,   96,   12,   24,  -48,   12,   17,  -56,  -96,   12, -120,
    -104,  -43,  -71, -115,  -47,  -91,  -67,  -71,   13,   17,  -56,  -32,   12,   24,  -71,  -96,
    -107,  -79,  -63, -107,  -55,  125, -103,  -43,  -71, -115,  -47,  -91,  -67,  -71,   89,   13,
      17,  -56,   32,   13,   24,  -71,  -96, -107,  -79,  -63, -107,  -55,  125,  -51, -107,  -47,
       9,  -43, -103, -103, -107,  -55,   13,   17,  -56,   96,   13,   88,  -71,  -96, -107,  -79,
     -63, -107,  -55,  125,  -51, -107,  -47,    5,  -79,  -79,  -67, -115, -123,  -47,  -91,  -67,
     -71,   13,   17,  -56,  -96,   13,   72,  -56,  -67,  -67,  -47,   13,   17,  -56,  -32,   13,
    -104,  -92,  -71, -115,  -55, -107,  -75, -107,  -71,  -47,   13,   17,  -56,   32,   14,   24,
     -64,   12,   17,  -56,   96,   14,   40,  -52,  -44,   12,   17,  -56,  -96,   14, -104,  -52,
     -43,  -75,  -75, -123,  -47,  -91,  -67,  -71,  -47, -103,  -85,  107,   11,   26,   27,  -85,
     107,  -85,   99,   11,  -93,  123, -109,   27,   66, -112,    1,   30, -112,   65,  -62,  101,
     -82,  -82,  109,  -24,  -83,   77,   44,  -51,  -83,   76,  110, -120,   66,    6,  119,   64,
       6,  101,   64,    6,  121,    0,    1,  100,  -96,    7,   67,    4,   50,    0,    3,    6,
     120,   28,  -46,  -36,  -24, -122,   16,  100,  -48,    7,  100,  -32,    7,   12,  -14, -122,
      16,  100,    0,   10,  100,  -32,    7,  124,  -34,  -38,  -36,  -46,  -32,  -34,  -24,  -54,
     -36,  -24,   64,  -58,  -48,  -62,  -28,   24,   77,  -91,  -75,  -63,  -79, -107, -127,   12,
     -67,   12,  -83,  -84, -128,   80,    9,    5,    5,   13,   17,  -56,   96,   20, -122,    8,
    -126,   54,  -60,   32,    3,   81,   32,    3,   82,   16,  -76,   33,    6,   25,   -8,    1,
      25, -104, -126,  -96,   13,   49,  -56,  -32,   20,  -56,  -32,   20,    4, -115,    4,  -37,
    -101,  -37,  -39,   16, -125,   12,   82, -127,   12,   76,   65,  -48, -122,   24,  100,  -96,
      10,  100,  -96,   10, -126,  -58,  -62, -116,  -19,   45, -116,  110, -120,   65,    6,  -84,
      64,    6,  -90,   32,  104,   67,   12,   50,  104,    5,   50,  104,    5,   65,  -93,   65,
     -10,   86,   39,  -58,   86,   54,  -60,   32, -125,   87,   32,    3,   83,   16,  -76,   33,
       6,   25,  -64,    2,   25,  -64, -126,  -96,  113,    9,  115,  -53,    3, -127,  123,   75,
     115,  -93,   43, -109,   27,   98, -112, -127,   44, -112, -127,   41,    8,  -38,   16, -125,
      12,  102, -127,   12,  102,   65,  -48,   26,  -79,  -79,  -39,  -75,  -71,  -76,  -67, -111,
     -43,  -79, -107,  -71, -104,  -79, -123,  -99,  -51,   77,   17, -122,  -94,   10,   27, -101,
      93, -101,   75,   26,   89, -103,   27,  -35, -108,  -32,  -24,   49,    2,   39,   23,  118,
     -42,   22,   54,   69,   80, -102,   58,   35,  114,  115,   95,  101,  120,  112,  111,  114,
     116,   95,  118,   97,  114,   83,   16,  104,  -86,  -80,  -51,   11,    3,   50,   40,   52,
      34,   55,   -9,  -11,   38,  -90,   86,   54,   70,   -9,   53,  -57,  -10,   70,   55,   55,
      37,   48, -125,   62,   35,  114,  115,   95,  101,  120,  112,  111,  114,  116,   95,  102,
     117,  110,   99,   83,    8,   52,   80,    3,   54,  112, -125,   94,   35,  114,  115,   95,
     101,  120,  112,  111,  114,  116,   95,  102,  111,  114,  101,   97,   99,  104,   95,  110,
      97,  109,  101,   83,    4,   56, -112, -125,   74,   35,  114,  115,   95,  101,  120,  112,
     111,  114,  116,   95,  102,  111,  114,  101,   97,   99,  104,   83,    4,   58,  -80, -125,
      70,   35,  114,  115,   95,  101,  120,  112,  111,  114,  116,   95,  114,  101,  100,  117,
      99,  101,   83, -126,   61,  -24,   51,   34,   55,   -9,   85, -122,    7,   -9,   38,   71,
      -9,   69, -105,    7,   87,   54,   37,  -32, -125,   30,   37,   80,  111,  105,  110,  116,
      50,   83, -124,   63,    8,    5,    0,    0,  121,   24,    0,    0,   92,    0,    0,    0,
      51,    8, -128,   28,  -60,  -31,   28,  102,   20,    1,   61, -120,   67,   56, -124,  -61,
    -116,   66, -128,    7,  121,  120,    7,  115, -104,  113,   12,  -26,    0,   15,  -19,   16,
      14,  -12, -128,   14,   51,   12,   66,   30,  -62,  -63,   29,  -50,  -95,   28,  102,   48,
       5,   61, -120,   67,   56, -124, -125,   27,  -52,    3,   61,  -56,   67,   61, -116,    3,
      61,  -52,  120, -116,  116,  112,    7,  123,    8,    7,  121,   72, -121,  112,  112,    7,
     122,  112,    3,  118,  120, -121,  112,   32, -121,   25,  -52,   17,   14,  -20, -112,   14,
     -31,   48,   15,  110,   48,   15,  -29,  -16,   14,  -16,   80,   14,   51,   16,  -60,   29,
     -34,   33,   28,  -40,   33,   29,  -62,   97,   30,  102,   48, -119,   59,  -68, -125,   59,
     -48,   67,   57,  -76,    3,   60,  -68, -125,   60, -124,    3,   59,  -52,  -16,   20,  118,
      96,    7,  123,  104,    7,   55,  104, -121,  114,  104,    7,   55, -128, -121,  112, -112,
    -121,  112,   96,    7,  118,   40,    7,  118,   -8,    5,  118,  120, -121,  119, -128, -121,
      95,    8, -121,  113,   24, -121,  114, -104, -121,  121, -104, -127,   44,  -18,  -16,   14,
     -18,  -32,   14,  -11,  -64,   14,  -20,   48,    3,   98,  -56,  -95,   28,  -28,  -95,   28,
     -52,  -95,   28,  -28,  -95,   28,  -36,   97,   28,  -54,   33,   28,  -60, -127,   29,  -54,
      97,    6,  -42, -112,   67,   57,  -56,   67,   57, -104,   67,   57,  -56,   67,   57,  -72,
     -61,   56, -108,   67,   56, -120,    3,   59, -108,  -61,   47,  -68, -125,   60,   -4, -126,
      59,  -44,    3,   59,  -80,  -61,   12,  -57,  105, -121,  112,   88, -121,  114,  112, -125,
     116,  104,    7,  120,   96, -121,  116,   24, -121,  116,  -96, -121,   25,  -50,   83,   15,
     -18,    0,   15,  -14,   80,   14,  -28, -112,   14,  -29,   64,   15,  -31,   32,   14,  -20,
      80,   14,   51,   32,   40,   29,  -36,  -63,   30,  -62,   65,   30,  -46,   33,   28,  -36,
    -127,   30,  -36,  -32,   28,  -28,  -31,   29,  -22,    1,   30,  102,   24,   81,   56,  -80,
      67,   58, -100, -125,   59,  -52,   80,   36,  118,   96,    7,  123,  104,    7,   55,   96,
    -121,  119,  120,    7,  120, -104,   81,   76,  -12, -112,   15,  -16,   80,   14,    0,    0,
     113,   32,    0,    0,   78,    0,    0,    0,   70,  -64,   84,   64,  -12,   83,   72,   51,
     -35,  -10,   63,  -39, -128,   82,    1,  -47,   63,   56,   84,  -80,   16,  -90, -128,   20,
      84,   35,   76, -120,  -45, -104,  -63,   82,    1,  -47, -113,   52,  -45,   -1,   76, -111,
      53,   52,   18,   49,  105,  -53,  -30,    8,  -64, -124,   56, -115,    5,   32,   21,   16,
      -3, -117,  -45,   24,  -74, -112,   20,   84,   35,   76, -120,  -45,  -68,  -26, -112,    6,
      -1,  108,  -45, -111,  -60,   18, -109,  -73,   16,   12,  -47,   76,  -38,  -12,   83,  -62,
       1,   68,  -11,   29,   73,   63,  -80,   44, -114,    0,   76, -120,  -45,   28, -119,   77,
    -124,  -63,   63,  -41,  119,   36,  113,   11,    1,   68,  104, -112,   16,  -62, -108,  -42,
     119,   36,   -3,  -64,  -78,   56,    2,   48,   33,   78,   99,   22, -107,  127,   16,  -53,
      67,   68,  -65,   68,   76,  -38,  -78,   56,    2,   48,   33,   78,   99,    2,   73,    5,
      68,  127,  -79,   56,  -64,  100,    5,   74,    5,   68,   -1,  -29,   32,  -51,  100,  -37,
      67, -126,   52,   66,   68,   48,   68,   51,   25,   67,   34,   17,  -45,   70,   21,    5,
      17,   89,  -60,   34,   81,   12,  -25,   48,    1,  -46,   16, -111,   37,  100,  126,   36,
      -7,   17,   49,   80,    2,  -15,   23, -115,   47,   81,   12,  -25,   48,    1,  -46,   16,
    -111,   81,   68,   -2,   65,   44,   15,   17,   -3,    5,  -43,    8,   19,  -30,   52,  -81,
      29,   56,   21,   16,   -3,  -64,  -78,   56,    2,   48,   33,   78,   99,    8, -100,   31,
      73,  126,   68,   12, -108,   64,   -4,   69,  -29,   75,   20,  -93,    9,    2,  -59,   80,
      11,   48,   57, -111,    1,   28,   21,   16,   -3,   72,   51,   89,   69,  -28,   31,  -60,
     -14,   16,  -47,   47,   17,  -45,   70,   21,    5,   17,   25, -124,   35,   81, -116,   38,
       8,   20,   67,   45,  -64,  -28,   68,   38, -127,   -8, -111,  -28,   15, -109,   19,    1,
      97,   32,    0,    0,   37,    0,    0,    0,   19,    4,   65,   44,   16,    0,    0,    0,
      12,    0,    0,    0,    4, -108,   66,   49, -108,    3,    9,   69,   64,  -63,   80,   70,
      82,    0,   23, -128,   13,  101,   36,    5,  112,    1,   23,   17,   99,    4,   32,    8,
    -126,   36,   24, -112,   49,   70,    0, -126,   32,    8, -126,   32,    8, -126,   36,   72,
       0,    0,    0,    0, -125,   17,    0,   54,    0, -125,   17,   65,   25,   16,  -64,   96,
    -124, -128,    6,    3,   48,   24,   49,  -92,    1,    1,   12,   70,   16,   98,   48,    0,
    -125,   17,  103,   48,    6,    3,   48,   24,   97,    6,  100,   48,    0,   24,   16,    3,
       9,    0,    0,    0,   91,    6,   32,   64, -123,   45,   67,   16,  -84,  -62, -106,   65,
       8,   92,   97,  -53,   48,    4,  -79,  -80,  101,   32,    2,   84,  -40,   50,   20,    1,
      42,  108,   25, -116,    0,   21,    0,    0,    0,    0,    0,    0,   97,   32,    0,    0,
      11,    0,    0,    0,   19,    4,  -63,   96,    4,   32,    6,    3, -128,  -31,   64,    0,
       2,    0,    0,    0,   38,   50,    0, -111,    1,    0,    0,    0,    1,   49,    0,    0,
       2,    0,    0,    0,   91,    6,   32,   64,    5,    0,    0,    0,    0,    0,    0,    0,
      97,   32,    0,    0,   38,    0,    0,    0,   19,    4,   68,   44,   16,    0,    0,    0,
       1,    0,    0,    0,    4, -108,    2,    0,  -61,   13,   98,  112, -103,  -63,   44,   67,
      48, -112,    1,   25,   99, -106,   64,   24,  -88,    0,  -82,    0,   13, -124,  -15, -124,
      50,   48, -125,  -63, -120,   51,   24, -125,    1,   48,   51,  -64,   96,   48,  -36, -128,
       6,   98,    0,    6,  -77,   12, -125, -112,    6,   24,   14,    4,   14,    0,    0,    0,
      23,   96,   -8,   75,  -28,   63,  -57,   13,   44,   -2,   47,   68,  -56,  -12,   19, -125,
      65,  -40,    9,    2,   68,   17, -128,   33,  -61,  101,   36, -124,  -64,   60,  -72, -119,
      12,    3,  -62,   24,  -54, -128,   52, -126, -103,   16, -120,   79,  -25, -106, -126,   16,
      23,   50,    9,   78,   51,    0,    0,    0,    1,   49,    0,    0,    3,    0,    0,    0,
      91,    6,   33,  -96, -123,   45, -125,   17,  -96,    2,    0,    0,    0,    0,    0,    0,
      97,   32,    0,    0,   36,    0,    0,    0,   19,    4,   67,   44,   16,    0,    0,    0,
       3,    0,    0,    0,  -44, -108,    3,    5,  -74,  -52,    1,   85,   51,    0,    0,    0,
     -61,   13,   98,  112, -103,  -63,   44,   67,   32, -104,  -63,   64,    5,  -96,    6,  -63,
       5,   16,   25, -116,  -39, -122,   50,   64,    3,   96,  -60,  -64,   80,    2,   39,   13,
     -58,  -32,   12,  -20,   12,   48,   24,   12,   55,  -88, -127,   24, -128,  -63,   44, -125,
      16,  -84,    1, -122,    3,    1,    0,    0,   14,    0,    0,    0, -122,  114,   -8,   84,
     -13,    0, -126,  114,    1, -122,  -65,   68,   -2,  115, -100,  -64,  -30,   -1,   66, -124,
      76,   63,   49,   24, -124, -103,   16,    2,  -13,  -32,   38,   50,   12,    8,   99,   42,
       3,  -46,    8,  118,   66,   92,   62,  -99,  -37,   10,   66,   92,  -56,   36,   56,  -51,
       0,    0,    0,    0,    0,    0,    0,    0,   97,   32,    0,    0,   12,    0,    0,    0,
      19,    4,  -63, -119,    1,   16,   54,    6,   24,   12, -114,   12,   26,  -56,   50,    8,
       7,    2,    0,    0,    5,    0,    0,    0,   54,   66,    8,   78,   83, -103, -120, -128,
      52,   86,   82,    8,   78,   83,  -43,   70,   50,    0,  -61,    0,    0,    0,    0,    0,
      97,   32,    0,    0,   16,    0,    0,    0,   19,    4,    1, -119,  -63,   48,   50,   24,
       3,   16,   12,   70, -120,   65,   25,   12,    0, -122,    3,    1,    4,    0,    0,    0,
      54,   50,   84,  -64,   98,   34,    5,   32,    8,   20,   99,   37,    3,   48,   12,    0,
       1,   49,    0,    0,    3,    0,    0,    0,   91,    6,   32,   64, -123,   45, -125,   16,
     -96,    2,    0,    0,    0,    0,    0,    0,   97,   32,    0,    0,   18,    0,    0,    0,
      19,    4,    1, -115,  -63,   32,   49,   24,   86,    6,  100,    0, -126,  -63,    8,   49,
      48, -125,    1,  -64,  112,   32,    0,    0,    4,    0,    0,    0,   54,   50,   84,  -64,
      98,   34,    5,   32,    8,   20,   99,   38,    3,   48,   12,    0,    1,   49,    0,    0,
       4,    0,    0,    0,   91,    6,   32,   64, -123,   45,   67,   16,  -96,  -62, -106,   97,
       8,   80,    1,    0,    0,    0,    0,    0,   97,   32,    0,    0,    3,    0,    0,    0,
      19,    4,  -63, -120,    1,  -79,    4,  -45, -127,    0,    0,    0,   97,   32,    0,    0,
       9,    0,    0,    0,   19,    4,  -63,  120, -125,   24,   92,   23, -115,  -63,   24,   49,
      32, -128,   96,   33,    3,   12,    7,    2,    2,    0,    0,    0,    7,   80,   16,  -51,
      20,   97,    0,    0,    0,    0,    0,    0,   97,   32,    0,    0,    9,    0,    0,    0,
      19,    4,  -63,  120, -125,   24,   92,   23, -115,  -63,   24,   49,   32, -128, -128,   33,
       3,   12,    7,    2,    2,    0,    0,    0,    7,   80,   16,  -51,   20,   97,    0,    0,
       0,    0,    0,    0,   97,   32,    0,    0,    9,    0,    0,    0,   19,    4,  -63,  120,
    -125,   24,   92,   23, -115,  -63,   24,   49,   32, -128,  -96,   33,    3,   12,    7,    2,
       2,    0,    0,    0,    7,   80,   16,  -51,   20,   97,    0,    0,    0,    0,    0,    0,
       0,    0,    0,    0,
};

const int bitCodeLength = 3364;

#else

const int8_t bitCode[] = {
     -34,  -64,   23,   11,    0,    0,    0,    0,   44,    0,    0,    0,  108,   13,    0,    0,
       0,    0,    0,    0,   -1,   -1,   -1,   -1,    0,    0,    0,    0,    1,   64,    4,    0,
      96,    9,    0,    0,    2,   64,    4,    0,    3,    0,    0,    0,   66,   67,  -64,  -34,
      33,   12,    0,    0,   88,    3,    0,    0,    1,   16,    0,    0,   18,    0,    0,    0,
       7, -127,   35, -111,   65,  -56,    4,   73,    6,   16,   50,   57, -110,    1, -124,   12,
      37,    5,    8,   25,   30,    4, -117,   98, -128,   24,   69,    2,   66, -110,   11,   66,
     -60,   16,   50,   20,   56,    8,   24,   73,   10,   50,   68,   36,   72,   10, -112,   33,
      35,  -60,   82, -128,   12,   25,   33,  114,   36,    7,  -56, -120,   17,   98,  -88,  -96,
     -88,   64,  -58,  -16,    1,    0,    0,    0,   73,   24,    0,    0,   33,    0,    0,    0,
      11, -124,   -1,   -1,   -1,   -1,   31,  -64,   96, -127,  -16,   -1,   -1,   -1,   -1,    3,
      24,   44,   16,   -2,   -1,   -1,   -1,  127,    0,   22,   24,    1,    8, -126,   32,    8,
      18,    2,    8, -126,   32,    8,   18,   -1,   -1,   -1,   -1,   63, -128,  -63,    2,  -31,
      -1,   -1,   -1,   -1,    7,   48,   90,   64,    4,   32,    8, -126,   32,   72,   -4,   -1,
      -1,   -1,   -1,    0,    6,   11, -116,    0,    4,   65,   16,    4,    9,    1,    4,   65,
      16,    4, -119,   -1,   -1,   -1,   -1,   31,  -64,   96,    1,   17, -128,   32,    8, -126,
      32,  -15,   -1,   -1,   -1,   -1,    3,   24,   10,   11, -120,    0,    4,   65,   16,    4,
    -119,   -1,   -1,   -1,   -1,   31,  -64,   80,   88,   64,    4,  -64,   -1,   -1,   -1,   -1,
      15,   96,    0,    0, -119,   32,    0,    0,   38,    0,    0,    0,   50,   34, -120,    9,
      32,  100, -123,    4,   19,   35,  -92, -124,    4,   19,   35,  -29, -124,  -95, -112,   20,
      18,   76, -116, -116,   11, -124,  -60,   76,   16,  -96,  -63,   28,    1,   24,   16,   48,
      71,    0,   10,   36,  -52,    0,   16,   49,    4,   64,  -58,   65,  -46,   20,   81,  -62,
     -28,  -89,   14,  -46,   76,  -74,  -33,  -29,   72,    0,    0,   66,   40,  -72,   75, -102,
      34,   74, -104,   -4,   72,   -6, -127,  101,  113,    4,   96,   66, -100,  -58,  -17,  115,
      68,   12,  -61,   48,  -48,   50,   71, -128,   80,   67,  -50,    8,   64,    9,   32, -118,
    -118,    0,    1,   52,   21,    2,   98,   26, -128,  -86,   57, -126,  -96,   24, -112,  -29,
       8,  -64,   69,   88,   17, -102, -122,  -76,   50,   64,    1,   64,   92,   25,  -96,   32,
      32,  -81,    8,   16,   67,  -96,    9,    0,   18, -117,    0, -115,   68,   14,    4,   76,
       1,    0,    0,    0,   19,  -76,  112,    8,    7,  121,   24,    7,  116,  -80,    3,   58,
     104,    3,  119,  120,    7,  119,   40, -121,   54,   96, -121,  116,  112, -121,  122,  -64,
    -121,   54,   56,    7,  119,  -88, -121,  114,    8,    7,  113,   72, -121,   13,  115,   80,
      14,  109,  -48,   14,  122,   80,   14,  109, -112,   14,  120,  -96,    7,  120,  -96,    7,
     115,   32,    7,  109, -112,   14,  113,   96,    7,  122,   16,    7,  118,  -96,    7,  115,
      32,    7,  109, -112,   14,  118,   64,    7,  122,   96,    7,  116,  -48,    6,  -23,   16,
       7,  114, -128,    7,  122,   16,    7,  114, -128,    7,  109,  -32,   14,  115,   32,    7,
     122,   96,    7,  116,  -48,    6,  -77,   16,    7,  114, -128,    7,   58,   15, -124,   72,
      32,   35,   68,   70, -128,   29,   74,    0,  100,  -56,    0,    0,   64,    0,  -20,   80,
       6,   96,   67,    8,    0,    0,    2,   96, -121,   82,    0,   31,   50,    0,    0,   16,
       0,   59, -108,    3,    0,    3, -124,    0,    0,   32,    0,  118,   40,    1, -112,   33,
       3,    0,    0,    1,  -80,   67,   73, -128,   48,   64,    6,    0,    0,    2,   96, -121,
     -94,    0,   30,   66,    0,    0,   16,    0,  100,   98, -128,  -36,  -95,   60,  -64,   24,
       0,    4,    0,    0,    1,  -80,   67,  121,    0,   50,    0,    8,    0,    0,    2,   96,
    -120,   34,    1,    0,   16,    0,    0,    0,    4,   67,   20,   10,    0, -128,    0,    0,
       0,   32,   24,  -94,   80,    0,    0,    4,    0,    0,    0,  -63,   16, -123,    2,    0,
      64,    0,    0,    0,    8, -122,   40,   22,   16,    0,    3,    0,    0,   64,   48,   68,
     -55, -128,    0,   32,    0,    0,    0, -128,   33,  -54,    6,    0,   64,    1,    0,    0,
      16,   12,   81,   58,    0,   24,   12,    0,    0,    0,   96, -120,  -14,    1,  -64,  112,
       0,    0,    0,    0,   67,   20,    9,    0,    0,    1,    0,    0,   32,   24,  -94, -124,
       1,   16,    0,    3,    0,    0,   64,   48,   68,   41,    3,    0,    0,   16,    0,    0,
    -128,   96, -120,   82,    6,    0,    0,   32,    0,    0,    0,  -63,   16,  -91,   12,    0,
       0,   72,    0,    0,    0, -126,   44,   16,   13,    0,    0,    0,   50,   30, -104,   24,
      25,   17,   76, -112, -116,    9,   38,   71,  -58,    4,   67,    2,   70,    0,   72,   40,
    -104,   17, -128, -126,   40,   16,   10,   70,    0, -120,   24,    1,   32,   99,    4, -128,
    -112,   17,    0,   90,   70,    0,  -56,  -79,  -19,   34,  108,   63,    9,    0,    0,    0,
     121,   24,    0,    0,  -22,    0,    0,    0,   26,    3,   76, -112,   70,    2,   19,   68,
      62,    8,  114,   35, -109,  123,   75,   35,    3,   25,   99,   11,  115,   59,    3,  -79,
      43, -109, -101,   75,  123,  115,    3, -103,  113,  -63,  113, -111,  -71,  -87,  -95,  -63,
    -127,    1,    1,   65,   17,   11, -101,   43,   35,    3,  121,  115,    3,   97,   98,  -78,
     106,    2, -103,  113,  -63,  113, -111,  -71,  -87,  -95,  -63, -127,   73,   25,   34, -104,
       1,  -64,  -61,  -82,   76,  110,   46,  -19,  -51, -115,   65,  -52,   16,  -62,   12,    4,
      51,   24,   24,  -87, -123,  -39, -123,  125,  -63, -123, -115,  -83, -123,  -99, -107,  125,
     -71, -123,  -75, -107,  113,   26,  123,  107,  115,    9,  115,   35, -109,  123,   75,   35,
     115, -111, -101,  115,  -95,   43, -101,  -93,   27,   66, -104,   65,   97,    6,    6,   15,
     -69,   48,  -71,  -81,   52,   55,   58,    6,   53,   67,    8,   51,   64,  -52,   32,   33,
      98,   23,   38,   -9,  -59,  -10,  -26,  118,  -58,  -64,  102,    8,   97,    6, -117,   25,
      48,   76,  -20,  -62,  -28,  -66,  -52,  -40,  -34,  -62,  -24, -122,   16,  102,  -32, -104,
     -63,   64,  -59,   46,   76,  -18, -117,  -20,  -83,   78, -116,  -83, -116, -127,  -52,   16,
     -62,   12,   32,   51, -120,  -24,  -40, -123,  -55,  125, -123,  -79,  -79,  -67, -115, -123,
     -47,  -91,  -67,  -71,   81, -112, -127,   25,   66, -104,  -63,  100,    6,   20,   25,  -69,
      48,  -71,  -81,  -70,   52,   55,  -70,   25, -103,   47,   58,    6,   57,   67,    8,   51,
     -80,  -52,  -32,  -94,   98,   23,   38,   -9,    5,   -9, -106,  -26,   70,   39,   67,    3,
     -22,   45,  -51, -115,   78,  102,    8,   97,    6, -103,   25,  104,   92,  -20,  -62,  -28,
     -66,  -46,  -36,  -24,  -66,  -32,  -24,  -28,   72,  -88,  -92,  -71,  -47,   13,   33,  -52,
    -128,   51, -125, -114,    1,  -51,   16,  -63,   12,   62,   34,  102,  117,  110,   99,  116,
     105,  111,  110,   67,    4,   51,    8,    3,   70,   46,  104,  101,  108,  112,  101,  114,
      95,  102,  117,  110,   99,  116,  105,  111,  110,   86,   67,    4,   51,   24,    3,   70,
      46,  104,  101,  108,  112,  101,  114,   95,  115,  101,  116,   66,  117,  102,  102,  101,
     114,   67,    4,   51,   40,    3,   86,   46,  104,  101,  108,  112,  101,  114,   95,  115,
     101,  116,   65,  108,  108,  111,   99,   97,  116,  105,  111,  110,   67,    4,   51,   56,
       3,   18,  114,  111,  111,  116,   67,    4,   51,   72,    3,   38,  105,  110,   99,  114,
     101,  109,  101,  110,  116,   67,    4,   51,   88,    3,    6,   48,   67,    4,   51,  104,
       3,   10,   51,   53,   67,    4,   51,  120,    3,   38,  115,  117,  109,  109,   97,  116,
     105,  111,  110,  116,  -26,  -22,  -38, -126,  -58,  -58,  -22,  -38,  -22,  -40,  -62,  -24,
     -34,  -28, -122,   16,  102,   32,    7,  102,   48,  112, -103,  -85,  107,   27,  122,  107,
      19,   75,  115,   43, -109,   27,  -94, -104,   65,   28, -104,  -63,  103,    6,  115,    0,
       1,  102,   64,    7,   67,    4,   51,  -48,   24,  -32,  113,   72,  115,  -93,   27,   66,
    -104,  -63,   29, -104,    1,   30,   48,  -56,   27,   66, -104, -127,   30, -104,    1,   30,
     -16,  121,  107,  115,   75, -125,  123,  -93,   43,  115,  -93,    3,   25,   67,   11, -109,
      99,   52, -107,  -42,    6,  -57,   86,    6,   50,  -12,   50,  -76,  -78,    2,   66,   37,
      20,   20,   52,   68,   48, -125,   62,   24,   34,    8,  -38,   16,  -61,   12,   -8,  -64,
      12,   -4,   64,  -48, -122,   24,  102, -128,    7,  102,    0,   10, -126,   54,  -60,   48,
    -125,   80,   48, -125,   80,   16,   52,   18,  108,  111,  110,  103,   67,   12,   51,   24,
       5,   51,    0,    5,   65,   27,   98, -104,    1,   41, -104,    1,   41,    8,   26,   11,
      51,  -74,  -73,   48,  -70,   33, -122,   25, -104, -126,   25, -128, -126,  -96,   13,   49,
     -52,  -32,   20,  -52,  -32,   20,    4, -115,    6,  -39,   91,  -99,   24,   91,  -39,   16,
     -61,   12,   82,  -63,   12,   64,   65,  -48, -122,   24,  102,  -96,   10,  102,  -96,   10,
    -126,  -58,   37,  -52,   45,   15,    4,  -18,   45,  -51, -115,  -82,   76,  110, -120,   97,
       6,  -84,   96,    6,  -96,   32,  104,   67,   12,   51,  104,    5,   51,  104,    5,   65,
      27,   34,    8,  -37,   16,   65,  -32, -122,    8,   66,   54,    4,   19,   52,   97,   51,
       3,   87,   16,   54,   97,   51,    3,   87,   16,   56,   97,   51,    3,   87,   16,   50,
      97,   51,    3,   87,  -88,  -62,  -58,  102,  -41,  -26, -110,   70,   86,  -26,   70,   55,
      37,    8,  122, -116,  -64,  -55, -123,  -99,  -75, -123,   77,   17, -120,  -93,  -50, -120,
     -36,  -36,   87,   25,   30,  -36, -101,   28,  -35, -105,   93, -104,  -36,   20,   68,  105,
      30,  -87,  -62,   54,  -81,  -48, -120,  -36,  -36,  -41, -101, -104,   90,  -39,   24,  -35,
     -41,   28,  -37,   27,  -35,  -36, -108,    0,   12,   -6, -116,  -56,  -51,  125, -107,  -31,
     -63,  -67,  -55,  -47,  125, -103,  -43,  -71, -115,   77,   33,  -60, -128,   12,  -52,    0,
      13,  122, -115,  -56,  -51,  125, -107,  -31,  -63,  -67,  -55,  -47,  125, -103,  -67,  -55,
    -107, -123, -115,  -95,  125,  -71, -123,  -75, -107,   77,   17,  -44, -128,   13,   42, -115,
     -56,  -51,  125, -107,  -31,  -63,  -67,  -55,  -47,  125, -103,  -67,  -55, -107, -123, -115,
     -95,   77,   17,  -36,    0,   14,   26, -115,  -56,  -51,  125, -107,  -31,  -63,  -67,  -55,
     -47,  125,  -55, -107, -111,  -43, -115, -107,   77,    9,  -22,  -96,  -49, -120,  -36,  -36,
      87,   25,   30,  -36, -101,   28,  -35,   23,   93,   30,   92,  -39, -108,  -64,   14,  122,
    -108,   64,  -67,  -91,  -71,  -47,  -55,   76,   17,  -14,   96,   15,    0,    0,    0,    0,
     121,   24,    0,    0,   92,    0,    0,    0,   51,    8, -128,   28,  -60,  -31,   28,  102,
      20,    1,   61, -120,   67,   56, -124,  -61, -116,   66, -128,    7,  121,  120,    7,  115,
    -104,  113,   12,  -26,    0,   15,  -19,   16,   14,  -12, -128,   14,   51,   12,   66,   30,
     -62,  -63,   29,  -50,  -95,   28,  102,   48,    5,   61, -120,   67,   56, -124, -125,   27,
     -52,    3,   61,  -56,   67,   61, -116,    3,   61,  -52,  120, -116,  116,  112,    7,  123,
       8,    7,  121,   72, -121,  112,  112,    7,  122,  112,    3,  118,  120, -121,  112,   32,
    -121,   25,  -52,   17,   14,  -20, -112,   14,  -31,   48,   15,  110,   48,   15,  -29,  -16,
      14,  -16,   80,   14,   51,   16,  -60,   29,  -34,   33,   28,  -40,   33,   29,  -62,   97,
      30,  102,   48, -119,   59,  -68, -125,   59,  -48,   67,   57,  -76,    3,   60,  -68, -125,
      60, -124,    3,   59,  -52,  -16,   20,  118,   96,    7,  123,  104,    7,   55,  104, -121,
     114,  104,    7,   55, -128, -121,  112, -112, -121,  112,   96,    7,  118,   40,    7,  118,
      -8,    5,  118,  120, -121,  119, -128, -121,   95,    8, -121,  113,   24, -121,  114, -104,
    -121,  121, -104, -127,   44,  -18,  -16,   14,  -18,  -32,   14,  -11,  -64,   14,  -20,   48,
       3,   98,  -56,  -95,   28,  -28,  -95,   28,  -52,  -95,   28,  -28,  -95,   28,  -36,   97,
      28,  -54,   33,   28,  -60, -127,   29,  -54,   97,    6,  -42, -112,   67,   57,  -56,   67,
      57, -104,   67,   57,  -56,   67,   57,  -72,  -61,   56, -108,   67,   56, -120,    3,   59,
    -108,  -61,   47,  -68, -125,   60,   -4, -126,   59,  -44,    3,   59,  -80,  -61,   12,  -57,
     105, -121,  112,   88, -121,  114,  112, -125,  116,  104,    7,  120,   96, -121,  116,   24,
    -121,  116,  -96, -121,   25,  -50,   83,   15,  -18,    0,   15,  -14,   80,   14,  -28, -112,
      14,  -29,   64,   15,  -31,   32,   14,  -20,   80,   14,   51,   32,   40,   29,  -36,  -63,
      30,  -62,   65,   30,  -46,   33,   28,  -36, -127,   30,  -36,  -32,   28,  -28,  -31,   29,
     -22,    1,   30,  102,   24,   81,   56,  -80,   67,   58, -100, -125,   59,  -52,   80,   36,
     118,   96,    7,  123,  104,    7,   55,   96, -121,  119,  120,    7,  120, -104,   81,   76,
     -12, -112,   15,  -16,   80,   14,    0,    0,  113,   32,    0,    0,   84,    0,    0,    0,
      70,  -64,   84,   64,  -12,   83,   72,   51,  -35,  -10,   63,  -39, -128,   82,    1,  -47,
      63,   56,   84,  -80,   16,  -90, -128,   20,   84,   35,   76, -120,  -45, -104,  -63,   82,
       1,  -47, -113,   52,  -45,   -1,   76, -111,   53,   52,   18,   49,  105,  -53,  -30,    8,
     -64, -124,   56, -115,   61,  100,  -53,   82,   49,   62,   67,   48,  -62, -125,   -7,   15,
    -115,  -16,   -2,   67,   35,  -68, -113,  -24,  -72,    5,   32,   21,   16,   -3, -117,  -45,
      24,  -74, -112,   20,   84,   35,   76, -120,  -45,  -68,  -26, -112,    6,   -1,  108,  -45,
    -111,  -60,   18, -109,  -73,   16,   12,  -47,   76,  -38,  -12,   83,  -62,    1,   68,  -11,
      29,   73,   63,  -80,   44, -114,    0,   76, -120,  -45,   28, -119,   81, -124,  -63,   63,
     -41,  119,   36,  113,   11,    1,   68,  104, -112,   16,  -62, -108,  -42,  119,   36,   -3,
     -64,  -78,   56,    2,   48,   33,   78,   99,    2,   73,    5,   68,  127,  -79,   56,  -64,
     100,    9, -103,   31,   73,  126,   68,   12, -108,   64,   -4,   69,  -29,   75,   20,  -61,
      57,   76, -128,   52,   68,  100,   23, -107,  127,   16,  -53,   67,   68,  -65,   68,   76,
     -38,  -78,   56,    2,   48,   33,   78,   99,    5,   74,    5,   68,   -1,  -29,   32,  -51,
     100,   27,   68, -126,   52,   66,   68,   48,   68,   51,   25,   67,   34,   17,  -45,   70,
      21,    5,   17, -103,  -60,   34,   81,   12,  -25,   48,    1,  -46,   16, -111,   85,   68,
      -2,   65,   44,   15,   17,   -3,    5,  -43,    8,   19,  -30,   52,  -81,   29,   56,   21,
      16,   -3,  -64,  -78,   56,    2,   48,   33,   78,   99,    8, -100,   31,   73,  126,   68,
      12, -108,   64,   -4,   69,  -29,   75,   20,  -93,    9,    2,  -59,   80,   11,   48,   57,
    -111,    1,   28,   21,   16,   -3,   72,   51, -103,   69,  -28,   31,  -60,  -14,   16,  -47,
      47,   17,  -45,   70,   21,    5,   17,   89, -124,   35,   81, -116,   38,    8,   20,   67,
      45,  -64,  -28,   68,   54, -127,   -8, -111,  -28,   15, -109,   19,    1,    0,    0,    0,
      97,   32,    0,    0,   38,    0,    0,    0,   19,    4,   65,   44,   16,    0,    0,    0,
      12,    0,    0,    0,    4, -108,   64,   41,   20,   67,   57, -112,   80,    4,   20,   12,
     101,   36, -123,  -96,    1,  100,   48, -108, -111,   20, -126,    6,   96,   68, -116,   17,
    -128,   32,    8, -110,   96,   64,  -58,   24,    1,    8, -126,   32,    8, -126,   32,    8,
    -110,   32,    1,    0, -125,   17,    0,   25,   12,  -64,   96,   68, -128,    6,    4,   48,
      24,   33,  -84,  -63,    0,   12,   70,   12,  108,   64,    0, -125,   17,   68,   25,   12,
     -64,   96, -124,   26, -104,  -63,    0,   12,   70,  -92,  -63,   25,   12,    0,    6,  -60,
       0,    0,    0,    0,    9,    0,    0,    0,   91,    6,   32,   16, -123,   45,   67,   16,
    -108,  -62, -106,   65,    8,   80,   97,  -53,   48,    4,  -85,  -80,  101,   32,    2,   81,
     -40,   50,   20, -127,   40,  108,   25, -116,   64,   20,    0,    0,    0,    0,    0,    0,
      97,   32,    0,    0,   11,    0,    0,    0,   19,    4,  -63,   96,    4,   64,    6,    3,
    -128,  -31,   64,    0,    2,    0,    0,    0,   70,   50,    0, -111,    1,    0,    0,    0,
       1,   49,    0,    0,    2,    0,    0,    0,   91,    6,   32,   16,    5,    0,    0,    0,
       0,    0,    0,    0,   97,   32,    0,    0,   46,    0,    0,    0,   19,    4,   68,   44,
      16,    0,    0,    0,    2,    0,    0,    0,    4, -108,    2,    9,   37,    0,    0,    0,
     -61,   13,  100, -128, -103,  -63,   44,   67,   48, -100,    1,   25,  100, -106,   64,   24,
     -88,   16,  -76,   96,   13, -124,  -15,    4,   52,   72, -125,  -63,    8,   53,   40, -125,
       1,  -80,   52,   48,    3,   24,  -36,   26,    0,   48,  -36,  -64,    6,  100,    0,    6,
     -77,   12, -125,  -48,    6,   24,   14,    4,   20,    0,    0,    0,  -90, -126,    0,   81,
       4,   96,  -56,  112,   89, -118, -126,   52,   67,    5,   68, -110, -113,   84,  -58,  -78,
      44,  -59,   20,   -7,   22,   50,   16,   72,  101,   43,   15,  -46,   12,   21,   16,   73,
      62,   82,   -7,   13,  113,   77,   23,   96,   -8,   75,  -28,   63,  -57,   13,   44,   -2,
      47,   68,  -56,  -12,   19, -125,   65,  -40,    9,   33,   48,   15,  110,   36,  -61, -128,
      48,  -42, -126,   16,   23,   50,    9,   78,   51,    0,    0,    0,    1,   49,    0,    0,
       3,    0,    0,    0,   91,    6,   33,  112, -123,   45, -125,   17, -120,    2,    0,    0,
       0,    0,    0,    0,   97,   32,    0,    0,   45,    0,    0,    0,   19,    4,   68,   44,
      16,    0,    0,    0,    5,    0,    0,    0,    4, -108,   64,   65, -112,   80,   64,  -44,
    -108,    3,   93,   35,    0,  -28,  -40,   50,    7,    0,    0,    0,   51,   17,   12,   80,
       6,  -60,  112,    3,   25,   96,  102,   48,  -53,   16,   12,  108,  112,  107,  -32,  -20,
      44, -127,   48,   80,    1,   96,  -63,   27,    8,   35,    6,    8,    0,   60,  109,  -96,
       6,  103,   96,    6,  105,   48,   98,   96,   40, -128,  -77,    6,  104,  -32,    6,  -26,
       6,  101,    0, -125,  -31, -122,   55,   32,    3,   48, -104,  101,   24,    4,   56,  -64,
     112,   32,    0,    0,   13,    0,    0,    0,  -74,   50,   76,  -52,  115,    1, -122,  -65,
      68,   -2,  115,  -36,  -64,  -30,   -1,   66, -124,   76,   63,   49,   24, -124,  -79,   16,
       2,  -13,  -32,   70,   50,   12,    8,   99,   47,    3,  -46,    8,  -26,   66,   92,   62,
     -99,   27,   12,   66,   92,  -56,   36,   56,  -51,    0,    0,    0,    1,   49,    0,    0,
       2,    0,    0,    0,   91,    6,  -93, -112,    5,    0,    0,    0,    0,    0,    0,    0,
      97,   32,    0,    0,   15,    0,    0,    0,   19,    4,   65,   44,   16,    0,    0,    0,
       1,    0,    0,    0,    4, -108,    0,    0,   71,    6,   64, -104,   25, -108,    1,   12,
     -18,   12,   26,   72,   52,    8,    7,    2,    5,    0,    0,    0,  102,   66,    8,   78,
      83,   25, -119, -128,   52, -122,   82,    8,   78,   83,  -43,  118,   50,    0,  -61,    0,
       0,    0,    0,    0,   97,   32,    0,    0,   16,    0,    0,    0,   19,    4,    1, -111,
     -63,   48,   51,   40,    3,   16,   12,   70, -112,  -63,   25,   12,    0, -122,    3,    1,
       4,    0,    0,    0,   86,   50,   84,  -64,   98,   36,    5,   32,    8,   20,   99,   39,
       3,   48,   12,    0,    1,   49,    0,    0,    3,    0,    0,    0,   91,    6,   32,   16,
    -123,   45, -125,   16, -120,    2,    0,    0,    0,    0,    0,    0,   97,   32,    0,    0,
      18,    0,    0,    0,   19,    4,    1, -107,  -63,   32,   50,   24,  118,    6,  102,    0,
    -126,  -63,    8,   50,   64, -125,    1,  -64,  112,   32,    0,    0,    4,    0,    0,    0,
      86,   50,   84,  -64,   98,   36,    5,   32,    8,   20,   99,   40,    3,   48,   12,    0,
       1,   49,    0,    0,    4,    0,    0,    0,   91,    6,   32,   16, -123,   45,   67,   16,
    -120,  -62, -106,   97,    8,   68,    1,    0,    0,    0,    0,    0,   97,   32,    0,    0,
       3,    0,    0,    0,   19,    4,  -63, -120,    1,  -95,    4,  -44, -127,    0,    0,    0,
      97,   32,    0,    0,    9,    0,    0,    0,   19,    4,  -63,  120,    3,   25,  104,   24,
    -107,  -63,   24,   49,   32, -128,   96,   49,    3,   12,    7,    2,    2,    0,    0,    0,
       7,   80,   16,  -51,   20,   97,    0,    0,    0,    0,    0,    0,   97,   32,    0,    0,
       9,    0,    0,    0,   19,    4,  -63,  120,    3,   25,  104,   24, -107,  -63,   24,   49,
      32, -128, -128,   49,    3,   12,    7,    2,    2,    0,    0,    0,    7,   80,   16,  -51,
      20,   97,    0,    0,    0,    0,    0,    0,   97,   32,    0,    0,    9,    0,    0,    0,
      19,    4,  -63,  120,    3,   25,  104,   24, -107,  -63,   24,   49,   32, -128,  -96,   49,
       3,   12,    7,    2,    2,    0,    0,    0,    7,   80,   16,  -51,   20,   97,    0,    0,
       0,    0,    0,    0,    0,    0,    0,    0,
};

const int bitCodeLength = 3480;

#endif
