description('Test setting the protocol attribute of the URL in HTMLAnchorElement .');

var a = document.createElement('a');

debug("Basic test");
a.href = "https://www.mydomain.com/path/";
a.protocol = "http-foo";
shouldBe("a.href", "'http-foo://www.mydomain.com/path/'");

// IE8 throws "Invalid argument" exception.
debug("Set a protocol that contains ':'");
try {
a.href = "https://www.mydomain.com/path/";
a.protocol = "http:foo";
shouldBe("a.href", "'http://www.mydomain.com/path/'");
} catch(e) {
debug("Exception: " + e.description);
}

// IE8 throws "Invalid argument" exception.
debug("Set a protocol that contains invalid characters");
try {
a.href = "https://www.mydomain.com/path/";
a.protocol = "http^foo";
shouldBe("a.href", "'https://www.mydomain.com/path/'");
} catch(e) {
debug("Exception: " + e.description);
}

// The expected behavior should change when the character table is updated.
// IE8 encodes '^' in the host.
debug("Set a protocol to a URL with invalid host name");
a.href = "h:^^";
a.protocol = "foo";
shouldBe("a.href", "'foo:^^'");

// IE8 throws "Invalid argument" exception.
try {
debug("Set a protocol that starts with ':'");
a.href = "https://www.mydomain.com/path/";
a.protocol = ":http";
shouldBe("a.href", "'https://www.mydomain.com/path/'");
} catch(e) {
debug("Exception: " + e.description);
}

// IE8 converts null to "null", which is not the right thing to do.
debug("Set protocol to null");
a.href = "https://www.mydomain.com/path/";
a.protocol = null;
shouldBe("a.href", "'https://www.mydomain.com/path/'");

// IE8 throws "Invalid argument" exception.
try {
debug("Set protocol to empty string");
a.href = "https://www.mydomain.com/path/";
a.protocol = "";
shouldBe("a.href", "'https://www.mydomain.com/path/'");
} catch(e) {
debug("Exception: " + e.description);
}

// Firefox 3.5.2 tries to build a hierarchical URL.
debug("Set protocol to http on malformed URL");
a.href = "foo:??bar";
a.protocol = "http";
shouldBe("a.href", "'http:??bar'");

// IE8 keeps the protocol if it is 'c:'.
debug("Set protocol to a URL which points to a local file");
a.href = "c:\path";
a.protocol = "f-oo";
shouldBe("a.href", "'f-oo:path'");

debug("Set protocol to undefined");
a.href = "https://www.mydomain.com/path/";
a.protocol = undefined;
shouldBe("a.href", "'undefined://www.mydomain.com/path/'");

var successfullyParsed = true;
