/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.0*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8821C_SUPPORT == 1)
static boolean
check_positive(
	struct dm_struct *dm,
	const u32	condition1,
	const u32	condition2,
	const u32	condition3,
	const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2, cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para = (dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;
	u8	pkg_type_for_para = (dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);


	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) && ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}
static boolean
check_negative(
	struct dm_struct *dm,
	const u32	condition1,
	const u32	condition2
)
{
	return true;
}

/******************************************************************************
*                           radioa.TXT
******************************************************************************/

u32 array_mp_8821c_radioa[] = {
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00010000,
		0x018, 0x00010D24,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00010000,
		0x018, 0x00010D24,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00010000,
		0x018, 0x00010D24,
	0xA0000000,	0x00000000,
		0x000, 0x00010000,
		0x018, 0x00010D24,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000004,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000004,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000004,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
	0xA0000000,	0x00000000,
		0x0B0, 0x000FF0F8,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000004,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000058,
		0x03F, 0x0000001C,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000058,
		0x03F, 0x0000001C,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000058,
		0x03F, 0x0000001C,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000058,
		0x03F, 0x0000001C,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010524,
		0x081, 0x0000FCC1,
		0x089, 0x00000004,
		0x08A, 0x0008A186,
		0x08B, 0x0006FFFC,
		0x08C, 0x000312C7,
		0x08D, 0x00020888,
		0x08E, 0x00064140,
		0x08F, 0x000A8010,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010524,
		0x081, 0x0000FCC1,
		0x089, 0x00000004,
		0x08A, 0x0008A186,
		0x08B, 0x0006FFFC,
		0x08C, 0x000312C7,
		0x08D, 0x00020888,
		0x08E, 0x00064140,
		0x08F, 0x000A8010,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010524,
		0x081, 0x0000FCC1,
		0x089, 0x00000004,
		0x08A, 0x0008A186,
		0x08B, 0x0007060C,
		0x08C, 0x000312C7,
		0x08D, 0x00020888,
		0x08E, 0x00064140,
		0x08F, 0x000A8010,
	0xA0000000,	0x00000000,
		0x018, 0x00010524,
		0x081, 0x0000FCC1,
		0x089, 0x00000004,
		0x08A, 0x0008A186,
		0x08B, 0x0007060C,
		0x08C, 0x000312C7,
		0x08D, 0x00020888,
		0x08E, 0x00064140,
		0x08F, 0x000A8010,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000020,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000020,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000020,
	0xA0000000,	0x00000000,
		0x0DD, 0x00000020,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00038000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x00038080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x000380C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x00038190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x00038998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x00039840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x000398C4,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x00039930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000001,
		0x03F, 0x0000000A,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000001,
		0x03F, 0x0000000A,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000001,
		0x03F, 0x0000000A,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000001,
		0x03F, 0x0000000A,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
		0x087, 0x000E8180,
		0x088, 0x00006020,
		0x0DF, 0x00008009,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
		0x087, 0x000E8180,
		0x088, 0x00006020,
		0x0DF, 0x00008009,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
		0x087, 0x000E8180,
		0x088, 0x00006020,
		0x0DF, 0x00008009,
	0xA0000000,	0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
		0x087, 0x000E8180,
		0x088, 0x00006020,
		0x0DF, 0x00008009,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x0000001E,
		0x03F, 0x00000000,
		0x033, 0x0000001C,
		0x03F, 0x00000000,
		0x033, 0x0000000E,
		0x03F, 0x00000000,
		0x033, 0x0000000C,
		0x03F, 0x00000000,
		0x033, 0x0000000A,
		0x03F, 0x00000002,
		0x033, 0x00000008,
		0x03F, 0x00000000,
		0x033, 0x00000036,
		0x03F, 0x00000000,
		0x033, 0x00000037,
		0x03F, 0x00000000,
		0x033, 0x00000034,
		0x03F, 0x00000000,
		0x033, 0x00000026,
		0x03F, 0x00000006,
		0x033, 0x00000027,
		0x03F, 0x00000006,
		0x033, 0x00000024,
		0x03F, 0x00000006,
		0x033, 0x00000022,
		0x03F, 0x00000006,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000000,
		0x033, 0x00000007,
		0x03F, 0x00000006,
		0x033, 0x00000004,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000000,
		0x03F, 0x00000006,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x0000001E,
		0x03F, 0x00000000,
		0x033, 0x0000001C,
		0x03F, 0x00000000,
		0x033, 0x0000000E,
		0x03F, 0x00000000,
		0x033, 0x0000000C,
		0x03F, 0x00000000,
		0x033, 0x0000000A,
		0x03F, 0x00000002,
		0x033, 0x00000008,
		0x03F, 0x00000000,
		0x033, 0x00000036,
		0x03F, 0x00000000,
		0x033, 0x00000037,
		0x03F, 0x00000000,
		0x033, 0x00000034,
		0x03F, 0x00000000,
		0x033, 0x00000026,
		0x03F, 0x00000006,
		0x033, 0x00000027,
		0x03F, 0x00000006,
		0x033, 0x00000024,
		0x03F, 0x00000006,
		0x033, 0x00000022,
		0x03F, 0x00000006,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000000,
		0x033, 0x00000007,
		0x03F, 0x00000006,
		0x033, 0x00000004,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000000,
		0x03F, 0x00000006,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x0000001E,
		0x03F, 0x00000000,
		0x033, 0x0000001C,
		0x03F, 0x00000000,
		0x033, 0x0000000E,
		0x03F, 0x00000000,
		0x033, 0x0000000C,
		0x03F, 0x00000000,
		0x033, 0x0000000A,
		0x03F, 0x00000002,
		0x033, 0x00000008,
		0x03F, 0x00000000,
		0x033, 0x00000036,
		0x03F, 0x00000000,
		0x033, 0x00000037,
		0x03F, 0x00000000,
		0x033, 0x00000034,
		0x03F, 0x00000000,
		0x033, 0x00000026,
		0x03F, 0x00000006,
		0x033, 0x00000027,
		0x03F, 0x00000006,
		0x033, 0x00000024,
		0x03F, 0x00000006,
		0x033, 0x00000022,
		0x03F, 0x00000006,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000000,
		0x033, 0x00000007,
		0x03F, 0x00000006,
		0x033, 0x00000004,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000000,
		0x03F, 0x00000006,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x0000001E,
		0x03F, 0x00000000,
		0x033, 0x0000001C,
		0x03F, 0x00000000,
		0x033, 0x0000000E,
		0x03F, 0x00000000,
		0x033, 0x0000000C,
		0x03F, 0x00000000,
		0x033, 0x0000000A,
		0x03F, 0x00000002,
		0x033, 0x00000008,
		0x03F, 0x00000000,
		0x033, 0x00000036,
		0x03F, 0x00000000,
		0x033, 0x00000037,
		0x03F, 0x00000000,
		0x033, 0x00000034,
		0x03F, 0x00000000,
		0x033, 0x00000026,
		0x03F, 0x00000006,
		0x033, 0x00000027,
		0x03F, 0x00000006,
		0x033, 0x00000024,
		0x03F, 0x00000006,
		0x033, 0x00000022,
		0x03F, 0x00000006,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000000,
		0x033, 0x00000007,
		0x03F, 0x00000006,
		0x033, 0x00000004,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000000,
		0x03F, 0x00000006,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0A0, 0x000F0005,
		0x0A1, 0x0006C000,
		0x0A2, 0x0000161B,
		0x0A3, 0x000B9CBD,
		0x0AF, 0x00070000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0A0, 0x000F0005,
		0x0A1, 0x0006C000,
		0x0A2, 0x0000161B,
		0x0A3, 0x000B9CBD,
		0x0AF, 0x00070000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0A0, 0x000F0005,
		0x0A1, 0x0006C000,
		0x0A2, 0x0000161B,
		0x0A3, 0x000B9CBD,
		0x0AF, 0x00070000,
	0xA0000000,	0x00000000,
		0x0A0, 0x000F0005,
		0x0A1, 0x0006C000,
		0x0A2, 0x0000161B,
		0x0A3, 0x000B9CBD,
		0x0AF, 0x00070000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000200,
		0x0EE, 0x00000100,
		0x033, 0x00000007,
		0x03F, 0x00000043,
		0x033, 0x00000006,
		0x03F, 0x0000007A,
		0x033, 0x00000005,
		0x03F, 0x00000041,
		0x033, 0x00000004,
		0x03F, 0x00000079,
		0x033, 0x00000003,
		0x03F, 0x00000043,
		0x033, 0x00000002,
		0x03F, 0x0000007A,
		0x033, 0x00000001,
		0x03F, 0x00000041,
		0x033, 0x00000000,
		0x03F, 0x00000079,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000200,
		0x0EE, 0x00000100,
		0x033, 0x00000007,
		0x03F, 0x00000043,
		0x033, 0x00000006,
		0x03F, 0x0000007A,
		0x033, 0x00000005,
		0x03F, 0x00000041,
		0x033, 0x00000004,
		0x03F, 0x00000079,
		0x033, 0x00000003,
		0x03F, 0x00000043,
		0x033, 0x00000002,
		0x03F, 0x0000007A,
		0x033, 0x00000001,
		0x03F, 0x00000041,
		0x033, 0x00000000,
		0x03F, 0x00000079,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000200,
		0x0EE, 0x00000100,
		0x033, 0x00000007,
		0x03F, 0x00000043,
		0x033, 0x00000006,
		0x03F, 0x0000007A,
		0x033, 0x00000005,
		0x03F, 0x00000041,
		0x033, 0x00000004,
		0x03F, 0x00000079,
		0x033, 0x00000003,
		0x03F, 0x00000043,
		0x033, 0x00000002,
		0x03F, 0x0000007A,
		0x033, 0x00000001,
		0x03F, 0x00000041,
		0x033, 0x00000000,
		0x03F, 0x00000079,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000200,
		0x0EE, 0x00000100,
		0x033, 0x00000007,
		0x03F, 0x00000043,
		0x033, 0x00000006,
		0x03F, 0x0000007A,
		0x033, 0x00000005,
		0x03F, 0x00000041,
		0x033, 0x00000004,
		0x03F, 0x00000079,
		0x033, 0x00000003,
		0x03F, 0x00000043,
		0x033, 0x00000002,
		0x03F, 0x0000007A,
		0x033, 0x00000001,
		0x03F, 0x00000041,
		0x033, 0x00000000,
		0x03F, 0x00000079,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
	0xA0000000,	0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
	0xA0000000,	0x00000000,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0xA0000000,	0x00000000,
		0x0B0, 0x000FF0F8,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00018D24,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00018D24,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00018D24,
	0xA0000000,	0x00000000,
		0x018, 0x00018D24,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010D24,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010D24,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010D24,
	0xA0000000,	0x00000000,
		0x018, 0x00010D24,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00003A40,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00003A40,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00003A40,
	0xA0000000,	0x00000000,
		0x01B, 0x00003A40,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0004D3A3,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0004D3A3,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0004D3A1,
		0x062, 0x0000D3A3,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x061, 0x0004D3A1,
		0x062, 0x0000D3A3,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000000,
		0x03F, 0x00033303,
		0x030, 0x00001000,
		0x03F, 0x00033303,
		0x030, 0x00002000,
		0x03F, 0x00033303,
		0x030, 0x00003000,
		0x03F, 0x00033303,
		0x030, 0x00004000,
		0x03F, 0x00033303,
		0x030, 0x00005000,
		0x03F, 0x00033303,
		0x030, 0x00006000,
		0x03F, 0x00033303,
		0x030, 0x00007000,
		0x03F, 0x00033303,
		0x030, 0x00008000,
		0x03F, 0x00033303,
		0x030, 0x00009000,
		0x03F, 0x00033303,
		0x030, 0x0000A000,
		0x03F, 0x00033303,
		0x030, 0x0000B000,
		0x03F, 0x00033303,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000000,
		0x03F, 0x00033303,
		0x030, 0x00001000,
		0x03F, 0x00033303,
		0x030, 0x00002000,
		0x03F, 0x00033303,
		0x030, 0x00003000,
		0x03F, 0x00033303,
		0x030, 0x00004000,
		0x03F, 0x000313A3,
		0x030, 0x00005000,
		0x03F, 0x000313A3,
		0x030, 0x00006000,
		0x03F, 0x000313A3,
		0x030, 0x00007000,
		0x03F, 0x000313A3,
		0x030, 0x00008000,
		0x03F, 0x000333A3,
		0x030, 0x00009000,
		0x03F, 0x000333A3,
		0x030, 0x0000A000,
		0x03F, 0x000333A3,
		0x030, 0x0000B000,
		0x03F, 0x000333A3,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000000,
		0x03F, 0x000335A3,
		0x030, 0x00001000,
		0x03F, 0x000335A3,
		0x030, 0x00002000,
		0x03F, 0x000335A3,
		0x030, 0x00003000,
		0x03F, 0x000335A3,
		0x030, 0x00004000,
		0x03F, 0x000335A3,
		0x030, 0x00005000,
		0x03F, 0x000335A3,
		0x030, 0x00006000,
		0x03F, 0x000335A3,
		0x030, 0x00007000,
		0x03F, 0x000335A3,
		0x030, 0x00008000,
		0x03F, 0x000335A3,
		0x030, 0x00009000,
		0x03F, 0x000335A3,
		0x030, 0x0000A000,
		0x03F, 0x000335A3,
		0x030, 0x0000B000,
		0x03F, 0x000335A3,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000000,
		0x03F, 0x000335A3,
		0x030, 0x00001000,
		0x03F, 0x000335A3,
		0x030, 0x00002000,
		0x03F, 0x000335A3,
		0x030, 0x00003000,
		0x03F, 0x000335A3,
		0x030, 0x00004000,
		0x03F, 0x000335A3,
		0x030, 0x00005000,
		0x03F, 0x000335A3,
		0x030, 0x00006000,
		0x03F, 0x000335A3,
		0x030, 0x00007000,
		0x03F, 0x000335A3,
		0x030, 0x00008000,
		0x03F, 0x000335A3,
		0x030, 0x00009000,
		0x03F, 0x000335A3,
		0x030, 0x0000A000,
		0x03F, 0x000335A3,
		0x030, 0x0000B000,
		0x03F, 0x000335A3,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03F, 0x00033303,
		0x033, 0x00000001,
		0x03F, 0x00033303,
		0x033, 0x00000002,
		0x03F, 0x00033303,
		0x033, 0x00000003,
		0x03F, 0x00033303,
		0x033, 0x00000004,
		0x03F, 0x00033303,
		0x033, 0x00000005,
		0x03F, 0x00033303,
		0x033, 0x00000006,
		0x03F, 0x00033303,
		0x033, 0x00000007,
		0x03F, 0x00033303,
		0x033, 0x00000008,
		0x03F, 0x00033303,
		0x033, 0x00000009,
		0x03F, 0x00033303,
		0x033, 0x0000000A,
		0x03F, 0x00033303,
		0x033, 0x0000000B,
		0x03F, 0x00033303,
		0x033, 0x0000000C,
		0x03F, 0x00033303,
		0x033, 0x0000000D,
		0x03F, 0x00033303,
		0x033, 0x0000000E,
		0x03F, 0x00033303,
		0x033, 0x0000000F,
		0x03F, 0x00033303,
		0x033, 0x00000010,
		0x03F, 0x00033303,
		0x033, 0x00000011,
		0x03F, 0x00033303,
		0x033, 0x00000012,
		0x03F, 0x00033303,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03F, 0x00033303,
		0x033, 0x00000001,
		0x03F, 0x00033303,
		0x033, 0x00000002,
		0x03F, 0x00033303,
		0x033, 0x00000003,
		0x03F, 0x00033303,
		0x033, 0x00000004,
		0x03F, 0x00033303,
		0x033, 0x00000005,
		0x03F, 0x00033303,
		0x033, 0x00000006,
		0x03F, 0x00033303,
		0x033, 0x00000007,
		0x03F, 0x00033303,
		0x033, 0x00000008,
		0x03F, 0x000313A3,
		0x033, 0x00000009,
		0x03F, 0x000313A3,
		0x033, 0x0000000A,
		0x03F, 0x000313A3,
		0x033, 0x0000000B,
		0x03F, 0x000313A3,
		0x033, 0x0000000C,
		0x03F, 0x000313A3,
		0x033, 0x0000000D,
		0x03F, 0x000333A3,
		0x033, 0x0000000E,
		0x03F, 0x000333A3,
		0x033, 0x0000000F,
		0x03F, 0x000333A3,
		0x033, 0x00000010,
		0x03F, 0x000333A3,
		0x033, 0x00000011,
		0x03F, 0x000333A3,
		0x033, 0x00000012,
		0x03F, 0x000333A3,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03F, 0x000335A3,
		0x033, 0x00000001,
		0x03F, 0x000335A3,
		0x033, 0x00000002,
		0x03F, 0x000335A3,
		0x033, 0x00000003,
		0x03F, 0x000335A3,
		0x033, 0x00000004,
		0x03F, 0x000335A3,
		0x033, 0x00000005,
		0x03F, 0x000335A3,
		0x033, 0x00000006,
		0x03F, 0x000335A3,
		0x033, 0x00000007,
		0x03F, 0x000335A3,
		0x033, 0x00000008,
		0x03F, 0x000335A3,
		0x033, 0x00000009,
		0x03F, 0x000335A3,
		0x033, 0x0000000A,
		0x03F, 0x000335A3,
		0x033, 0x0000000B,
		0x03F, 0x000335A3,
		0x033, 0x0000000C,
		0x03F, 0x000335A3,
		0x033, 0x0000000D,
		0x03F, 0x000335A3,
		0x033, 0x0000000E,
		0x03F, 0x000335A3,
		0x033, 0x0000000F,
		0x03F, 0x000335A3,
		0x033, 0x00000010,
		0x03F, 0x000335A3,
		0x033, 0x00000011,
		0x03F, 0x000335A3,
		0x033, 0x00000012,
		0x03F, 0x000335A3,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03F, 0x000335A3,
		0x033, 0x00000001,
		0x03F, 0x000335A3,
		0x033, 0x00000002,
		0x03F, 0x000335A3,
		0x033, 0x00000003,
		0x03F, 0x000335A3,
		0x033, 0x00000004,
		0x03F, 0x000335A3,
		0x033, 0x00000005,
		0x03F, 0x000335A3,
		0x033, 0x00000006,
		0x03F, 0x000335A3,
		0x033, 0x00000007,
		0x03F, 0x000335A3,
		0x033, 0x00000008,
		0x03F, 0x000335A3,
		0x033, 0x00000009,
		0x03F, 0x000335A3,
		0x033, 0x0000000A,
		0x03F, 0x000335A3,
		0x033, 0x0000000B,
		0x03F, 0x000335A3,
		0x033, 0x0000000C,
		0x03F, 0x000335A3,
		0x033, 0x0000000D,
		0x03F, 0x000335A3,
		0x033, 0x0000000E,
		0x03F, 0x000335A3,
		0x033, 0x0000000F,
		0x03F, 0x000335A3,
		0x033, 0x00000010,
		0x03F, 0x000335A3,
		0x033, 0x00000011,
		0x03F, 0x000335A3,
		0x033, 0x00000012,
		0x03F, 0x000335A3,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000644,
		0x030, 0x00001135,
		0x030, 0x00002133,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000644,
		0x030, 0x00001412,
		0x030, 0x00002202,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000640,
		0x030, 0x00001512,
		0x030, 0x00002202,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000640,
		0x030, 0x00001512,
		0x030, 0x00002202,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000001,
		0x033, 0x00000021,
		0x03F, 0x00000004,
		0x033, 0x00000022,
		0x03F, 0x00000007,
		0x033, 0x00000023,
		0x03F, 0x00000024,
		0x033, 0x00000024,
		0x03F, 0x00000027,
		0x033, 0x00000025,
		0x03F, 0x0000002A,
		0x033, 0x00000026,
		0x03F, 0x0000002D,
		0x033, 0x00000027,
		0x03F, 0x00000030,
		0x033, 0x00000028,
		0x03F, 0x00000033,
		0x033, 0x00000029,
		0x03F, 0x00000036,
		0x033, 0x0000002A,
		0x03F, 0x00000039,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000E42,
		0x033, 0x00000021,
		0x03F, 0x00000E45,
		0x033, 0x00000022,
		0x03F, 0x00000E65,
		0x033, 0x00000023,
		0x03F, 0x00000E68,
		0x033, 0x00000024,
		0x03F, 0x00000EE4,
		0x033, 0x00000025,
		0x03F, 0x00000EE7,
		0x033, 0x00000026,
		0x03F, 0x00000EEA,
		0x033, 0x00000027,
		0x03F, 0x00000EED,
		0x033, 0x00000028,
		0x03F, 0x00000EF0,
		0x033, 0x00000029,
		0x03F, 0x00000EF3,
		0x033, 0x0000002A,
		0x03F, 0x00000EF6,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000E42,
		0x033, 0x00000021,
		0x03F, 0x00000E45,
		0x033, 0x00000022,
		0x03F, 0x00000E48,
		0x033, 0x00000023,
		0x03F, 0x00000E68,
		0x033, 0x00000024,
		0x03F, 0x00000E6B,
		0x033, 0x00000025,
		0x03F, 0x00000EAA,
		0x033, 0x00000026,
		0x03F, 0x00000EEA,
		0x033, 0x00000027,
		0x03F, 0x00000EED,
		0x033, 0x00000028,
		0x03F, 0x00000EF0,
		0x033, 0x00000029,
		0x03F, 0x00000EF3,
		0x033, 0x0000002A,
		0x03F, 0x00000EF6,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000E42,
		0x033, 0x00000021,
		0x03F, 0x00000E45,
		0x033, 0x00000022,
		0x03F, 0x00000E65,
		0x033, 0x00000023,
		0x03F, 0x00000E68,
		0x033, 0x00000024,
		0x03F, 0x00000EE4,
		0x033, 0x00000025,
		0x03F, 0x00000EE7,
		0x033, 0x00000026,
		0x03F, 0x00000EEA,
		0x033, 0x00000027,
		0x03F, 0x00000EED,
		0x033, 0x00000028,
		0x03F, 0x00000EF0,
		0x033, 0x00000029,
		0x03F, 0x00000EF3,
		0x033, 0x0000002A,
		0x03F, 0x00000EF6,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000001,
		0x033, 0x00000061,
		0x03F, 0x00000004,
		0x033, 0x00000062,
		0x03F, 0x00000007,
		0x033, 0x00000063,
		0x03F, 0x00000024,
		0x033, 0x00000064,
		0x03F, 0x00000027,
		0x033, 0x00000065,
		0x03F, 0x0000002A,
		0x033, 0x00000066,
		0x03F, 0x0000002D,
		0x033, 0x00000067,
		0x03F, 0x00000030,
		0x033, 0x00000068,
		0x03F, 0x00000033,
		0x033, 0x00000069,
		0x03F, 0x00000036,
		0x033, 0x0000006A,
		0x03F, 0x00000039,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E42,
		0x033, 0x00000061,
		0x03F, 0x00000E45,
		0x033, 0x00000062,
		0x03F, 0x00000E65,
		0x033, 0x00000063,
		0x03F, 0x00000E68,
		0x033, 0x00000064,
		0x03F, 0x00000EE5,
		0x033, 0x00000065,
		0x03F, 0x00000EE8,
		0x033, 0x00000066,
		0x03F, 0x00000EEB,
		0x033, 0x00000067,
		0x03F, 0x00000EEE,
		0x033, 0x00000068,
		0x03F, 0x00000EF1,
		0x033, 0x00000069,
		0x03F, 0x00000EF4,
		0x033, 0x0000006A,
		0x03F, 0x00000EF7,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E09,
		0x033, 0x00000061,
		0x03F, 0x00000E43,
		0x033, 0x00000062,
		0x03F, 0x00000E46,
		0x033, 0x00000063,
		0x03F, 0x00000E49,
		0x033, 0x00000064,
		0x03F, 0x00000E88,
		0x033, 0x00000065,
		0x03F, 0x00000E8B,
		0x033, 0x00000066,
		0x03F, 0x00000ECB,
		0x033, 0x00000067,
		0x03F, 0x00000ECE,
		0x033, 0x00000068,
		0x03F, 0x00000EF0,
		0x033, 0x00000069,
		0x03F, 0x00000EF3,
		0x033, 0x0000006A,
		0x03F, 0x00000EF6,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E42,
		0x033, 0x00000061,
		0x03F, 0x00000E45,
		0x033, 0x00000062,
		0x03F, 0x00000E65,
		0x033, 0x00000063,
		0x03F, 0x00000E68,
		0x033, 0x00000064,
		0x03F, 0x00000EE5,
		0x033, 0x00000065,
		0x03F, 0x00000EE8,
		0x033, 0x00000066,
		0x03F, 0x00000EEB,
		0x033, 0x00000067,
		0x03F, 0x00000EEE,
		0x033, 0x00000068,
		0x03F, 0x00000EF1,
		0x033, 0x00000069,
		0x03F, 0x00000EF4,
		0x033, 0x0000006A,
		0x03F, 0x00000EF7,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000001,
		0x033, 0x000000A1,
		0x03F, 0x00000004,
		0x033, 0x000000A2,
		0x03F, 0x00000007,
		0x033, 0x000000A3,
		0x03F, 0x00000025,
		0x033, 0x000000A4,
		0x03F, 0x00000028,
		0x033, 0x000000A5,
		0x03F, 0x0000002B,
		0x033, 0x000000A6,
		0x03F, 0x0000002E,
		0x033, 0x000000A7,
		0x03F, 0x00000031,
		0x033, 0x000000A8,
		0x03F, 0x00000034,
		0x033, 0x000000A9,
		0x03F, 0x00000037,
		0x033, 0x000000AA,
		0x03F, 0x0000003A,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000E09,
		0x033, 0x000000A1,
		0x03F, 0x00000E43,
		0x033, 0x000000A2,
		0x03F, 0x00000E64,
		0x033, 0x000000A3,
		0x03F, 0x00000E67,
		0x033, 0x000000A4,
		0x03F, 0x00000EE4,
		0x033, 0x000000A5,
		0x03F, 0x00000EE7,
		0x033, 0x000000A6,
		0x03F, 0x00000EEA,
		0x033, 0x000000A7,
		0x03F, 0x00000EED,
		0x033, 0x000000A8,
		0x03F, 0x00000EF0,
		0x033, 0x000000A9,
		0x03F, 0x00000EF3,
		0x033, 0x000000AA,
		0x03F, 0x00000EF6,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000E08,
		0x033, 0x000000A1,
		0x03F, 0x00000E42,
		0x033, 0x000000A2,
		0x03F, 0x00000E45,
		0x033, 0x000000A3,
		0x03F, 0x00000E48,
		0x033, 0x000000A4,
		0x03F, 0x00000EA5,
		0x033, 0x000000A5,
		0x03F, 0x00000EA8,
		0x033, 0x000000A6,
		0x03F, 0x00000ECA,
		0x033, 0x000000A7,
		0x03F, 0x00000ECD,
		0x033, 0x000000A8,
		0x03F, 0x00000EEF,
		0x033, 0x000000A9,
		0x03F, 0x00000EF2,
		0x033, 0x000000AA,
		0x03F, 0x00000EF5,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000E09,
		0x033, 0x000000A1,
		0x03F, 0x00000E43,
		0x033, 0x000000A2,
		0x03F, 0x00000E64,
		0x033, 0x000000A3,
		0x03F, 0x00000E67,
		0x033, 0x000000A4,
		0x03F, 0x00000EE4,
		0x033, 0x000000A5,
		0x03F, 0x00000EE7,
		0x033, 0x000000A6,
		0x03F, 0x00000EEA,
		0x033, 0x000000A7,
		0x03F, 0x00000EED,
		0x033, 0x000000A8,
		0x03F, 0x00000EF0,
		0x033, 0x000000A9,
		0x03F, 0x00000EF3,
		0x033, 0x000000AA,
		0x03F, 0x00000EF6,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0006AC00,
		0x033, 0x00000001,
		0x03F, 0x00060C00,
		0x033, 0x00000002,
		0x03F, 0x0006AC00,
		0x033, 0x00000003,
		0x03F, 0x00086A00,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0006AC00,
		0x033, 0x00000001,
		0x03F, 0x00060C00,
		0x033, 0x00000002,
		0x03F, 0x0006AC00,
		0x033, 0x00000003,
		0x03F, 0x00086A00,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0006AC00,
		0x033, 0x00000001,
		0x03F, 0x00060C00,
		0x033, 0x00000002,
		0x03F, 0x0006AC00,
		0x033, 0x00000003,
		0x03F, 0x00086A00,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0006AC00,
		0x033, 0x00000001,
		0x03F, 0x00060C00,
		0x033, 0x00000002,
		0x03F, 0x0006AC00,
		0x033, 0x00000003,
		0x03F, 0x00086A00,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000040,
		0x033, 0x00000001,
		0x03F, 0x00000040,
		0x033, 0x00000002,
		0x03F, 0x00000040,
		0x033, 0x00000003,
		0x03F, 0x00000040,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000040,
		0x033, 0x00000001,
		0x03F, 0x00000040,
		0x033, 0x00000002,
		0x03F, 0x00000040,
		0x033, 0x00000003,
		0x03F, 0x00000040,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000040,
		0x033, 0x00000001,
		0x03F, 0x00000040,
		0x033, 0x00000002,
		0x03F, 0x00000040,
		0x033, 0x00000003,
		0x03F, 0x00000040,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000040,
		0x033, 0x00000001,
		0x03F, 0x00000040,
		0x033, 0x00000002,
		0x03F, 0x00000040,
		0x033, 0x00000003,
		0x03F, 0x00000040,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00040000,
		0x033, 0x00000000,
		0x03F, 0x00086A40,
		0x033, 0x00000001,
		0x03F, 0x00086A40,
		0x033, 0x00000002,
		0x03F, 0x00086A40,
		0x033, 0x00000003,
		0x03F, 0x00086A40,
		0x033, 0x00000004,
		0x03F, 0x00086A40,
		0x033, 0x00000005,
		0x03F, 0x00086A40,
		0x033, 0x00000006,
		0x03F, 0x00084A40,
		0x033, 0x00000007,
		0x03F, 0x00084A40,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00040000,
		0x033, 0x00000000,
		0x03F, 0x00086A40,
		0x033, 0x00000001,
		0x03F, 0x00086A40,
		0x033, 0x00000002,
		0x03F, 0x00086A40,
		0x033, 0x00000003,
		0x03F, 0x00086A40,
		0x033, 0x00000004,
		0x03F, 0x00086A40,
		0x033, 0x00000005,
		0x03F, 0x00086A40,
		0x033, 0x00000006,
		0x03F, 0x00084A40,
		0x033, 0x00000007,
		0x03F, 0x00084A40,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00040000,
		0x033, 0x00000000,
		0x03F, 0x00086A40,
		0x033, 0x00000001,
		0x03F, 0x00086A40,
		0x033, 0x00000002,
		0x03F, 0x00086A40,
		0x033, 0x00000003,
		0x03F, 0x00086A40,
		0x033, 0x00000004,
		0x03F, 0x00086A40,
		0x033, 0x00000005,
		0x03F, 0x00086A40,
		0x033, 0x00000006,
		0x03F, 0x00084A40,
		0x033, 0x00000007,
		0x03F, 0x00084A40,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00040000,
		0x033, 0x00000000,
		0x03F, 0x00086A40,
		0x033, 0x00000001,
		0x03F, 0x00086A40,
		0x033, 0x00000002,
		0x03F, 0x00086A40,
		0x033, 0x00000003,
		0x03F, 0x00086A40,
		0x033, 0x00000004,
		0x03F, 0x00086A40,
		0x033, 0x00000005,
		0x03F, 0x00086A40,
		0x033, 0x00000006,
		0x03F, 0x00084A40,
		0x033, 0x00000007,
		0x03F, 0x00084A40,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x051, 0x000801A8,
		0x052, 0x000972E3,
		0x053, 0x00008069,
		0x054, 0x00030032,
		0x055, 0x00082003,
		0x056, 0x00051CCB,
		0x057, 0x0000CFC2,
		0x058, 0x00000010,
		0x059, 0x00030000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x051, 0x000801A8,
		0x052, 0x000972E3,
		0x053, 0x00008069,
		0x054, 0x00030032,
		0x055, 0x00082003,
		0x056, 0x00051CCB,
		0x057, 0x0000CFC2,
		0x058, 0x00000010,
		0x059, 0x00030000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x051, 0x000801A8,
		0x052, 0x000972E3,
		0x053, 0x00008069,
		0x054, 0x00030032,
		0x055, 0x00082003,
		0x056, 0x00051CCB,
		0x057, 0x0000CFC2,
		0x058, 0x00000010,
		0x059, 0x00030000,
	0xA0000000,	0x00000000,
		0x051, 0x000801A8,
		0x052, 0x000972E3,
		0x053, 0x00008069,
		0x054, 0x00030032,
		0x055, 0x00082003,
		0x056, 0x00051CCB,
		0x057, 0x0000CFC2,
		0x058, 0x00000010,
		0x059, 0x00030000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00051429,
		0x033, 0x00000001,
		0x03F, 0x00051449,
		0x033, 0x00000002,
		0x03F, 0x0005144C,
		0x033, 0x00000003,
		0x03F, 0x00051C66,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051CE8,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00051429,
		0x033, 0x00000001,
		0x03F, 0x00051449,
		0x033, 0x00000002,
		0x03F, 0x0005144C,
		0x033, 0x00000003,
		0x03F, 0x00051C66,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051CE8,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C67,
		0x033, 0x00000005,
		0x03F, 0x00051C6A,
		0x033, 0x00000006,
		0x03F, 0x00051C8B,
		0x033, 0x00000007,
		0x03F, 0x00051CE9,
		0x033, 0x00000008,
		0x03F, 0x00051CEC,
		0x033, 0x00000009,
		0x03F, 0x00051CEF,
		0x033, 0x0000000A,
		0x03F, 0x00051CF2,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C67,
		0x033, 0x00000005,
		0x03F, 0x00051C6A,
		0x033, 0x00000006,
		0x03F, 0x00051C8B,
		0x033, 0x00000007,
		0x03F, 0x00051CE9,
		0x033, 0x00000008,
		0x03F, 0x00051CEC,
		0x033, 0x00000009,
		0x03F, 0x00051CEF,
		0x033, 0x0000000A,
		0x03F, 0x00051CF2,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00086E00,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00086E00,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00086E00,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00086E00,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000000,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000000,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000000,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000000,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00080000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00048400,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x033, 0x00000004,
		0x03F, 0x00048400,
		0x033, 0x00000005,
		0x03F, 0x00048400,
		0x033, 0x00000006,
		0x03F, 0x00048400,
		0x033, 0x00000007,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00080000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00048400,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x033, 0x00000004,
		0x03F, 0x00048400,
		0x033, 0x00000005,
		0x03F, 0x00048400,
		0x033, 0x00000006,
		0x03F, 0x00048400,
		0x033, 0x00000007,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00080000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00048400,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x033, 0x00000004,
		0x03F, 0x00048400,
		0x033, 0x00000005,
		0x03F, 0x00048400,
		0x033, 0x00000006,
		0x03F, 0x00048400,
		0x033, 0x00000007,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00080000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00048400,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x033, 0x00000004,
		0x03F, 0x00048400,
		0x033, 0x00000005,
		0x03F, 0x00048400,
		0x033, 0x00000006,
		0x03F, 0x00048400,
		0x033, 0x00000007,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x070, 0x00008000,
		0x075, 0x000027DA,
		0x076, 0x00006997,
		0x077, 0x00070418,
		0x078, 0x000BB000,
		0x07D, 0x00007600,
		0x07F, 0x00000000,
		0x06A, 0x000F4C00,
		0x065, 0x00082030,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x070, 0x00008000,
		0x075, 0x000027DA,
		0x076, 0x00006997,
		0x077, 0x00070418,
		0x078, 0x000BB000,
		0x07D, 0x00007600,
		0x07F, 0x00000000,
		0x06A, 0x000F4C00,
		0x065, 0x00082030,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x070, 0x00008000,
		0x075, 0x000027DA,
		0x076, 0x00006997,
		0x077, 0x00070418,
		0x078, 0x000BB000,
		0x07D, 0x00007600,
		0x07F, 0x00000000,
		0x06A, 0x000F4C00,
		0x065, 0x00082030,
	0xA0000000,	0x00000000,
		0x070, 0x00008000,
		0x075, 0x000027DA,
		0x076, 0x00006997,
		0x077, 0x00070418,
		0x078, 0x000BB000,
		0x07D, 0x00007600,
		0x07F, 0x00000000,
		0x06A, 0x000F4C00,
		0x065, 0x00082030,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000004,
		0x03F, 0x00001EC1,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000004,
		0x03F, 0x00001EC1,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000004,
		0x03F, 0x00001EC1,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000004,
		0x03F, 0x00001EC1,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000005,
		0x03F, 0x00001ECF,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000005,
		0x03F, 0x00001ECF,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000005,
		0x03F, 0x00001ECF,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000005,
		0x03F, 0x00001ECF,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000006,
		0x03F, 0x00001F9D,
		0x0EE, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000006,
		0x03F, 0x00001F9D,
		0x0EE, 0x00000000,
	0x90000400,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000006,
		0x03F, 0x00001F9D,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000006,
		0x03F, 0x00001F9D,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8821c_radioa(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8821c_radioa) / sizeof(u32);
	u32	*array = array_mp_8821c_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT, "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(dm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8821c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_radioa(void)
{
		return 49;
}

/******************************************************************************
*                           txpowertrack.TXT
******************************************************************************/

u8 delta_swingidx_mp_5gb_n_txpwrtrk_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 2, 3, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5gb_p_txpwrtrk_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5ga_n_txpwrtrk_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 2, 3, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5ga_p_txpwrtrk_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_2gb_n_txpwrtrk_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 delta_swingidx_mp_2gb_p_txpwrtrk_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 delta_swingidx_mp_2ga_n_txpwrtrk_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 delta_swingidx_mp_2ga_p_txpwrtrk_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};

void
odm_read_and_config_mp_8821c_txpowertrack(struct dm_struct *dm)
{
	struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8821c\n");


	odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p, delta_swingidx_mp_2ga_p_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n, delta_swingidx_mp_2ga_n_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p, delta_swingidx_mp_2gb_p_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n, delta_swingidx_mp_2gb_n_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p, delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n, delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p, delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n, delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p, delta_swingidx_mp_5ga_p_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n, delta_swingidx_mp_5ga_n_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p, delta_swingidx_mp_5gb_p_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n, delta_swingidx_mp_5gb_n_txpwrtrk_8821c, DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type0x20.TXT
******************************************************************************/

u8 delta_swingidx_mp_5gb_n_txpwrtrk_type0x20_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 2, 3, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5gb_p_txpwrtrk_type0x20_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5ga_n_txpwrtrk_type0x20_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5ga_p_txpwrtrk_type0x20_8821c[][DELTA_SWINGIDX_SIZE] = {
	{1, 1, 2, 2, 2, 3, 3, 4, 5, 5, 5, 6, 6, 7, 8, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 2, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_2gb_n_txpwrtrk_type0x20_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 delta_swingidx_mp_2gb_p_txpwrtrk_type0x20_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 delta_swingidx_mp_2ga_n_txpwrtrk_type0x20_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 delta_swingidx_mp_2ga_p_txpwrtrk_type0x20_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0x20_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0x20_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0x20_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0x20_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};

void
odm_read_and_config_mp_8821c_txpowertrack_type0x20(struct dm_struct *dm)
{
	struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8821c\n");


	odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p, delta_swingidx_mp_2ga_p_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n, delta_swingidx_mp_2ga_n_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p, delta_swingidx_mp_2gb_p_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n, delta_swingidx_mp_2gb_n_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p, delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n, delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p, delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n, delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p, delta_swingidx_mp_5ga_p_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n, delta_swingidx_mp_5ga_n_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p, delta_swingidx_mp_5gb_p_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n, delta_swingidx_mp_5gb_n_txpwrtrk_type0x20_8821c, DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpowertrack_type0x28.TXT
******************************************************************************/

u8 delta_swingidx_mp_5gb_n_txpwrtrk_type0x28_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 2, 3, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5gb_p_txpwrtrk_type0x28_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 delta_swingidx_mp_5ga_n_txpwrtrk_type0x28_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 3, 3, 4, 5, 5, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 12, 14, 15, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 3, 4, 4, 5, 7, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 3, 4, 6, 6, 6, 6, 7, 8, 9, 10, 11, 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18, 18, 18, 18},
};
u8 delta_swingidx_mp_5ga_p_txpwrtrk_type0x28_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 3, 4, 5, 7, 7, 8, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17},
	{0, 1, 2, 3, 3, 4, 4, 5, 6, 7, 8, 9, 10, 10, 11, 13, 13, 14, 15, 15, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17},
	{0, 1, 2, 2, 3, 4, 4, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 14, 14, 14, 15, 16, 16, 16, 16, 16, 16},
};
u8 delta_swingidx_mp_2gb_n_txpwrtrk_type0x28_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 delta_swingidx_mp_2gb_p_txpwrtrk_type0x28_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 delta_swingidx_mp_2ga_n_txpwrtrk_type0x28_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 delta_swingidx_mp_2ga_p_txpwrtrk_type0x28_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0x28_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0x28_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0x28_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0x28_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};

void
odm_read_and_config_mp_8821c_txpowertrack_type0x28(struct dm_struct *dm)
{
	struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8821c\n");


	odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p, delta_swingidx_mp_2ga_p_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n, delta_swingidx_mp_2ga_n_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p, delta_swingidx_mp_2gb_p_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n, delta_swingidx_mp_2gb_n_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p, delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n, delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p, delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n, delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p, delta_swingidx_mp_5ga_p_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n, delta_swingidx_mp_5ga_n_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p, delta_swingidx_mp_5gb_p_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE * 3);
	odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n, delta_swingidx_mp_5gb_n_txpwrtrk_type0x28_8821c, DELTA_SWINGIDX_SIZE * 3);
}

/******************************************************************************
*                           txpwr_lmt.TXT
******************************************************************************/

const char *array_mp_8821c_txpwr_lmt[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "30",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "01", "30",
	"KCC", "2.4G", "20M", "CCK", "1T", "01", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "02", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "03", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "04", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "05", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "06", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "07", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "08", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "09", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "10", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "11", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "24",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "12", "24",
	"KCC", "2.4G", "20M", "CCK", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "12", "24",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "16",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "13", "16",
	"KCC", "2.4G", "20M", "CCK", "1T", "13", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "13", "16",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"KCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "CCK", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "CCK", "1T", "14", "63",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"KCC", "2.4G", "20M", "OFDM", "1T", "01", "32",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"KCC", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"KCC", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"KCC", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"KCC", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "16",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "13", "16",
	"KCC", "2.4G", "20M", "OFDM", "1T", "13", "32",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "13", "16",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"IC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"KCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"IC", "2.4G", "20M", "HT", "1T", "01", "26",
	"KCC", "2.4G", "20M", "HT", "1T", "01", "32",
	"ACMA", "2.4G", "20M", "HT", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "01", "26",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"IC", "2.4G", "20M", "HT", "1T", "02", "30",
	"KCC", "2.4G", "20M", "HT", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"IC", "2.4G", "20M", "HT", "1T", "03", "32",
	"KCC", "2.4G", "20M", "HT", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "03", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"IC", "2.4G", "20M", "HT", "1T", "04", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"IC", "2.4G", "20M", "HT", "1T", "05", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"IC", "2.4G", "20M", "HT", "1T", "06", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"IC", "2.4G", "20M", "HT", "1T", "07", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"IC", "2.4G", "20M", "HT", "1T", "08", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"IC", "2.4G", "20M", "HT", "1T", "09", "32",
	"KCC", "2.4G", "20M", "HT", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "09", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"IC", "2.4G", "20M", "HT", "1T", "10", "30",
	"KCC", "2.4G", "20M", "HT", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"IC", "2.4G", "20M", "HT", "1T", "11", "28",
	"KCC", "2.4G", "20M", "HT", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "11", "28",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"IC", "2.4G", "20M", "HT", "1T", "12", "26",
	"KCC", "2.4G", "20M", "HT", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "12", "26",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "12",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"IC", "2.4G", "20M", "HT", "1T", "13", "12",
	"KCC", "2.4G", "20M", "HT", "1T", "13", "32",
	"ACMA", "2.4G", "20M", "HT", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "13", "12",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"IC", "2.4G", "20M", "HT", "1T", "14", "63",
	"KCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "HT", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"IC", "2.4G", "40M", "HT", "1T", "01", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "01", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"IC", "2.4G", "40M", "HT", "1T", "02", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "02", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "30",
	"IC", "2.4G", "40M", "HT", "1T", "03", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "03", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "03", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "03", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "30",
	"IC", "2.4G", "40M", "HT", "1T", "04", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "04", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "04", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "04", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "30",
	"IC", "2.4G", "40M", "HT", "1T", "05", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "05", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "30",
	"IC", "2.4G", "40M", "HT", "1T", "06", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "06", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "06", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "30",
	"IC", "2.4G", "40M", "HT", "1T", "07", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "07", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "30",
	"IC", "2.4G", "40M", "HT", "1T", "08", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "08", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "08", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "08", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "30",
	"IC", "2.4G", "40M", "HT", "1T", "09", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "09", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "09", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "09", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "28",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "30",
	"IC", "2.4G", "40M", "HT", "1T", "10", "28",
	"KCC", "2.4G", "40M", "HT", "1T", "10", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "10", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "10", "28",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "30",
	"IC", "2.4G", "40M", "HT", "1T", "11", "20",
	"KCC", "2.4G", "40M", "HT", "1T", "11", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "11", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "11", "20",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"IC", "2.4G", "40M", "HT", "1T", "12", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "12", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"IC", "2.4G", "40M", "HT", "1T", "13", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "13", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"IC", "2.4G", "40M", "HT", "1T", "14", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "14", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "31",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "33",
	"IC", "5G", "20M", "OFDM", "1T", "36", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "36", "29",
	"ACMA", "5G", "20M", "OFDM", "1T", "36", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "36", "29",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "33",
	"IC", "5G", "20M", "OFDM", "1T", "40", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "40", "28",
	"ACMA", "5G", "20M", "OFDM", "1T", "40", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "40", "29",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "33",
	"IC", "5G", "20M", "OFDM", "1T", "44", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "44", "28",
	"ACMA", "5G", "20M", "OFDM", "1T", "44", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "31",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "33",
	"IC", "5G", "20M", "OFDM", "1T", "48", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "48", "27",
	"ACMA", "5G", "20M", "OFDM", "1T", "48", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "33",
	"IC", "5G", "20M", "OFDM", "1T", "52", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "52", "16",
	"ACMA", "5G", "20M", "OFDM", "1T", "52", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "52", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "33",
	"IC", "5G", "20M", "OFDM", "1T", "56", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "56", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "56", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "56", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "33",
	"IC", "5G", "20M", "OFDM", "1T", "60", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "60", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "60", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "60", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "33",
	"IC", "5G", "20M", "OFDM", "1T", "64", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "64", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "64", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "64", "29",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "33",
	"IC", "5G", "20M", "OFDM", "1T", "100", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "100", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "100", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "100", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "33",
	"IC", "5G", "20M", "OFDM", "1T", "104", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "104", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "104", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "104", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "33",
	"IC", "5G", "20M", "OFDM", "1T", "108", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "108", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "108", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "108", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "33",
	"IC", "5G", "20M", "OFDM", "1T", "112", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "112", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "112", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "112", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "33",
	"IC", "5G", "20M", "OFDM", "1T", "116", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "116", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "116", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "116", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "33",
	"IC", "5G", "20M", "OFDM", "1T", "120", "63",
	"KCC", "5G", "20M", "OFDM", "1T", "120", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "120", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "120", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "33",
	"IC", "5G", "20M", "OFDM", "1T", "124", "63",
	"KCC", "5G", "20M", "OFDM", "1T", "124", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "124", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "124", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "33",
	"IC", "5G", "20M", "OFDM", "1T", "128", "63",
	"KCC", "5G", "20M", "OFDM", "1T", "128", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "128", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "128", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "33",
	"IC", "5G", "20M", "OFDM", "1T", "132", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "132", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "132", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "132", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "33",
	"IC", "5G", "20M", "OFDM", "1T", "136", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "136", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "136", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "136", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "31",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "33",
	"IC", "5G", "20M", "OFDM", "1T", "140", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "140", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "140", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "140", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"IC", "5G", "20M", "OFDM", "1T", "144", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "144", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "144", "63",
	"CHILE", "5G", "20M", "OFDM", "1T", "144", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"IC", "5G", "20M", "OFDM", "1T", "149", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "149", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "149", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "149", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"IC", "5G", "20M", "OFDM", "1T", "153", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "153", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "153", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "153", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"IC", "5G", "20M", "OFDM", "1T", "157", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "157", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "157", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "157", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"IC", "5G", "20M", "OFDM", "1T", "161", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "161", "31",
	"ACMA", "5G", "20M", "OFDM", "1T", "161", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "161", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"IC", "5G", "20M", "OFDM", "1T", "165", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "165", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "165", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "165", "30",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "33",
	"IC", "5G", "20M", "HT", "1T", "36", "30",
	"KCC", "5G", "20M", "HT", "1T", "36", "27",
	"ACMA", "5G", "20M", "HT", "1T", "36", "32",
	"CHILE", "5G", "20M", "HT", "1T", "36", "30",
	"FCC", "5G", "20M", "HT", "1T", "40", "33",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "33",
	"IC", "5G", "20M", "HT", "1T", "40", "31",
	"KCC", "5G", "20M", "HT", "1T", "40", "29",
	"ACMA", "5G", "20M", "HT", "1T", "40", "32",
	"CHILE", "5G", "20M", "HT", "1T", "40", "30",
	"FCC", "5G", "20M", "HT", "1T", "44", "33",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "33",
	"IC", "5G", "20M", "HT", "1T", "44", "31",
	"KCC", "5G", "20M", "HT", "1T", "44", "29",
	"ACMA", "5G", "20M", "HT", "1T", "44", "32",
	"CHILE", "5G", "20M", "HT", "1T", "44", "30",
	"FCC", "5G", "20M", "HT", "1T", "48", "33",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "33",
	"IC", "5G", "20M", "HT", "1T", "48", "31",
	"KCC", "5G", "20M", "HT", "1T", "48", "26",
	"ACMA", "5G", "20M", "HT", "1T", "48", "32",
	"CHILE", "5G", "20M", "HT", "1T", "48", "30",
	"FCC", "5G", "20M", "HT", "1T", "52", "33",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "33",
	"IC", "5G", "20M", "HT", "1T", "52", "32",
	"KCC", "5G", "20M", "HT", "1T", "52", "7",
	"ACMA", "5G", "20M", "HT", "1T", "52", "32",
	"CHILE", "5G", "20M", "HT", "1T", "52", "30",
	"FCC", "5G", "20M", "HT", "1T", "56", "33",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "33",
	"IC", "5G", "20M", "HT", "1T", "56", "32",
	"KCC", "5G", "20M", "HT", "1T", "56", "33",
	"ACMA", "5G", "20M", "HT", "1T", "56", "32",
	"CHILE", "5G", "20M", "HT", "1T", "56", "30",
	"FCC", "5G", "20M", "HT", "1T", "60", "33",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "33",
	"IC", "5G", "20M", "HT", "1T", "60", "32",
	"KCC", "5G", "20M", "HT", "1T", "60", "33",
	"ACMA", "5G", "20M", "HT", "1T", "60", "32",
	"CHILE", "5G", "20M", "HT", "1T", "60", "30",
	"FCC", "5G", "20M", "HT", "1T", "64", "30",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "33",
	"IC", "5G", "20M", "HT", "1T", "64", "30",
	"KCC", "5G", "20M", "HT", "1T", "64", "33",
	"ACMA", "5G", "20M", "HT", "1T", "64", "32",
	"CHILE", "5G", "20M", "HT", "1T", "64", "30",
	"FCC", "5G", "20M", "HT", "1T", "100", "30",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "33",
	"IC", "5G", "20M", "HT", "1T", "100", "30",
	"KCC", "5G", "20M", "HT", "1T", "100", "33",
	"ACMA", "5G", "20M", "HT", "1T", "100", "32",
	"CHILE", "5G", "20M", "HT", "1T", "100", "30",
	"FCC", "5G", "20M", "HT", "1T", "104", "33",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "33",
	"IC", "5G", "20M", "HT", "1T", "104", "33",
	"KCC", "5G", "20M", "HT", "1T", "104", "33",
	"ACMA", "5G", "20M", "HT", "1T", "104", "32",
	"CHILE", "5G", "20M", "HT", "1T", "104", "30",
	"FCC", "5G", "20M", "HT", "1T", "108", "33",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "33",
	"IC", "5G", "20M", "HT", "1T", "108", "33",
	"KCC", "5G", "20M", "HT", "1T", "108", "33",
	"ACMA", "5G", "20M", "HT", "1T", "108", "32",
	"CHILE", "5G", "20M", "HT", "1T", "108", "30",
	"FCC", "5G", "20M", "HT", "1T", "112", "33",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "33",
	"IC", "5G", "20M", "HT", "1T", "112", "33",
	"KCC", "5G", "20M", "HT", "1T", "112", "33",
	"ACMA", "5G", "20M", "HT", "1T", "112", "32",
	"CHILE", "5G", "20M", "HT", "1T", "112", "30",
	"FCC", "5G", "20M", "HT", "1T", "116", "33",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "33",
	"IC", "5G", "20M", "HT", "1T", "116", "33",
	"KCC", "5G", "20M", "HT", "1T", "116", "33",
	"ACMA", "5G", "20M", "HT", "1T", "116", "32",
	"CHILE", "5G", "20M", "HT", "1T", "116", "30",
	"FCC", "5G", "20M", "HT", "1T", "120", "33",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "33",
	"IC", "5G", "20M", "HT", "1T", "120", "63",
	"KCC", "5G", "20M", "HT", "1T", "120", "33",
	"ACMA", "5G", "20M", "HT", "1T", "120", "32",
	"CHILE", "5G", "20M", "HT", "1T", "120", "30",
	"FCC", "5G", "20M", "HT", "1T", "124", "33",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "33",
	"IC", "5G", "20M", "HT", "1T", "124", "63",
	"KCC", "5G", "20M", "HT", "1T", "124", "33",
	"ACMA", "5G", "20M", "HT", "1T", "124", "32",
	"CHILE", "5G", "20M", "HT", "1T", "124", "30",
	"FCC", "5G", "20M", "HT", "1T", "128", "33",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "33",
	"IC", "5G", "20M", "HT", "1T", "128", "63",
	"KCC", "5G", "20M", "HT", "1T", "128", "63",
	"ACMA", "5G", "20M", "HT", "1T", "128", "32",
	"CHILE", "5G", "20M", "HT", "1T", "128", "30",
	"FCC", "5G", "20M", "HT", "1T", "132", "33",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "33",
	"IC", "5G", "20M", "HT", "1T", "132", "33",
	"KCC", "5G", "20M", "HT", "1T", "132", "63",
	"ACMA", "5G", "20M", "HT", "1T", "132", "32",
	"CHILE", "5G", "20M", "HT", "1T", "132", "30",
	"FCC", "5G", "20M", "HT", "1T", "136", "33",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "33",
	"IC", "5G", "20M", "HT", "1T", "136", "33",
	"KCC", "5G", "20M", "HT", "1T", "136", "63",
	"ACMA", "5G", "20M", "HT", "1T", "136", "32",
	"CHILE", "5G", "20M", "HT", "1T", "136", "30",
	"FCC", "5G", "20M", "HT", "1T", "140", "29",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "33",
	"IC", "5G", "20M", "HT", "1T", "140", "29",
	"KCC", "5G", "20M", "HT", "1T", "140", "63",
	"ACMA", "5G", "20M", "HT", "1T", "140", "32",
	"CHILE", "5G", "20M", "HT", "1T", "140", "30",
	"FCC", "5G", "20M", "HT", "1T", "144", "27",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"IC", "5G", "20M", "HT", "1T", "144", "27",
	"KCC", "5G", "20M", "HT", "1T", "144", "63",
	"ACMA", "5G", "20M", "HT", "1T", "144", "63",
	"CHILE", "5G", "20M", "HT", "1T", "144", "30",
	"FCC", "5G", "20M", "HT", "1T", "149", "33",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"IC", "5G", "20M", "HT", "1T", "149", "33",
	"KCC", "5G", "20M", "HT", "1T", "149", "33",
	"ACMA", "5G", "20M", "HT", "1T", "149", "33",
	"CHILE", "5G", "20M", "HT", "1T", "149", "30",
	"FCC", "5G", "20M", "HT", "1T", "153", "33",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"IC", "5G", "20M", "HT", "1T", "153", "33",
	"KCC", "5G", "20M", "HT", "1T", "153", "33",
	"ACMA", "5G", "20M", "HT", "1T", "153", "33",
	"CHILE", "5G", "20M", "HT", "1T", "153", "30",
	"FCC", "5G", "20M", "HT", "1T", "157", "33",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"IC", "5G", "20M", "HT", "1T", "157", "33",
	"KCC", "5G", "20M", "HT", "1T", "157", "33",
	"ACMA", "5G", "20M", "HT", "1T", "157", "33",
	"CHILE", "5G", "20M", "HT", "1T", "157", "30",
	"FCC", "5G", "20M", "HT", "1T", "161", "33",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"IC", "5G", "20M", "HT", "1T", "161", "33",
	"KCC", "5G", "20M", "HT", "1T", "161", "31",
	"ACMA", "5G", "20M", "HT", "1T", "161", "33",
	"CHILE", "5G", "20M", "HT", "1T", "161", "30",
	"FCC", "5G", "20M", "HT", "1T", "165", "33",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"IC", "5G", "20M", "HT", "1T", "165", "33",
	"KCC", "5G", "20M", "HT", "1T", "165", "63",
	"ACMA", "5G", "20M", "HT", "1T", "165", "33",
	"CHILE", "5G", "20M", "HT", "1T", "165", "30",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "32",
	"MKK", "5G", "40M", "HT", "1T", "38", "32",
	"IC", "5G", "40M", "HT", "1T", "38", "22",
	"KCC", "5G", "40M", "HT", "1T", "38", "26",
	"ACMA", "5G", "40M", "HT", "1T", "38", "32",
	"CHILE", "5G", "40M", "HT", "1T", "38", "22",
	"FCC", "5G", "40M", "HT", "1T", "46", "32",
	"ETSI", "5G", "40M", "HT", "1T", "46", "32",
	"MKK", "5G", "40M", "HT", "1T", "46", "32",
	"IC", "5G", "40M", "HT", "1T", "46", "32",
	"KCC", "5G", "40M", "HT", "1T", "46", "28",
	"ACMA", "5G", "40M", "HT", "1T", "46", "32",
	"CHILE", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "32",
	"ETSI", "5G", "40M", "HT", "1T", "54", "32",
	"MKK", "5G", "40M", "HT", "1T", "54", "32",
	"IC", "5G", "40M", "HT", "1T", "54", "32",
	"KCC", "5G", "40M", "HT", "1T", "54", "22",
	"ACMA", "5G", "40M", "HT", "1T", "54", "32",
	"CHILE", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "23",
	"ETSI", "5G", "40M", "HT", "1T", "62", "32",
	"MKK", "5G", "40M", "HT", "1T", "62", "32",
	"IC", "5G", "40M", "HT", "1T", "62", "23",
	"KCC", "5G", "40M", "HT", "1T", "62", "31",
	"ACMA", "5G", "40M", "HT", "1T", "62", "32",
	"CHILE", "5G", "40M", "HT", "1T", "62", "23",
	"FCC", "5G", "40M", "HT", "1T", "102", "21",
	"ETSI", "5G", "40M", "HT", "1T", "102", "32",
	"MKK", "5G", "40M", "HT", "1T", "102", "32",
	"IC", "5G", "40M", "HT", "1T", "102", "21",
	"KCC", "5G", "40M", "HT", "1T", "102", "31",
	"ACMA", "5G", "40M", "HT", "1T", "102", "32",
	"CHILE", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "32",
	"ETSI", "5G", "40M", "HT", "1T", "110", "32",
	"MKK", "5G", "40M", "HT", "1T", "110", "32",
	"IC", "5G", "40M", "HT", "1T", "110", "32",
	"KCC", "5G", "40M", "HT", "1T", "110", "32",
	"ACMA", "5G", "40M", "HT", "1T", "110", "32",
	"CHILE", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "32",
	"ETSI", "5G", "40M", "HT", "1T", "118", "32",
	"MKK", "5G", "40M", "HT", "1T", "118", "32",
	"IC", "5G", "40M", "HT", "1T", "118", "63",
	"KCC", "5G", "40M", "HT", "1T", "118", "32",
	"ACMA", "5G", "40M", "HT", "1T", "118", "32",
	"CHILE", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "32",
	"ETSI", "5G", "40M", "HT", "1T", "126", "32",
	"MKK", "5G", "40M", "HT", "1T", "126", "32",
	"IC", "5G", "40M", "HT", "1T", "126", "63",
	"KCC", "5G", "40M", "HT", "1T", "126", "63",
	"ACMA", "5G", "40M", "HT", "1T", "126", "32",
	"CHILE", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "32",
	"ETSI", "5G", "40M", "HT", "1T", "134", "32",
	"MKK", "5G", "40M", "HT", "1T", "134", "32",
	"IC", "5G", "40M", "HT", "1T", "134", "32",
	"KCC", "5G", "40M", "HT", "1T", "134", "63",
	"ACMA", "5G", "40M", "HT", "1T", "134", "32",
	"CHILE", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "29",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"IC", "5G", "40M", "HT", "1T", "142", "29",
	"KCC", "5G", "40M", "HT", "1T", "142", "63",
	"ACMA", "5G", "40M", "HT", "1T", "142", "63",
	"CHILE", "5G", "40M", "HT", "1T", "142", "30",
	"FCC", "5G", "40M", "HT", "1T", "151", "32",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"IC", "5G", "40M", "HT", "1T", "151", "32",
	"KCC", "5G", "40M", "HT", "1T", "151", "27",
	"ACMA", "5G", "40M", "HT", "1T", "151", "32",
	"CHILE", "5G", "40M", "HT", "1T", "151", "30",
	"FCC", "5G", "40M", "HT", "1T", "159", "32",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"IC", "5G", "40M", "HT", "1T", "159", "32",
	"KCC", "5G", "40M", "HT", "1T", "159", "26",
	"ACMA", "5G", "40M", "HT", "1T", "159", "32",
	"CHILE", "5G", "40M", "HT", "1T", "159", "30",
	"FCC", "5G", "80M", "VHT", "1T", "42", "19",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "32",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"IC", "5G", "80M", "VHT", "1T", "42", "19",
	"KCC", "5G", "80M", "VHT", "1T", "42", "25",
	"ACMA", "5G", "80M", "VHT", "1T", "42", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "42", "19",
	"FCC", "5G", "80M", "VHT", "1T", "58", "22",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "32",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"IC", "5G", "80M", "VHT", "1T", "58", "22",
	"KCC", "5G", "80M", "VHT", "1T", "58", "28",
	"ACMA", "5G", "80M", "VHT", "1T", "58", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "58", "22",
	"FCC", "5G", "80M", "VHT", "1T", "106", "18",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "32",
	"MKK", "5G", "80M", "VHT", "1T", "106", "32",
	"IC", "5G", "80M", "VHT", "1T", "106", "18",
	"KCC", "5G", "80M", "VHT", "1T", "106", "30",
	"ACMA", "5G", "80M", "VHT", "1T", "106", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "32",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "32",
	"MKK", "5G", "80M", "VHT", "1T", "122", "32",
	"IC", "5G", "80M", "VHT", "1T", "122", "63",
	"KCC", "5G", "80M", "VHT", "1T", "122", "26",
	"ACMA", "5G", "80M", "VHT", "1T", "122", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "28",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"IC", "5G", "80M", "VHT", "1T", "138", "28",
	"KCC", "5G", "80M", "VHT", "1T", "138", "63",
	"ACMA", "5G", "80M", "VHT", "1T", "138", "63",
	"CHILE", "5G", "80M", "VHT", "1T", "138", "30",
	"FCC", "5G", "80M", "VHT", "1T", "155", "32",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"IC", "5G", "80M", "VHT", "1T", "155", "32",
	"KCC", "5G", "80M", "VHT", "1T", "155", "27",
	"ACMA", "5G", "80M", "VHT", "1T", "155", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "155", "30"
};

void
odm_read_and_config_mp_8821c_txpwr_lmt(struct dm_struct *dm)
{
	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8821c_txpwr_lmt) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8821c_txpwr_lmt;
#else
	u32	array_len = sizeof(array_mp_8821c_txpwr_lmt) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8821c_txpwr_lmt;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	PlatformZeroMemory(hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT * MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8821c(dm, regulation, band, bandwidth, rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

/******************************************************************************
*                           txpwr_lmt_fccsar.TXT
******************************************************************************/

const char *array_mp_8821c_txpwr_lmt_fccsar[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "30",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "01", "30",
	"KCC", "2.4G", "20M", "CCK", "1T", "01", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "02", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "03", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "04", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "05", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "06", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "07", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "08", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "09", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "10", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"KCC", "2.4G", "20M", "CCK", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "11", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "24",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "12", "24",
	"KCC", "2.4G", "20M", "CCK", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "12", "24",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "16",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "13", "16",
	"KCC", "2.4G", "20M", "CCK", "1T", "13", "34",
	"ACMA", "2.4G", "20M", "CCK", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "CCK", "1T", "13", "16",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "34",
	"IC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"KCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "CCK", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "CCK", "1T", "14", "63",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"KCC", "2.4G", "20M", "OFDM", "1T", "01", "32",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"KCC", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"KCC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"KCC", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"KCC", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"KCC", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "16",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"IC", "2.4G", "20M", "OFDM", "1T", "13", "16",
	"KCC", "2.4G", "20M", "OFDM", "1T", "13", "32",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "13", "16",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"IC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"KCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"IC", "2.4G", "20M", "HT", "1T", "01", "26",
	"KCC", "2.4G", "20M", "HT", "1T", "01", "32",
	"ACMA", "2.4G", "20M", "HT", "1T", "01", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "01", "26",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"IC", "2.4G", "20M", "HT", "1T", "02", "30",
	"KCC", "2.4G", "20M", "HT", "1T", "02", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "02", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"IC", "2.4G", "20M", "HT", "1T", "03", "32",
	"KCC", "2.4G", "20M", "HT", "1T", "03", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "03", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "03", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"IC", "2.4G", "20M", "HT", "1T", "04", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "04", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"IC", "2.4G", "20M", "HT", "1T", "05", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "05", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"IC", "2.4G", "20M", "HT", "1T", "06", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "06", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"IC", "2.4G", "20M", "HT", "1T", "07", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "07", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"IC", "2.4G", "20M", "HT", "1T", "08", "34",
	"KCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "08", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"IC", "2.4G", "20M", "HT", "1T", "09", "32",
	"KCC", "2.4G", "20M", "HT", "1T", "09", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "09", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "09", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"IC", "2.4G", "20M", "HT", "1T", "10", "30",
	"KCC", "2.4G", "20M", "HT", "1T", "10", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "10", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"IC", "2.4G", "20M", "HT", "1T", "11", "28",
	"KCC", "2.4G", "20M", "HT", "1T", "11", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "11", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "11", "28",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"IC", "2.4G", "20M", "HT", "1T", "12", "26",
	"KCC", "2.4G", "20M", "HT", "1T", "12", "34",
	"ACMA", "2.4G", "20M", "HT", "1T", "12", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "12", "26",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "12",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"IC", "2.4G", "20M", "HT", "1T", "13", "12",
	"KCC", "2.4G", "20M", "HT", "1T", "13", "32",
	"ACMA", "2.4G", "20M", "HT", "1T", "13", "30",
	"CHILE", "2.4G", "20M", "HT", "1T", "13", "12",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"IC", "2.4G", "20M", "HT", "1T", "14", "63",
	"KCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ACMA", "2.4G", "20M", "HT", "1T", "14", "63",
	"CHILE", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"IC", "2.4G", "40M", "HT", "1T", "01", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "01", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"IC", "2.4G", "40M", "HT", "1T", "02", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "02", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "30",
	"IC", "2.4G", "40M", "HT", "1T", "03", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "03", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "03", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "03", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "30",
	"IC", "2.4G", "40M", "HT", "1T", "04", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "04", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "04", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "04", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "30",
	"IC", "2.4G", "40M", "HT", "1T", "05", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "05", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "30",
	"IC", "2.4G", "40M", "HT", "1T", "06", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "06", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "06", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "30",
	"IC", "2.4G", "40M", "HT", "1T", "07", "30",
	"KCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "07", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "30",
	"IC", "2.4G", "40M", "HT", "1T", "08", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "08", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "08", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "08", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "30",
	"IC", "2.4G", "40M", "HT", "1T", "09", "26",
	"KCC", "2.4G", "40M", "HT", "1T", "09", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "09", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "09", "26",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "28",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "30",
	"IC", "2.4G", "40M", "HT", "1T", "10", "28",
	"KCC", "2.4G", "40M", "HT", "1T", "10", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "10", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "10", "28",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "30",
	"IC", "2.4G", "40M", "HT", "1T", "11", "20",
	"KCC", "2.4G", "40M", "HT", "1T", "11", "30",
	"ACMA", "2.4G", "40M", "HT", "1T", "11", "30",
	"CHILE", "2.4G", "40M", "HT", "1T", "11", "20",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"IC", "2.4G", "40M", "HT", "1T", "12", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "12", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"IC", "2.4G", "40M", "HT", "1T", "13", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "13", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"IC", "2.4G", "40M", "HT", "1T", "14", "63",
	"KCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ACMA", "2.4G", "40M", "HT", "1T", "14", "63",
	"CHILE", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "33",
	"IC", "5G", "20M", "OFDM", "1T", "36", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "36", "29",
	"ACMA", "5G", "20M", "OFDM", "1T", "36", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "36", "29",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "33",
	"IC", "5G", "20M", "OFDM", "1T", "40", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "40", "28",
	"ACMA", "5G", "20M", "OFDM", "1T", "40", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "40", "29",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "33",
	"IC", "5G", "20M", "OFDM", "1T", "44", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "44", "28",
	"ACMA", "5G", "20M", "OFDM", "1T", "44", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "44", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "33",
	"IC", "5G", "20M", "OFDM", "1T", "48", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "48", "27",
	"ACMA", "5G", "20M", "OFDM", "1T", "48", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "48", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "33",
	"IC", "5G", "20M", "OFDM", "1T", "52", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "52", "16",
	"ACMA", "5G", "20M", "OFDM", "1T", "52", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "52", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "33",
	"IC", "5G", "20M", "OFDM", "1T", "56", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "56", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "56", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "56", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "33",
	"IC", "5G", "20M", "OFDM", "1T", "60", "32",
	"KCC", "5G", "20M", "OFDM", "1T", "60", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "60", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "60", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "33",
	"IC", "5G", "20M", "OFDM", "1T", "64", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "64", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "64", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "64", "29",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "33",
	"IC", "5G", "20M", "OFDM", "1T", "100", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "100", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "100", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "100", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "33",
	"IC", "5G", "20M", "OFDM", "1T", "104", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "104", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "104", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "104", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "33",
	"IC", "5G", "20M", "OFDM", "1T", "108", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "108", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "108", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "108", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "33",
	"IC", "5G", "20M", "OFDM", "1T", "112", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "112", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "112", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "112", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "33",
	"IC", "5G", "20M", "OFDM", "1T", "116", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "116", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "116", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "116", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "33",
	"IC", "5G", "20M", "OFDM", "1T", "120", "63",
	"KCC", "5G", "20M", "OFDM", "1T", "120", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "120", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "120", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "33",
	"IC", "5G", "20M", "OFDM", "1T", "124", "63",
	"KCC", "5G", "20M", "OFDM", "1T", "124", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "124", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "124", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "33",
	"IC", "5G", "20M", "OFDM", "1T", "128", "63",
	"KCC", "5G", "20M", "OFDM", "1T", "128", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "128", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "128", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "33",
	"IC", "5G", "20M", "OFDM", "1T", "132", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "132", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "132", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "132", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "33",
	"IC", "5G", "20M", "OFDM", "1T", "136", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "136", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "136", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "136", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "33",
	"IC", "5G", "20M", "OFDM", "1T", "140", "31",
	"KCC", "5G", "20M", "OFDM", "1T", "140", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "140", "32",
	"CHILE", "5G", "20M", "OFDM", "1T", "140", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "27",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"IC", "5G", "20M", "OFDM", "1T", "144", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "144", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "144", "63",
	"CHILE", "5G", "20M", "OFDM", "1T", "144", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"IC", "5G", "20M", "OFDM", "1T", "149", "30",
	"KCC", "5G", "20M", "OFDM", "1T", "149", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "149", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "149", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"IC", "5G", "20M", "OFDM", "1T", "153", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "153", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "153", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "153", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"IC", "5G", "20M", "OFDM", "1T", "157", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "157", "33",
	"ACMA", "5G", "20M", "OFDM", "1T", "157", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "157", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"IC", "5G", "20M", "OFDM", "1T", "161", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "161", "31",
	"ACMA", "5G", "20M", "OFDM", "1T", "161", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "161", "30",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "28",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"IC", "5G", "20M", "OFDM", "1T", "165", "33",
	"KCC", "5G", "20M", "OFDM", "1T", "165", "63",
	"ACMA", "5G", "20M", "OFDM", "1T", "165", "33",
	"CHILE", "5G", "20M", "OFDM", "1T", "165", "30",
	"FCC", "5G", "20M", "HT", "1T", "36", "27",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "33",
	"IC", "5G", "20M", "HT", "1T", "36", "30",
	"KCC", "5G", "20M", "HT", "1T", "36", "27",
	"ACMA", "5G", "20M", "HT", "1T", "36", "32",
	"CHILE", "5G", "20M", "HT", "1T", "36", "30",
	"FCC", "5G", "20M", "HT", "1T", "40", "27",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "33",
	"IC", "5G", "20M", "HT", "1T", "40", "31",
	"KCC", "5G", "20M", "HT", "1T", "40", "29",
	"ACMA", "5G", "20M", "HT", "1T", "40", "32",
	"CHILE", "5G", "20M", "HT", "1T", "40", "30",
	"FCC", "5G", "20M", "HT", "1T", "44", "27",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "33",
	"IC", "5G", "20M", "HT", "1T", "44", "31",
	"KCC", "5G", "20M", "HT", "1T", "44", "29",
	"ACMA", "5G", "20M", "HT", "1T", "44", "32",
	"CHILE", "5G", "20M", "HT", "1T", "44", "30",
	"FCC", "5G", "20M", "HT", "1T", "48", "27",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "33",
	"IC", "5G", "20M", "HT", "1T", "48", "31",
	"KCC", "5G", "20M", "HT", "1T", "48", "26",
	"ACMA", "5G", "20M", "HT", "1T", "48", "32",
	"CHILE", "5G", "20M", "HT", "1T", "48", "30",
	"FCC", "5G", "20M", "HT", "1T", "52", "27",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "33",
	"IC", "5G", "20M", "HT", "1T", "52", "32",
	"KCC", "5G", "20M", "HT", "1T", "52", "7",
	"ACMA", "5G", "20M", "HT", "1T", "52", "32",
	"CHILE", "5G", "20M", "HT", "1T", "52", "30",
	"FCC", "5G", "20M", "HT", "1T", "56", "27",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "33",
	"IC", "5G", "20M", "HT", "1T", "56", "32",
	"KCC", "5G", "20M", "HT", "1T", "56", "33",
	"ACMA", "5G", "20M", "HT", "1T", "56", "32",
	"CHILE", "5G", "20M", "HT", "1T", "56", "30",
	"FCC", "5G", "20M", "HT", "1T", "60", "27",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "33",
	"IC", "5G", "20M", "HT", "1T", "60", "32",
	"KCC", "5G", "20M", "HT", "1T", "60", "33",
	"ACMA", "5G", "20M", "HT", "1T", "60", "32",
	"CHILE", "5G", "20M", "HT", "1T", "60", "30",
	"FCC", "5G", "20M", "HT", "1T", "64", "27",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "33",
	"IC", "5G", "20M", "HT", "1T", "64", "30",
	"KCC", "5G", "20M", "HT", "1T", "64", "33",
	"ACMA", "5G", "20M", "HT", "1T", "64", "32",
	"CHILE", "5G", "20M", "HT", "1T", "64", "30",
	"FCC", "5G", "20M", "HT", "1T", "100", "27",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "33",
	"IC", "5G", "20M", "HT", "1T", "100", "30",
	"KCC", "5G", "20M", "HT", "1T", "100", "33",
	"ACMA", "5G", "20M", "HT", "1T", "100", "32",
	"CHILE", "5G", "20M", "HT", "1T", "100", "30",
	"FCC", "5G", "20M", "HT", "1T", "104", "27",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "33",
	"IC", "5G", "20M", "HT", "1T", "104", "33",
	"KCC", "5G", "20M", "HT", "1T", "104", "33",
	"ACMA", "5G", "20M", "HT", "1T", "104", "32",
	"CHILE", "5G", "20M", "HT", "1T", "104", "30",
	"FCC", "5G", "20M", "HT", "1T", "108", "27",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "33",
	"IC", "5G", "20M", "HT", "1T", "108", "33",
	"KCC", "5G", "20M", "HT", "1T", "108", "33",
	"ACMA", "5G", "20M", "HT", "1T", "108", "32",
	"CHILE", "5G", "20M", "HT", "1T", "108", "30",
	"FCC", "5G", "20M", "HT", "1T", "112", "27",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "33",
	"IC", "5G", "20M", "HT", "1T", "112", "33",
	"KCC", "5G", "20M", "HT", "1T", "112", "33",
	"ACMA", "5G", "20M", "HT", "1T", "112", "32",
	"CHILE", "5G", "20M", "HT", "1T", "112", "30",
	"FCC", "5G", "20M", "HT", "1T", "116", "27",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "33",
	"IC", "5G", "20M", "HT", "1T", "116", "33",
	"KCC", "5G", "20M", "HT", "1T", "116", "33",
	"ACMA", "5G", "20M", "HT", "1T", "116", "32",
	"CHILE", "5G", "20M", "HT", "1T", "116", "30",
	"FCC", "5G", "20M", "HT", "1T", "120", "27",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "33",
	"IC", "5G", "20M", "HT", "1T", "120", "63",
	"KCC", "5G", "20M", "HT", "1T", "120", "33",
	"ACMA", "5G", "20M", "HT", "1T", "120", "32",
	"CHILE", "5G", "20M", "HT", "1T", "120", "30",
	"FCC", "5G", "20M", "HT", "1T", "124", "27",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "33",
	"IC", "5G", "20M", "HT", "1T", "124", "63",
	"KCC", "5G", "20M", "HT", "1T", "124", "33",
	"ACMA", "5G", "20M", "HT", "1T", "124", "32",
	"CHILE", "5G", "20M", "HT", "1T", "124", "30",
	"FCC", "5G", "20M", "HT", "1T", "128", "27",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "33",
	"IC", "5G", "20M", "HT", "1T", "128", "63",
	"KCC", "5G", "20M", "HT", "1T", "128", "63",
	"ACMA", "5G", "20M", "HT", "1T", "128", "32",
	"CHILE", "5G", "20M", "HT", "1T", "128", "30",
	"FCC", "5G", "20M", "HT", "1T", "132", "27",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "33",
	"IC", "5G", "20M", "HT", "1T", "132", "33",
	"KCC", "5G", "20M", "HT", "1T", "132", "63",
	"ACMA", "5G", "20M", "HT", "1T", "132", "32",
	"CHILE", "5G", "20M", "HT", "1T", "132", "30",
	"FCC", "5G", "20M", "HT", "1T", "136", "27",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "33",
	"IC", "5G", "20M", "HT", "1T", "136", "33",
	"KCC", "5G", "20M", "HT", "1T", "136", "63",
	"ACMA", "5G", "20M", "HT", "1T", "136", "32",
	"CHILE", "5G", "20M", "HT", "1T", "136", "30",
	"FCC", "5G", "20M", "HT", "1T", "140", "27",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "33",
	"IC", "5G", "20M", "HT", "1T", "140", "29",
	"KCC", "5G", "20M", "HT", "1T", "140", "63",
	"ACMA", "5G", "20M", "HT", "1T", "140", "32",
	"CHILE", "5G", "20M", "HT", "1T", "140", "30",
	"FCC", "5G", "20M", "HT", "1T", "144", "27",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"IC", "5G", "20M", "HT", "1T", "144", "27",
	"KCC", "5G", "20M", "HT", "1T", "144", "63",
	"ACMA", "5G", "20M", "HT", "1T", "144", "63",
	"CHILE", "5G", "20M", "HT", "1T", "144", "30",
	"FCC", "5G", "20M", "HT", "1T", "149", "28",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"IC", "5G", "20M", "HT", "1T", "149", "33",
	"KCC", "5G", "20M", "HT", "1T", "149", "33",
	"ACMA", "5G", "20M", "HT", "1T", "149", "33",
	"CHILE", "5G", "20M", "HT", "1T", "149", "30",
	"FCC", "5G", "20M", "HT", "1T", "153", "28",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"IC", "5G", "20M", "HT", "1T", "153", "33",
	"KCC", "5G", "20M", "HT", "1T", "153", "33",
	"ACMA", "5G", "20M", "HT", "1T", "153", "33",
	"CHILE", "5G", "20M", "HT", "1T", "153", "30",
	"FCC", "5G", "20M", "HT", "1T", "157", "28",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"IC", "5G", "20M", "HT", "1T", "157", "33",
	"KCC", "5G", "20M", "HT", "1T", "157", "33",
	"ACMA", "5G", "20M", "HT", "1T", "157", "33",
	"CHILE", "5G", "20M", "HT", "1T", "157", "30",
	"FCC", "5G", "20M", "HT", "1T", "161", "28",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"IC", "5G", "20M", "HT", "1T", "161", "33",
	"KCC", "5G", "20M", "HT", "1T", "161", "31",
	"ACMA", "5G", "20M", "HT", "1T", "161", "33",
	"CHILE", "5G", "20M", "HT", "1T", "161", "30",
	"FCC", "5G", "20M", "HT", "1T", "165", "28",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"IC", "5G", "20M", "HT", "1T", "165", "33",
	"KCC", "5G", "20M", "HT", "1T", "165", "63",
	"ACMA", "5G", "20M", "HT", "1T", "165", "33",
	"CHILE", "5G", "20M", "HT", "1T", "165", "30",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "32",
	"MKK", "5G", "40M", "HT", "1T", "38", "32",
	"IC", "5G", "40M", "HT", "1T", "38", "22",
	"KCC", "5G", "40M", "HT", "1T", "38", "26",
	"ACMA", "5G", "40M", "HT", "1T", "38", "32",
	"CHILE", "5G", "40M", "HT", "1T", "38", "22",
	"FCC", "5G", "40M", "HT", "1T", "46", "24",
	"ETSI", "5G", "40M", "HT", "1T", "46", "32",
	"MKK", "5G", "40M", "HT", "1T", "46", "32",
	"IC", "5G", "40M", "HT", "1T", "46", "32",
	"KCC", "5G", "40M", "HT", "1T", "46", "28",
	"ACMA", "5G", "40M", "HT", "1T", "46", "32",
	"CHILE", "5G", "40M", "HT", "1T", "46", "30",
	"FCC", "5G", "40M", "HT", "1T", "54", "27",
	"ETSI", "5G", "40M", "HT", "1T", "54", "32",
	"MKK", "5G", "40M", "HT", "1T", "54", "32",
	"IC", "5G", "40M", "HT", "1T", "54", "32",
	"KCC", "5G", "40M", "HT", "1T", "54", "22",
	"ACMA", "5G", "40M", "HT", "1T", "54", "32",
	"CHILE", "5G", "40M", "HT", "1T", "54", "30",
	"FCC", "5G", "40M", "HT", "1T", "62", "23",
	"ETSI", "5G", "40M", "HT", "1T", "62", "32",
	"MKK", "5G", "40M", "HT", "1T", "62", "32",
	"IC", "5G", "40M", "HT", "1T", "62", "23",
	"KCC", "5G", "40M", "HT", "1T", "62", "31",
	"ACMA", "5G", "40M", "HT", "1T", "62", "32",
	"CHILE", "5G", "40M", "HT", "1T", "62", "23",
	"FCC", "5G", "40M", "HT", "1T", "102", "21",
	"ETSI", "5G", "40M", "HT", "1T", "102", "32",
	"MKK", "5G", "40M", "HT", "1T", "102", "32",
	"IC", "5G", "40M", "HT", "1T", "102", "21",
	"KCC", "5G", "40M", "HT", "1T", "102", "31",
	"ACMA", "5G", "40M", "HT", "1T", "102", "32",
	"CHILE", "5G", "40M", "HT", "1T", "102", "30",
	"FCC", "5G", "40M", "HT", "1T", "110", "27",
	"ETSI", "5G", "40M", "HT", "1T", "110", "32",
	"MKK", "5G", "40M", "HT", "1T", "110", "32",
	"IC", "5G", "40M", "HT", "1T", "110", "32",
	"KCC", "5G", "40M", "HT", "1T", "110", "32",
	"ACMA", "5G", "40M", "HT", "1T", "110", "32",
	"CHILE", "5G", "40M", "HT", "1T", "110", "30",
	"FCC", "5G", "40M", "HT", "1T", "118", "27",
	"ETSI", "5G", "40M", "HT", "1T", "118", "32",
	"MKK", "5G", "40M", "HT", "1T", "118", "32",
	"IC", "5G", "40M", "HT", "1T", "118", "63",
	"KCC", "5G", "40M", "HT", "1T", "118", "32",
	"ACMA", "5G", "40M", "HT", "1T", "118", "32",
	"CHILE", "5G", "40M", "HT", "1T", "118", "30",
	"FCC", "5G", "40M", "HT", "1T", "126", "27",
	"ETSI", "5G", "40M", "HT", "1T", "126", "32",
	"MKK", "5G", "40M", "HT", "1T", "126", "32",
	"IC", "5G", "40M", "HT", "1T", "126", "63",
	"KCC", "5G", "40M", "HT", "1T", "126", "63",
	"ACMA", "5G", "40M", "HT", "1T", "126", "32",
	"CHILE", "5G", "40M", "HT", "1T", "126", "30",
	"FCC", "5G", "40M", "HT", "1T", "134", "27",
	"ETSI", "5G", "40M", "HT", "1T", "134", "32",
	"MKK", "5G", "40M", "HT", "1T", "134", "32",
	"IC", "5G", "40M", "HT", "1T", "134", "32",
	"KCC", "5G", "40M", "HT", "1T", "134", "63",
	"ACMA", "5G", "40M", "HT", "1T", "134", "32",
	"CHILE", "5G", "40M", "HT", "1T", "134", "30",
	"FCC", "5G", "40M", "HT", "1T", "142", "27",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"IC", "5G", "40M", "HT", "1T", "142", "29",
	"KCC", "5G", "40M", "HT", "1T", "142", "63",
	"ACMA", "5G", "40M", "HT", "1T", "142", "63",
	"CHILE", "5G", "40M", "HT", "1T", "142", "30",
	"FCC", "5G", "40M", "HT", "1T", "151", "28",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"IC", "5G", "40M", "HT", "1T", "151", "32",
	"KCC", "5G", "40M", "HT", "1T", "151", "27",
	"ACMA", "5G", "40M", "HT", "1T", "151", "32",
	"CHILE", "5G", "40M", "HT", "1T", "151", "30",
	"FCC", "5G", "40M", "HT", "1T", "159", "28",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"IC", "5G", "40M", "HT", "1T", "159", "32",
	"KCC", "5G", "40M", "HT", "1T", "159", "26",
	"ACMA", "5G", "40M", "HT", "1T", "159", "32",
	"CHILE", "5G", "40M", "HT", "1T", "159", "30",
	"FCC", "5G", "80M", "VHT", "1T", "42", "19",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "32",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"IC", "5G", "80M", "VHT", "1T", "42", "19",
	"KCC", "5G", "80M", "VHT", "1T", "42", "25",
	"ACMA", "5G", "80M", "VHT", "1T", "42", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "42", "19",
	"FCC", "5G", "80M", "VHT", "1T", "58", "22",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "32",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"IC", "5G", "80M", "VHT", "1T", "58", "22",
	"KCC", "5G", "80M", "VHT", "1T", "58", "28",
	"ACMA", "5G", "80M", "VHT", "1T", "58", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "58", "22",
	"FCC", "5G", "80M", "VHT", "1T", "106", "18",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "32",
	"MKK", "5G", "80M", "VHT", "1T", "106", "32",
	"IC", "5G", "80M", "VHT", "1T", "106", "18",
	"KCC", "5G", "80M", "VHT", "1T", "106", "30",
	"ACMA", "5G", "80M", "VHT", "1T", "106", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "106", "30",
	"FCC", "5G", "80M", "VHT", "1T", "122", "27",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "32",
	"MKK", "5G", "80M", "VHT", "1T", "122", "32",
	"IC", "5G", "80M", "VHT", "1T", "122", "63",
	"KCC", "5G", "80M", "VHT", "1T", "122", "26",
	"ACMA", "5G", "80M", "VHT", "1T", "122", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "122", "30",
	"FCC", "5G", "80M", "VHT", "1T", "138", "27",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"IC", "5G", "80M", "VHT", "1T", "138", "28",
	"KCC", "5G", "80M", "VHT", "1T", "138", "63",
	"ACMA", "5G", "80M", "VHT", "1T", "138", "63",
	"CHILE", "5G", "80M", "VHT", "1T", "138", "30",
	"FCC", "5G", "80M", "VHT", "1T", "155", "28",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"IC", "5G", "80M", "VHT", "1T", "155", "32",
	"KCC", "5G", "80M", "VHT", "1T", "155", "27",
	"ACMA", "5G", "80M", "VHT", "1T", "155", "32",
	"CHILE", "5G", "80M", "VHT", "1T", "155", "30"
};

void
odm_read_and_config_mp_8821c_txpwr_lmt_fccsar(struct dm_struct *dm)
{
	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len = sizeof(array_mp_8821c_txpwr_lmt_fccsar) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8821c_txpwr_lmt_fccsar;
#else
	u32	array_len = sizeof(array_mp_8821c_txpwr_lmt_fccsar) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8821c_txpwr_lmt_fccsar;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	PlatformZeroMemory(hal_data->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT * MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8821c(dm, regulation, band, bandwidth, rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
		regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}
}

#endif /* end of HWIMG_SUPPORT*/
