/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.analytics.containertag.proto.Serving;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.CtfeHost;
import com.google.tagmanager.LoadCallback;
import com.google.tagmanager.Log;
import com.google.tagmanager.NetworkClient;
import com.google.tagmanager.NetworkClientFactory;
import com.google.tagmanager.PreviewManager;
import com.google.tagmanager.ResourceUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class ResourceLoader
implements Runnable {
    private static final String CTFE_URL_PREFIX = "/r?id=";
    @VisibleForTesting
    static final String SDK_VERSION = "a62676326";
    private static final String CTFE_URL_SUFFIX = "&v=a62676326";
    private static final String PREVIOUS_CONTAINER_VERSION_QUERY_NAME = "pv";
    private final Context mContext;
    private final NetworkClientFactory mClientFactory;
    private final String mContainerId;
    private final String mDefaultCtfeUrlPathAndQuery;
    private LoadCallback<Serving.SupplementedResource> mCallback;
    private volatile CtfeHost mCtfeHost;
    private volatile String mCtfeUrlPathAndQuery;
    private volatile String mPreviousVersion;

    public ResourceLoader(Context context, String containerId, CtfeHost ctfeHost) {
        this(context, containerId, new NetworkClientFactory(), ctfeHost);
    }

    @VisibleForTesting
    ResourceLoader(Context context, String containerId, NetworkClientFactory factory, CtfeHost ctfeHost) {
        this.mContext = context;
        this.mClientFactory = factory;
        this.mContainerId = containerId;
        this.mCtfeHost = ctfeHost;
        this.mCtfeUrlPathAndQuery = this.mDefaultCtfeUrlPathAndQuery = CTFE_URL_PREFIX + containerId;
        this.mPreviousVersion = null;
    }

    @Override
    public void run() {
        if (this.mCallback == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.mCallback.startLoad();
        this.loadResource();
    }

    private boolean okToLoad() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo network = cm.getActiveNetworkInfo();
        if (network == null || !network.isConnected()) {
            Log.v("...no network connectivity");
            return false;
        }
        return true;
    }

    void setLoadCallback(LoadCallback<Serving.SupplementedResource> callback) {
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadResource() {
        block12: {
            if (!this.okToLoad()) {
                this.mCallback.onFailure(LoadCallback.Failure.NOT_AVAILABLE);
                return;
            }
            Log.v("Start loading resource from network ...");
            String url = this.getCtfeUrl();
            NetworkClient networkClient = this.mClientFactory.createNetworkClient();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = networkClient.getInputStream(url);
                }
                catch (FileNotFoundException e) {
                    Log.w("No data is retrieved from the given url: " + url + ". Make sure container_id: " + this.mContainerId + " is correct.");
                    this.mCallback.onFailure(LoadCallback.Failure.SERVER_ERROR);
                    networkClient.close();
                    return;
                }
                catch (IOException e) {
                    Log.w("Error when loading resources from url: " + url + " " + e.getMessage(), e);
                    this.mCallback.onFailure(LoadCallback.Failure.IO_ERROR);
                    networkClient.close();
                    return;
                }
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    ResourceUtil.copyStream(inputStream, outputStream);
                    Serving.SupplementedResource resource = Serving.SupplementedResource.parseFrom(outputStream.toByteArray());
                    Log.v("Successfully loaded supplemented resource: " + resource);
                    if (resource.resource == null) {
                        Log.v("No change for container: " + this.mContainerId);
                    }
                    this.mCallback.onSuccess(resource);
                    break block12;
                }
                catch (IOException e) {
                    Log.w("Error when parsing downloaded resources from url: " + url + " " + e.getMessage(), e);
                    this.mCallback.onFailure(LoadCallback.Failure.SERVER_ERROR);
                    networkClient.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                networkClient.close();
            }
        }
        Log.v("Load resource from network finished.");
    }

    @VisibleForTesting
    String getCtfeUrl() {
        String url = this.mCtfeHost.getCtfeServerAddress() + this.mCtfeUrlPathAndQuery + CTFE_URL_SUFFIX;
        if (this.mPreviousVersion != null && !this.mPreviousVersion.trim().equals("")) {
            url = url + "&pv=" + this.mPreviousVersion;
        }
        if (PreviewManager.getInstance().getPreviewMode().equals((Object)PreviewManager.PreviewMode.CONTAINER_DEBUG)) {
            url = url + "&gtm_debug=x";
        }
        return url;
    }

    @VisibleForTesting
    void setCtfeURLPathAndQuery(String urlPathAndQuery) {
        if (urlPathAndQuery == null) {
            this.mCtfeUrlPathAndQuery = this.mDefaultCtfeUrlPathAndQuery;
        } else {
            Log.d("Setting CTFE URL path: " + urlPathAndQuery);
            this.mCtfeUrlPathAndQuery = urlPathAndQuery;
        }
    }

    @VisibleForTesting
    void setPreviousVersion(String version) {
        Log.d("Setting previous container version: " + version);
        this.mPreviousVersion = version;
    }
}

