/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.Clock;
import com.google.tagmanager.DataLayer;
import com.google.tagmanager.FutureApis;
import com.google.tagmanager.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class DataLayerPersistentStoreImpl
implements DataLayer.PersistentStore {
    private static final String DATABASE_NAME = "google_tagmanager.db";
    private static final String MAPS_TABLE = "datalayer";
    private static final String KEY_FIELD = "key";
    private static final String VALUE_FIELD = "value";
    private static final String EXPIRE_FIELD = "expires";
    private static final String ID_FIELD = "ID";
    private static final String CREATE_MAPS_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' STRING NOT NULL, '%s' BLOB NOT NULL, '%s' INTEGER NOT NULL);", "datalayer", "ID", "key", "value", "expires");
    private static final int MAX_NUM_STORED_ITEMS = 2000;
    private final Executor mExecutor;
    private final Context mContext;
    private DatabaseHelper mDbHelper;
    private Clock mClock;
    private int mMaxNumStoredItems;

    public DataLayerPersistentStoreImpl(Context context) {
        this(context, new Clock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        }, DATABASE_NAME, 2000, Executors.newSingleThreadExecutor());
    }

    @VisibleForTesting
    DataLayerPersistentStoreImpl(Context context, Clock clock, String databaseName, int maxNumStoredItems, Executor executor) {
        this.mContext = context;
        this.mClock = clock;
        this.mMaxNumStoredItems = maxNumStoredItems;
        this.mExecutor = executor;
        this.mDbHelper = new DatabaseHelper(this.mContext, databaseName);
    }

    @Override
    public void saveKeyValues(List<DataLayer.KeyValue> keysAndValues, final long lifetimeInMillis) {
        final List<KeyAndSerialized> serializedKeysAndValues = this.serializeValues(keysAndValues);
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                DataLayerPersistentStoreImpl.this.saveSingleThreaded(serializedKeysAndValues, lifetimeInMillis);
            }
        });
    }

    @Override
    public void loadSaved(final DataLayer.PersistentStore.Callback callback) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onKeyValuesLoaded(DataLayerPersistentStoreImpl.this.loadSingleThreaded());
            }
        });
    }

    @Override
    public void clearKeysWithPrefix(final String keyPrefix) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                DataLayerPersistentStoreImpl.this.clearKeysWithPrefixSingleThreaded(keyPrefix);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataLayer.KeyValue> loadSingleThreaded() {
        try {
            this.deleteEntriesOlderThan(this.mClock.currentTimeMillis());
            List<DataLayer.KeyValue> list = this.unserializeValues(this.loadSerialized());
            return list;
        }
        finally {
            this.closeDatabaseConnection();
        }
    }

    private List<DataLayer.KeyValue> unserializeValues(List<KeyAndSerialized> serialized) {
        ArrayList<DataLayer.KeyValue> result = new ArrayList<DataLayer.KeyValue>();
        for (KeyAndSerialized keyAndSerialized : serialized) {
            result.add(new DataLayer.KeyValue(keyAndSerialized.mKey, this.unserialize(keyAndSerialized.mSerialized)));
        }
        return result;
    }

    private List<KeyAndSerialized> serializeValues(List<DataLayer.KeyValue> keysAndValues) {
        ArrayList<KeyAndSerialized> result = new ArrayList<KeyAndSerialized>();
        for (DataLayer.KeyValue keyAndValue : keysAndValues) {
            result.add(new KeyAndSerialized(keyAndValue.mKey, this.serialize(keyAndValue.mValue)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unserialize(byte[] bytes) {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = null;
        try {
            objectInput = new ObjectInputStream(byteStream);
            Object object = objectInput.readObject();
            return object;
        }
        catch (IOException e) {
            Object var5_8 = null;
            return var5_8;
        }
        catch (ClassNotFoundException e) {
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            try {
                if (objectInput != null) {
                    objectInput.close();
                }
                byteStream.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(Object o) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = null;
        try {
            objectOutput = new ObjectOutputStream(byteStream);
            objectOutput.writeObject(o);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (objectOutput != null) {
                    objectOutput.close();
                }
                byteStream.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveSingleThreaded(List<KeyAndSerialized> keysAndValues, long lifetimeInMillis) {
        try {
            long now = this.mClock.currentTimeMillis();
            this.deleteEntriesOlderThan(now);
            this.makeRoomForEntries(keysAndValues.size());
            this.writeEntriesToDatabase(keysAndValues, now + lifetimeInMillis);
        }
        finally {
            this.closeDatabaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyAndSerialized> loadSerialized() {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for loadSerialized.");
        ArrayList<KeyAndSerialized> list = new ArrayList<KeyAndSerialized>();
        if (db == null) {
            return list;
        }
        String[] columns = new String[]{KEY_FIELD, VALUE_FIELD};
        Cursor results = db.query(MAPS_TABLE, columns, null, null, null, null, ID_FIELD, null);
        try {
            while (results.moveToNext()) {
                list.add(new KeyAndSerialized(results.getString(0), results.getBlob(1)));
            }
        }
        finally {
            results.close();
        }
        return list;
    }

    private void writeEntriesToDatabase(List<KeyAndSerialized> keysAndValues, long expireTime) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for writeEntryToDatabase.");
        if (db == null) {
            return;
        }
        for (KeyAndSerialized keyAndValue : keysAndValues) {
            ContentValues values = new ContentValues();
            values.put(EXPIRE_FIELD, Long.valueOf(expireTime));
            values.put(KEY_FIELD, keyAndValue.mKey);
            values.put(VALUE_FIELD, keyAndValue.mSerialized);
            db.insert(MAPS_TABLE, null, values);
        }
    }

    private void makeRoomForEntries(int count) {
        int entrysOverLimit = this.getNumStoredEntries() - this.mMaxNumStoredItems + count;
        if (entrysOverLimit > 0) {
            List<String> entrysToDelete = this.peekEntryIds(entrysOverLimit);
            Log.i("DataLayer store full, deleting " + entrysToDelete.size() + " entries to make room.");
            this.deleteEntries(entrysToDelete.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearKeysWithPrefixSingleThreaded(String keyPrefix) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for clearKeysWithPrefix.");
        if (db == null) {
            return;
        }
        try {
            int deleted = db.delete(MAPS_TABLE, "key = ? OR key LIKE ?", new String[]{keyPrefix, keyPrefix + ".%"});
            Log.v("Cleared " + deleted + " items");
        }
        catch (SQLiteException e) {
            Log.w("Error deleting entries with key prefix: " + keyPrefix + " (" + (Object)((Object)e) + ").");
        }
        finally {
            this.closeDatabaseConnection();
        }
    }

    private void deleteEntriesOlderThan(long timeInMillis) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteOlderThan.");
        if (db == null) {
            return;
        }
        try {
            int deleted = db.delete(MAPS_TABLE, "expires <= ?", new String[]{Long.toString(timeInMillis)});
            Log.v("Deleted " + deleted + " expired items");
        }
        catch (SQLiteException e) {
            Log.w("Error deleting old entries.");
        }
    }

    private void deleteEntries(String[] entryIds) {
        if (entryIds == null || entryIds.length == 0) {
            return;
        }
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteEntries.");
        if (db == null) {
            return;
        }
        String whereClause = String.format("%s in (%s)", ID_FIELD, TextUtils.join((CharSequence)",", Collections.nCopies(entryIds.length, "?")));
        try {
            db.delete(MAPS_TABLE, whereClause, entryIds);
        }
        catch (SQLiteException e) {
            Log.w("Error deleting entries " + Arrays.toString(entryIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> peekEntryIds(int maxEntries) {
        ArrayList<String> entryIds = new ArrayList<String>();
        if (maxEntries <= 0) {
            Log.w("Invalid maxEntries specified. Skipping.");
            return entryIds;
        }
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for peekEntryIds.");
        if (db == null) {
            return entryIds;
        }
        Cursor cursor = null;
        try {
            cursor = db.query(MAPS_TABLE, new String[]{ID_FIELD}, null, null, null, null, String.format("%s ASC", ID_FIELD), Integer.toString(maxEntries));
            if (cursor.moveToFirst()) {
                do {
                    entryIds.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException e) {
            Log.w("Error in peekEntries fetching entryIds: " + e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return entryIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumStoredEntries() {
        int numStoredEntries = 0;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for getNumStoredEntries.");
        if (db == null) {
            return numStoredEntries;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT COUNT(*) from datalayer", null);
            if (cursor.moveToFirst()) {
                numStoredEntries = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException e) {
            Log.w("Error getting numStoredEntries");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return numStoredEntries;
    }

    private SQLiteDatabase getWritableDatabase(String errorMessage) {
        SQLiteDatabase db = null;
        try {
            db = this.mDbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            Log.w(errorMessage);
            return null;
        }
        return db;
    }

    private void closeDatabaseConnection() {
        try {
            this.mDbHelper.close();
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
    }

    private static class KeyAndSerialized {
        final String mKey;
        final byte[] mSerialized;

        KeyAndSerialized(String key, byte[] serialized) {
            this.mKey = key;
            this.mSerialized = serialized;
        }

        public String toString() {
            return "KeyAndSerialized: key = " + this.mKey + " serialized hash = " + Arrays.hashCode(this.mSerialized);
        }
    }

    @VisibleForTesting
    class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context, String databaseName) {
            super(context, databaseName, null, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tablePresent(String table, SQLiteDatabase db) {
            Cursor cursor = null;
            try {
                cursor = db.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{table}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
            catch (SQLiteException e) {
                Log.w("Error querying for table " + table);
                boolean bl = false;
                return bl;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            SQLiteDatabase db = null;
            try {
                db = super.getWritableDatabase();
            }
            catch (SQLiteException e) {
                DataLayerPersistentStoreImpl.this.mContext.getDatabasePath(DataLayerPersistentStoreImpl.DATABASE_NAME).delete();
            }
            if (db == null) {
                db = super.getWritableDatabase();
            }
            return db;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);
                try {
                    cursor.moveToFirst();
                }
                finally {
                    cursor.close();
                }
            }
            if (!this.tablePresent(DataLayerPersistentStoreImpl.MAPS_TABLE, db)) {
                db.execSQL(CREATE_MAPS_TABLE);
            } else {
                this.validateColumnsPresent(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateColumnsPresent(SQLiteDatabase db) {
            Cursor c = db.rawQuery("SELECT * FROM datalayer WHERE 0", null);
            HashSet<String> columns = new HashSet<String>();
            try {
                String[] columnNames = c.getColumnNames();
                for (int i = 0; i < columnNames.length; ++i) {
                    columns.add(columnNames[i]);
                }
            }
            finally {
                c.close();
            }
            if (!(columns.remove(DataLayerPersistentStoreImpl.KEY_FIELD) && columns.remove(DataLayerPersistentStoreImpl.VALUE_FIELD) && columns.remove(DataLayerPersistentStoreImpl.ID_FIELD) && columns.remove(DataLayerPersistentStoreImpl.EXPIRE_FIELD))) {
                throw new SQLiteException("Database column missing");
            }
            if (!columns.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            FutureApis.setOwnerOnlyReadWrite(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

