/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import android.text.TextUtils;
import com.google.analytics.tracking.android.AnalyticsThread;
import com.google.analytics.tracking.android.AppFieldsDefaultProvider;
import com.google.analytics.tracking.android.ClientIdDefaultProvider;
import com.google.analytics.tracking.android.DefaultLoggerImpl;
import com.google.analytics.tracking.android.GAThread;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.Logger;
import com.google.analytics.tracking.android.ScreenResolutionDefaultProvider;
import com.google.analytics.tracking.android.Tracker;
import com.google.analytics.tracking.android.TrackerHandler;
import com.google.analytics.tracking.android.Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GoogleAnalytics
extends TrackerHandler {
    private boolean mDryRun;
    private AnalyticsThread mThread;
    private Context mContext;
    private Tracker mDefaultTracker;
    private volatile Boolean mAppOptOut = false;
    private final Map<String, Tracker> mTrackers = new HashMap<String, Tracker>();
    private Logger mLogger;
    private static GoogleAnalytics sInstance;

    @VisibleForTesting
    protected GoogleAnalytics(Context context) {
        this(context, GAThread.getInstance(context));
    }

    private GoogleAnalytics(Context context, AnalyticsThread thread) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.mThread = thread;
        AppFieldsDefaultProvider.initializeProvider(this.mContext);
        ScreenResolutionDefaultProvider.initializeProvider(this.mContext);
        ClientIdDefaultProvider.initializeProvider(this.mContext);
        this.mLogger = new DefaultLoggerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleAnalytics getInstance(Context context) {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (sInstance == null) {
                sInstance = new GoogleAnalytics(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GoogleAnalytics getInstance() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static GoogleAnalytics getNewInstance(Context context, AnalyticsThread thread) {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (sInstance != null) {
                sInstance.close();
            }
            sInstance = new GoogleAnalytics(context, thread);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearInstance() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            sInstance = null;
            GoogleAnalytics.clearDefaultProviders();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    static void clearDefaultProviders() {
        AppFieldsDefaultProvider.dropInstance();
        ScreenResolutionDefaultProvider.dropInstance();
        ClientIdDefaultProvider.dropInstance();
    }

    public void setDryRun(boolean dryRun) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_DRY_RUN);
        this.mDryRun = dryRun;
    }

    public boolean isDryRunEnabled() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_DRY_RUN);
        return this.mDryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker getTracker(String name, String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            if (TextUtils.isEmpty((CharSequence)name)) {
                throw new IllegalArgumentException("Tracker name cannot be empty");
            }
            Tracker tracker = this.mTrackers.get(name);
            if (tracker == null) {
                tracker = new Tracker(name, trackingId, this);
                this.mTrackers.put(name, tracker);
                if (this.mDefaultTracker == null) {
                    this.mDefaultTracker = tracker;
                }
            }
            if (!TextUtils.isEmpty((CharSequence)trackingId)) {
                tracker.set("&tid", trackingId);
            }
            GAUsage.getInstance().setUsage(GAUsage.Field.GET_TRACKER);
            return tracker;
        }
    }

    public Tracker getTracker(String trackingId) {
        return this.getTracker(trackingId, trackingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker getDefaultTracker() {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            GAUsage.getInstance().setUsage(GAUsage.Field.GET_DEFAULT_TRACKER);
            return this.mDefaultTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTracker(Tracker tracker) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            GAUsage.getInstance().setUsage(GAUsage.Field.SET_DEFAULT_TRACKER);
            this.mDefaultTracker = tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTracker(String name) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            GAUsage.getInstance().setUsage(GAUsage.Field.CLOSE_TRACKER);
            Tracker tracker = this.mTrackers.remove(name);
            if (tracker == this.mDefaultTracker) {
                this.mDefaultTracker = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sendHit(Map<String, String> hit) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            if (hit == null) {
                throw new IllegalArgumentException("hit cannot be null");
            }
            Utils.putIfAbsent(hit, "&ul", Utils.getLanguage(Locale.getDefault()));
            Utils.putIfAbsent(hit, "&sr", ScreenResolutionDefaultProvider.getProvider().getValue("&sr"));
            hit.put("&_u", GAUsage.getInstance().getAndClearSequence());
            GAUsage.getInstance().getAndClearUsage();
            this.mThread.sendHit(hit);
        }
    }

    @VisibleForTesting
    void close() {
    }

    public void setAppOptOut(boolean optOut) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_OPT_OUT);
        this.mAppOptOut = optOut;
        if (this.mAppOptOut.booleanValue()) {
            this.mThread.clearHits();
        }
    }

    public boolean getAppOptOut() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_APP_OPT_OUT);
        return this.mAppOptOut;
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    public void setLogger(Logger logger) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_LOGGER);
        this.mLogger = logger;
    }
}

