/*
 This Java source file was generated by test-to-java.xsl
 and is a derived work from the source document.
 The source document contained the following notice:



 Copyright (c) 2001 World Wide Web Consortium, 
 (Massachusetts Institute of Technology, Institut National de
 Recherche en Informatique et en Automatique, Keio University).  All 
 Rights Reserved.  This program is distributed under the W3C's Software
 Intellectual Property License.  This program is distributed in the 
 hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  

 See W3C License http://www.w3.org/Consortium/Legal/ for more details.


 */

package tests.org.w3c.dom;

import dalvik.annotation.TestTargets;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargetClass;

import org.w3c.dom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Attr;

import javax.xml.parsers.DocumentBuilder;

/**
 * The method hasAttributeNS returns true when an attribute with a given local
 * name and namespace URI is specified on this element or has a default value,
 * false otherwise.
 * 
 * Retreive the first employee element node. Invoke the hasAttributeNS method to
 * check if it has the xmlns attribute that belongs to the namespace
 * http://www.w3.org/2000/xmlns/.
 * 
 * @author IBM
 * @author Neil Delima
 * @see <a
 *      href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElHasAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElHasAttrNS</a>
 */
@TestTargetClass(Element.class) 
public final class ElementHasAttributeNS extends DOMTestCase {

    DOMDocumentBuilderFactory factory;

    DocumentBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            factory = new DOMDocumentBuilderFactory(DOMDocumentBuilderFactory
                    .getConfiguration2());
            builder = factory.getBuilder();
        } catch (Exception e) {
            fail("Unexpected exception" + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        factory = null;
        builder = null;
        super.tearDown();
    }

    /**
     * Runs the test case.
     * 
     * @throws Throwable
     *             Any uncaught exception causes test to fail
     */
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Doesn't verify DOMException.",
        method = "hasAttributeNS",
        args = {java.lang.String.class, java.lang.String.class}
    )
    public void _testHasAttributeNS1() throws Throwable {
        Document doc;
        Element element;
        boolean state;
        NodeList elementList;
        doc = (Document) load("staffNS", builder);
        elementList = doc.getElementsByTagNameNS("*", "employee");
        element = (Element) elementList.item(0);
        state = element
                .hasAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        assertTrue("elementhasattributens01", state);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Doesn't verify DOMException.",
        method = "hasAttributeNS",
        args = {java.lang.String.class, java.lang.String.class}
    )
    public void testHasAttributeNS2() throws Throwable {
        Document doc;
        Element element;
        boolean state;
        Attr attribute;
        
        doc = (Document) load("staff", builder);
        element = doc.createElementNS("http://www.w3.org/DOM", "address");
        attribute = doc.createAttributeNS("http://www.w3.org/DOM", "domestic");
        element.setAttributeNode(attribute);
        state = element.hasAttributeNS("http://www.w3.org/DOM", "domestic");
        assertTrue("hasDomesticAttr", state);
    }
    @TestTargetNew(
        level = TestLevel.PARTIAL,
        notes = "Doesn't verify DOMException.",
        method = "hasAttributeNS",
        args = {java.lang.String.class, java.lang.String.class}
    )
    public void testHasAttributeNS3() throws Throwable {
        Document doc;
        Element element;
        boolean state;
        Attr attribute;
        
        String nullNS = null;

        doc = (Document) load("staff", builder);
        element = doc.createElementNS("http://www.w3.org/DOM", "address");
        assertNotNull("createElementNotNull", element);
        attribute = doc.createAttributeNS(nullNS, "domestic");
        element.setAttributeNode(attribute);
        state = element.hasAttributeNS(nullNS, "domestic");
        assertTrue("elementhasattributens03", state);
    }
}
