/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package tests.api.java.nio.charset;

import dalvik.annotation.AndroidOnly;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;

@TestTargetClass(targets.Charsets.EUC_JP.class)
@AndroidOnly("icu different from RI")

public class Charset_MultiByte_EUC_JP_Android extends Charset_AbstractTest {

    protected void setUp() throws Exception {
        charsetName = "EUC-JP";

        testChars = theseChars(new int[]{
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
161, 162, 163, 164, /*165,*/ 166, 167, 168, 169, 170, 172, 174, 175, 176, 177, 180, 
182, 184, 186, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
204, 205, 206, 207, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 
221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 
253, 254, 255, 256, 266, 278, 288, 298, 308, 318, 328, 338, 348, 358, 368, 378, 
461, 471, 501, 711, 728, 900, 910, 920, 931, 941, 951, 961, 971, 1025, 1035, 1045, 
1055, 1065, 1075, 1085, 1095, 1105, 1115, 8208, 8220, 8230, 8240, 8251, 8451, 8470, 8482, 8592, 
8658, 8704, 8715, 8730, 8743, 8756, 8786, 8800, 8810, 8834, 8869, 8978, 9472, 9484, 9495, 9507, 
9519, 9531, 9547, 9632, 9650, 9660, 9670, 9711, 9733, 9792, 9834, 12288, 12298, 12308, 12353, 12363, 
12373, 12383, 12393, 12403, 12413, 12423, 12433, 12443, 12453, 12463, 12473, 12483, 12493, 12503, 12513, 12523, 
12533, 19968, 19978, 19988, 19998, 20008, 20018, 20028, 20039, 20049, 20060, 20072, 20083, 20094, 20104, 20114, 
20124, 20134, 20144, 20154, 20164, 20174, 20184, 20194, 20205, 20215, 20225, 20235, 20245, 20270, 20280, 20290, 
20300, 20310, 20320, 20330, 20341, 20351, 20361, 20371, 20381, 20395, 20405, 20415, 20425, 20436, 20447, 20462, 
20472, 20484, 20494, 20504, 20514, 20524, 20534, 20544, 20554, 20565, 20575, 20586, 20596, 20608, 20618, 20628, 
20638, 20650, 20660, 20670, 20681, 20691, 20701, 20711, 20721, 20731, 20742, 20752, 20762, 20775, 20785, 20795, 
20805, 20815, 20826, 20836, 20846, 20856, 20866, 20876, 20886, 20896, 20906, 20916, 20926, 20936, 20946, 20956, 
20966, 20976, 20986, 20996, 21006, 21016, 21026, 21038, 21048, 21059, 21069, 21079, 21089, 21102, 21112, 21122, 
21132, 21142, 21152, 21162, 21172, 21182, 21192, 21202, 21212, 21222, 21232, 21242, 21253, 21263, 21273, 21283, 
21293, 21304, 21314, 21324, 21335, 21345, 21356, 21367, 21378, 21390, 21400, 21412, 21422, 21432, 21442, 21452, 
21462, 21472, 21482, 21493, 21505, 21515, 21530, 21542, 21553, 21563, 21574, 21585, 21598, 21608, 21619, 21629, 
21640, 21650, 21660, 21670, 21681, 21691, 21702, 21720, 21730, 21740, 21750, 21760, 21772, 21782, 21802, 21813, 
21824, 21834, 21846, 21856, 21883, 21894, 21905, 21916, 21927, 21938, 21951, 21961, 21971, 21982, 21993, 22006, 
22021, 22031, 22041, 22057, 22067, 22077, 22089, 22100, 22110, 22120, 22130, 22144, 22154, 22164, 22174, 22184, 
22195, 22206, 22216, 22227, 22237, 22247, 22257, 22269, 22279, 22289, 22299, 22309, 22319, 22331, 22341, 22351, 
22369, 22379, 22389, 22399, 22409, 22419, 22429, 22439, 22451, 22461, 22471, 22482, 22492, 22502, 22512, 22522, 
22532, 22549, 22559, 22570, 22580, 22591, 22601, 22612, 22622, 22632, 22642, 22652, 22663, 22675, 22685, 22696, 
22706, 22716, 22727, 22737, 22748, 22761, 22771, 22781, 22793, 22803, 22813, 22823, 22833, 22846, 22856, 22866, 
22877, 22887, 22898, 22908, 22922, 22933, 22943, 22956, 22967, 22977, 22987, 23001, 23011, 23022, 23035, 23049, 
23059, 23070, 23080, 23093, 23104, 23116, 23130, 23141, 23159, 23179, 23190, 23200, 23212, 23224, 23234, 23244, 
23254, 23264, 23274, 23285, 23296, 23307, 23318, 23329, 23340, 23350, 23360, 23371, 23381, 23391, 23401, 23411, 
23421, 23431, 23441, 23451, 23461, 23471, 23481, 23491, 23501, 23511, 23521, 23531, 23541, 23551, 23561, 23571, 
23582, 23592, 23602, 23612, 23622, 23632, 23642, 23652, 23662, 23673, 23687, 23697, 23709, 23720, 23730, 23740, 
23751, 23762, 23773, 23784, 23794, 23805, 23815, 23825, 23835, 23846, 23857, 23869, 23880, 23890, 23900, 23913, 
23923, 23934, 23944, 23954, 23965, 23975, 23986, 23996, 24007, 24018, 24029, 24039, 24049, 24059, 24070, 24081, 
24091, 24101, 24111, 24125, 24135, 24145, 24155, 24168, 24178, 24188, 24199, 24213, 24224, 24234, 24245, 24255, 
24265, 24275, 24285, 24296, 24307, 24318, 24328, 24339, 24349, 24359, 24369, 24379, 24389, 24400, 24411, 24422, 
24432, 24442, 24452, 24463, 24473, 24484, 24494, 24504, 24515, 24525, 24535, 24545, 24555, 24565, 24575, 24586, 
24596, 24607, 24617, 24627, 24640, 24650, 24660, 24671, 24681, 24693, 24703, 24713, 24723, 24733, 24743, 24753, 
24763, 24773, 24783, 24793, 24803, 24816, 24826, 24838, 24848, 24858, 24871, 24881, 24892, 24902, 24915, 24925, 
24935, 24945, 24955, 24967, 24977, 24988, 24999, 25010, 25020, 25030, 25040, 25052, 25062, 25074, 25084, 25095, 
25105, 25115, 25126, 25136, 25147, 25158, 25168, 25178, 25188, 25198, 25209, 25219, 25229, 25239, 25254, 25265, 
25275, 25285, 25295, 25305, 25322, 25332, 25342, 25352, 25363, 25375, 25385, 25397, 25407, 25417, 25427, 25445, 
25457, 25467, 25479, 25490, 25502, 25512, 25522, 25533, 25544, 25554, 25564, 25577, 25587, 25606, 25616, 25628, 
25638, 25648, 25658, 25675, 25688, 25699, 25709, 25720, 25731, 25743, 25753, 25763, 25773, 25785, 25796, 25806, 
25816, 25826, 25836, 25846, 25856, 25866, 25876, 25886, 25897, 25908, 25918, 25928, 25938, 25949, 25959, 25970, 
25981, 25991, 26001, 26011, 26021, 26031, 26041, 26051, 26062, 26072, 26082, 26092, 26105, 26115, 26125, 26140, 
26150, 26160, 26172, 26182, 26193, 26203, 26214, 26224, 26234, 26244, 26254, 26264, 26274, 26285, 26296, 26306, 
26316, 26326, 26336, 26347, 26357, 26367, 26377, 26387, 26397, 26407, 26417, 26429, 26439, 26449, 26460, 26470, 
26480, 26491, 26501, 26511, 26521, 26534, 26544, 26555, 26565, 26575, 26585, 26596, 26606, 26617, 26627, 26643, 
26653, 26663, 26673, 26683, 26693, 26704, 26715, 26727, 26737, 26747, 26757, 26767, 26778, 26789, 26799, 26809, 
26820, 26831, 26841, 26851, 26861, 26873, 26884, 26894, 26905, 26915, 26928, 26939, 26949, 26963, 26973, 26984, 
26994, 27004, 27018, 27028, 27040, 27051, 27063, 27073, 27083, 27094, 27106, 27117, 27129, 27139, 27151, 27161, 
27171, 27182, 27192, 27204, 27214, 27224, 27234, 27249, 27262, 27273, 27287, 27298, 27308, 27320, 27330, 27340, 
27350, 27364, 27376, 27386, 27396, 27407, 27419, 27431, 27442, 27453, 27463, 27474, 27485, 27495, 27507, 27517, 
27529, 27541, 27551, 27561, 27571, 27581, 27593, 27603, 27615, 27627, 27639, 27650, 27661, 27671, 27683, 27694, 
27704, 27714, 27725, 27735, 27746, 27757, 27768, 27778, 27788, 27798, 27809, 27819, 27832, 27842, 27852, 27862, 
27872, 27882, 27892, 27908, 27918, 27929, 27941, 27951, 27961, 27972, 27991, 28001, 28012, 28023, 28034, 28044, 
28054, 28074, 28084, 28095, 28106, 28117, 28127, 28137, 28147, 28160, 28170, 28181, 28191, 28201, 28214, 28227, 
28237, 28247, 28258, 28270, 28283, 28300, 28310, 28320, 28330, 28342, 28352, 28362, 28372, 28382, 28395, 28407, 
28417, 28428, 28438, 28448, 28458, 28470, 28481, 28495, 28505, 28516, 28526, 28536, 28546, 28556, 28566, 28576, 
28586, 28597, 28608, 28618, 28628, 28638, 28648, 28659, 28669, 28679, 28689, 28699, 28710, 28720, 28732, 28744, 
28756, 28766, 28779, 28789, 28801, 28814, 28824, 28836, 28846, 28856, 28872, 28883, 28893, 28913, 28925, 28935, 
28948, 28958, 28971, 28982, 28993, 29003, 29013, 29024, 29036, 29049, 29060, 29071, 29081, 29096, 29106, 29118, 
29128, 29138, 29148, 29158, 29173, 29183, 29193, 29203, 29213, 29224, 29234, 29244, 29254, 29264, 29274, 29287, 
29297, 29307, 29319, 29330, 29344, 29356, 29366, 29377, 29388, 29398, 29408, 29420, 29431, 29442, 29453, 29463, 
29474, 29484, 29494, 29507, 29517, 29527, 29539, 29550, 29560, 29571, 29582, 29592, 29602, 29613, 29623, 29634, 
29644, 29654, 29664, 29674, 29684, 29694, 29705, 29722, 29732, 29742, 29753, 29763, 29773, 29783, 29794, 29805, 
29822, 29833, 29848, 29858, 29870, 29881, 29896, 29907, 29918, 29928, 29938, 29948, 29958, 29969, 29980, 29990, 
30000, 30010, 30020, 30030, 30041, 30052, 30063, 30073, 30085, 30095, 30105, 30115, 30129, 30140, 30150, 30162, 
30172, 30183, 30193, 30204, 30215, 30226, 30236, 30246, 30256, 30266, 30276, 30290, 30300, 30311, 30321, 30331, 
30341, 30352, 30362, 30372, 30382, 30392, 30402, 30412, 30422, 30432, 30442, 30452, 30462, 30472, 30482, 30492, 
30502, 30516, 30526, 30538, 30550, 30560, 30570, 30580, 30590, 30603, 30613, 30623, 30634, 30645, 30655, 30665, 
30677, 30687, 30697, 30707, 30722, 30732, 30749, 30759, 30770, 30783, 30796, 30812, 30824, 30834, 30844, 30854, 
30865, 30877, 30887, 30897, 30907, 30917, 30928, 30938, 30948, 30959, 30970, 30982, 30992, 31002, 31013, 31025, 
31035, 31045, 31055, 31066, 31077, 31090, 31100, 31114, 31124, 31137, 31147, 31160, 31170, 31183, 31194, 31204, 
31216, 31227, 31239, 31249, 31259, 31271, 31281, 31291, 31301, 31311, 31321, 31331, 31341, 31352, 31362, 31376, 
31390, 31401, 31411, 31423, 31433, 31443, 31453, 31464, 31476, 31486, 31496, 31508, 31518, 31528, 31539, 31549, 
31559, 31569, 31581, 31591, 31601, 31620, 31630, 31640, 31653, 31663, 31674, 31684, 31695, 31705, 31716, 31730, 
31740, 31750, 31761, 31771, 31781, 31793, 31805, 31818, 31828, 31838, 31849, 31859, 31869, 31879, 31890, 31902, 
31912, 31922, 31932, 31943, 31954, 31964, 31974, 31986, 31998, 32008, 32018, 32028, 32038, 32048, 32058, 32068, 
32078, 32089, 32099, 32110, 32120, 32130, 32140, 32150, 32162, 32172, 32182, 32194, 32204, 32215, 32225, 32235, 
32245, 32256, 32266, 32277, 32287, 32299, 32309, 32319, 32330, 32340, 32350, 32361, 32371, 32381, 32391, 32401, 
32411, 32566, 32579, 32589, 32600, 32611, 32621, 32631, 32642, 32652, 32662, 32673, 32685, 32696, 32707, 32718, 
32731, 32741, 32751, 32761, 32771, 32781, 32791, 32801, 32812, 32822, 32832, 32842, 32854, 32864, 32877, 32887, 
32897, 32907, 32918, 32929, 32939, 32952, 32963, 32973, 32983, 32993, 33005, 33016, 33026, 33046, 33056, 33068, 
33081, 33093, 33104, 33119, 33129, 33140, 33151, 33162, 33173, 33184, 33198, 33208, 33218, 33229, 33239, 33249, 
33259, 33269, 33279, 33289, 33299, 33309, 33320, 33330, 33344, 33355, 33366, 33376, 33386, 33396, 33406, 33417, 
33428, 33439, 33449, 33459, 33469, 33488, 33498, 33508, 33519, 33529, 33539, 33550, 33560, 33570, 33580, 33590, 
33600, 33610, 33620, 33648, 33659, 33669, 33682, 33692, 33702, 33713, 33725, 33735, 33745, 33756, 33768, 33778, 
33788, 33798, 33809, 33824, 33834, 33845, 33861, 33871, 33881, 33891, 33901, 33911, 33921, 33931, 33941, 33951, 
33961, 33972, 33982, 33992, 34003, 34023, 34033, 34043, 34054, 34064, 34074, 34084, 34095, 34109, 34120, 34130, 
34140, 34152, 34167, 34177, 34187, 34199, 34210, 34220, 34230, 34241, 34251, 34261, 34271, 34281, 34291, 34302, 
34314, 34326, 34337, 34349, 34360, 34370, 34381, 34391, 34401, 34411, 34421, 34440, 34451, 34465, 34475, 34485, 
34495, 34505, 34516, 34526, 34537, 34552, 34562, 34573, 34584, 34595, 34606, 34617, 34627, 34637, 34647, 34657, 
34670, 34680, 34690, 34700, 34711, 34722, 34732, 34746, 34756, 34766, 34777, 34787, 34797, 34807, 34817, 34827, 
34837, 34847, 34861, 34873, 34883, 34893, 34903, 34913, 34923, 34933, 34943, 34955, 34966, 34976, 34986, 34996, 
35006, 35018, 35028, 35038, 35048, 35058, 35068, 35078, 35088, 35098, 35109, 35120, 35130, 35140, 35151, 35162, 
35172, 35182, 35194, 35206, 35216, 35226, 35237, 35247, 35258, 35282, 35292, 35302, 35313, 35325, 35335, 35345, 
35355, 35365, 35375, 35386, 35397, 35408, 35419, 35429, 35440, 35450, 35460, 35471, 35481, 35491, 35501, 35511, 
35522, 35532, 35542, 35552, 35563, 35573, 35583, 35594, 35604, 35614, 35624, 35635, 35646, 35656, 35666, 35676, 
35686, 35696, 35708, 35722, 35732, 35742, 35895, 35905, 35915, 35925, 35937, 35947, 35957, 35970, 35980, 35992, 
36002, 36012, 36022, 36032, 36042, 36053, 36064, 36074, 36085, 36095, 36105, 36115, 36196, 36206, 36223, 36234, 
36245, 36255, 36267, 36277, 36288, 36298, 36308, 36319, 36330, 36340, 36351, 36361, 36372, 36382, 36394, 36404, 
36416, 36426, 36436, 36446, 36457, 36468, 36481, 36491, 36501, 36513, 36523, 36533, 36544, 36554, 36564, 36575, 
36587, 36599, 36610, 36620, 36630, 36640, 36650, 36660, 36670, 36681, 36691, 36701, 36763, 36773, 36783, 36794, 
36804, 36814, 36826, 36836, 36846, 36856, 36866, 36876, 36886, 36896, 36906, 36916, 36926, 36937, 36947, 36957, 
36967, 36978, 36988, 36999, 37009, 37019, 37029, 37039, 37053, 37063, 37074, 37084, 37096, 37108, 37118, 37128, 
37138, 37148, 37159, 37169, 37180, 37191, 37202, 37217, 37228, 37239, 37249, 37259, 37269, 37281, 37291, 37301, 
37311, 37321, 37331, 37341, 37351, 37361, 37371, 37381, 37392, 37404, 37414, 37424, 37434, 37444, 37454, 37464, 
37474, 37486, 37496, 37507, 37517, 37527, 37540, 37551, 37561, 37571, 37581, 37591, 37601, 37612, 37624, 37634, 
37645, 37656, 37666, 37676, 37686, 37700, 37712, 37722, 37732, 37742, 37754, 37768, 37778, 37790, 37800, 37812, 
37825, 37835, 37846, 37857, 37879, 37889, 37901, 37911, 37921, 37931, 37941, 37951, 37962, 37973, 37983, 37994, 
38005, 38015, 38263, 38274, 38284, 38294, 38304, 38315, 38326, 38339, 38349, 38360, 38370, 38428, 38438, 38449, 
38459, 38475, 38486, 38497, 38508, 38518, 38529, 38539, 38549, 38559, 38569, 38579, 38592, 38602, 38613, 38623, 
38633, 38646, 38656, 38666, 38678, 38689, 38704, 38717, 38728, 38738, 38748, 38758, 38769, 38779, 38789, 38799, 
38809, 38819, 38829, 38840, 38851, 38861, 38871, 38881, 38893, 38903, 38913, 38924, 38934, 38944, 38955, 38965, 
38980, 38990, 39000, 39010, 39020, 39080, 39092, 39103, 39116, 39131, 39141, 39151, 39164, 39175, 39185, 39195, 
39206, 39217, 39227, 39237, 39248, 39259, 39318, 39333, 39344, 39354, 39364, 39376, 39386, 39399, 39409, 39419, 
39429, 39439, 39449, 39459, 39469, 39479, 39489, 39499, 39509, 39519, 39529, 39592, 39602, 39612, 39622, 39632, 
39643, 39653, 39663, 39673, 39683, 39693, 39704, 39714, 39725, 39735, 39745, 39755, 39765, 39777, 39787, 39797, 
39807, 39817, 39827, 39837, 39847, 39857, 39867, 39878, 39888, 39899, 39909, 39919, 39929, 39940, 39951, 39961, 
39971, 39981, 39991, 40001, 40014, 40024, 40035, 40046, 40056, 40165, 40176, 40194, 40206, 40216, 40227, 40239, 
40250, 40260, 40272, 40284, 40297, 40310, 40323, 40333, 40343, 40353, 40363, 40373, 40383, 40393, 40403, 40414, 
40425, 40435, 40445, 40455, 40465, 40475, 40565, 40575, 40587, 40597, 40607, 40617, 40627, 40638, 40648, 40658, 
40668, 40679, 40689, 40699, 40711, 40721, 40731, 40742, 40753, 40763, 40773, 40783, 40794, 40806, 40816, 40826, 
40845, 40855, 40865, 65281, 65291, 65301, 65311, 65321, 65331, 65341, 65351, 65361, 65371, 65381, 65391, 65401, 
65411, 65421, 65431, 65507
            });

        testBytes = theseBytes(new int[]{
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
143, 162, 194, 142, 224, 142, 225, 143, 162, 240, 143, 162, 195, 161, 248, 161, 
175, 143, 162, 237, 143, 162, 236, 142, 226, 143, 162, 238, 143, 162, 180, 161, 
235, 161, 222, 161, 173, 162, 249, 143, 162, 177, 143, 162, 235, 143, 162, 196, 
143, 170, 162, 143, 170, 161, 143, 170, 164, 143, 170, 170, 143, 170, 163, 143, 
170, 169, 143, 169, 161, 143, 170, 174, 143, 170, 178, 143, 170, 177, 143, 170, 
180, 143, 170, 179, 143, 170, 192, 143, 170, 191, 143, 170, 194, 143, 170, 193, 
143, 170, 208, 143, 170, 210, 143, 170, 209, 143, 170, 212, 143, 170, 216, 143, 
170, 211, 161, 223, 143, 169, 172, 143, 170, 227, 143, 170, 226, 143, 170, 229, 
143, 170, 228, 143, 170, 242, 143, 169, 176, 143, 169, 206, 143, 171, 162, 143, 
171, 161, 143, 171, 164, 143, 171, 170, 143, 171, 163, 143, 171, 169, 143, 169, 
193, 143, 171, 174, 143, 171, 178, 143, 171, 177, 143, 171, 180, 143, 171, 179, 
143, 171, 192, 143, 171, 191, 143, 171, 194, 143, 171, 193, 143, 169, 195, 143, 
171, 208, 143, 171, 210, 143, 171, 209, 143, 171, 212, 143, 171, 216, 143, 171, 
211, 161, 224, 143, 169, 204, 143, 171, 227, 143, 171, 226, 143, 171, 229, 143, 
171, 228, 143, 171, 242, 143, 169, 208, 143, 171, 243, 143, 170, 167, 143, 170, 
175, 143, 170, 182, 143, 170, 189, 143, 170, 197, 143, 170, 200, 143, 171, 203, 
143, 171, 206, 143, 169, 173, 143, 170, 221, 143, 169, 175, 143, 170, 232, 143, 
171, 245, 143, 170, 166, 143, 170, 237, 143, 171, 185, 143, 162, 176, 143, 162, 
175, 143, 162, 184, 143, 166, 233, 166, 168, 166, 178, 143, 166, 242, 166, 199, 
166, 209, 143, 166, 250, 167, 167, 143, 167, 203, 167, 166, 167, 177, 167, 187, 
167, 212, 167, 223, 167, 233, 167, 215, 143, 167, 251, 161, 190, 161, 200, 161, 
196, 162, 243, 162, 168, 161, 238, 143, 162, 241, 143, 162, 239, 162, 171, 162, 
205, 162, 207, 162, 187, 162, 229, 162, 202, 161, 232, 162, 226, 161, 226, 162, 
227, 162, 190, 162, 221, 162, 222, 168, 161, 168, 163, 168, 177, 168, 178, 168, 
184, 168, 181, 168, 182, 162, 163, 162, 165, 162, 167, 162, 161, 162, 254, 161, 
250, 161, 234, 162, 246, 161, 161, 161, 212, 161, 204, 164, 161, 164, 171, 164, 
181, 164, 191, 164, 201, 164, 211, 164, 221, 164, 231, 164, 241, 161, 171, 165, 
165, 165, 175, 165, 185, 165, 195, 165, 205, 165, 215, 165, 225, 165, 235, 165, 
245, 176, 236, 190, 229, 179, 238, 190, 231, 143, 176, 169, 182, 250, 208, 167, 
143, 176, 178, 143, 176, 179, 143, 176, 181, 143, 176, 183, 198, 253, 180, 165, 
205, 189, 184, 223, 176, 161, 203, 242, 208, 183, 191, 205, 208, 188, 208, 186, 
201, 213, 143, 176, 201, 208, 193, 208, 195, 180, 235, 143, 176, 214, 143, 176, 
217, 143, 176, 221, 191, 173, 143, 176, 231, 143, 176, 235, 143, 176, 238, 143, 
176, 223, 143, 176, 242, 202, 187, 187, 200, 143, 177, 162, 143, 177, 168, 176, 
205, 213, 165, 191, 175, 202, 216, 143, 177, 187, 208, 215, 208, 216, 189, 164, 
202, 240, 143, 177, 203, 143, 177, 207, 143, 177, 211, 143, 177, 216, 208, 235, 
182, 230, 143, 177, 223, 143, 177, 228, 208, 243, 143, 177, 236, 143, 177, 242, 
194, 166, 208, 250, 143, 177, 251, 143, 178, 163, 143, 178, 167, 143, 178, 172, 
208, 253, 183, 185, 209, 161, 143, 178, 185, 143, 178, 189, 193, 206, 143, 178, 
197, 202, 200, 143, 178, 202, 143, 178, 210, 209, 179, 143, 178, 218, 143, 178, 
223, 209, 184, 189, 188, 143, 178, 231, 197, 222, 143, 178, 237, 209, 194, 197, 
181, 209, 196, 209, 198, 209, 204, 180, 167, 209, 209, 186, 227, 143, 178, 252, 
143, 179, 161, 143, 179, 164, 244, 165, 189, 232, 209, 224, 189, 208, 209, 227, 
209, 230, 143, 179, 183, 143, 179, 184, 209, 233, 183, 244, 196, 230, 193, 176, 
143, 179, 193, 143, 179, 199, 143, 179, 201, 143, 179, 203, 143, 179, 206, 143, 
179, 209, 143, 179, 212, 178, 195, 197, 216, 207, 171, 179, 175, 143, 179, 232, 
240, 213, 143, 179, 239, 210, 171, 143, 179, 246, 188, 219, 202, 241, 210, 183, 
186, 252, 210, 186, 143, 180, 175, 210, 190, 143, 180, 182, 143, 180, 183, 198, 
238, 143, 180, 187, 143, 180, 190, 210, 203, 210, 204, 143, 180, 198, 206, 210, 
143, 180, 204, 210, 209, 143, 180, 212, 187, 178, 193, 208, 188, 232, 143, 180, 
224, 194, 254, 143, 180, 227, 210, 222, 177, 165, 143, 180, 230, 200, 221, 143, 
180, 236, 202, 173, 202, 242, 198, 221, 143, 180, 244, 188, 254, 204, 163, 204, 
191, 143, 181, 164, 210, 240, 143, 181, 170, 143, 181, 173, 143, 181, 179, 143, 
181, 183, 143, 181, 185, 211, 166, 211, 175, 143, 181, 191, 143, 181, 193, 143, 
181, 197, 143, 181, 202, 176, 162, 143, 181, 206, 143, 181, 209, 211, 177, 143, 
181, 217, 211, 183, 143, 181, 225, 211, 193, 143, 181, 232, 143, 181, 236, 180, 
238, 183, 246, 143, 181, 244, 143, 181, 245, 143, 181, 249, 143, 182, 161, 143, 
182, 165, 143, 182, 167, 143, 182, 168, 143, 182, 170, 143, 182, 175, 143, 182, 
179, 178, 222, 143, 182, 182, 143, 182, 188, 143, 182, 195, 143, 182, 199, 143, 
182, 200, 180, 239, 143, 182, 210, 211, 230, 211, 231, 211, 233, 143, 182, 221, 
143, 182, 225, 143, 182, 231, 143, 182, 233, 211, 244, 211, 247, 143, 182, 244, 
143, 182, 250, 143, 182, 252, 185, 241, 143, 183, 165, 143, 183, 168, 143, 183, 
171, 143, 183, 177, 143, 183, 182, 212, 173, 143, 183, 188, 212, 175, 212, 179, 
143, 183, 197, 143, 183, 205, 212, 180, 212, 181, 212, 182, 143, 183, 220, 143, 
183, 225, 212, 184, 143, 183, 230, 143, 183, 231, 212, 191, 199, 184, 143, 183, 
239, 143, 183, 243, 180, 240, 143, 183, 251, 194, 196, 143, 184, 165, 180, 174, 
190, 236, 143, 184, 172, 143, 184, 173, 197, 227, 186, 201, 143, 184, 183, 212, 
199, 143, 184, 185, 143, 184, 189, 202, 232, 143, 184, 199, 203, 207, 143, 184, 
206, 143, 184, 208, 195, 197, 212, 219, 212, 224, 143, 184, 221, 143, 184, 222, 
212, 232, 202, 209, 143, 184, 228, 143, 184, 231, 194, 231, 188, 186, 212, 243, 
198, 224, 143, 184, 244, 143, 184, 248, 212, 252, 143, 185, 162, 143, 185, 167, 
199, 165, 143, 185, 172, 143, 185, 174, 197, 202, 143, 185, 182, 143, 185, 185, 
187, 207, 213, 172, 143, 185, 195, 143, 185, 198, 176, 249, 213, 178, 143, 185, 
210, 143, 185, 211, 143, 185, 215, 213, 183, 213, 180, 143, 185, 223, 186, 167, 
143, 185, 228, 143, 185, 231, 143, 185, 235, 143, 185, 238, 143, 185, 243, 143, 
185, 246, 143, 185, 251, 213, 191, 183, 249, 213, 197, 143, 186, 167, 143, 186, 
169, 143, 186, 171, 143, 186, 174, 213, 201, 213, 202, 143, 186, 182, 196, 220, 
213, 206, 213, 210, 143, 186, 187, 213, 212, 204, 210, 213, 216, 213, 218, 143, 
186, 196, 177, 167, 143, 186, 205, 176, 184, 205, 168, 143, 186, 213, 205, 198, 
213, 227, 143, 186, 221, 143, 186, 224, 178, 201, 213, 237, 195, 254, 188, 247, 
176, 211, 213, 245, 143, 186, 235, 213, 248, 143, 186, 244, 198, 244, 213, 252, 
214, 161, 143, 186, 248, 193, 216, 214, 165, 214, 168, 143, 187, 169, 214, 170, 
143, 187, 174, 193, 187, 143, 187, 181, 214, 176, 214, 180, 143, 187, 187, 143, 
187, 188, 178, 229, 143, 187, 192, 214, 183, 191, 242, 214, 194, 214, 193, 143, 
187, 201, 143, 187, 203, 143, 187, 206, 143, 187, 211, 214, 201, 214, 191, 191, 
243, 214, 205, 143, 187, 226, 143, 187, 230, 143, 187, 232, 214, 211, 143, 187, 
240, 143, 230, 244, 214, 217, 143, 187, 247, 214, 221, 192, 238, 185, 170, 184, 
202, 180, 172, 200, 193, 214, 230, 214, 231, 191, 227, 194, 211, 203, 185, 214, 
243, 143, 188, 181, 143, 188, 184, 143, 188, 187, 180, 179, 205, 196, 200, 223, 
196, 236, 214, 249, 143, 188, 201, 176, 195, 143, 188, 207, 206, 247, 179, 199, 
215, 163, 215, 168, 215, 172, 215, 176, 143, 188, 223, 181, 221, 143, 188, 227, 
184, 204, 188, 229, 143, 188, 239, 143, 188, 244, 143, 188, 247, 143, 188, 250, 
201, 167, 190, 180, 143, 189, 166, 183, 194, 143, 189, 171, 215, 208, 143, 189, 
178, 200, 249, 143, 189, 183, 191, 180, 199, 166, 187, 214, 143, 189, 195, 178, 
247, 199, 176, 215, 221, 143, 189, 210, 143, 189, 213, 143, 189, 217, 215, 226, 
143, 189, 220, 143, 189, 222, 215, 240, 143, 189, 228, 215, 239, 178, 184, 183, 
195, 143, 189, 236, 188, 189, 143, 189, 243, 143, 189, 246, 216, 166, 143, 189, 
253, 143, 190, 161, 190, 240, 143, 190, 170, 143, 190, 173, 193, 218, 194, 198, 
216, 185, 216, 180, 143, 190, 188, 182, 242, 216, 195, 143, 190, 202, 216, 198, 
143, 190, 209, 216, 216, 216, 215, 183, 197, 216, 213, 143, 190, 216, 216, 220, 
216, 225, 143, 190, 229, 198, 180, 183, 251, 143, 190, 239, 216, 234, 178, 251, 
143, 190, 246, 216, 239, 196, 168, 216, 246, 143, 191, 167, 178, 230, 216, 254, 
192, 239, 217, 165, 204, 225, 143, 191, 182, 143, 191, 184, 143, 191, 189, 143, 
191, 191, 202, 177, 200, 227, 217, 183, 143, 191, 197, 185, 179, 143, 191, 201, 
202, 250, 217, 187, 195, 180, 217, 188, 192, 219, 143, 191, 214, 143, 191, 216, 
189, 166, 217, 205, 143, 191, 225, 182, 180, 143, 191, 228, 143, 191, 231, 193, 
222, 194, 170, 143, 191, 244, 143, 191, 248, 143, 191, 252, 199, 177, 143, 192, 
167, 199, 211, 143, 192, 174, 191, 228, 183, 199, 143, 192, 180, 143, 192, 183, 
217, 231, 143, 192, 189, 217, 226, 143, 192, 195, 217, 236, 143, 192, 201, 217, 
211, 217, 238, 143, 192, 213, 183, 200, 143, 192, 217, 197, 166, 143, 192, 230, 
143, 192, 231, 204, 206, 183, 226, 143, 192, 238, 143, 192, 242, 143, 192, 247, 
199, 197, 179, 201, 143, 193, 161, 143, 193, 166, 218, 166, 197, 167, 181, 188, 
218, 177, 218, 181, 143, 193, 185, 143, 193, 188, 143, 193, 192, 143, 193, 196, 
218, 189, 202, 252, 218, 195, 143, 193, 206, 218, 201, 143, 193, 210, 218, 202, 
143, 193, 213, 202, 184, 200, 195, 218, 207, 192, 205, 187, 219, 202, 253, 218, 
211, 143, 193, 232, 143, 193, 236, 180, 251, 189, 220, 143, 193, 242, 218, 224, 
143, 193, 249, 218, 230, 143, 194, 166, 143, 194, 172, 195, 235, 143, 194, 179, 
143, 194, 182, 143, 194, 187, 179, 162, 218, 242, 195, 210, 218, 247, 218, 245, 
218, 248, 196, 170, 143, 194, 217, 219, 162, 143, 194, 224, 143, 194, 227, 219, 
163, 219, 165, 143, 194, 234, 219, 170, 194, 216, 205, 173, 143, 194, 241, 196, 
171, 219, 176, 188, 235, 181, 224, 143, 194, 249, 194, 188, 197, 206, 143, 195, 
161, 219, 191, 143, 195, 166, 219, 199, 143, 195, 170, 143, 195, 175, 219, 197, 
143, 195, 177, 143, 195, 181, 143, 195, 188, 199, 240, 143, 195, 193, 219, 207, 
219, 211, 143, 195, 184, 198, 202, 192, 242, 143, 195, 204, 143, 195, 207, 143, 
195, 212, 143, 195, 214, 143, 195, 217, 182, 205, 143, 195, 223, 201, 176, 143, 
195, 228, 143, 195, 233, 199, 223, 219, 231, 143, 195, 241, 143, 195, 245, 196, 
244, 219, 238, 180, 254, 143, 195, 254, 143, 196, 165, 220, 168, 143, 196, 173, 
220, 170, 220, 166, 196, 199, 191, 250, 220, 176, 220, 191, 143, 196, 193, 143, 
196, 195, 201, 246, 220, 194, 143, 196, 204, 143, 196, 209, 207, 176, 186, 231, 
207, 177, 220, 213, 143, 196, 222, 143, 196, 225, 220, 201, 185, 189, 143, 196, 
232, 143, 196, 234, 220, 229, 220, 223, 143, 196, 244, 143, 196, 245, 201, 184, 
220, 235, 220, 211, 220, 247, 220, 237, 143, 197, 170, 181, 204, 220, 243, 143, 
197, 180, 143, 197, 182, 143, 197, 187, 221, 161, 220, 253, 221, 168, 221, 166, 
221, 165, 143, 197, 206, 143, 197, 210, 143, 197, 213, 143, 197, 216, 221, 178, 
205, 243, 143, 197, 226, 143, 197, 230, 178, 164, 205, 223, 182, 214, 221, 188, 
143, 197, 244, 143, 197, 247, 143, 197, 249, 186, 208, 143, 197, 254, 189, 222, 
221, 205, 143, 198, 166, 143, 198, 171, 221, 213, 143, 198, 178, 143, 198, 182, 
221, 218, 221, 219, 221, 221, 143, 198, 192, 143, 198, 195, 143, 198, 199, 181, 
164, 221, 230, 143, 198, 209, 177, 202, 181, 225, 143, 198, 218, 180, 192, 221, 
233, 143, 198, 226, 143, 198, 230, 221, 235, 198, 217, 178, 173, 203, 215, 203, 
247, 202, 168, 143, 198, 246, 200, 231, 143, 198, 254, 143, 199, 163, 222, 165, 
143, 199, 170, 143, 199, 171, 143, 199, 174, 222, 172, 196, 197, 143, 199, 184, 
143, 199, 186, 190, 244, 143, 199, 189, 143, 199, 192, 179, 189, 179, 164, 143, 
199, 198, 205, 176, 143, 199, 203, 143, 199, 206, 143, 199, 208, 143, 199, 212, 
143, 199, 215, 222, 204, 143, 199, 221, 143, 199, 225, 189, 223, 143, 199, 231, 
222, 189, 222, 188, 222, 219, 178, 185, 143, 199, 237, 222, 220, 222, 218, 143, 
199, 251, 143, 200, 161, 222, 208, 143, 200, 165, 200, 174, 189, 224, 143, 200, 
170, 222, 228, 205, 207, 143, 200, 178, 143, 200, 183, 222, 237, 194, 218, 143, 
200, 187, 223, 163, 181, 249, 143, 200, 196, 143, 200, 198, 199, 249, 143, 200, 
204, 143, 200, 208, 222, 243, 143, 200, 212, 143, 200, 217, 189, 225, 196, 172, 
223, 166, 223, 173, 143, 200, 231, 143, 200, 237, 143, 200, 240, 223, 186, 143, 
200, 248, 183, 227, 143, 200, 254, 223, 190, 143, 201, 162, 143, 201, 163, 223, 
171, 143, 201, 169, 143, 201, 173, 223, 198, 223, 202, 195, 245, 223, 208, 143, 
201, 182, 143, 201, 185, 143, 201, 189, 143, 201, 192, 178, 208, 143, 201, 198, 
143, 201, 201, 177, 234, 143, 201, 208, 143, 201, 210, 223, 220, 223, 218, 206, 
245, 143, 201, 218, 223, 223, 223, 216, 223, 226, 143, 201, 230, 177, 235, 143, 
201, 234, 143, 201, 236, 193, 179, 143, 201, 242, 143, 201, 247, 223, 230, 143, 
201, 254, 223, 236, 143, 202, 162, 223, 239, 223, 237, 244, 166, 223, 241, 143, 
202, 174, 223, 245, 197, 245, 223, 246, 143, 202, 187, 187, 184, 223, 253, 224, 
162, 143, 202, 193, 143, 202, 194, 143, 202, 197, 224, 166, 224, 170, 224, 172, 
224, 175, 143, 202, 211, 143, 202, 215, 203, 210, 143, 202, 224, 143, 202, 227, 
224, 182, 224, 183, 181, 190, 184, 164, 190, 245, 143, 202, 242, 143, 202, 245, 
143, 202, 247, 224, 195, 198, 200, 224, 198, 143, 203, 162, 143, 203, 167, 224, 
200, 143, 203, 173, 143, 203, 177, 205, 177, 143, 203, 184, 143, 203, 185, 224, 
213, 189, 195, 143, 203, 199, 224, 217, 143, 203, 207, 143, 203, 210, 143, 203, 
215, 143, 203, 220, 143, 203, 225, 143, 203, 227, 178, 209, 143, 203, 236, 143, 
203, 240, 188, 238, 183, 190, 143, 203, 248, 184, 189, 206, 176, 143, 204, 168, 
143, 204, 170, 143, 204, 178, 143, 204, 182, 143, 204, 184, 143, 204, 189, 143, 
204, 192, 143, 204, 194, 143, 204, 199, 224, 247, 143, 204, 208, 143, 204, 213, 
224, 229, 143, 204, 226, 143, 204, 231, 143, 204, 234, 143, 204, 238, 143, 204, 
242, 143, 204, 245, 225, 166, 143, 204, 252, 143, 204, 254, 185, 249, 197, 188, 
225, 180, 197, 196, 196, 174, 225, 183, 143, 205, 180, 206, 177, 225, 191, 143, 
205, 187, 143, 205, 189, 143, 205, 196, 193, 193, 143, 205, 201, 225, 207, 225, 
215, 225, 214, 143, 205, 211, 225, 218, 143, 205, 216, 143, 205, 221, 143, 205, 
225, 225, 224, 143, 205, 231, 143, 205, 236, 143, 205, 242, 143, 205, 247, 225, 
240, 143, 206, 161, 143, 206, 167, 204, 254, 225, 245, 225, 252, 143, 206, 179, 
197, 208, 143, 206, 182, 187, 169, 226, 173, 143, 206, 193, 200, 233, 226, 176, 
226, 179, 143, 206, 205, 226, 181, 143, 206, 209, 226, 187, 196, 190, 189, 226, 
226, 190, 143, 206, 222, 143, 206, 228, 226, 197, 143, 206, 234, 143, 206, 239, 
143, 206, 243, 143, 206, 248, 143, 206, 253, 143, 207, 163, 143, 207, 168, 226, 
208, 226, 211, 143, 207, 176, 143, 207, 179, 143, 207, 182, 143, 207, 186, 226, 
218, 143, 207, 189, 143, 207, 192, 143, 207, 195, 182, 235, 192, 208, 186, 189, 
226, 230, 143, 207, 212, 181, 206, 203, 164, 185, 220, 143, 207, 225, 143, 207, 
228, 143, 207, 234, 200, 163, 226, 239, 226, 238, 200, 234, 143, 207, 244, 202, 
203, 143, 207, 252, 143, 208, 161, 226, 252, 200, 216, 227, 162, 143, 208, 173, 
176, 235, 143, 208, 185, 143, 208, 188, 143, 208, 190, 143, 208, 191, 143, 208, 
196, 143, 208, 200, 143, 208, 203, 143, 208, 207, 143, 208, 211, 227, 175, 190, 
205, 143, 208, 220, 143, 208, 223, 227, 180, 143, 208, 229, 143, 208, 235, 143, 
208, 238, 143, 208, 242, 143, 208, 244, 143, 208, 249, 143, 208, 252, 199, 233, 
190, 206, 176, 220, 143, 209, 172, 143, 209, 176, 143, 209, 178, 143, 209, 181, 
227, 202, 227, 203, 143, 209, 192, 178, 186, 143, 209, 198, 190, 247, 143, 209, 
206, 143, 209, 208, 143, 209, 211, 143, 209, 216, 143, 209, 219, 227, 221, 143, 
209, 223, 227, 227, 143, 209, 229, 227, 234, 227, 237, 143, 209, 234, 143, 209, 
239, 143, 209, 242, 181, 232, 143, 209, 244, 227, 250, 227, 252, 227, 247, 143, 
210, 163, 143, 210, 167, 195, 222, 228, 184, 228, 170, 228, 172, 143, 210, 180, 
143, 210, 182, 228, 176, 143, 210, 189, 143, 210, 191, 143, 210, 196, 200, 207, 
228, 189, 143, 210, 207, 198, 198, 143, 210, 212, 143, 210, 218, 143, 210, 224, 
228, 194, 143, 210, 231, 143, 210, 233, 143, 210, 237, 228, 213, 143, 210, 244, 
228, 216, 143, 210, 254, 143, 211, 164, 202, 198, 143, 211, 171, 143, 211, 173, 
206, 179, 143, 211, 176, 228, 234, 228, 236, 143, 211, 184, 143, 211, 187, 228, 
245, 228, 246, 143, 211, 199, 228, 250, 181, 234, 143, 211, 205, 143, 211, 209, 
229, 162, 143, 211, 215, 186, 217, 186, 176, 193, 200, 229, 174, 143, 211, 230, 
229, 179, 229, 177, 143, 211, 238, 143, 211, 243, 143, 211, 249, 143, 211, 252, 
229, 194, 188, 250, 143, 212, 166, 143, 212, 169, 143, 212, 174, 143, 212, 177, 
229, 206, 143, 212, 184, 143, 212, 187, 143, 212, 179, 229, 208, 143, 212, 194, 
229, 213, 203, 165, 229, 220, 143, 212, 206, 193, 161, 191, 165, 229, 229, 229, 
234, 143, 212, 221, 229, 239, 143, 212, 226, 143, 212, 229, 229, 251, 180, 204, 
143, 212, 240, 230, 163, 230, 169, 143, 212, 250, 143, 212, 254, 200, 237, 230, 
176, 230, 181, 143, 213, 171, 143, 213, 174, 143, 213, 178, 230, 192, 143, 213, 
183, 143, 213, 185, 143, 213, 187, 143, 213, 190, 143, 213, 194, 230, 203, 185, 
205, 143, 213, 203, 204, 215, 230, 212, 143, 213, 216, 204, 237, 143, 213, 226, 
230, 216, 192, 187, 143, 213, 228, 143, 213, 231, 191, 166, 143, 213, 234, 207, 
190, 190, 211, 184, 212, 143, 213, 241, 143, 213, 242, 176, 223, 143, 213, 245, 
143, 213, 250, 184, 213, 143, 213, 253, 182, 187, 187, 233, 143, 214, 170, 143, 
214, 175, 143, 214, 178, 196, 177, 143, 214, 183, 201, 229, 231, 181, 143, 214, 
193, 231, 171, 194, 220, 231, 174, 231, 178, 231, 177, 143, 214, 209, 231, 187, 
231, 190, 231, 193, 143, 214, 220, 143, 214, 224, 143, 214, 226, 143, 214, 231, 
143, 214, 236, 218, 170, 143, 214, 240, 143, 214, 244, 143, 214, 247, 143, 214, 
248, 231, 217, 143, 215, 161, 143, 215, 165, 143, 215, 167, 231, 226, 143, 215, 
171, 231, 232, 143, 215, 180, 143, 215, 184, 231, 236, 143, 215, 195, 203, 167, 
178, 234, 143, 215, 207, 143, 215, 209, 143, 215, 212, 143, 215, 216, 231, 249, 
231, 247, 183, 212, 232, 173, 143, 215, 233, 143, 215, 234, 195, 227, 232, 166, 
183, 213, 143, 215, 227, 143, 215, 253, 178, 174, 232, 174, 143, 216, 168, 143, 
216, 174, 143, 216, 176, 205, 233, 232, 207, 143, 216, 183, 143, 216, 187, 186, 
218, 143, 216, 191, 232, 203, 143, 216, 196, 143, 216, 198, 143, 216, 201, 232, 
206, 232, 212, 232, 226, 143, 216, 207, 143, 216, 212, 143, 216, 217, 198, 161, 
232, 211, 232, 216, 143, 216, 232, 190, 213, 143, 216, 236, 232, 231, 143, 216, 
240, 143, 216, 244, 143, 216, 247, 143, 216, 251, 143, 216, 254, 143, 217, 162, 
143, 217, 166, 143, 217, 171, 232, 209, 143, 217, 178, 177, 182, 143, 217, 183, 
143, 217, 188, 202, 195, 232, 254, 143, 217, 197, 143, 217, 201, 207, 207, 233, 
177, 143, 217, 216, 143, 217, 220, 177, 242, 143, 217, 228, 204, 244, 143, 217, 
232, 207, 206, 143, 217, 242, 233, 185, 143, 217, 247, 200, 205, 143, 217, 252, 
233, 193, 233, 190, 221, 177, 143, 218, 174, 205, 246, 143, 218, 178, 143, 218, 
183, 233, 200, 143, 218, 188, 143, 218, 193, 195, 238, 143, 218, 200, 143, 218, 
237, 233, 206, 143, 218, 210, 233, 219, 143, 218, 218, 143, 218, 222, 233, 217, 
233, 220, 233, 221, 233, 222, 194, 253, 203, 170, 233, 235, 195, 216, 143, 218, 
254, 143, 219, 162, 143, 219, 166, 143, 219, 172, 143, 219, 174, 233, 251, 143, 
219, 177, 233, 253, 233, 247, 234, 167, 143, 219, 192, 143, 219, 196, 234, 165, 
143, 219, 203, 205, 230, 234, 175, 143, 219, 214, 143, 219, 217, 143, 219, 222, 
143, 219, 226, 234, 187, 143, 219, 232, 143, 219, 237, 234, 192, 143, 219, 248, 
143, 219, 250, 234, 197, 143, 220, 164, 222, 167, 179, 185, 185, 213, 234, 206, 
234, 210, 182, 222, 194, 222, 194, 181, 143, 220, 190, 143, 220, 192, 184, 211, 
143, 220, 195, 143, 220, 197, 234, 227, 143, 220, 206, 234, 235, 234, 236, 234, 
233, 143, 220, 214, 179, 236, 143, 220, 222, 234, 243, 143, 220, 228, 143, 220, 
233, 234, 247, 143, 220, 240, 143, 220, 243, 235, 162, 143, 220, 250, 143, 220, 
254, 202, 164, 143, 221, 166, 179, 208, 143, 221, 173, 235, 178, 235, 180, 179, 
209, 235, 185, 191, 168, 143, 221, 189, 143, 221, 193, 143, 221, 197, 143, 221, 
199, 235, 194, 235, 196, 143, 221, 210, 191, 199, 143, 221, 217, 186, 190, 235, 
199, 143, 221, 229, 181, 205, 143, 221, 235, 235, 209, 143, 221, 243, 143, 221, 
248, 235, 216, 198, 201, 143, 222, 162, 235, 219, 180, 210, 207, 192, 235, 227, 
235, 221, 143, 222, 180, 143, 222, 183, 143, 222, 191, 235, 226, 143, 222, 189, 
235, 245, 235, 240, 235, 244, 143, 222, 201, 143, 222, 202, 201, 232, 183, 217, 
181, 196, 143, 222, 213, 218, 206, 143, 222, 221, 143, 222, 224, 195, 171, 236, 
175, 143, 222, 233, 236, 181, 190, 221, 208, 174, 143, 222, 250, 236, 186, 203, 
198, 236, 194, 185, 215, 192, 213, 236, 202, 178, 236, 194, 177, 143, 223, 178, 
199, 229, 188, 193, 143, 223, 187, 143, 223, 191, 143, 223, 194, 236, 219, 192, 
214, 143, 223, 201, 143, 223, 202, 177, 219, 143, 223, 209, 143, 223, 211, 143, 
223, 214, 143, 223, 218, 143, 223, 222, 143, 223, 227, 143, 223, 230, 236, 240, 
236, 238, 143, 223, 242, 236, 245, 236, 244, 143, 223, 250, 236, 247, 237, 169, 
236, 253, 143, 224, 171, 236, 254, 143, 224, 177, 143, 224, 181, 143, 224, 184, 
189, 179, 237, 175, 237, 179, 143, 224, 198, 237, 186, 191, 200, 143, 224, 209, 
143, 224, 212, 188, 214, 143, 224, 219, 198, 240, 237, 199, 143, 224, 225, 143, 
224, 230, 237, 210, 143, 224, 235, 143, 224, 239, 206, 216, 143, 224, 248, 237, 
217, 237, 219, 143, 225, 166, 143, 225, 170, 191, 201, 143, 225, 177, 237, 231, 
202, 213, 203, 248, 183, 222, 237, 233, 143, 225, 195, 143, 225, 197, 237, 254, 
143, 225, 203, 143, 225, 206, 237, 248, 194, 164, 143, 225, 212, 143, 225, 216, 
238, 167, 238, 166, 198, 187, 143, 225, 223, 143, 225, 226, 238, 175, 206, 203, 
237, 238, 205, 184, 143, 225, 241, 143, 225, 245, 238, 184, 143, 225, 251, 143, 
226, 163, 143, 226, 173, 143, 226, 169, 201, 244, 143, 226, 178, 143, 226, 179, 
143, 226, 185, 238, 192, 143, 226, 193, 143, 226, 199, 143, 226, 203, 143, 226, 
209, 143, 226, 212, 188, 242, 143, 226, 220, 189, 183, 185, 243, 143, 226, 228, 
238, 204, 143, 226, 237, 143, 226, 240, 238, 208, 238, 211, 143, 226, 254, 238, 
216, 143, 227, 164, 191, 203, 182, 252, 143, 227, 179, 143, 227, 182, 143, 227, 
187, 143, 227, 193, 143, 227, 198, 143, 227, 203, 143, 227, 207, 143, 227, 213, 
197, 180, 143, 227, 223, 143, 227, 226, 200, 173, 143, 227, 236, 143, 227, 242, 
189, 198, 143, 227, 251, 143, 227, 254, 143, 228, 164, 143, 228, 169, 238, 248, 
143, 228, 181, 143, 228, 188, 143, 228, 193, 143, 228, 200, 143, 228, 205, 181, 
248, 143, 228, 212, 143, 228, 214, 191, 238, 239, 162, 207, 163, 143, 228, 230, 
238, 253, 143, 228, 235, 143, 228, 241, 143, 228, 243, 239, 171, 143, 229, 161, 
143, 229, 167, 143, 229, 172, 143, 229, 176, 143, 229, 181, 143, 229, 183, 143, 
229, 188, 143, 229, 195, 239, 178, 182, 192, 143, 229, 207, 143, 229, 212, 143, 
229, 217, 143, 229, 222, 239, 197, 239, 195, 239, 196, 143, 229, 231, 143, 229, 
236, 143, 229, 238, 143, 229, 241, 239, 206, 239, 209, 239, 216, 196, 185, 239, 
217, 143, 230, 164, 239, 221, 239, 224, 143, 230, 173, 143, 230, 176, 239, 234, 
239, 235, 198, 174, 239, 243, 201, 236, 143, 230, 201, 143, 230, 203, 193, 203, 
239, 251, 143, 230, 214, 143, 230, 217, 240, 165, 198, 171, 143, 230, 224, 231, 
161, 240, 168, 143, 230, 233, 143, 230, 237, 143, 230, 240, 191, 253, 143, 230, 
242, 240, 186, 143, 230, 249, 143, 230, 250, 206, 237, 188, 251, 206, 238, 240, 
195, 143, 231, 167, 240, 199, 240, 201, 240, 205, 192, 196, 240, 208, 240, 211, 
240, 215, 143, 231, 191, 240, 217, 240, 223, 143, 231, 199, 240, 228, 202, 220, 
143, 231, 210, 240, 231, 143, 231, 223, 143, 231, 228, 143, 231, 235, 240, 236, 
143, 231, 240, 202, 199, 240, 243, 143, 231, 249, 143, 231, 252, 143, 232, 161, 
143, 232, 167, 143, 232, 170, 179, 220, 180, 234, 143, 232, 180, 143, 232, 185, 
201, 247, 143, 232, 190, 143, 232, 195, 143, 232, 199, 200, 244, 143, 232, 202, 
200, 211, 187, 244, 143, 232, 209, 143, 232, 211, 143, 232, 216, 143, 232, 220, 
143, 232, 223, 143, 232, 230, 241, 189, 241, 190, 143, 232, 242, 188, 243, 241, 
198, 143, 232, 251, 143, 233, 162, 194, 204, 195, 243, 143, 233, 170, 143, 233, 
173, 241, 209, 241, 211, 241, 215, 241, 214, 241, 217, 143, 233, 194, 143, 233, 
197, 241, 219, 143, 233, 204, 143, 233, 207, 241, 225, 241, 229, 241, 233, 185, 
252, 143, 233, 218, 241, 238, 143, 233, 228, 143, 233, 231, 143, 233, 236, 143, 
233, 240, 241, 249, 143, 233, 247, 143, 233, 254, 143, 234, 167, 242, 163, 242, 
166, 143, 234, 178, 143, 234, 182, 179, 161, 143, 234, 187, 143, 234, 189, 143, 
234, 194, 143, 234, 200, 143, 234, 205, 143, 234, 209, 143, 234, 215, 242, 184, 
143, 234, 223, 143, 234, 226, 143, 234, 230, 143, 234, 234, 242, 196, 143, 234, 
242, 194, 228, 143, 234, 247, 143, 234, 251, 143, 235, 161, 242, 218, 143, 235, 
168, 143, 235, 172, 143, 235, 177, 201, 201, 143, 235, 186, 143, 235, 188, 143, 
235, 194, 143, 235, 200, 143, 235, 205, 143, 235, 211, 242, 233, 196, 187, 242, 
236, 143, 235, 222, 178, 170, 143, 235, 225, 242, 245, 143, 235, 229, 143, 235, 
234, 242, 247, 243, 165, 177, 173, 143, 235, 248, 143, 235, 252, 143, 236, 163, 
143, 236, 167, 143, 236, 173, 143, 236, 175, 243, 170, 143, 236, 180, 143, 236, 
183, 143, 236, 186, 243, 186, 143, 236, 193, 143, 236, 198, 143, 236, 202, 243, 
191, 143, 236, 207, 143, 236, 210, 243, 193, 243, 195, 188, 175, 243, 200, 243, 
203, 206, 219, 243, 207, 143, 236, 238, 221, 224, 143, 236, 242, 185, 245, 243, 
217, 143, 236, 247, 143, 236, 252, 243, 228, 243, 231, 143, 237, 168, 143, 237, 
175, 143, 237, 178, 143, 237, 182, 201, 161, 143, 237, 194, 240, 237, 143, 237, 
202, 243, 245, 143, 237, 210, 143, 237, 214, 206, 182, 143, 237, 222, 143, 237, 
224, 161, 170, 161, 220, 163, 181, 161, 169, 163, 201, 163, 211, 161, 207, 163, 
231, 163, 241, 161, 208, 142, 165, 142, 175, 142, 185, 142, 195, 142, 205, 142, 
215, 161, 177
            });

        super.setUp();
    }

    @TestTargetNew(
        level = TestLevel.PARTIAL_COMPLETE,
        notes = "Duplicate Characters.",
        method = "functionalCoDec_REPR",
        args = {}
    )
    @Override
    public void test_CodecDynamic () throws CharacterCodingException {
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        CharBuffer inputCB = CharBuffer.allocate(65536);
        for (int code = 32; code <= 65533; code ++) {
            if ((encoder.canEncode((char) code))
                    && (code != 165) && (code != 8254) && (code != 63599)) {
                inputCB.put((char) code);
            }
        }
        inputCB.rewind();
        ByteBuffer intermediateBB = encoder.encode(inputCB);
        inputCB.rewind();
        intermediateBB.rewind();
        CharBuffer outputCB = decoder.decode(intermediateBB);
        outputCB.rewind();
        assertEqualCBs("decode(encode(A)) must be identical with A!",
                inputCB, outputCB);
    }

}
