/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_expf_intel_data[] = {
  { // Entry 0
    0x1.e0fabf081222780d74c00fda30aa3943p-1,
    -0x1.000006p-4
  },
  { // Entry 1
    0x1.e0fabecbf2ca9acd25eef63af858ed60p-1,
    -0x1.000008p-4
  },
  { // Entry 2
    0x1.fc03fccfb913167ecfa84f48f5b7205bp-1,
    -0x1.000022p-7
  },
  { // Entry 3
    0x1.c3d642ff9bf2d294c0ce088e8bad27b3p-1,
    -0x1.0001b0p-3
  },
  { // Entry 4
    0x1.ff800efaebb8218fc5d491b9868689aap-1,
    -0x1.000208p-10
  },
  { // Entry 5
    0x1.8ebd9d0446182e9056f60489fcd002cdp-1,
    -0x1.000380p-2
  },
  { // Entry 6
    0x1.e0f995010fd96d3f294c3ffe0e512426p-1,
    -0x1.0009f0p-4
  },
  { // Entry 7
    0x1.78a3bb4c17adf5b2d40e6ee3dbd4866fp-2,
    -0x1.000cp0
  },
  { // Entry 8
    0x1.ffdffd003aacbfca6591e7a38368b94cp-1,
    -0x1.0020p-12
  },
  { // Entry 9
    0x1.fdff416aa3827d6335a1ffa43d440562p-1,
    -0x1.00e0p-8
  },
  { // Entry 10
    0x1.99007ffbdffac31dff90da5ee46a16fap-47,
    -0x1.00e0p5
  },
  { // Entry 11
    0x1.35c0dcfffb4419dc29555c232f3cdca7p-1,
    -0x1.014ep-1
  },
  { // Entry 12
    0x1.fbed9ac7ed032abfc76306a3e1dc816bp-1,
    -0x1.05a4p-7
  },
  { // Entry 13
    0x1.efddb9cccd73f71a4b2b8c01a57ae75fp-1,
    -0x1.064cp-5
  },
  { // Entry 14
    0x1.fffdf1010f37e2f1f5fca8b9c13aff70p-1,
    -0x1.0780p-16
  },
  { // Entry 15
    0x1.efc35653912fade6a17a8f8ef4109679p-1,
    -0x1.08p-5
  },
  { // Entry 16
    0x1.8b3096fffcbe737961f8c61cdf9d7137p-1,
    -0x1.092c68p-2
  },
  { // Entry 17
    0x1.fbdd1ce561f9d0a689812e5bea089f9cp-1,
    -0x1.09ccp-7
  },
  { // Entry 18
    0x1.efa1ef8a19d40bb22c5d3c315991e15fp-1,
    -0x1.0a28p-5
  },
  { // Entry 19
    0x1.ffffef09ce47ecc03d1d11f9491e6519p-1,
    -0x1.0f6320p-21
  },
  { // Entry 20
    0x1.ffffef09c047ed36f8aa1a7e67e26528p-1,
    -0x1.0f64p-21
  },
  { // Entry 21
    0x1.8890636e31f543b3853b1b305daeb933p-1,
    -0x1.10p-2
  },
  { // Entry 22
    0x1.ffffef0000483fff334aac5dabfd1c7dp-1,
    -0x1.10p-21
  },
  { // Entry 23
    0x1.ef1c2d002f7639d4d82edc01eaad1dedp-1,
    -0x1.12ccp-5
  },
  { // Entry 24
    0x1.de7f010d1c6494139b0531bd5b8f108bp-1,
    -0x1.1534p-4
  },
  { // Entry 25
    0x1.02057d1245ceaf62a21099d4441a36dbp-101,
    -0x1.18p6
  },
  { // Entry 26
    0x1.e9040734a16333567cf6f31bc90d4355p-27,
    -0x1.211588p4
  },
  { // Entry 27
    0x1.8d03f8ffffb1a2622bba81d6ab4a92ffp-14,
    -0x1.287d08p3
  },
  { // Entry 28
    0x1.e97e430257e75f497f6a3efe51ff5054p-112,
    -0x1.33efeap6
  },
  { // Entry 29
    0x1.c69c518ea7c58842c178fbd9e8cf536ep-117,
    -0x1.421888p6
  },
  { // Entry 30
    0x1.df2a0f92c17e9ff0bfb77b7abbe637a6p-126,
    -0x1.5ad6b6p6
  },
  { // Entry 31
    0x1.782f23068c10b1c5513dc3b0192d30d4p-127,
    -0x1.5e9444p6
  },
  { // Entry 32
    0x1.710602f9f4288348cc8348472a24f93dp-127,
    -0x1.5ea7f2p6
  },
  { // Entry 33
    0x1.65ab7994ff3440dcd3ee7f9b9a02423ap-127,
    -0x1.5ec7f2p6
  },
  { // Entry 34
    0x1.6031cc454f1c3e0126b71bf21e903d20p-127,
    -0x1.5ed7bep6
  },
  { // Entry 35
    0x1.b78f6800030fb7ec7984a3e7419d6fc2p-129,
    -0x1.638066p6
  },
  { // Entry 36
    0x1.f9363f3583279ac24e757eeb7654910cp-3,
    -0x1.664ee0p0
  },
  { // Entry 37
    0x1.d617f10e63adfcd67414c08dc6f9d010p-9,
    -0x1.685b44p2
  },
  { // Entry 38
    0x1.cf8c4503bf17d8c7647e93a153af37b6p-9,
    -0x1.6941p2
  },
  { // Entry 39
    0x1.d470b70e90d5097e87b925c5f63fee7dp-1,
    -0x1.6c3328p-4
  },
  { // Entry 40
    0x1.a9c0a5010de85f9a60c8104f37fc597fp-1,
    -0x1.79c984p-3
  },
  { // Entry 41
    0x1.dff126fffcdde3436322ba09db4556e1p-2,
    -0x1.83ff38p-1
  },
  { // Entry 42
    0x1.da1b8301af81384b8e495c9a4f97497fp-72,
    -0x1.8a529ep5
  },
  { // Entry 43
    0x1.babaf4ffffe29025ce751094aecf9b03p-19,
    -0x1.93e788p3
  },
  { // Entry 44
    0x1.6e953afffec7fc3b5dda17c820678821p-43,
    -0x1.d723f8p4
  },
  { // Entry 45
    0x1.ff0ff6f3d9f493ed610364861a995664p-1,
    -0x1.e082c4p-10
  },
  { // Entry 46
    0x1.ff38a40a3bc33f65f4bed5de0bdfc397p-45,
    -0x1.e7fffep4
  },
  { // Entry 47
    0x1.8028990034fcc8f33443321db08c6de8p-2,
    -0x1.f5f922p-1
  },
  { // Entry 48
    0x1.ff0248f1a17418e63d4711f3e66b7c25p-1,
    -0x1.fbecp-10
  },
  { // Entry 49
    0x1.ff0246f29f2c26c5ed51d16498d1d68ep-1,
    -0x1.fbf0p-10
  },
  { // Entry 50
    0x1.fa87f66f812849292290a9f6268ef2f9p-24,
    -0x1.fe7ffep3
  },
  { // Entry 51
    0x1.ff0046f2d716c095770d849e182a3bb2p-1,
    -0x1.fff1fep-10
  },
  { // Entry 52
    0x1.e0fb2911655006422a15c3c03f8ce847p-1,
    -0x1.fff8fep-5
  },
  { // Entry 53
    0x1.ff0040f4d6cac316bdcfa13cc5af7e7cp-1,
    -0x1.fffep-10
  },
  { // Entry 54
    0x1.ffe001081a28c420260a161b12fbb97dp-1,
    -0x1.ffff7ep-13
  },
  { // Entry 55
    0x1.0000010000008000002aaaaab5555557p0,
    0x1.p-24
  },
  { // Entry 56
    0x1.426436f5aec1c313a6d2bbcd58a388dep92,
    0x1.000022p6
  },
  { // Entry 57
    0x1.a615e50a5e54e1f2f7e57c3f0ff90c61p0,
    0x1.0004p-1
  },
  { // Entry 58
    0x1.d95d63014ce5cdcd113fee0a4be67902p2,
    0x1.002038p1
  },
  { // Entry 59
    0x1.762b6304e19f3518e90348b5d9dc544ep11,
    0x1.0022p3
  },
  { // Entry 60
    0x1.a636e00a0cd5b85262756d50b95ccc88p0,
    0x1.002cp-1
  },
  { // Entry 61
    0x1.8ca6d30587af504a6f69d3a57bf3e6a8p11,
    0x1.02p3
  },
  { // Entry 62
    0x1.dfa2d701da98a148063c3ca6d13f1bcep93,
    0x1.045cb6p6
  },
  { // Entry 63
    0x1.6340e70000e296e79073670ef9c0915dp1,
    0x1.05533ep0
  },
  { // Entry 64
    0x1.ef595b018549442ec73e3d5161768d16p5,
    0x1.080d74p2
  },
  { // Entry 65
    0x1.89acdf26f99012ec527c5e9e7c47117fp47,
    0x1.0810eep5
  },
  { // Entry 66
    0x1.f33bef00003ab93a467c94fc95deed30p5,
    0x1.088d74p2
  },
  { // Entry 67
    0x1.b0f34affff9dc2430b31c2ea04f9df90p95,
    0x1.097f6ap6
  },
  { // Entry 68
    0x1.6b4ae5522604e10273283efbf9f626c9p1,
    0x1.0b0dbap0
  },
  { // Entry 69
    0x1.000011000090800332d562ed602e3824p0,
    0x1.10p-20
  },
  { // Entry 70
    0x1.b380b0f6a12fa19df391f5034b8ae31bp0,
    0x1.1009a4p-1
  },
  { // Entry 71
    0x1.b5d293f5bfa20416721999c6be03a195p0,
    0x1.12c1fep-1
  },
  { // Entry 72
    0x1.b6609ff785a04630531354d1924f8d11p0,
    0x1.1368p-1
  },
  { // Entry 73
    0x1.78241affffd1cf967a9eec663f45677ep1,
    0x1.13f37ap0
  },
  { // Entry 74
    0x1.b77660f58bcb1ee2d757a97f82c8223dp0,
    0x1.14acp-1
  },
  { // Entry 75
    0x1.7b4d6f06cf0fbd1fbc05d50908352075p1,
    0x1.1618p0
  },
  { // Entry 76
    0x1.2765810002c2eb4265308ac8b12afa3bp0,
    0x1.252726p-3
  },
  { // Entry 77
    0x1.92b0acffff1c8646d4075976f62dfbc2p1,
    0x1.25693ep0
  },
  { // Entry 78
    0x1.fbd224c7e1970bed868fadc8012c85aep13,
    0x1.364486p3
  },
  { // Entry 79
    0x1.06007d00084349f9491104f20c89f2f9p28,
    0x1.36e696p4
  },
  { // Entry 80
    0x1.5ec18400003419ad3815b41c45384dccp0,
    0x1.427898p-2
  },
  { // Entry 81
    0x1.b23fdacfa3e0d9d21b342983e159fedcp118,
    0x1.49477cp6
  },
  { // Entry 82
    0x1.fea000e2438214ca9155d4c91bd29e9ap119,
    0x1.4cb32cp6
  },
  { // Entry 83
    0x1.f67176c19fee0c9a8d1c9cbb2d73b617p120,
    0x1.4f686ap6
  },
  { // Entry 84
    0x1.d1c241024d841bd52972be6182633733p121,
    0x1.51e090p6
  },
  { // Entry 85
    0x1.cde2dd070c7de9cb58c0caed927145d8p3,
    0x1.55b4e2p1
  },
  { // Entry 86
    0x1.f7109009cd3494af526c18af019055eep0,
    0x1.59e08ep-1
  },
  { // Entry 87
    0x1.fa7c26c12afb87b5b2b151e654f6eb90p0,
    0x1.5d58aep-1
  },
  { // Entry 88
    0x1.cf3d46cb98a571871f6dee1a80581a52p126,
    0x1.5fb7ecp6
  },
  { // Entry 89
    0x1.fd8718f3d3ed8f4a5d8dec6ae7327159p7,
    0x1.6294e2p2
  },
  { // Entry 90
    0x1.feaffef3e736b71569a474042054e8b7p7,
    0x1.62ba22p2
  },
  { // Entry 91
    0x1.f76ba46733f4146a0f94b3d1311494bcp127,
    0x1.62d2e2p6
  },
  { // Entry 92
    0x1.fd7b9f01b4df08855feb29023232fd99p127,
    0x1.62df24p6
  },
  { // Entry 93
    0x1.ff691e6dd71bc8cb1f1fcffcc32cb982p127,
    0x1.62e302p6
  },
  { // Entry 94
    0x1.ffce0a9e4fc6762c91f1a0ce358a8487p127,
    0x1.62e3ccp6
  },
  { // Entry 95
    0x1.fffc0109c402d8b23bfea3a14835831bp15,
    0x1.62e3f0p3
  },
  { // Entry 96
    0x1.fff1086632b0e9b93bc5be44d9c1dea7p127,
    0x1.62e412p6
  },
  { // Entry 97
    0x1.fff608470786d7e47ef11662f1790c2ap127,
    0x1.62e41cp6
  },
  { // Entry 98
    0x1.232b96ffec147bb31695595878ba4f9dp4,
    0x1.735e70p1
  },
  { // Entry 99
    0x1.8d2c990317660e21a64ba7723f5e0ed3p8,
    0x1.7fp2
  },
  { // Entry 100
    0x1.ed379f025781ddca240c83375ee496abp70,
    0x1.89689ap5
  },
  { // Entry 101
    0x1.3687410000e2c9f8732208c97919fb0ep0,
    0x1.8b76d0p-3
  },
  { // Entry 102
    0x1.312e79ff522af71b9e2e837bf8872972p2,
    0x1.8fe0cap0
  },
  { // Entry 103
    0x1.7008f10020226e4f59b5afd8c117c096p4,
    0x1.915afcp1
  },
  { // Entry 104
    0x1.de75e90225ec6da2cfb39dca6440b688p75,
    0x1.a4e438p5
  },
  { // Entry 105
    0x1.79f0650095fd426dce8aa803e9a4fc98p9,
    0x1.a82f30p2
  },
  { // Entry 106
    0x1.2e02d6fffffed97f27dcc3742472ffa4p1,
    0x1.b78498p-1
  },
  { // Entry 107
    0x1.fa2b60fffffeea1c7bd1c78bb5c46b17p9,
    0x1.bae196p2
  },
  { // Entry 108
    0x1.000734ffffffbaba4820a2b79d296d63p0,
    0x1.cd3982p-14
  },
  { // Entry 109
    0x1.d54158f5434edb2a234359befb2209bcp10,
    0x1.e26570p2
  },
  { // Entry 110
    0x1.99fb290176ec010d068c5f888a18d847p87,
    0x1.e632aap5
  },
  { // Entry 111
    0x1.bc8e5300003e12eaf0ea04b8c5076474p2,
    0x1.f02d68p0
  },
  { // Entry 112
    0x1.565672ffffe78168cea9ed1deed2c472p1,
    0x1.f7b05cp-1
  },
  { // Entry 113
    0x1.a664dced7cc33ede965392722b0d87bfp22,
    0x1.f7fffep3
  },
  { // Entry 114
    0x1.fe8bfd38762490c7f68e80a4bdf3a17dp90,
    0x1.f896a2p5
  },
  { // Entry 115
    0x1.cc24d50c16500084754fbddc60e7276cp2,
    0x1.f8fffep0
  },
  { // Entry 116
    0x1.72151c69ff0e9850b88cbd9a600fea50p11,
    0x1.ff900ep2
  },
  { // Entry 117
    0x1.3d59d2d8b22b41c2bb6334c9be7be902p92,
    0x1.ffdffep5
  },
  { // Entry 118
    0x1.74875300042b943ba368994eec8dcb0ep11,
    0x1.fffbfep2
  },
  { // Entry 119
    0x1.d8e6090cefe80487948c01efe3cf4c5ap2,
    0x1.ffffdcp0
  },
  { // Entry 120
    0x1.000000fffffe7ffffe2aaaabb5555702p0,
    0x1.fffffcp-25
  },
  { // Entry 121
    0x1.304d1ed9511bf5a6a5b20e4cdbf6d8ffp69,
    0x1.7ffffep5
  },
  { // Entry 122
    0x1.304d6aeca254b3af4bc5d6293d5f65c7p69,
    0x1.80p5
  },
  { // Entry 123
    0x1.304db70006924866bc1845097c91e488p69,
    0x1.800002p5
  },
  { // Entry 124
    0x1.f8e64411b4c7429f260cb72539880919p-76,
    -0x1.a00002p5
  },
  { // Entry 125
    0x1.f8e6c24b5592e3421df27acf1e080144p-76,
    -0x1.a0p5
  },
  { // Entry 126
    0x1.f8e7408515ecf009cb5b7fe80003ae74p-76,
    -0x1.9ffffep5
  },
  { // Entry 127
    0x1.5576f0dcac21787f2d57b14a700224e3p115,
    0x1.3ffffep6
  },
  { // Entry 128
    0x1.55779b984f3eb3c8a503b4a8e2489d98p115,
    0x1.40p6
  },
  { // Entry 129
    0x1.5578465447b9d5f83246af1e48e8225bp115,
    0x1.400002p6
  },
  { // Entry 130
    0x1.07b68d505a60dd444b8b2bdfe06038cfp-127,
    -0x1.600002p6
  },
  { // Entry 131
    0x1.07b7112bc1ffe19d3e703e4a794f7372p-127,
    -0x1.60p6
  },
  { // Entry 132
    0x1.07b795076b8caa412334e7ddf18b00f5p-127,
    -0x1.5ffffep6
  },
  { // Entry 133
    0x1.039924428f47511c03e75dd623bc47e1p75,
    0x1.9ffffep5
  },
  { // Entry 134
    0x1.03996528e074bebcfd76416fc2c0eb92p75,
    0x1.a0p5
  },
  { // Entry 135
    0x1.0399a60f41dbc2b085221312f505089dp75,
    0x1.a00002p5
  },
  { // Entry 136
    0x1.aeba4f3502d837951889740890747609p-70,
    -0x1.800002p5
  },
  { // Entry 137
    0x1.aebabae3a41b4be3f576e70303a37932p-70,
    -0x1.80p5
  },
  { // Entry 138
    0x1.aebb2692604a0be10cc9f3a09e77aae1p-70,
    -0x1.7ffffep5
  },
  { // Entry 139
    0x1.f1047545465f97aad6774dfe16b960e2p126,
    0x1.5ffffep6
  },
  { // Entry 140
    0x1.f1056dc7bf22d3de0ed57615bc501f8bp126,
    0x1.60p6
  },
  { // Entry 141
    0x1.f106664ab4276b833993050c9aa09a95p126,
    0x1.600002p6
  },
  { // Entry 142
    0x1.7fd8b4e6e875b5988aeb2e9083caf791p-116,
    -0x1.400002p6
  },
  { // Entry 143
    0x1.7fd974d372e4486f72358acdd12690e5p-116,
    -0x1.40p6
  },
  { // Entry 144
    0x1.7fda34c05d49387b3838c5c2bfad0123p-116,
    -0x1.3ffffep6
  },
  { // Entry 145
    0x1.6a32e160645dc5364da93c123215c591p-107,
    -0x1.274768p6
  },
  { // Entry 146
    0x1.42a280b47f1e50e7307c9599e94975dap-121,
    -0x1.4e8ed0p6
  },
  { // Entry 147
    0x1.1f6479d6e79d924759c7f44160ad30e3p-135,
    -0x1.75d638p6
  },
  { // Entry 148
    0x1.ffffffefa39ef39a7f254535d935142bp-2,
    -0x1.62e430p-1
  },
  { // Entry 149
    0x1.000000f7d1cff19f0f33036cf01c120cp-1,
    -0x1.62e42ep-1
  },
  { // Entry 150
    0x1.000001f7d1d16970dfcb360efa91fea0p-1,
    -0x1.62e42cp-1
  },
  { // Entry 151
    0x1.6a09e6622aebfbd7a4a03777223c604fp-1,
    -0x1.62e430p-2
  },
  { // Entry 152
    0x1.6a09e7172fdf5a2e5771f3866a25514ep-1,
    -0x1.62e42ep-2
  },
  { // Entry 153
    0x1.6a09e7cc34d3130784097b8d8a7c9008p-1,
    -0x1.62e42cp-2
  },
  { // Entry 154
    0x1.ae89f9923cbb49183aabb33b9de1bc82p-1,
    -0x1.62e430p-3
  },
  { // Entry 155
    0x1.ae89f9fddf39bb1bb94baa36c98abb7bp-1,
    -0x1.62e42ep-3
  },
  { // Entry 156
    0x1.ae89fa6981b84807d78b7f25910956dep-1,
    -0x1.62e42cp-3
  },
  { // Entry 157
    0x1.d5818dcdda301bca95fbcc530ab9b938p-1,
    -0x1.62e430p-4
  },
  { // Entry 158
    0x1.d5818e088a61d930df1b087a4b928ea0p-1,
    -0x1.62e42ep-4
  },
  { // Entry 159
    0x1.d5818e433a939ded2e7266cb13d29986p-1,
    -0x1.62e42cp-4
  },
  { // Entry 160
    0x1.ea4afa294e60b4bfa24494610e75261cp-1,
    -0x1.62e430p-5
  },
  { // Entry 161
    0x1.ea4afa47f3105849adccfa1dd5b3f93dp-1,
    -0x1.62e42ep-5
  },
  { // Entry 162
    0x1.ea4afa6697bffdbe044fa7cdad4b3ee7p-1,
    -0x1.62e42cp-5
  },
  { // Entry 163
    0x1.f50765b6643efaa2ca9e6690933e5c37p-1,
    -0x1.62e430p-6
  },
  { // Entry 164
    0x1.f50765c60c7a28948d82f31a7288232fp-1,
    -0x1.62e42ep-6
  },
  { // Entry 165
    0x1.f50765d5b4b557039240f127705c11e7p-1,
    -0x1.62e42cp-6
  },
  { // Entry 166
    0x1.059b0d214186cff9a974bcb883cf68dep0,
    0x1.62e42cp-6
  },
  { // Entry 167
    0x1.059b0d296e5f3924690ce10533fe599bp0,
    0x1.62e42ep-6
  },
  { // Entry 168
    0x1.059b0d319b37a2908f684fad7bfb94d0p0,
    0x1.62e430p-6
  },
  { // Entry 169
    0x1.0b5586aeb68ea24c9281f25b79d84f83p0,
    0x1.62e42cp-5
  },
  { // Entry 170
    0x1.0b5586bf6be70dbda62f7148cd5a788fp0,
    0x1.62e42ep-5
  },
  { // Entry 171
    0x1.0b5586d0213f7a3a0f63afa207ea7587p0,
    0x1.62e430p-5
  },
  { // Entry 172
    0x1.172b838327ae1f9d7e70418a476da480p0,
    0x1.62e42cp-4
  },
  { // Entry 173
    0x1.172b83a60d1e9230cb3b52cd1200b8dcp0,
    0x1.62e42ep-4
  },
  { // Entry 174
    0x1.172b83c8f28f0920c614fc4456de049fp0,
    0x1.62e430p-4
  },
  { // Entry 175
    0x1.306fe00d521c5b35bf373738b0a12e1ap0,
    0x1.62e42cp-3
  },
  { // Entry 176
    0x1.306fe0596e14680dc54f3a2ea15e3afcp0,
    0x1.62e42ep-3
  },
  { // Entry 177
    0x1.306fe0a58a0c87ecc96cd405d8b582dbp0,
    0x1.62e430p-3
  },
  { // Entry 178
    0x1.6a09e503b2a7dd99cf9474b115a73ecep0,
    0x1.62e42cp-2
  },
  { // Entry 179
    0x1.6a09e5b8b79a8cb4602b42cd4c99e60ep0,
    0x1.62e42ep-2
  },
  { // Entry 180
    0x1.6a09e66dbc8d96516a303ed0289c5d36p0,
    0x1.62e430p-2
  },
  { // Entry 181
    0x1.fffffc105c64ec3292f2afac3f1a430dp0,
    0x1.62e42cp-1
  },
  { // Entry 182
    0x1.fffffe105c61fc8ef63c65c66a9d4971p0,
    0x1.62e42ep-1
  },
  { // Entry 183
    0x1.000000082e308675abcb3c215eacf84ap1,
    0x1.62e430p-1
  },
  { // Entry 184
    0x1.fffff820b8d19779692fb0fcc0281246p1,
    0x1.62e42cp0
  },
  { // Entry 185
    0x1.fffffc20b8c5d8eaff4ac013cf734639p1,
    0x1.62e42ep0
  },
  { // Entry 186
    0x1.000000105c610d2e42f45922768a8e6cp2,
    0x1.62e430p0
  },
  { // Entry 187
    0x1.fffff04171c22b43a28d8088c347bf1fp3,
    0x1.62e42cp1
  },
  { // Entry 188
    0x1.fffff8417193310a429b71e70d792186p3,
    0x1.62e42ep1
  },
  { // Entry 189
    0x1.00000020b8c21b6833603e51897c598cp4,
    0x1.62e430p1
  },
  { // Entry 190
    0x1.ffffe082e40047c89dfa41d09c1e1ef8p7,
    0x1.62e42cp2
  },
  { // Entry 191
    0x1.fffff082e3445ee55b3fa84a5dd849c9p7,
    0x1.62e42ep2
  },
  { // Entry 192
    0x1.0000004171843aff1c9ef14341bfa42ep8,
    0x1.62e430p2
  },
  { // Entry 193
    0x1.ffffc105c9f0548760a823b0dfdaeb66p15,
    0x1.62e42cp3
  },
  { // Entry 194
    0x1.ffffe105c700b10c3e2a549fbdebb0dap15,
    0x1.62e42ep3
  },
  { // Entry 195
    0x1.00000082e30886b910b9d8752828389dp16,
    0x1.62e430p3
  },
  { // Entry 196
    0x1.ffff820b9b9fbc6d5dda406ad9f93354p31,
    0x1.62e42cp4
  },
  { // Entry 197
    0x1.ffffc20b8fe12f101740ac9653f78fe3p31,
    0x1.62e42ep4
  },
  { // Entry 198
    0x1.00000105c611505d7f74a41433312dp32,
    0x1.62e430p4
  },
  { // Entry 199
    0x1.fffe082f28688d3872ab8aa69f3dc358p127,
    0x1.62e42cp6
  },
  { // Entry 200
    0x1.ffff082e6c7fed1d3fd5cff7e1f60591p127,
    0x1.62e42ep6
  },
  { // Entry 201
    HUGE_VALF,
    0x1.62e430p6
  },
  { // Entry 202
    0.0f,
    -0x1.9d1da2p6
  },
  { // Entry 203
    0.0f,
    -0x1.9d1da0p6
  },
  { // Entry 204
    0x1.0000733d37b1d08a80d7f5b45a57b888p-149,
    -0x1.9d1d9ep6
  },
  { // Entry 205
    0x1.8ebef92368a3eafa519740584c0bc3b4p-1,
    -0x1.000002p-2
  },
  { // Entry 206
    0x1.8ebef9eac820ae8682b9793ac6d1e772p-1,
    -0x1.p-2
  },
  { // Entry 207
    0x1.8ebefa4e77df35ae82b57af121518cefp-1,
    -0x1.fffffep-3
  },
  { // Entry 208
    0x1.c3d6a1dde27992e129ed78a65573f878p-1,
    -0x1.000002p-3
  },
  { // Entry 209
    0x1.c3d6a24ed82218787d624d3e5eba95f5p-1,
    -0x1.p-3
  },
  { // Entry 210
    0x1.c3d6a28752f665db2eea1fa5876798a3p-1,
    -0x1.fffffep-4
  },
  { // Entry 211
    0x1.e0fabf8050d24919d357946f9e880754p-1,
    -0x1.000002p-4
  },
  { // Entry 212
    0x1.e0fabfbc702a3ce5e31fe0609358bafdp-1,
    -0x1.p-4
  },
  { // Entry 213
    0x1.e0fabfda7fd6399d632391f9771f3e82p-1,
    -0x1.fffffep-5
  },
  { // Entry 214
    0x1.f03f568987680f8419de7d66d0a619ecp-1,
    -0x1.000002p-5
  },
  { // Entry 215
    0x1.f03f56a88b5d7914b00abf97762735d1p-1,
    -0x1.p-5
  },
  { // Entry 216
    0x1.f03f56b80d582e9712e15df3cc9e8e9cp-1,
    -0x1.fffffep-6
  },
  { // Entry 217
    0x1.f80feab02e7af3675b36eb6c3c71a5eep-1,
    -0x1.000002p-6
  },
  { // Entry 218
    0x1.f80feabfeefa4927d10bdd54ead5aa46p-1,
    -0x1.p-6
  },
  { // Entry 219
    0x1.f80feac7cf39f4374d745808a78130ecp-1,
    -0x1.fffffep-7
  },
  { // Entry 220
    0x1.fc03fd4eba125a4d3455bf72cbc939f7p-1,
    -0x1.000002p-7
  },
  { // Entry 221
    0x1.fc03fd56aa224f97fcbf1332988842dep-1,
    -0x1.p-7
  },
  { // Entry 222
    0x1.fc03fd5aa22a4a49490bad128ba5af93p-1,
    -0x1.fffffep-8
  },
  { // Entry 223
    0x1.fe00ffa6c3f9bd20292897f42d7b9d76p-1,
    -0x1.000002p-8
  },
  { // Entry 224
    0x1.fe00ffaabffbbc71ad1e1184afc19c7ep-1,
    -0x1.p-8
  },
  { // Entry 225
    0x1.fe00ffacbdfcbc1d6c1a4dcc11ddb6d8p-1,
    -0x1.fffffep-9
  },
  { // Entry 226
    0x1.ff003ff357aa48970957a2cf7d7a6cacp-1,
    -0x1.000002p-9
  },
  { // Entry 227
    0x1.ff003ff556aa888b60820b6087d1e91ap-1,
    -0x1.p-9
  },
  { // Entry 228
    0x1.ff003ff6562aa8864bb757a4ed8d9686p-1,
    -0x1.fffffep-10
  },
  { // Entry 229
    0x1.ff800ffdaafff6efe4df3f7f5ce23accp-1,
    -0x1.000002p-10
  },
  { // Entry 230
    0x1.ff800ffeaabffeeefa4f3cf70f59d9bfp-1,
    -0x1.p-10
  },
  { // Entry 231
    0x1.ff800fff2aa002eeb4fb3d32c498a8ffp-1,
    -0x1.fffffep-11
  },
  { // Entry 232
    0x1.fff0003fdf5656a6a9932df6283cfcbdp-1,
    -0x1.000002p-13
  },
  { // Entry 233
    0x1.fff0003fff5556aaa8888b60b2cb2ff2p-1,
    -0x1.p-13
  },
  { // Entry 234
    0x1.fff000400f54d6aca8c334161010099ep-1,
    -0x1.fffffep-14
  },
  { // Entry 235
    0x1.48b5e371ba9f7fc224c75d198fe4cd1bp0,
    0x1.fffffep-3
  },
  { // Entry 236
    0x1.48b5e3c3e81866767bc3b69baabe534ep0,
    0x1.p-2
  },
  { // Entry 237
    0x1.48b5e468430a7181447647fc03adbfb6p0,
    0x1.000002p-2
  },
  { // Entry 238
    0x1.221604372c9c46732dd72e996c9e23f2p0,
    0x1.fffffep-4
  },
  { // Entry 239
    0x1.2216045b6f5ccf9ced688384e06b8d42p0,
    0x1.p-3
  },
  { // Entry 240
    0x1.221604a3f4ddef8974c0079f23fd0bb9p0,
    0x1.000002p-3
  },
  { // Entry 241
    0x1.1082b566cb2380e0be0d559a0150172fp0,
    0x1.fffffep-5
  },
  { // Entry 242
    0x1.1082b577d34ed7d5b1a019e225c9a951p0,
    0x1.p-4
  },
  { // Entry 243
    0x1.1082b599e3a588f120e61af4869c9842p0,
    0x1.000002p-4
  },
  { // Entry 244
    0x1.082055f8d17c19a67be4f7058e9a570ap0,
    0x1.fffffep-6
  },
  { // Entry 245
    0x1.08205601127ec98e0bd083aba80c97a6p0,
    0x1.p-5
  },
  { // Entry 246
    0x1.0820561194842a2343e81fd5fab451efp0,
    0x1.000002p-5
  },
  { // Entry 247
    0x1.04080ab14dc366ad6116c39e3c2d0a9ep0,
    0x1.fffffep-7
  },
  { // Entry 248
    0x1.04080ab55de3917ab864b3e9044e6b45p0,
    0x1.p-6
  },
  { // Entry 249
    0x1.04080abd7e23e746288296c1313f21b1p0,
    0x1.000002p-6
  },
  { // Entry 250
    0x1.02020153fc40586235decf4eb727a15fp0,
    0x1.fffffep-8
  },
  { // Entry 251
    0x1.0202015600445b0c326382bc73689d32p0,
    0x1.p-7
  },
  { // Entry 252
    0x1.0202015a084c606c4384f9a7ff2ee425p0,
    0x1.000002p-7
  },
  { // Entry 253
    0x1.01008029b456f7a855530b151055fcccp0,
    0x1.fffffep-9
  },
  { // Entry 254
    0x1.0100802ab55777d28a2a42d26aa9ee67p0,
    0x1.p-8
  },
  { // Entry 255
    0x1.0100802cb7587829f6da32ce4058b940p0,
    0x1.000002p-8
  },
  { // Entry 256
    0x1.00802004d5c0010ff251d134d9bbdf8cp0,
    0x1.fffffep-10
  },
  { // Entry 257
    0x1.00802005560011127d41d5bd72f4c8f3p0,
    0x1.p-9
  },
  { // Entry 258
    0x1.00802006568031185381f6d2c5f6ac90p0,
    0x1.000002p-9
  },
  { // Entry 259
    0x1.004008006aa553ddc0e317b0fa59b1c4p0,
    0x1.fffffep-11
  },
  { // Entry 260
    0x1.00400800aab555dde38e6ce86e9277aap0,
    0x1.p-10
  },
  { // Entry 261
    0x1.004008012ad559de58f118d77b0703afp0,
    0x1.000002p-10
  },
  { // Entry 262
    0x1.0008001ff85515ff012e68cd2d69c588p0,
    0x1.fffffep-14
  },
  { // Entry 263
    0x1.00080020005556000111127d297298c9p0,
    0x1.p-13
  },
  { // Entry 264
    0x1.000800201055d60201966bdd39867f5cp0,
    0x1.000002p-13
  },
  { // Entry 265
    0x1.969c7be3ad874c06787aba955d206d83p-93,
    -0x1.000002p6
  },
  { // Entry 266
    0x1.969d47321e4cbabf2d28070963b04194p-93,
    -0x1.p6
  },
  { // Entry 267
    0x1.969dacd97cce2d9b005ff576b7a0bb4fp-93,
    -0x1.fffffep5
  },
  { // Entry 268
    0x1.c845dd6490ab2d9c7b0cfec9c5008483p-47,
    -0x1.000002p5
  },
  { // Entry 269
    0x1.c8464f76164681e299a0124487884d64p-47,
    -0x1.p5
  },
  { // Entry 270
    0x1.c846887ee3c5d1705be6172d117870a0p-47,
    -0x1.fffffep4
  },
  { // Entry 271
    0x1.e3557f4434ad7be9e06c29966f56e62bp-24,
    -0x1.000002p4
  },
  { // Entry 272
    0x1.e355bbaee85cada65f73f32e88fb3cc6p-24,
    -0x1.p4
  },
  { // Entry 273
    0x1.e355d9e44509470f0aa73ac7ef12148fp-24,
    -0x1.fffffep3
  },
  { // Entry 274
    0x1.5fc1fa44e2269c9c9706469c20b93e95p-12,
    -0x1.000002p3
  },
  { // Entry 275
    0x1.5fc21041027acbbfcd46780fee71ead2p-12,
    -0x1.p3
  },
  { // Entry 276
    0x1.5fc21b3f1328cc16210576d3c70bf98bp-12,
    -0x1.fffffep2
  },
  { // Entry 277
    0x1.2c1552216918b98b1cef7b04f710e36cp-6,
    -0x1.000002p2
  },
  { // Entry 278
    0x1.2c155b8213cf477e8af0132c2ae23d4ap-6,
    -0x1.p2
  },
  { // Entry 279
    0x1.2c1560326946b078b09f8faebe2fc287p-6,
    -0x1.fffffep1
  },
  { // Entry 280
    0x1.152aa5e74d7c73728ada0663f224a381p-3,
    -0x1.000002p1
  },
  { // Entry 281
    0x1.152aaa3bf81cb9fdb76eae12d029571fp-3,
    -0x1.p1
  },
  { // Entry 282
    0x1.152aac664d735c4346cc27f42a3d83b1p-3,
    -0x1.fffffep0
  },
  { // Entry 283
    0x1.78b56071642fa837c9519eec10a7f937p-2,
    -0x1.000002p0
  },
  { // Entry 284
    0x1.78b56362cef37c6aeb7b1e0a4153e437p-2,
    -0x1.p0
  },
  { // Entry 285
    0x1.78b564db84579b9490e7b9557026c647p-2,
    -0x1.fffffep-1
  },
  { // Entry 286
    0x1.4259323902dbc6e62e3e07ce26cd904cp92,
    0x1.fffffep5
  },
  { // Entry 287
    0x1.425982cf597cd205ce3d5b4edb031756p92,
    0x1.p6
  },
  { // Entry 288
    0x1.425a23fc432fb5d556006a4d8e7ee11bp92,
    0x1.000002p6
  },
  { // Entry 289
    0x1.1f43d8dc3908b8ed87a5abd50621706ap46,
    0x1.fffffep4
  },
  { // Entry 290
    0x1.1f43fcc4b662c7d84788401842174074p46,
    0x1.p5
  },
  { // Entry 291
    0x1.1f444495be8e1616a1e5e388779bc146p46,
    0x1.000002p5
  },
  { // Entry 292
    0x1.0f2eac1794b8f3edb5c10d26a51f420fp23,
    0x1.fffffep3
  },
  { // Entry 293
    0x1.0f2ebd0a8002049223f170882b5ee5efp23,
    0x1.p4
  },
  { // Entry 294
    0x1.0f2edef059c1b22312bed964006ee633p23,
    0x1.000002p4
  },
  { // Entry 295
    0x1.749e9c2f7bb6cf5a276ee08236c2d6c3p11,
    0x1.fffffep2
  },
  { // Entry 296
    0x1.749ea7d470c6df0be00e084a815d1de6p11,
    0x1.p3
  },
  { // Entry 297
    0x1.749ebf1e5bfe757019de4e22b113fde9p11,
    0x1.000002p3
  },
  { // Entry 298
    0x1.b4c8fc0f4fa7a2f2459a6ef53c315f0fp5,
    0x1.fffffep1
  },
  { // Entry 299
    0x1.b4c902e273a58678d6d3bfdb93db96d0p5,
    0x1.p2
  },
  { // Entry 300
    0x1.b4c91088bbf33336f0ee52b1ad858e43p5,
    0x1.000002p2
  },
  { // Entry 301
    0x1.d8e647db814773f419262ee477a98616p2,
    0x1.fffffep0
  },
  { // Entry 302
    0x1.d8e64b8d4ddadcc33a3ba206b68abba8p2,
    0x1.p1
  },
  { // Entry 303
    0x1.d8e652f0e717d92d15cd610022ae51e3p2,
    0x1.000002p1
  },
  { // Entry 304
    0x1.5bf0a75554ce91e83d421c2a7c075cb2p1,
    0x1.fffffep-1
  },
  { // Entry 305
    0x1.5bf0a8b1457695355fb8ac404e7a79e3p1,
    0x1.p0
  },
  { // Entry 306
    0x1.5bf0ab6926caafa1a0158d79693ac8e1p1,
    0x1.000002p0
  },
  { // Entry 307
    HUGE_VALF,
    0x1.p124
  },
  { // Entry 308
    HUGE_VALF,
    0x1.99999ap124
  },
  { // Entry 309
    HUGE_VALF,
    0x1.19999ap125
  },
  { // Entry 310
    HUGE_VALF,
    0x1.666668p125
  },
  { // Entry 311
    HUGE_VALF,
    0x1.b33334p125
  },
  { // Entry 312
    HUGE_VALF,
    0x1.p126
  },
  { // Entry 313
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 314
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 315
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 316
    HUGE_VALF,
    0x1.fffffcp127
  },
  { // Entry 317
    0x1.7240490a165620d9b922aaa22a8e4c09p4,
    0x1.921fb6p1
  },
  { // Entry 318
    0x1.33dedd672084cca612aab2b9a3e817bbp2,
    0x1.921fb6p0
  },
  { // Entry 319
    0x1.5bf0ab6926caafa1a0158d79693ac8e1p1,
    0x1.000002p0
  },
  { // Entry 320
    0x1.5bf0a8b1457695355fb8ac404e7a79e3p1,
    0x1.p0
  },
  { // Entry 321
    0x1.5bf0a75554ce91e83d421c2a7c075cb2p1,
    0x1.fffffep-1
  },
  { // Entry 322
    0x1.18bd66fb62b31900cc07634deba43456p1,
    0x1.921fb6p-1
  },
  { // Entry 323
    0x1.00000000000000000000000000000004p0,
    0x1.000002p-126
  },
  { // Entry 324
    0x1.00000000000000000000000000000004p0,
    0x1.p-126
  },
  { // Entry 325
    0x1.00000000000000000000000000000003p0,
    0x1.fffffcp-127
  },
  { // Entry 326
    0x1.00000000000000000000000000000003p0,
    0x1.fffff8p-127
  },
  { // Entry 327
    0x1.p0,
    0x1.p-148
  },
  { // Entry 328
    0x1.p0,
    0x1.p-149
  },
  { // Entry 329
    0x1.p0,
    0.0f
  },
  { // Entry 330
    0x1.p0,
    -0.0f
  },
  { // Entry 331
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149
  },
  { // Entry 332
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-148
  },
  { // Entry 333
    0x1.fffffffffffffffffffffffffffffff8p-1,
    -0x1.fffff8p-127
  },
  { // Entry 334
    0x1.fffffffffffffffffffffffffffffff8p-1,
    -0x1.fffffcp-127
  },
  { // Entry 335
    0x1.fffffffffffffffffffffffffffffff8p-1,
    -0x1.p-126
  },
  { // Entry 336
    0x1.fffffffffffffffffffffffffffffff7p-1,
    -0x1.000002p-126
  },
  { // Entry 337
    0x1.d2e17123d2ae02abbcf896f2025e3463p-2,
    -0x1.921fb6p-1
  },
  { // Entry 338
    0x1.78b564db84579b9490e7b9557026c647p-2,
    -0x1.fffffep-1
  },
  { // Entry 339
    0x1.78b56362cef37c6aeb7b1e0a4153e437p-2,
    -0x1.p0
  },
  { // Entry 340
    0x1.78b56071642fa837c9519eec10a7f937p-2,
    -0x1.000002p0
  },
  { // Entry 341
    0x1.a9bcc3373efd3e4d6a96be7a7562f428p-3,
    -0x1.921fb6p0
  },
  { // Entry 342
    0x1.620225ae5e9349593d6bb618c231545ep-5,
    -0x1.921fb6p1
  },
  { // Entry 343
    0.0f,
    -0x1.fffffcp127
  },
  { // Entry 344
    0.0f,
    -0x1.fffffep127
  },
  { // Entry 345
    0.0,
    -HUGE_VALF
  },
  { // Entry 346
    0x1.ffff082e6c7fed1d3fd5cff7e1f60591p127,
    0x1.62e42ep6
  },
  { // Entry 347
    HUGE_VALF,
    0x1.62e430p6
  },
  { // Entry 348
    0x1.00004bf94f63e3fa686222148f1293c4p-126,
    -0x1.5d589ep6
  },
  { // Entry 349
    0x1.ffff97f292ce80e494231c6496e9cbf5p-127,
    -0x1.5d58a0p6
  },
};
