/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Deliberately overwrite the stack canary.
__attribute__((noinline)) void modify_stack_protector_test() {
  char buf[128];
  // We can't use memset here because it's fortified, and we want to test
  // the line of defense *after* that.
  // Without volatile, the generic x86/x86-64 targets don't write to the stack.
  volatile char* p = buf;
  int size = static_cast<int>(sizeof(buf) + 1);
#if __x86_64__
  // The generic x86-64 target leaves an 8-byte gap between `buf` and the stack guard.
  // We only need to corrupt one byte though.
  size += 8;
#endif
  while ((p - buf) < size) *p++ = '\0';
}
