/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_sinhf_intel_data[] = {
  { // Entry 0
    -0x1.00000000000aaaaaaaaaaaccccccccccp-21,
    -0x1.p-21
  },
  { // Entry 1
    0x1.00000000000aaaaaaaaaaaccccccccccp-21,
    0x1.p-21
  },
  { // Entry 2
    -0x1.1770c0fffee31db7a31664de401a57cdp-1,
    -0x1.0b26eep-1
  },
  { // Entry 3
    0x1.1770c0fffee31db7a31664de401a57cdp-1,
    0x1.0b26eep-1
  },
  { // Entry 4
    -0x1.204fd00000000000000f3ca3e81c03afp-37,
    -0x1.204fd0p-37
  },
  { // Entry 5
    0x1.204fd00000000000000f3ca3e81c03afp-37,
    0x1.204fd0p-37
  },
  { // Entry 6
    -0x1.43510055f383351ba9ec4cdf5b1b1fa5p-12,
    -0x1.4351p-12
  },
  { // Entry 7
    0x1.43510055f383351ba9ec4cdf5b1b1fa5p-12,
    0x1.4351p-12
  },
  { // Entry 8
    -0x1.4f1fe6fffd055403a0afa5f61f7ad456p122,
    -0x1.561b10p6
  },
  { // Entry 9
    0x1.4f1fe6fffd055403a0afa5f61f7ad456p122,
    0x1.561b10p6
  },
  { // Entry 10
    -0x1.76339d048c41010db95311bf38824f7fp-2,
    -0x1.6e564ep-2
  },
  { // Entry 11
    0x1.76339d048c41010db95311bf38824f7fp-2,
    0x1.6e564ep-2
  },
  { // Entry 12
    -0x1.a6399b00031ae7e2d10c4d5ca8b85bb6p-2,
    -0x1.9b17d8p-2
  },
  { // Entry 13
    0x1.a6399b00031ae7e2d10c4d5ca8b85bb6p-2,
    0x1.9b17d8p-2
  },
  { // Entry 14
    -0x1.ed9c6b045cf886a719553b239eced39ap-1,
    -0x1.b62492p-1
  },
  { // Entry 15
    0x1.ed9c6b045cf886a719553b239eced39ap-1,
    0x1.b62492p-1
  },
  { // Entry 16
    -0x1.ffb1b2f8d872ac8cb2c8ae78073874cep-1,
    -0x1.c30c06p-1
  },
  { // Entry 17
    0x1.ffb1b2f8d872ac8cb2c8ae78073874cep-1,
    0x1.c30c06p-1
  },
  { // Entry 18
    -0x1.490e3effd17cc5e5cebb7150a45530b0p9,
    -0x1.cbae70p2
  },
  { // Entry 19
    0x1.490e3effd17cc5e5cebb7150a45530b0p9,
    0x1.cbae70p2
  },
  { // Entry 20
    -0x1.d3735503c31601d8a231e42764dca76bp-12,
    -0x1.d37354p-12
  },
  { // Entry 21
    0x1.d3735503c31601d8a231e42764dca76bp-12,
    0x1.d37354p-12
  },
  { // Entry 22
    -0x1.d3750103c5df89146104862bc8eb9511p-12,
    -0x1.d375p-12
  },
  { // Entry 23
    0x1.d3750103c5df89146104862bc8eb9511p-12,
    0x1.d375p-12
  },
  { // Entry 24
    -0x1.d4bc08fe54522492a18ed763f5905a3cp-6,
    -0x1.d4abacp-6
  },
  { // Entry 25
    0x1.d4bc08fe54522492a18ed763f5905a3cp-6,
    0x1.d4abacp-6
  },
  { // Entry 26
    -0x1.b495d8f96ad2507c36e288f42ed69c65p4,
    -0x1.fffcp1
  },
  { // Entry 27
    0x1.b495d8f96ad2507c36e288f42ed69c65p4,
    0x1.fffcp1
  },
  { // Entry 28
    0x1.0acd00fe63b96ca357895761ae66224ap-1,
    0x1.p-1
  },
  { // Entry 29
    -0x1.0acd00fe63b96ca357895761ae66224ap-1,
    -0x1.p-1
  },
  { // Entry 30
    0x1.00000000000aaaaaaaaaaaccccccccccp-21,
    0x1.p-21
  },
  { // Entry 31
    -0x1.00000000000aaaaaaaaaaaccccccccccp-21,
    -0x1.p-21
  },
  { // Entry 32
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 33
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 34
    0x1.000002000000000000000aaaaaeaaaabp-41,
    0x1.000002p-41
  },
  { // Entry 35
    -0x1.000002000000000000000aaaaaeaaaabp-41,
    -0x1.000002p-41
  },
  { // Entry 36
    0x1.00aae5001d35b2cc9f1bf5024aad3fc7p-3,
    0x1.000018p-3
  },
  { // Entry 37
    -0x1.00aae5001d35b2cc9f1bf5024aad3fc7p-3,
    -0x1.000018p-3
  },
  { // Entry 38
    0x1.2cdc4cd13dbaaea971cf4c6df8d02db1p0,
    0x1.000180p0
  },
  { // Entry 39
    -0x1.2cdc4cd13dbaaea971cf4c6df8d02db1p0,
    -0x1.000180p0
  },
  { // Entry 40
    0x1.000220000000000000002aabbaacecacp-40,
    0x1.000220p-40
  },
  { // Entry 41
    -0x1.000220000000000000002aabbaacecacp-40,
    -0x1.000220p-40
  },
  { // Entry 42
    0x1.75b684fbb21e3fadfd76948a74ff619cp10,
    0x1.0018p3
  },
  { // Entry 43
    -0x1.75b684fbb21e3fadfd76948a74ff619cp10,
    -0x1.0018p3
  },
  { // Entry 44
    0x1.0af11706dc935e6b8d9889ffd9d7f9eep-1,
    0x1.0020p-1
  },
  { // Entry 45
    -0x1.0af11706dc935e6b8d9889ffd9d7f9eep-1,
    -0x1.0020p-1
  },
  { // Entry 46
    0x1.2de53500112b48b54416fd3ac0fd5d35p0,
    0x1.00adp0
  },
  { // Entry 47
    -0x1.2de53500112b48b54416fd3ac0fd5d35p0,
    -0x1.00adp0
  },
  { // Entry 48
    0x1.d311590094b7169257222f29159c5274p1,
    0x1.00c0p1
  },
  { // Entry 49
    -0x1.d311590094b7169257222f29159c5274p1,
    -0x1.00c0p1
  },
  { // Entry 50
    0x1.bb8be0f928fa482d264aec809030cb98p4,
    0x1.0101p2
  },
  { // Entry 51
    -0x1.bb8be0f928fa482d264aec809030cb98p4,
    -0x1.0101p2
  },
  { // Entry 52
    0x1.d6509cfff1b887cd50d3c7b33a490af5p1,
    0x1.019bp1
  },
  { // Entry 53
    -0x1.d6509cfff1b887cd50d3c7b33a490af5p1,
    -0x1.019bp1
  },
  { // Entry 54
    0x1.d99ef101df23c13de5368e55ebb4c952p45,
    0x1.04p5
  },
  { // Entry 55
    -0x1.d99ef101df23c13de5368e55ebb4c952p45,
    -0x1.04p5
  },
  { // Entry 56
    0x1.b61e5ca3a5e30b2f0a03f292f9ce0084p92,
    0x1.04p6
  },
  { // Entry 57
    -0x1.b61e5ca3a5e30b2f0a03f292f9ce0084p92,
    -0x1.04p6
  },
  { // Entry 58
    0x1.0f53c500dab3115ec83d0a87f389efa5p-1,
    0x1.0401c0p-1
  },
  { // Entry 59
    -0x1.0f53c500dab3115ec83d0a87f389efa5p-1,
    -0x1.0401c0p-1
  },
  { // Entry 60
    0x1.07a43d780cd02aa326997430cb72ec6ep-2,
    0x1.04d0p-2
  },
  { // Entry 61
    -0x1.07a43d780cd02aa326997430cb72ec6ep-2,
    -0x1.04d0p-2
  },
  { // Entry 62
    0x1.070b91000585e92eceba7f1d10686783p-5,
    0x1.07p-5
  },
  { // Entry 63
    -0x1.070b91000585e92eceba7f1d10686783p-5,
    -0x1.07p-5
  },
  { // Entry 64
    0x1.0aef2dfa6f09af758cfac3ec7bbe6580p-2,
    0x1.08p-2
  },
  { // Entry 65
    -0x1.0aef2dfa6f09af758cfac3ec7bbe6580p-2,
    -0x1.08p-2
  },
  { // Entry 66
    0x1.0ab8c103d210ecc999dea2fb1e601dffp-7,
    0x1.0ab8p-7
  },
  { // Entry 67
    -0x1.0ab8c103d210ecc999dea2fb1e601dffp-7,
    -0x1.0ab8p-7
  },
  { // Entry 68
    HUGE_VALF,
    0x1.0bd822p85
  },
  { // Entry 69
    -HUGE_VALF,
    -0x1.0bd822p85
  },
  { // Entry 70
    0x1.1b0bd9fff434fa99eb934f12cfcde40dp-1,
    0x1.0e50p-1
  },
  { // Entry 71
    -0x1.1b0bd9fff434fa99eb934f12cfcde40dp-1,
    -0x1.0e50p-1
  },
  { // Entry 72
    0x1.13a0d500d2f8e84e29cf7e0b47593d6bp-7,
    0x1.13a0p-7
  },
  { // Entry 73
    -0x1.13a0d500d2f8e84e29cf7e0b47593d6bp-7,
    -0x1.13a0p-7
  },
  { // Entry 74
    0x1.14635aff07928f6b82b6efd046d85611p-6,
    0x1.1460p-6
  },
  { // Entry 75
    -0x1.14635aff07928f6b82b6efd046d85611p-6,
    -0x1.1460p-6
  },
  { // Entry 76
    0x1.1837d7019c29ac4261d83dbdd9540770p-4,
    0x1.18p-4
  },
  { // Entry 77
    -0x1.1837d7019c29ac4261d83dbdd9540770p-4,
    -0x1.18p-4
  },
  { // Entry 78
    0x1.1e9a66ffff67888e2226adc979242050p-2,
    0x1.1afcc0p-2
  },
  { // Entry 79
    -0x1.1e9a66ffff67888e2226adc979242050p-2,
    -0x1.1afcc0p-2
  },
  { // Entry 80
    0x1.5851b581ab5774b6bc22fe804a609974p0,
    0x1.1b08p0
  },
  { // Entry 81
    -0x1.5851b581ab5774b6bc22fe804a609974p0,
    -0x1.1b08p0
  },
  { // Entry 82
    0x1.1fc09496b655ab5f571a14fc538740f3p-2,
    0x1.1c18p-2
  },
  { // Entry 83
    -0x1.1fc09496b655ab5f571a14fc538740f3p-2,
    -0x1.1c18p-2
  },
  { // Entry 84
    0x1.1c4fa6fffe2308d6059816c28ca68b93p-6,
    0x1.1c4cp-6
  },
  { // Entry 85
    -0x1.1c4fa6fffe2308d6059816c28ca68b93p-6,
    -0x1.1c4cp-6
  },
  { // Entry 86
    0x1.1ef0f05245d564eb621bc3580e810ecbp-7,
    0x1.1ef0p-7
  },
  { // Entry 87
    -0x1.1ef0f05245d564eb621bc3580e810ecbp-7,
    -0x1.1ef0p-7
  },
  { // Entry 88
    0x1.5ef59f4fb8454858c70cce0b76f0d1c1p0,
    0x1.1ef8p0
  },
  { // Entry 89
    -0x1.5ef59f4fb8454858c70cce0b76f0d1c1p0,
    -0x1.1ef8p0
  },
  { // Entry 90
    0x1.7922d2f6a620cc176196ee619e38cedep0,
    0x1.2e073ap0
  },
  { // Entry 91
    -0x1.7922d2f6a620cc176196ee619e38cedep0,
    -0x1.2e073ap0
  },
  { // Entry 92
    0x1.43b381fff77c0efbac7ee89fffb83db3p-1,
    0x1.31497ep-1
  },
  { // Entry 93
    -0x1.43b381fff77c0efbac7ee89fffb83db3p-1,
    -0x1.31497ep-1
  },
  { // Entry 94
    0x1.32b4320000022be269a7e0844e8fb427p-3,
    0x1.3191a2p-3
  },
  { // Entry 95
    -0x1.32b4320000022be269a7e0844e8fb427p-3,
    -0x1.3191a2p-3
  },
  { // Entry 96
    0x1.81e2b0f865f7d68960908dea8dbff652p0,
    0x1.32e74cp0
  },
  { // Entry 97
    -0x1.81e2b0f865f7d68960908dea8dbff652p0,
    -0x1.32e74cp0
  },
  { // Entry 98
    0x1.684f9300049996963e27553b525d785cp2,
    0x1.36ea5cp1
  },
  { // Entry 99
    -0x1.684f9300049996963e27553b525d785cp2,
    -0x1.36ea5cp1
  },
  { // Entry 100
    0x1.3e8c5a52344c5fc05de7cf393fd80bacp-12,
    0x1.3e8c5ap-12
  },
  { // Entry 101
    -0x1.3e8c5a52344c5fc05de7cf393fd80bacp-12,
    -0x1.3e8c5ap-12
  },
  { // Entry 102
    0x1.3ebc005259354f37ecfabafab164439dp-12,
    0x1.3ebcp-12
  },
  { // Entry 103
    -0x1.3ebc005259354f37ecfabafab164439dp-12,
    -0x1.3ebcp-12
  },
  { // Entry 104
    0x1.3ec66e52614b0b45d34f5458bd2b6d4ap-12,
    0x1.3ec66ep-12
  },
  { // Entry 105
    -0x1.3ec66e52614b0b45d34f5458bd2b6d4ap-12,
    -0x1.3ec66ep-12
  },
  { // Entry 106
    0x1.9a856d00436428754784f838aa53dcdep0,
    0x1.403a42p0
  },
  { // Entry 107
    -0x1.9a856d00436428754784f838aa53dcdep0,
    -0x1.403a42p0
  },
  { // Entry 108
    0x1.4674690003b5c33e7fd09a6bffacac02p-2,
    0x1.4129d6p-2
  },
  { // Entry 109
    -0x1.4674690003b5c33e7fd09a6bffacac02p-2,
    -0x1.4129d6p-2
  },
  { // Entry 110
    0x1.442556569d4a81e2d99f316cd704988bp-12,
    0x1.442556p-12
  },
  { // Entry 111
    -0x1.442556569d4a81e2d99f316cd704988bp-12,
    -0x1.442556p-12
  },
  { // Entry 112
    0x1.f897f07e50760e5213f6121940ce7277p115,
    0x1.4455a8p6
  },
  { // Entry 113
    -0x1.f897f07e50760e5213f6121940ce7277p115,
    -0x1.4455a8p6
  },
  { // Entry 114
    0x1.f7c601c26a0aab07acb3aed129529860p116,
    0x1.4719c6p6
  },
  { // Entry 115
    -0x1.f7c601c26a0aab07acb3aed129529860p116,
    -0x1.4719c6p6
  },
  { // Entry 116
    0x1.8fd142fffbf07bcd9c6607b02fc55b74p117,
    0x1.48f2e4p6
  },
  { // Entry 117
    -0x1.8fd142fffbf07bcd9c6607b02fc55b74p117,
    -0x1.48f2e4p6
  },
  { // Entry 118
    0x1.54e2c50008b73d8e4d7ed6ca4c155dbcp-3,
    0x1.5354c2p-3
  },
  { // Entry 119
    -0x1.54e2c50008b73d8e4d7ed6ca4c155dbcp-3,
    -0x1.5354c2p-3
  },
  { // Entry 120
    0x1.7ff7f6932445d2e31f1b7c20d7c7d875p125,
    0x1.5ef7bcp6
  },
  { // Entry 121
    -0x1.7ff7f6932445d2e31f1b7c20d7c7d875p125,
    -0x1.5ef7bcp6
  },
  { // Entry 122
    0x1.f13408794171d98e14f95245a340ab06p125,
    0x1.600060p6
  },
  { // Entry 123
    -0x1.f13408794171d98e14f95245a340ab06p125,
    -0x1.600060p6
  },
  { // Entry 124
    0x1.f916467349b058b9c38906911b856056p125,
    0x1.60107cp6
  },
  { // Entry 125
    -0x1.f916467349b058b9c38906911b856056p125,
    -0x1.60107cp6
  },
  { // Entry 126
    0x1.6918410000c5ae5656882e7cea64f25bp-2,
    0x1.620054p-2
  },
  { // Entry 127
    -0x1.6918410000c5ae5656882e7cea64f25bp-2,
    -0x1.620054p-2
  },
  { // Entry 128
    0x1.0021063836b49dcc89e4c5aab5e911d1p127,
    0x1.62e4b4p6
  },
  { // Entry 129
    -0x1.0021063836b49dcc89e4c5aab5e911d1p127,
    -0x1.62e4b4p6
  },
  { // Entry 130
    0x1.f40a2c6c7e4eec4c0ed1fae32d255e23p127,
    0x1.6591c4p6
  },
  { // Entry 131
    -0x1.f40a2c6c7e4eec4c0ed1fae32d255e23p127,
    -0x1.6591c4p6
  },
  { // Entry 132
    0x1.ff0714d44fc871ff0c086096f1bf0ae0p127,
    0x1.65a806p6
  },
  { // Entry 133
    -0x1.ff0714d44fc871ff0c086096f1bf0ae0p127,
    -0x1.65a806p6
  },
  { // Entry 134
    0x1.ff70ec400b9c2d8dee878e30b56339bep127,
    0x1.65a8dap6
  },
  { // Entry 135
    -0x1.ff70ec400b9c2d8dee878e30b56339bep127,
    -0x1.65a8dap6
  },
  { // Entry 136
    0x1.fff2d869d07d11d6c64d896f117f0094p127,
    0x1.65a9dep6
  },
  { // Entry 137
    -0x1.fff2d869d07d11d6c64d896f117f0094p127,
    -0x1.65a9dep6
  },
  { // Entry 138
    0x1.6e444103bc8945311358dde7a66bdb38p-2,
    0x1.66dffap-2
  },
  { // Entry 139
    -0x1.6e444103bc8945311358dde7a66bdb38p-2,
    -0x1.66dffap-2
  },
  { // Entry 140
    0x1.67cf01000052cb8c07fcbe6cb68dcc3dp-6,
    0x1.67c79ap-6
  },
  { // Entry 141
    -0x1.67cf01000052cb8c07fcbe6cb68dcc3dp-6,
    -0x1.67c79ap-6
  },
  { // Entry 142
    0x1.7800852fb7173f3c300caca6708f0d6fp-8,
    0x1.77fffep-8
  },
  { // Entry 143
    -0x1.7800852fb7173f3c300caca6708f0d6fp-8,
    -0x1.77fffep-8
  },
  { // Entry 144
    0x1.80000900001033334115f1660750774cp-10,
    0x1.80p-10
  },
  { // Entry 145
    -0x1.80000900001033334115f1660750774cp-10,
    -0x1.80p-10
  },
  { // Entry 146
    0x1.5df91cff9ace26df572d528a8d7e4d99p16,
    0x1.8313eap3
  },
  { // Entry 147
    -0x1.5df91cff9ace26df572d528a8d7e4d99p16,
    -0x1.8313eap3
  },
  { // Entry 148
    0x1.16c370fc40a0ef3180f8a61c8b25157cp1,
    0x1.853c56p0
  },
  { // Entry 149
    -0x1.16c370fc40a0ef3180f8a61c8b25157cp1,
    -0x1.853c56p0
  },
  { // Entry 150
    0x1.880000993055674ae98a9a44aa624509p-12,
    0x1.88p-12
  },
  { // Entry 151
    -0x1.880000993055674ae98a9a44aa624509p-12,
    -0x1.88p-12
  },
  { // Entry 152
    0x1.dab77d03d9ceea48387c7a3e5ebde612p16,
    0x1.8cd558p3
  },
  { // Entry 153
    -0x1.dab77d03d9ceea48387c7a3e5ebde612p16,
    -0x1.8cd558p3
  },
  { // Entry 154
    0x1.b36be4f606d0cd43778f0b56d6c78c69p3,
    0x1.a70ca4p1
  },
  { // Entry 155
    -0x1.b36be4f606d0cd43778f0b56d6c78c69p3,
    -0x1.a70ca4p1
  },
  { // Entry 156
    0x1.9fc768f63e2199d4161ad52c42c43993p8,
    0x1.ae4a96p2
  },
  { // Entry 157
    -0x1.9fc768f63e2199d4161ad52c42c43993p8,
    -0x1.ae4a96p2
  },
  { // Entry 158
    0x1.fddcb5028f3c5f2f9057b275fda963b5p-1,
    0x1.c1c0p-1
  },
  { // Entry 159
    -0x1.fddcb5028f3c5f2f9057b275fda963b5p-1,
    -0x1.c1c0p-1
  },
  { // Entry 160
    0x1.c9d78317aae58861bfa01747e05aaa21p-3,
    0x1.c61c8ep-3
  },
  { // Entry 161
    -0x1.c9d78317aae58861bfa01747e05aaa21p-3,
    -0x1.c61c8ep-3
  },
  { // Entry 162
    0x1.17d46d00e7aa2bd311c9d06faf31cd0fp4,
    0x1.c71c78p1
  },
  { // Entry 163
    -0x1.17d46d00e7aa2bd311c9d06faf31cd0fp4,
    -0x1.c71c78p1
  },
  { // Entry 164
    0x1.d00fdefedbdc86d82e34a1726ce6fd5ep-6,
    0x1.cffffep-6
  },
  { // Entry 165
    -0x1.d00fdefedbdc86d82e34a1726ce6fd5ep-6,
    -0x1.cffffep-6
  },
  { // Entry 166
    0x1.d12f11000068b29f1390f76019d191e9p-12,
    0x1.d12f10p-12
  },
  { // Entry 167
    -0x1.d12f11000068b29f1390f76019d191e9p-12,
    -0x1.d12f10p-12
  },
  { // Entry 168
    0x1.e161430003f635efa46c1b93b40d124ap-2,
    0x1.d13608p-2
  },
  { // Entry 169
    -0x1.e161430003f635efa46c1b93b40d124ap-2,
    -0x1.d13608p-2
  },
  { // Entry 170
    0x1.e518f10016d4233539a6a86b46de305dp9,
    0x1.e48570p2
  },
  { // Entry 171
    -0x1.e518f10016d4233539a6a86b46de305dp9,
    -0x1.e48570p2
  },
  { // Entry 172
    0x1.f882f8ffff8c2c97052fff77b0fe05cap-2,
    0x1.e60da6p-2
  },
  { // Entry 173
    -0x1.f882f8ffff8c2c97052fff77b0fe05cap-2,
    -0x1.e60da6p-2
  },
  { // Entry 174
    0x1.a6565af66cc00367cd4b44acef8fe3b4p1,
    0x1.e8bce0p0
  },
  { // Entry 175
    -0x1.a6565af66cc00367cd4b44acef8fe3b4p1,
    -0x1.e8bce0p0
  },
  { // Entry 176
    0x1.ee2fa5ffffffd478a109217059ddb3a9p-4,
    0x1.ecfeb6p-4
  },
  { // Entry 177
    -0x1.ee2fa5ffffffd478a109217059ddb3a9p-4,
    -0x1.ecfeb6p-4
  },
  { // Entry 178
    0x1.b54f74f65bab12830f959a3e2d7e1c61p1,
    0x1.f14910p0
  },
  { // Entry 179
    -0x1.b54f74f65bab12830f959a3e2d7e1c61p1,
    -0x1.f14910p0
  },
  { // Entry 180
    0x1.b56a96f6fbbb8045af62b07d5d56b656p1,
    0x1.f1584ep0
  },
  { // Entry 181
    -0x1.b56a96f6fbbb8045af62b07d5d56b656p1,
    -0x1.f1584ep0
  },
  { // Entry 182
    0x1.f6e42e000047623ec2a83a461e98dec7p-3,
    0x1.f1f852p-3
  },
  { // Entry 183
    -0x1.f6e42e000047623ec2a83a461e98dec7p-3,
    -0x1.f1f852p-3
  },
  { // Entry 184
    0x1.f6ec1458fb3487aac4bfeec4b6812670p-3,
    0x1.f1fffep-3
  },
  { // Entry 185
    -0x1.f6ec1458fb3487aac4bfeec4b6812670p-3,
    -0x1.f1fffep-3
  },
  { // Entry 186
    0x1.f2fda6fdfa98a35b66e5104fdacd2bd5p-9,
    0x1.f2fd58p-9
  },
  { // Entry 187
    -0x1.f2fda6fdfa98a35b66e5104fdacd2bd5p-9,
    -0x1.f2fd58p-9
  },
  { // Entry 188
    0x1.f8521dffffcd41462b0d73569b1d3819p-3,
    0x1.f35bacp-3
  },
  { // Entry 189
    -0x1.f8521dffffcd41462b0d73569b1d3819p-3,
    -0x1.f35bacp-3
  },
  { // Entry 190
    0x1.f4dda8fe2ec303fc7f7568475545139cp-11,
    0x1.f4dda4p-11
  },
  { // Entry 191
    -0x1.f4dda8fe2ec303fc7f7568475545139cp-11,
    -0x1.f4dda4p-11
  },
  { // Entry 192
    0x1.f51a7d0000ac50ad5402c949ba82e8a3p-11,
    0x1.f51a78p-11
  },
  { // Entry 193
    -0x1.f51a7d0000ac50ad5402c949ba82e8a3p-11,
    -0x1.f51a78p-11
  },
  { // Entry 194
    0x1.a664dced7cb98c68f2b973d65c676a35p21,
    0x1.f7fffep3
  },
  { // Entry 195
    -0x1.a664dced7cb98c68f2b973d65c676a35p21,
    -0x1.f7fffep3
  },
  { // Entry 196
    0x1.f9b658ffff3ce39965e1b291abc9efb8p-4,
    0x1.f86facp-4
  },
  { // Entry 197
    -0x1.f9b658ffff3ce39965e1b291abc9efb8p-4,
    -0x1.f86facp-4
  },
  { // Entry 198
    0x1.28c3fb0016be4fd802e83c9be0d9cad1p0,
    0x1.faaee8p-1
  },
  { // Entry 199
    -0x1.28c3fb0016be4fd802e83c9be0d9cad1p0,
    -0x1.faaee8p-1
  },
  { // Entry 200
    0x1.29b1530000004a3722ae1117c2787152p0,
    0x1.fbe4b0p-1
  },
  { // Entry 201
    -0x1.29b1530000004a3722ae1117c2787152p0,
    -0x1.fbe4b0p-1
  },
  { // Entry 202
    0x1.fc14d4961039dc857c796f56b34af3b3p-6,
    0x1.fbfffep-6
  },
  { // Entry 203
    -0x1.fc14d4961039dc857c796f56b34af3b3p-6,
    -0x1.fbfffep-6
  },
  { // Entry 204
    0x1.fc4d7fd2d8e70ecb66e028137da8ba9dp-7,
    0x1.fc4848p-7
  },
  { // Entry 205
    -0x1.fc4d7fd2d8e70ecb66e028137da8ba9dp-7,
    -0x1.fc4848p-7
  },
  { // Entry 206
    0x1.fce613caa0469e68c720c7696cf35c3dp-9,
    0x1.fce5c0p-9
  },
  { // Entry 207
    -0x1.fce613caa0469e68c720c7696cf35c3dp-9,
    -0x1.fce5c0p-9
  },
  { // Entry 208
    0x1.fdf50fe0194330cfcecb2935b09d09a3p-6,
    0x1.fddffep-6
  },
  { // Entry 209
    -0x1.fdf50fe0194330cfcecb2935b09d09a3p-6,
    -0x1.fddffep-6
  },
  { // Entry 210
    0x1.ff92198272299e9dd5a4315372947bb7p-4,
    0x1.fe3ffep-4
  },
  { // Entry 211
    -0x1.ff92198272299e9dd5a4315372947bb7p-4,
    -0x1.fe3ffep-4
  },
  { // Entry 212
    0x1.fed49818a86c9e5d357348cc86552ecfp-5,
    0x1.fe7ffep-5
  },
  { // Entry 213
    -0x1.fed49818a86c9e5d357348cc86552ecfp-5,
    -0x1.fe7ffep-5
  },
  { // Entry 214
    0x1.3d59d2d8b22b41c2bb6334c9be7be902p91,
    0x1.ffdffep5
  },
  { // Entry 215
    -0x1.3d59d2d8b22b41c2bb6334c9be7be902p91,
    -0x1.ffdffep5
  },
  { // Entry 216
    0x1.fff77f554451e1f58b2d5e1ecc407a66p-12,
    0x1.fff77ep-12
  },
  { // Entry 217
    -0x1.fff77f554451e1f58b2d5e1ecc407a66p-12,
    -0x1.fff77ep-12
  },
  { // Entry 218
    0x1.7474c2f9144f003acd66e60d58643f07p10,
    0x1.fff8cep2
  },
  { // Entry 219
    -0x1.7474c2f9144f003acd66e60d58643f07p10,
    -0x1.fff8cep2
  },
  { // Entry 220
    0x1.b495d8f96ad2507c36e288f42ed69c65p4,
    0x1.fffcp1
  },
  { // Entry 221
    -0x1.b495d8f96ad2507c36e288f42ed69c65p4,
    -0x1.fffcp1
  },
  { // Entry 222
    0x1.2cd7476ede0aac2c3be4d81efc1fae2bp0,
    0x1.fffc7ep-1
  },
  { // Entry 223
    -0x1.2cd7476ede0aac2c3be4d81efc1fae2bp0,
    -0x1.fffc7ep-1
  },
  { // Entry 224
    0x1.d03a90ffffa72affa30aae2126410fd3p1,
    0x1.fffebap0
  },
  { // Entry 225
    -0x1.d03a90ffffa72affa30aae2126410fd3p1,
    -0x1.fffebap0
  },
  { // Entry 226
    0x1.b4a0e9ff76786bf6ec2ea4f53a42a118p4,
    0x1.ffff3ep1
  },
  { // Entry 227
    -0x1.b4a0e9ff76786bf6ec2ea4f53a42a118p4,
    -0x1.ffff3ep1
  },
  { // Entry 228
    0.0,
    0.0
  },
  { // Entry 229
    0x1.24d1fe8cfad7f98fcdbea5882af8e32dp-4,
    0x1.24924ap-4
  },
  { // Entry 230
    -0x1.24d1fe8cfad7f98fcdbea5882af8e32dp-4,
    -0x1.24924ap-4
  },
  { // Entry 231
    0x1.25914e250092e5c3cddf2040afd79c65p-3,
    0x1.24924ap-3
  },
  { // Entry 232
    -0x1.25914e250092e5c3cddf2040afd79c65p-3,
    -0x1.24924ap-3
  },
  { // Entry 233
    0x1.ba393734ca25f6f4197cc41844ff6e7dp-3,
    0x1.b6db70p-3
  },
  { // Entry 234
    -0x1.ba393734ca25f6f4197cc41844ff6e7dp-3,
    -0x1.b6db70p-3
  },
  { // Entry 235
    0x1.28917b1a67c439ef2a28337ebef6dc3cp-2,
    0x1.24924ap-2
  },
  { // Entry 236
    -0x1.28917b1a67c439ef2a28337ebef6dc3cp-2,
    -0x1.24924ap-2
  },
  { // Entry 237
    0x1.7589df829503fa20ed8774c31e6a332cp-2,
    0x1.6db6dcp-2
  },
  { // Entry 238
    -0x1.7589df829503fa20ed8774c31e6a332cp-2,
    -0x1.6db6dcp-2
  },
  { // Entry 239
    0x1.c46a5c1d32d4860b81155aef808f7d0fp-2,
    0x1.b6db6ep-2
  },
  { // Entry 240
    -0x1.c46a5c1d32d4860b81155aef808f7d0fp-2,
    -0x1.b6db6ep-2
  },
  { // Entry 241
    0x1.0acd00fe63b96ca357895761ae66224ap-1,
    0x1.p-1
  },
  { // Entry 242
    -0x1.0acd00fe63b96ca357895761ae66224ap-1,
    -0x1.p-1
  },
  { // Entry 243
    0x1.0acd00fe63b96ca357895761ae66224ap-1,
    0x1.p-1
  },
  { // Entry 244
    -0x1.0acd00fe63b96ca357895761ae66224ap-1,
    -0x1.p-1
  },
  { // Entry 245
    0x1.34c1747f635dfc16c1d88e5910239fe8p-1,
    0x1.24924ap-1
  },
  { // Entry 246
    -0x1.34c1747f635dfc16c1d88e5910239fe8p-1,
    -0x1.24924ap-1
  },
  { // Entry 247
    0x1.604959cb9dca66a6c6b1d52214b88901p-1,
    0x1.492494p-1
  },
  { // Entry 248
    -0x1.604959cb9dca66a6c6b1d52214b88901p-1,
    -0x1.492494p-1
  },
  { // Entry 249
    0x1.8d9d92611935ee8bcc9e9c1bbcb4ec0dp-1,
    0x1.6db6dep-1
  },
  { // Entry 250
    -0x1.8d9d92611935ee8bcc9e9c1bbcb4ec0dp-1,
    -0x1.6db6dep-1
  },
  { // Entry 251
    0x1.bcf9593d2ecc12e3836d15a1067a7896p-1,
    0x1.924928p-1
  },
  { // Entry 252
    -0x1.bcf9593d2ecc12e3836d15a1067a7896p-1,
    -0x1.924928p-1
  },
  { // Entry 253
    0x1.ee9a9041b2e77dc8645b07cd35bf1333p-1,
    0x1.b6db72p-1
  },
  { // Entry 254
    -0x1.ee9a9041b2e77dc8645b07cd35bf1333p-1,
    -0x1.b6db72p-1
  },
  { // Entry 255
    0x1.116108889abd3fd6df9a909af5b4b3abp0,
    0x1.db6dbcp-1
  },
  { // Entry 256
    -0x1.116108889abd3fd6df9a909af5b4b3abp0,
    -0x1.db6dbcp-1
  },
  { // Entry 257
    0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    0x1.p0
  },
  { // Entry 258
    -0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    -0x1.p0
  },
  { // Entry 259
    0.0,
    0.0
  },
  { // Entry 260
    0x1.18e1df94a3c9eec616f3c33e116ff136p-6,
    0x1.18de5ap-6
  },
  { // Entry 261
    -0x1.18e1df94a3c9eec616f3c33e116ff136p-6,
    -0x1.18de5ap-6
  },
  { // Entry 262
    0x1.18ec707b41cb05757f702b2e7bc8168fp-5,
    0x1.18de5ap-5
  },
  { // Entry 263
    -0x1.18ec707b41cb05757f702b2e7bc8168fp-5,
    -0x1.18de5ap-5
  },
  { // Entry 264
    0x1.a57d14c544db6f79ccb29cf647ec3bd6p-5,
    0x1.a54d88p-5
  },
  { // Entry 265
    -0x1.a57d14c544db6f79ccb29cf647ec3bd6p-5,
    -0x1.a54d88p-5
  },
  { // Entry 266
    0x1.1916b67842dff1025e79e06864bad805p-4,
    0x1.18de5ap-4
  },
  { // Entry 267
    -0x1.1916b67842dff1025e79e06864bad805p-4,
    -0x1.18de5ap-4
  },
  { // Entry 268
    0x1.5f840854828275e07b52147a0b34cec2p-4,
    0x1.5f15f0p-4
  },
  { // Entry 269
    -0x1.5f840854828275e07b52147a0b34cec2p-4,
    -0x1.5f15f0p-4
  },
  { // Entry 270
    0x1.a60bcc64888b5d1a7338b1a0f9243f1ep-4,
    0x1.a54d86p-4
  },
  { // Entry 271
    -0x1.a60bcc64888b5d1a7338b1a0f9243f1ep-4,
    -0x1.a54d86p-4
  },
  { // Entry 272
    0x1.ecb35112d674d05785ec00066c2b3ec8p-4,
    0x1.eb851cp-4
  },
  { // Entry 273
    -0x1.ecb35112d674d05785ec00066c2b3ec8p-4,
    -0x1.eb851cp-4
  },
  { // Entry 274
    0x1.ecb35316874ebf73aba92491a44e079fp-4,
    0x1.eb851ep-4
  },
  { // Entry 275
    -0x1.ecb35316874ebf73aba92491a44e079fp-4,
    -0x1.eb851ep-4
  },
  { // Entry 276
    0x1.02243d1276143106404fa4cb3fcadf33p-3,
    0x1.01767ep-3
  },
  { // Entry 277
    -0x1.02243d1276143106404fa4cb3fcadf33p-3,
    -0x1.01767ep-3
  },
  { // Entry 278
    0x1.0df0f8011126593efedda045c8fa0e09p-3,
    0x1.0d2a6cp-3
  },
  { // Entry 279
    -0x1.0df0f8011126593efedda045c8fa0e09p-3,
    -0x1.0d2a6cp-3
  },
  { // Entry 280
    0x1.19bff49926d4870c4cae1f4076b8e37ap-3,
    0x1.18de5ap-3
  },
  { // Entry 281
    -0x1.19bff49926d4870c4cae1f4076b8e37ap-3,
    -0x1.18de5ap-3
  },
  { // Entry 282
    0x1.25914c1fc4d40b236a218f858c70fb53p-3,
    0x1.249248p-3
  },
  { // Entry 283
    -0x1.25914c1fc4d40b236a218f858c70fb53p-3,
    -0x1.249248p-3
  },
  { // Entry 284
    0x1.316517df03194e62cdc39c303b8105ffp-3,
    0x1.304636p-3
  },
  { // Entry 285
    -0x1.316517df03194e62cdc39c303b8105ffp-3,
    -0x1.304636p-3
  },
  { // Entry 286
    0x1.3d3b712639f615986771a910d344617ep-3,
    0x1.3bfa24p-3
  },
  { // Entry 287
    -0x1.3d3b712639f615986771a910d344617ep-3,
    -0x1.3bfa24p-3
  },
  { // Entry 288
    0x1.4914714a38430228edb55e7949c30a96p-3,
    0x1.47ae12p-3
  },
  { // Entry 289
    -0x1.4914714a38430228edb55e7949c30a96p-3,
    -0x1.47ae12p-3
  },
  { // Entry 290
    0x1.49147350c990b8731b5aa06b375e9ad0p-3,
    0x1.47ae14p-3
  },
  { // Entry 291
    -0x1.49147350c990b8731b5aa06b375e9ad0p-3,
    -0x1.47ae14p-3
  },
  { // Entry 292
    0x1.227b2f3d30af1d4e22444c8e7f338460p-2,
    0x1.1eb852p-2
  },
  { // Entry 293
    -0x1.227b2f3d30af1d4e22444c8e7f338460p-2,
    -0x1.1eb852p-2
  },
  { // Entry 294
    0x1.a49c42670497025996a8b3ff42a49c6fp-2,
    0x1.99999ap-2
  },
  { // Entry 295
    -0x1.a49c42670497025996a8b3ff42a49c6fp-2,
    -0x1.99999ap-2
  },
  { // Entry 296
    0x1.1666dcd198ff92b46da6bfab8aba56a0p-1,
    0x1.0a3d70p-1
  },
  { // Entry 297
    -0x1.1666dcd198ff92b46da6bfab8aba56a0p-1,
    -0x1.0a3d70p-1
  },
  { // Entry 298
    0x1.5e8321e07e76d08e1e985ab3cd7da5b6p-1,
    0x1.47ae14p-1
  },
  { // Entry 299
    -0x1.5e8321e07e76d08e1e985ab3cd7da5b6p-1,
    -0x1.47ae14p-1
  },
  { // Entry 300
    0x1.abad14f0aa07a2fd5cc86f6098a8cf80p-1,
    0x1.851eb8p-1
  },
  { // Entry 301
    -0x1.abad14f0aa07a2fd5cc86f6098a8cf80p-1,
    -0x1.851eb8p-1
  },
  { // Entry 302
    0x1.ff0182668411539d3db9b8fd9af11fd0p-1,
    0x1.c28f5cp-1
  },
  { // Entry 303
    -0x1.ff0182668411539d3db9b8fd9af11fd0p-1,
    -0x1.c28f5cp-1
  },
  { // Entry 304
    0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    0x1.p0
  },
  { // Entry 305
    -0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    -0x1.p0
  },
  { // Entry 306
    0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    0x1.p0
  },
  { // Entry 307
    -0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    -0x1.p0
  },
  { // Entry 308
    0x1.95525e4a2ef718eb0754642866b5a7d4p3,
    0x1.9de826p1
  },
  { // Entry 309
    -0x1.95525e4a2ef718eb0754642866b5a7d4p3,
    -0x1.9de826p1
  },
  { // Entry 310
    0x1.d9a0eee58bbd37706f9307edad7da7ecp6,
    0x1.5de826p2
  },
  { // Entry 311
    -0x1.d9a0eee58bbd37706f9307edad7da7ecp6,
    -0x1.5de826p2
  },
  { // Entry 312
    0x1.144da80a2e3513241fedacab70954631p10,
    0x1.ecdc38p2
  },
  { // Entry 313
    -0x1.144da80a2e3513241fedacab70954631p10,
    -0x1.ecdc38p2
  },
  { // Entry 314
    0x1.425f2a3eb0771d774c3e790cd0f40c63p13,
    0x1.3de826p3
  },
  { // Entry 315
    -0x1.425f2a3eb0771d774c3e790cd0f40c63p13,
    -0x1.3de826p3
  },
  { // Entry 316
    0x1.781f001b7cc45e8c057d098d300a73d1p16,
    0x1.856230p3
  },
  { // Entry 317
    -0x1.781f001b7cc45e8c057d098d300a73d1p16,
    -0x1.856230p3
  },
  { // Entry 318
    0x1.b6d506c59d8cbe5c54f7f8927c597f84p19,
    0x1.ccdc3ap3
  },
  { // Entry 319
    -0x1.b6d506c59d8cbe5c54f7f8927c597f84p19,
    -0x1.ccdc3ap3
  },
  { // Entry 320
    0x1.ffffc188ace6b110a80fe49615910ff2p22,
    0x1.0a2b22p4
  },
  { // Entry 321
    -0x1.ffffc188ace6b110a80fe49615910ff2p22,
    -0x1.0a2b22p4
  },
  { // Entry 322
    0x1.ffffc103c9f0158d22d963e5b764c750p14,
    0x1.62e42cp3
  },
  { // Entry 323
    -0x1.ffffc103c9f0158d22d963e5b764c750p14,
    -0x1.62e42cp3
  },
  { // Entry 324
    0x1.ffffe103c7009212034b389759a93fddp14,
    0x1.62e42ep3
  },
  { // Entry 325
    -0x1.ffffe103c7009212034b389759a93fddp14,
    -0x1.62e42ep3
  },
  { // Entry 326
    0x1.00000081e308873bf3c21c42db0354c7p15,
    0x1.62e430p3
  },
  { // Entry 327
    -0x1.00000081e308873bf3c21c42db0354c7p15,
    -0x1.62e430p3
  },
  { // Entry 328
    0x1.fffde082c48329d920ae3d83c4008840p6,
    0x1.62e42cp2
  },
  { // Entry 329
    -0x1.fffde082c48329d920ae3d83c4008840p6,
    -0x1.62e42cp2
  },
  { // Entry 330
    0x1.fffdf082d3c741b1c6dfdaeedbc1cf8ep6,
    0x1.62e42ep2
  },
  { // Entry 331
    -0x1.fffdf082d3c741b1c6dfdaeedbc1cf8ep6,
    -0x1.62e42ep2
  },
  { // Entry 332
    0x1.fffe0082e38b59068dc66cd507e027edp6,
    0x1.62e430p2
  },
  { // Entry 333
    -0x1.fffe0082e38b59068dc66cd507e027edp6,
    -0x1.62e430p2
  },
  { // Entry 334
    0x1.fdfff031b333717da1077c4a50b5cc66p2,
    0x1.62e42cp1
  },
  { // Entry 335
    -0x1.fdfff031b333717da1077c4a50b5cc66p2,
    -0x1.62e42cp1
  },
  { // Entry 336
    0x1.fdfff839b304a63e7b93e68eccb8b8e4p2,
    0x1.62e42ep1
  },
  { // Entry 337
    -0x1.fdfff839b304a63e7b93e68eccb8b8e4p2,
    -0x1.62e42ep1
  },
  { // Entry 338
    0x1.fe000041b2f5bafed9bb81482ca2b8c4p2,
    0x1.62e430p1
  },
  { // Entry 339
    -0x1.fe000041b2f5bafed9bb81482ca2b8c4p2,
    -0x1.62e430p1
  },
  { // Entry 340
    0x1.dffff7a2c45cc12beb2065181f0d2495p0,
    0x1.62e42cp0
  },
  { // Entry 341
    -0x1.dffff7a2c45cc12beb2065181f0d2495p0,
    -0x1.62e42cp0
  },
  { // Entry 342
    0x1.dffffbe2c451be866a16d0ecdd9b167ep0,
    0x1.62e42ep0
  },
  { // Entry 343
    -0x1.dffffbe2c451be866a16d0ecdd9b167ep0,
    -0x1.62e42ep0
  },
  { // Entry 344
    0x1.e0000022c44e3be0d8984e0b1642ab45p0,
    0x1.62e430p0
  },
  { // Entry 345
    -0x1.e0000022c44e3be0d8984e0b1642ab45p0,
    -0x1.62e430p0
  },
  { // Entry 346
    0x1.7ffffb14737c377a230d14a4c1d143bdp-1,
    0x1.62e42cp-1
  },
  { // Entry 347
    -0x1.7ffffb14737c377a230d14a4c1d143bdp-1,
    -0x1.62e42cp-1
  },
  { // Entry 348
    0x1.7ffffd94737a03bf6ea2e40ff28f406bp-1,
    0x1.62e42ep-1
  },
  { // Entry 349
    -0x1.7ffffd94737a03bf6ea2e40ff28f406bp-1,
    -0x1.62e42ep-1
  },
  { // Entry 350
    0x1.8000001473795004b7cd26f5470cab89p-1,
    0x1.62e430p-1
  },
  { // Entry 351
    -0x1.8000001473795004b7cd26f5470cab89p-1,
    -0x1.62e430p-1
  },
  { // Entry 352
    0x1.6a09e23b307ca82c1b1f6dd4a0d1ed94p-2,
    0x1.62e42cp-2
  },
  { // Entry 353
    -0x1.6a09e23b307ca82c1b1f6dd4a0d1ed94p-2,
    -0x1.62e42cp-2
  },
  { // Entry 354
    0x1.6a09e45a3f55bf3a68e492142f0e7acfp-2,
    0x1.62e42ep-2
  },
  { // Entry 355
    -0x1.6a09e45a3f55bf3a68e492142f0e7acfp-2,
    -0x1.62e42ep-2
  },
  { // Entry 356
    0x1.6a09e6794e2f30cb2fc046292efc5a1dp-2,
    0x1.62e430p-2
  },
  { // Entry 357
    -0x1.6a09e6794e2f30cb2fc046292efc5a1dp-2,
    -0x1.62e430p-2
  },
  { // Entry 358
    0x1.64ab8b624500dcc74dc5de97a0720aabp-3,
    0x1.62e42cp-3
  },
  { // Entry 359
    -0x1.64ab8b624500dcc74dc5de97a0720aabp-3,
    -0x1.62e42cp-3
  },
  { // Entry 360
    0x1.64ab8d69f9de29ffa2a5944cf26374fap-3,
    0x1.62e42ep-3
  },
  { // Entry 361
    -0x1.64ab8d69f9de29ffa2a5944cf26374fap-3,
    -0x1.62e42ep-3
  },
  { // Entry 362
    0x1.64ab8f71aebb8d82b05be9a027129269p-3,
    0x1.62e430p-3
  },
  { // Entry 363
    -0x1.64ab8f71aebb8d82b05be9a027129269p-3,
    -0x1.62e430p-3
  },
  { // Entry 364
    0x1.6355e30c5322853739b87125ec22bdecp-4,
    0x1.62e42cp-4
  },
  { // Entry 365
    -0x1.6355e30c5322853739b87125ec22bdecp-4,
    -0x1.62e42cp-4
  },
  { // Entry 366
    0x1.6355e50e3f6d2cc2dd6e747f61bb8c65p-4,
    0x1.62e42ep-4
  },
  { // Entry 367
    -0x1.6355e50e3f6d2cc2dd6e747f61bb8c65p-4,
    -0x1.62e42ep-4
  },
  { // Entry 368
    0x1.6355e7102bb7d9dbd8b8b0d68c09401bp-4,
    0x1.62e430p-4
  },
  { // Entry 369
    -0x1.6355e7102bb7d9dbd8b8b0d68c09401bp-4,
    -0x1.62e430p-4
  },
  { // Entry 370
    0x1.630097b6aaea36d905a1e74a332b0102p-5,
    0x1.62e42cp-5
  },
  { // Entry 371
    -0x1.630097b6aaea36d905a1e74a332b0102p-5,
    -0x1.62e42cp-5
  },
  { // Entry 372
    0x1.630099b725ee198cf48f439e2807bf07p-5,
    0x1.62e42ep-5
  },
  { // Entry 373
    -0x1.630099b725ee198cf48f439e2807bf07p-5,
    -0x1.62e42ep-5
  },
  { // Entry 374
    0x1.63009bb7a0f1fda3e41657180afe2797p-5,
    0x1.62e430p-5
  },
  { // Entry 375
    -0x1.63009bb7a0f1fda3e41657180afe2797p-5,
    -0x1.62e430p-5
  },
  { // Entry 376
    0x1.62eb46cce5848efc0a888499742bfd4cp-6,
    0x1.62e42cp-6
  },
  { // Entry 377
    -0x1.62eb46cce5848efc0a888499742bfd4cp-6,
    -0x1.62e42cp-6
  },
  { // Entry 378
    0x1.62eb48cd04449b44496ceeff57490075p-6,
    0x1.62e42ep-6
  },
  { // Entry 379
    -0x1.62eb48cd04449b44496ceeff57490075p-6,
    -0x1.62e42ep-6
  },
  { // Entry 380
    0x1.62eb4acd2304a7e543238ca64b8cd689p-6,
    0x1.62e430p-6
  },
  { // Entry 381
    -0x1.62eb4acd2304a7e543238ca64b8cd689p-6,
    -0x1.62e430p-6
  },
  { // Entry 382
    -0x1.00000105c611505c7f74a519f94171b0p31,
    -0x1.62e430p4
  },
  { // Entry 383
    0x1.00000105c611505c7f74a519f94171b0p31,
    0x1.62e430p4
  },
  { // Entry 384
    -0x1.ffffc20b8fe12f0e17406ea1dc598aa0p30,
    -0x1.62e42ep4
  },
  { // Entry 385
    0x1.ffffc20b8fe12f0e17406ea1dc598aa0p30,
    0x1.62e42ep4
  },
  { // Entry 386
    -0x1.ffff820b9b9fbc6b5dd9c276569c9e77p30,
    -0x1.62e42cp4
  },
  { // Entry 387
    0x1.ffff820b9b9fbc6b5dd9c276569c9e77p30,
    0x1.62e42cp4
  },
  { // Entry 388
    -0x1.00000081e308873bf3c21c42db0354c7p15,
    -0x1.62e430p3
  },
  { // Entry 389
    0x1.00000081e308873bf3c21c42db0354c7p15,
    0x1.62e430p3
  },
  { // Entry 390
    -0x1.ffffe103c7009212034b389759a93fddp14,
    -0x1.62e42ep3
  },
  { // Entry 391
    0x1.ffffe103c7009212034b389759a93fddp14,
    0x1.62e42ep3
  },
  { // Entry 392
    -0x1.ffffc103c9f0158d22d963e5b764c750p14,
    -0x1.62e42cp3
  },
  { // Entry 393
    0x1.ffffc103c9f0158d22d963e5b764c750p14,
    0x1.62e42cp3
  },
  { // Entry 394
    -0x1.fffe0082e38b59068dc66cd507e027edp6,
    -0x1.62e430p2
  },
  { // Entry 395
    0x1.fffe0082e38b59068dc66cd507e027edp6,
    0x1.62e430p2
  },
  { // Entry 396
    -0x1.fffdf082d3c741b1c6dfdaeedbc1cf8ep6,
    -0x1.62e42ep2
  },
  { // Entry 397
    0x1.fffdf082d3c741b1c6dfdaeedbc1cf8ep6,
    0x1.62e42ep2
  },
  { // Entry 398
    -0x1.fffde082c48329d920ae3d83c4008840p6,
    -0x1.62e42cp2
  },
  { // Entry 399
    0x1.fffde082c48329d920ae3d83c4008840p6,
    0x1.62e42cp2
  },
  { // Entry 400
    -0x1.fe000041b2f5bafed9bb81482ca2b8c4p2,
    -0x1.62e430p1
  },
  { // Entry 401
    0x1.fe000041b2f5bafed9bb81482ca2b8c4p2,
    0x1.62e430p1
  },
  { // Entry 402
    -0x1.fdfff839b304a63e7b93e68eccb8b8e4p2,
    -0x1.62e42ep1
  },
  { // Entry 403
    0x1.fdfff839b304a63e7b93e68eccb8b8e4p2,
    0x1.62e42ep1
  },
  { // Entry 404
    -0x1.fdfff031b333717da1077c4a50b5cc66p2,
    -0x1.62e42cp1
  },
  { // Entry 405
    0x1.fdfff031b333717da1077c4a50b5cc66p2,
    0x1.62e42cp1
  },
  { // Entry 406
    -0x1.e0000022c44e3be0d8984e0b1642ab45p0,
    -0x1.62e430p0
  },
  { // Entry 407
    0x1.e0000022c44e3be0d8984e0b1642ab45p0,
    0x1.62e430p0
  },
  { // Entry 408
    -0x1.dffffbe2c451be866a16d0ecdd9b167ep0,
    -0x1.62e42ep0
  },
  { // Entry 409
    0x1.dffffbe2c451be866a16d0ecdd9b167ep0,
    0x1.62e42ep0
  },
  { // Entry 410
    -0x1.dffff7a2c45cc12beb2065181f0d2495p0,
    -0x1.62e42cp0
  },
  { // Entry 411
    0x1.dffff7a2c45cc12beb2065181f0d2495p0,
    0x1.62e42cp0
  },
  { // Entry 412
    -0x1.8000001473795004b7cd26f5470cab89p-1,
    -0x1.62e430p-1
  },
  { // Entry 413
    0x1.8000001473795004b7cd26f5470cab89p-1,
    0x1.62e430p-1
  },
  { // Entry 414
    -0x1.7ffffd94737a03bf6ea2e40ff28f406bp-1,
    -0x1.62e42ep-1
  },
  { // Entry 415
    0x1.7ffffd94737a03bf6ea2e40ff28f406bp-1,
    0x1.62e42ep-1
  },
  { // Entry 416
    -0x1.7ffffb14737c377a230d14a4c1d143bdp-1,
    -0x1.62e42cp-1
  },
  { // Entry 417
    0x1.7ffffb14737c377a230d14a4c1d143bdp-1,
    0x1.62e42cp-1
  },
  { // Entry 418
    -0x1.6a09e6794e2f30cb2fc046292efc5a1dp-2,
    -0x1.62e430p-2
  },
  { // Entry 419
    0x1.6a09e6794e2f30cb2fc046292efc5a1dp-2,
    0x1.62e430p-2
  },
  { // Entry 420
    -0x1.6a09e45a3f55bf3a68e492142f0e7acfp-2,
    -0x1.62e42ep-2
  },
  { // Entry 421
    0x1.6a09e45a3f55bf3a68e492142f0e7acfp-2,
    0x1.62e42ep-2
  },
  { // Entry 422
    -0x1.6a09e23b307ca82c1b1f6dd4a0d1ed94p-2,
    -0x1.62e42cp-2
  },
  { // Entry 423
    0x1.6a09e23b307ca82c1b1f6dd4a0d1ed94p-2,
    0x1.62e42cp-2
  },
  { // Entry 424
    -0x1.64ab8f71aebb8d82b05be9a027129269p-3,
    -0x1.62e430p-3
  },
  { // Entry 425
    0x1.64ab8f71aebb8d82b05be9a027129269p-3,
    0x1.62e430p-3
  },
  { // Entry 426
    -0x1.64ab8d69f9de29ffa2a5944cf26374fap-3,
    -0x1.62e42ep-3
  },
  { // Entry 427
    0x1.64ab8d69f9de29ffa2a5944cf26374fap-3,
    0x1.62e42ep-3
  },
  { // Entry 428
    -0x1.64ab8b624500dcc74dc5de97a0720aabp-3,
    -0x1.62e42cp-3
  },
  { // Entry 429
    0x1.64ab8b624500dcc74dc5de97a0720aabp-3,
    0x1.62e42cp-3
  },
  { // Entry 430
    -0x1.6355e7102bb7d9dbd8b8b0d68c09401bp-4,
    -0x1.62e430p-4
  },
  { // Entry 431
    0x1.6355e7102bb7d9dbd8b8b0d68c09401bp-4,
    0x1.62e430p-4
  },
  { // Entry 432
    -0x1.6355e50e3f6d2cc2dd6e747f61bb8c65p-4,
    -0x1.62e42ep-4
  },
  { // Entry 433
    0x1.6355e50e3f6d2cc2dd6e747f61bb8c65p-4,
    0x1.62e42ep-4
  },
  { // Entry 434
    -0x1.6355e30c5322853739b87125ec22bdecp-4,
    -0x1.62e42cp-4
  },
  { // Entry 435
    0x1.6355e30c5322853739b87125ec22bdecp-4,
    0x1.62e42cp-4
  },
  { // Entry 436
    -0x1.63009bb7a0f1fda3e41657180afe2797p-5,
    -0x1.62e430p-5
  },
  { // Entry 437
    0x1.63009bb7a0f1fda3e41657180afe2797p-5,
    0x1.62e430p-5
  },
  { // Entry 438
    -0x1.630099b725ee198cf48f439e2807bf07p-5,
    -0x1.62e42ep-5
  },
  { // Entry 439
    0x1.630099b725ee198cf48f439e2807bf07p-5,
    0x1.62e42ep-5
  },
  { // Entry 440
    -0x1.630097b6aaea36d905a1e74a332b0102p-5,
    -0x1.62e42cp-5
  },
  { // Entry 441
    0x1.630097b6aaea36d905a1e74a332b0102p-5,
    0x1.62e42cp-5
  },
  { // Entry 442
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 443
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 444
    0.0,
    0.0
  },
  { // Entry 445
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 446
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 447
    0x1.ecb35112d674d05785ec00066c2b3ec8p-4,
    0x1.eb851cp-4
  },
  { // Entry 448
    -0x1.ecb35112d674d05785ec00066c2b3ec8p-4,
    -0x1.eb851cp-4
  },
  { // Entry 449
    0x1.ecb35316874ebf73aba92491a44e079fp-4,
    0x1.eb851ep-4
  },
  { // Entry 450
    -0x1.ecb35316874ebf73aba92491a44e079fp-4,
    -0x1.eb851ep-4
  },
  { // Entry 451
    0x1.ecb3551a3828b6429eb2a33a17713014p-4,
    0x1.eb8520p-4
  },
  { // Entry 452
    -0x1.ecb3551a3828b6429eb2a33a17713014p-4,
    -0x1.eb8520p-4
  },
  { // Entry 453
    0x1.0accffddb7a12b4e6a96d72af3961f53p-1,
    0x1.fffffep-2
  },
  { // Entry 454
    -0x1.0accffddb7a12b4e6a96d72af3961f53p-1,
    -0x1.fffffep-2
  },
  { // Entry 455
    0x1.0acd00fe63b96ca357895761ae66224ap-1,
    0x1.p-1
  },
  { // Entry 456
    -0x1.0acd00fe63b96ca357895761ae66224ap-1,
    -0x1.p-1
  },
  { // Entry 457
    0x1.0acd033fbbeab766f2754da05aade930p-1,
    0x1.000002p-1
  },
  { // Entry 458
    -0x1.0acd033fbbeab766f2754da05aade930p-1,
    -0x1.000002p-1
  },
  { // Entry 459
    0x1.2cd9fab9e4439e75ab2524ffce0283e9p0,
    0x1.fffffep-1
  },
  { // Entry 460
    -0x1.2cd9fab9e4439e75ab2524ffce0283e9p0,
    -0x1.fffffep-1
  },
  { // Entry 461
    0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    0x1.p0
  },
  { // Entry 462
    -0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    -0x1.p0
  },
  { // Entry 463
    0x1.2cd9ff5afa44ba9aa6eb599be725c9bap0,
    0x1.000002p0
  },
  { // Entry 464
    -0x1.2cd9ff5afa44ba9aa6eb599be725c9bap0,
    -0x1.000002p0
  },
  { // Entry 465
    0x1.ab5aa630eb432540ea7a11d9455e5b65p30,
    0x1.5ffffep4
  },
  { // Entry 466
    -0x1.ab5aa630eb432540ea7a11d9455e5b65p30,
    -0x1.5ffffep4
  },
  { // Entry 467
    0x1.ab5adb9c435ff8194ddd9a72c8c01183p30,
    0x1.60p4
  },
  { // Entry 468
    -0x1.ab5adb9c435ff8194ddd9a72c8c01183p30,
    -0x1.60p4
  },
  { // Entry 469
    0x1.ab5b1107a22a36602250dcbb2b7eed81p30,
    0x1.600002p4
  },
  { // Entry 470
    -0x1.ab5b1107a22a36602250dcbb2b7eed81p30,
    -0x1.600002p4
  },
  { // Entry 471
    0x1.226aceedc3b97c2a0dd7e83bf16d5abdp32,
    0x1.6ffffep4
  },
  { // Entry 472
    -0x1.226aceedc3b97c2a0dd7e83bf16d5abdp32,
    -0x1.6ffffep4
  },
  { // Entry 473
    0x1.226af33b1fdc0a574c76ab2161309880p32,
    0x1.70p4
  },
  { // Entry 474
    -0x1.226af33b1fdc0a574c76ab2161309880p32,
    -0x1.70p4
  },
  { // Entry 475
    0x1.226b1788808844517796616972748648p32,
    0x1.700002p4
  },
  { // Entry 476
    -0x1.226b1788808844517796616972748648p32,
    -0x1.700002p4
  },
  { // Entry 477
    0x1.ffff8188b8b59acbb8a36c9f1de4adc7p22,
    0x1.0a2b20p4
  },
  { // Entry 478
    -0x1.ffff8188b8b59acbb8a36c9f1de4adc7p22,
    -0x1.0a2b20p4
  },
  { // Entry 479
    0x1.ffffc188ace6b110a80fe49615910ff2p22,
    0x1.0a2b22p4
  },
  { // Entry 480
    -0x1.ffffc188ace6b110a80fe49615910ff2p22,
    -0x1.0a2b22p4
  },
  { // Entry 481
    0x1.000000c4548be32ddd1950fdd39f4c49p23,
    0x1.0a2b24p4
  },
  { // Entry 482
    -0x1.000000c4548be32ddd1950fdd39f4c49p23,
    -0x1.0a2b24p4
  },
  { // Entry 483
    0x1.ffffbec45834f71f62c471559658238ap10,
    0x1.0a2b20p3
  },
  { // Entry 484
    -0x1.ffffbec45834f71f62c471559658238ap10,
    -0x1.0a2b20p3
  },
  { // Entry 485
    0x1.ffffdec455613c8f512d34bec21133e4p10,
    0x1.0a2b22p3
  },
  { // Entry 486
    -0x1.ffffdec455613c8f512d34bec21133e4p10,
    -0x1.0a2b22p3
  },
  { // Entry 487
    0x1.fffffec4548d81de03eb840f2501233dp10,
    0x1.0a2b24p3
  },
  { // Entry 488
    -0x1.fffffec4548d81de03eb840f2501233dp10,
    -0x1.0a2b24p3
  },
  { // Entry 489
    0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    0x1.65a9f6p6
  },
  { // Entry 490
    -0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    -0x1.65a9f6p6
  },
  { // Entry 491
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    0x1.65a9f8p6
  },
  { // Entry 492
    -0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    -0x1.65a9f8p6
  },
  { // Entry 493
    HUGE_VALF,
    0x1.65a9fap6
  },
  { // Entry 494
    -HUGE_VALF,
    -0x1.65a9fap6
  },
  { // Entry 495
    -HUGE_VALF,
    -0x1.65a9fap6
  },
  { // Entry 496
    HUGE_VALF,
    0x1.65a9fap6
  },
  { // Entry 497
    -0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    -0x1.65a9f8p6
  },
  { // Entry 498
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    0x1.65a9f8p6
  },
  { // Entry 499
    -0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    -0x1.65a9f6p6
  },
  { // Entry 500
    0x1.fffed83ee2532ac846bdff097cd2f43bp127,
    0x1.65a9f6p6
  },
  { // Entry 501
    0x1.fffffe00000000055555455555655559p-31,
    0x1.fffffep-31
  },
  { // Entry 502
    -0x1.fffffe00000000055555455555655559p-31,
    -0x1.fffffep-31
  },
  { // Entry 503
    0x1.0000000000000002aaaaaaaaaaaaaaacp-30,
    0x1.p-30
  },
  { // Entry 504
    -0x1.0000000000000002aaaaaaaaaaaaaaacp-30,
    -0x1.p-30
  },
  { // Entry 505
    0x1.0000020000000002aaaabaaaaacaaaacp-30,
    0x1.000002p-30
  },
  { // Entry 506
    -0x1.0000020000000002aaaabaaaaacaaaacp-30,
    -0x1.000002p-30
  },
  { // Entry 507
    0x1.fffffe0155555155999d984449720172p-16,
    0x1.fffffep-16
  },
  { // Entry 508
    -0x1.fffffe0155555155999d984449720172p-16,
    -0x1.fffffep-16
  },
  { // Entry 509
    0x1.00000000aaaaaaaaccccccccd00d00d0p-15,
    0x1.p-15
  },
  { // Entry 510
    -0x1.00000000aaaaaaaaccccccccd00d00d0p-15,
    -0x1.p-15
  },
  { // Entry 511
    0x1.00000200aaaaaeaaccd4ce222abd00fdp-15,
    0x1.000002p-15
  },
  { // Entry 512
    -0x1.00000200aaaaaeaaccd4ce222abd00fdp-15,
    -0x1.000002p-15
  },
  { // Entry 513
    0x1.0002a9acc4cd92374b92f33d0d8e44f7p-6,
    0x1.fffffep-7
  },
  { // Entry 514
    -0x1.0002a9acc4cd92374b92f33d0d8e44f7p-6,
    -0x1.fffffep-7
  },
  { // Entry 515
    0x1.0002aaaccccd9cd9fbd8a7d1dc72c44bp-6,
    0x1.p-6
  },
  { // Entry 516
    -0x1.0002aaaccccd9cd9fbd8a7d1dc72c44bp-6,
    -0x1.p-6
  },
  { // Entry 517
    0x1.0002acacdccdb24f5ce4216260c9d73ep-6,
    0x1.000002p-6
  },
  { // Entry 518
    -0x1.0002acacdccdb24f5ce4216260c9d73ep-6,
    -0x1.000002p-6
  },
  { // Entry 519
    0x1.000aa9ccad0025af274480ba84b0fbbcp-5,
    0x1.fffffep-6
  },
  { // Entry 520
    -0x1.000aa9ccad0025af274480ba84b0fbbcp-5,
    -0x1.fffffep-6
  },
  { // Entry 521
    0x1.000aaacccd00d03b3cb23dfecf8fcbdcp-5,
    0x1.p-5
  },
  { // Entry 522
    -0x1.000aaacccd00d03b3cb23dfecf8fcbdcp-5,
    -0x1.p-5
  },
  { // Entry 523
    0x1.000aaccd0d0226136f8e122926144f90p-5,
    0x1.000002p-5
  },
  { // Entry 524
    -0x1.000aaccd0d0226136f8e122926144f90p-5,
    -0x1.000002p-5
  },
  { // Entry 525
    0x1.002aabcc59c3209063dc64ea2e03bf70p-4,
    0x1.fffffep-5
  },
  { // Entry 526
    -0x1.002aabcc59c3209063dc64ea2e03bf70p-4,
    -0x1.fffffep-5
  },
  { // Entry 527
    0x1.002aacccd9cdcb1600814d8ee0ea5e98p-4,
    0x1.p-4
  },
  { // Entry 528
    -0x1.002aacccd9cdcb1600814d8ee0ea5e98p-4,
    -0x1.p-4
  },
  { // Entry 529
    0x1.002aaecdd9e32321b9d285e5bac4a4bdp-4,
    0x1.000002p-4
  },
  { // Entry 530
    -0x1.002aaecdd9e32321b9d285e5bac4a4bdp-4,
    -0x1.000002p-4
  },
  { // Entry 531
    0x1.00aacbce0c844e1659887b1aa3a95e84p-3,
    0x1.fffffep-4
  },
  { // Entry 532
    -0x1.00aacbce0c844e1659887b1aa3a95e84p-3,
    -0x1.fffffep-4
  },
  { // Entry 533
    0x1.00aaccd00d2f0d82badd7396c439091ep-3,
    0x1.p-3
  },
  { // Entry 534
    -0x1.00aaccd00d2f0d82badd7396c439091ep-3,
    -0x1.p-3
  },
  { // Entry 535
    0x1.00aaced40e8498637f252d2fe50c3df3p-3,
    0x1.000002p-3
  },
  { // Entry 536
    -0x1.00aaced40e8498637f252d2fe50c3df3p-3,
    -0x1.000002p-3
  },
  { // Entry 537
    0x1.02accc94fd5fc9d5c6d93f41fe780d47p-2,
    0x1.fffffep-3
  },
  { // Entry 538
    -0x1.02accc94fd5fc9d5c6d93f41fe780d47p-2,
    -0x1.fffffep-3
  },
  { // Entry 539
    0x1.02accd9d08101e6674cdf3fc8eaabf2ap-2,
    0x1.p-2
  },
  { // Entry 540
    -0x1.02accd9d08101e6674cdf3fc8eaabf2ap-2,
    -0x1.p-2
  },
  { // Entry 541
    0x1.02accfad1d70f80837554f9fbb4fbbb9p-2,
    0x1.000002p-2
  },
  { // Entry 542
    -0x1.02accfad1d70f80837554f9fbb4fbbb9p-2,
    -0x1.000002p-2
  },
  { // Entry 543
    0x1.d03cf2784edbd911feefcda4d65799f9p1,
    0x1.fffffep0
  },
  { // Entry 544
    -0x1.d03cf2784edbd911feefcda4d65799f9p1,
    -0x1.fffffep0
  },
  { // Entry 545
    0x1.d03cf63b6e19f6f34c802c96200970efp1,
    0x1.p1
  },
  { // Entry 546
    -0x1.d03cf63b6e19f6f34c802c96200970efp1,
    -0x1.p1
  },
  { // Entry 547
    0x1.d03cfdc1acabf591817690cd031d2cc7p1,
    0x1.000002p1
  },
  { // Entry 548
    -0x1.d03cfdc1acabf591817690cd031d2cc7p1,
    -0x1.000002p1
  },
  { // Entry 549
    0x1.b4a37963495a7a1c36845b0346599916p4,
    0x1.fffffep1
  },
  { // Entry 550
    -0x1.b4a37963495a7a1c36845b0346599916p4,
    -0x1.fffffep1
  },
  { // Entry 551
    0x1.b4a3803703630c8fe70261d92e563a88p4,
    0x1.p2
  },
  { // Entry 552
    -0x1.b4a3803703630c8fe70261d92e563a88p4,
    -0x1.p2
  },
  { // Entry 553
    0x1.b4a38dde77c6101fbf8ab4c24ce6ac27p4,
    0x1.000002p2
  },
  { // Entry 554
    -0x1.b4a38dde77c6101fbf8ab4c24ce6ac27p4,
    -0x1.000002p2
  },
  { // Entry 555
    0x1.749e996ff7805133d5d6b4402bd52f34p10,
    0x1.fffffep2
  },
  { // Entry 556
    -0x1.749e996ff7805133d5d6b4402bd52f34p10,
    -0x1.fffffep2
  },
  { // Entry 557
    0x1.749ea514eca65d06ea7688aff46cfe09p10,
    0x1.p3
  },
  { // Entry 558
    -0x1.749ea514eca65d06ea7688aff46cfe09p10,
    -0x1.p3
  },
  { // Entry 559
    0x1.749ebc5ed809ebabcca514f4a486c5a8p10,
    0x1.000002p3
  },
  { // Entry 560
    -0x1.749ebc5ed809ebabcca514f4a486c5a8p10,
    -0x1.000002p3
  },
  { // Entry 561
    0x1.0f2eac1794b52d4201f8831417012cc1p22,
    0x1.fffffep3
  },
  { // Entry 562
    -0x1.0f2eac1794b52d4201f8831417012cc1p22,
    -0x1.fffffep3
  },
  { // Entry 563
    0x1.0f2ebd0a7ffe3de6ac939fced0122707p22,
    0x1.p4
  },
  { // Entry 564
    -0x1.0f2ebd0a7ffe3de6ac939fced0122707p22,
    -0x1.p4
  },
  { // Entry 565
    0x1.0f2edef059bdeb7814367009089b255ap22,
    0x1.000002p4
  },
  { // Entry 566
    -0x1.0f2edef059bdeb7814367009089b255ap22,
    -0x1.000002p4
  },
  { // Entry 567
    0x1.1f43d8dc3908b8ed87a5abc6c3ed2c73p45,
    0x1.fffffep4
  },
  { // Entry 568
    -0x1.1f43d8dc3908b8ed87a5abc6c3ed2c73p45,
    -0x1.fffffep4
  },
  { // Entry 569
    0x1.1f43fcc4b662c7d847884009ffe4c4c3p45,
    0x1.p5
  },
  { // Entry 570
    -0x1.1f43fcc4b662c7d847884009ffe4c4c3p45,
    -0x1.p5
  },
  { // Entry 571
    0x1.1f444495be8e1616a1e5e37a356cd622p45,
    0x1.000002p5
  },
  { // Entry 572
    -0x1.1f444495be8e1616a1e5e37a356cd622p45,
    -0x1.000002p5
  },
  { // Entry 573
    0x1.4259323902dbc6e62e3e07ce26cd904cp91,
    0x1.fffffep5
  },
  { // Entry 574
    -0x1.4259323902dbc6e62e3e07ce26cd904cp91,
    -0x1.fffffep5
  },
  { // Entry 575
    0x1.425982cf597cd205ce3d5b4edb031756p91,
    0x1.p6
  },
  { // Entry 576
    -0x1.425982cf597cd205ce3d5b4edb031756p91,
    -0x1.p6
  },
  { // Entry 577
    0x1.425a23fc432fb5d556006a4d8e7ee11bp91,
    0x1.000002p6
  },
  { // Entry 578
    -0x1.425a23fc432fb5d556006a4d8e7ee11bp91,
    -0x1.000002p6
  },
  { // Entry 579
    -HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 580
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 581
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 582
    -HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 583
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 584
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 585
    HUGE_VALF,
    0x1.fffffcp127
  },
  { // Entry 586
    0x1.718f47f73f26d7350c83f4c71e2d335ep3,
    0x1.921fb6p1
  },
  { // Entry 587
    0x1.2690f74d668ce2b3a755fcc5d03d001ap1,
    0x1.921fb6p0
  },
  { // Entry 588
    0x1.2cd9ff5afa44ba9aa6eb599be725c9bap0,
    0x1.000002p0
  },
  { // Entry 589
    0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    0x1.p0
  },
  { // Entry 590
    0x1.2cd9fab9e4439e75ab2524ffce0283e9p0,
    0x1.fffffep-1
  },
  { // Entry 591
    0x1.bcc271add0bab156a8d0a0df56b0db93p-1,
    0x1.921fb6p-1
  },
  { // Entry 592
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 593
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 594
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 595
    0x1.fffff8p-127,
    0x1.fffff8p-127
  },
  { // Entry 596
    0x1.p-148,
    0x1.p-148
  },
  { // Entry 597
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 598
    0.0,
    0.0f
  },
  { // Entry 599
    -0.0,
    -0.0f
  },
  { // Entry 600
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 601
    -0x1.p-148,
    -0x1.p-148
  },
  { // Entry 602
    -0x1.fffff8p-127,
    -0x1.fffff8p-127
  },
  { // Entry 603
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 604
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 605
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 606
    -0x1.bcc271add0bab156a8d0a0df56b0db93p-1,
    -0x1.921fb6p-1
  },
  { // Entry 607
    -0x1.2cd9fab9e4439e75ab2524ffce0283e9p0,
    -0x1.fffffep-1
  },
  { // Entry 608
    -0x1.2cd9fc44eb9825a80249487f064ffd5cp0,
    -0x1.p0
  },
  { // Entry 609
    -0x1.2cd9ff5afa44ba9aa6eb599be725c9bap0,
    -0x1.000002p0
  },
  { // Entry 610
    -0x1.2690f74d668ce2b3a755fcc5d03d001ap1,
    -0x1.921fb6p0
  },
  { // Entry 611
    -0x1.718f47f73f26d7350c83f4c71e2d335ep3,
    -0x1.921fb6p1
  },
  { // Entry 612
    -HUGE_VALF,
    -0x1.fffffcp127
  },
  { // Entry 613
    -HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 614
    -HUGE_VALF,
    -HUGE_VALF
  },
  { // Entry 615
    0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    0x1.65a9f8p6
  },
  { // Entry 616
    -0x1.ffffd83e8e7281a45e432bd58cbbc38ap127,
    -0x1.65a9f8p6
  },
  { // Entry 617
    HUGE_VALF,
    0x1.65a9fap6
  },
  { // Entry 618
    -HUGE_VALF,
    -0x1.65a9fap6
  }
};
