/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<double, double> g_log2_intel_data[] = {
  { // Entry 0
    -0x1.fefffffffffffff4755c4d6a3e815099p9,
    0x1.0000000000001p-1022
  },
  { // Entry 1
    -0x1.dfffffffffa3a7ffc265aaf2255b6929p3,
    0x1.0000000002001p-15
  },
  { // Entry 2
    0x1.14ff58be06e4eb0f63ba8e7579bab913p-37,
    0x1.00000000060p0
  },
  { // Entry 3
    0x1.14ff5a1566a9a8000208af7208121486p-26,
    0x1.0000003000004p0
  },
  { // Entry 4
    0x1.4329e6fafed4ec17674fb20107ee4738p-24,
    0x1.000000ep0
  },
  { // Entry 5
    0x1.f2d8fc80dac97800003cbce6797ac725p-22,
    0x1.0000056719764p0
  },
  { // Entry 6
    0x1.dc413771d9f3c80050b7ef09134bfc65p-10,
    0x1.005294a5294a4p0
  },
  { // Entry 7
    0x1.f94f46da272ae87214f66783dc0012aep-10,
    0x1.00579f3c8a71dp0
  },
  { // Entry 8
    0x1.5af457c06976d86934e812fcabd086a0p-9,
    0x1.00785b0addce9p0
  },
  { // Entry 9
    0x1.9002e361d485cbe42f7c524eb194d904p6,
    0x1.0080402010080p100
  },
  { // Entry 10
    0x1.ebccc1095cfa8866ace79cfc00544c63p-9,
    0x1.00aaaaaaaa9abp0
  },
  { // Entry 11
    0x1.6fe50b6ef08517f8e37b001794f4441cp-7,
    0x1.020p0
  },
  { // Entry 12
    -0x1.f15f624786a9ffffff74dc63a8516430p-1,
    0x1.051eb856134c8p-1
  },
  { // Entry 13
    0x1.d73e46341148efff33d83f08a3113bb1p-6,
    0x1.0527acc8ad0c0p0
  },
  { // Entry 14
    0x1.06844f3329cf480160c9207b0fe9686dp-5,
    0x1.05bffd7177f90p0
  },
  { // Entry 15
    0x1.6d16ccbfe831300071d2e127dcadc62cp-5,
    0x1.080813d392eeap0
  },
  { // Entry 16
    0x1.bd735eb18cf5e801185222972fe7d7f7p-5,
    0x1.09d53e5078566p0
  },
  { // Entry 17
    0x1.883a578a2144d80000082236bb975a7bp6,
    0x1.0a4fea894ce63p98
  },
  { // Entry 18
    0x1.e52bb32dde0e37835b09979ee48eb915p-5,
    0x1.0aba57c4ca2d2p0
  },
  { // Entry 19
    0x1.8c4d60a6f91cffffffc4db521ec23052p1,
    0x1.11a2ad570fc84p3
  },
  { // Entry 20
    0x1.3c10652cd2c037b722d8c301a9cbb787p-3,
    0x1.1ce739ce739cdp0
  },
  { // Entry 21
    0x1.25a57ea54060affffd6e2b38d8a6e680p3,
    0x1.214e5031c9c98p9
  },
  { // Entry 22
    -0x1.95d8976fa2bec7fffe44e71ab30da275p-1,
    0x1.2790a7a4ac2e0p-1
  },
  { // Entry 23
    0x1.ad532cd7cfc0c800fec9752b0728c5e1p-3,
    0x1.280958add66e8p0
  },
  { // Entry 24
    -0x1.92a321a719e2f7ffffa46c9962f213fcp-1,
    0x1.28da10faa7922p-1
  },
  { // Entry 25
    0x1.f00d883a5154c80b7cdca07e1f4c03b7p-3,
    0x1.2ecc5d98bb317p0
  },
  { // Entry 26
    -0x1.79538de327eb0000008a31eeec5b4479p-1,
    0x1.333333363af15p-1
  },
  { // Entry 27
    -0x1.79538dd93df7d800008833cc9d230deap-1,
    0x1.3333333a5a724p-1
  },
  { // Entry 28
    0x1.83988d0dfa3b6fffff7c315d9eb388a3p-2,
    0x1.4ccccccd37c59p0
  },
  { // Entry 29
    0x1.83988d1cb5af2ffffffb364351973dbfp-2,
    0x1.4cccccd08960ap0
  },
  { // Entry 30
    0x1.60e6235281e10fffff72c07b47d5653ap0,
    0x1.4cccccdabef48p1
  },
  { // Entry 31
    0x1.325fe221441468000004dbe427ffcc6ap1,
    0x1.5049964882f16p2
  },
  { // Entry 32
    -0x1.95c01a39fbdf57ffa2ec6f697886f6abp0,
    0x1.55555555554d3p-2
  },
  { // Entry 33
    0x1.b219b408ac406801297f9c0f313a0abcp-2,
    0x1.57715d9c62be2p0
  },
  { // Entry 34
    -0x1.14c560fe68af880e0a0f337d55565281p-1,
    0x1.6p-1
  },
  { // Entry 35
    -0x1.5140ccfbc94ba7fc14cae25af1322e19p3,
    0x1.6057ff1745294p-11
  },
  { // Entry 36
    0x1.7c44eecc79d9080000884a87ce09a1e3p0,
    0x1.6666667712026p1
  },
  { // Entry 37
    0x1.f44c3b80ce1b7f53077e2d0ba2df3c58p-2,
    0x1.672ea4c8ed13cp0
  },
  { // Entry 38
    0x1.7e3d59b76fecf800001f276bfc801af5p0,
    0x1.685132bfb7bd6p1
  },
  { // Entry 39
    -0x1.a02b5ec4fc7c87ff9784e19a86accb9ep2,
    0x1.696p-7
  },
  { // Entry 40
    0x1.fffffffffff39d44979cc67bcf7dedfap-2,
    0x1.6a09e667f3b9cp0
  },
  { // Entry 41
    -0x1.ffffffffffe3d5cb0585a3840c91514cp-2,
    0x1.6a09e667f3c3bp-1
  },
  { // Entry 42
    -0x1.ebe47960e3c087fe4e5268625f5a697ap-2,
    0x1.6f0p-1
  },
  { // Entry 43
    -0x1.9e9716d1cb72c80133c5f0f373cd97d0p2,
    0x1.6f9be6f9be6f8p-7
  },
  { // Entry 44
    0x1.182ffdcced70affff9846eab53e769dfp-1,
    0x1.761702ac1314cp0
  },
  { // Entry 45
    -0x1.c5272484399d1fffa79b8c4ab89ea8bcp-2,
    0x1.78c0475799b40p-1
  },
  { // Entry 46
    -0x1.c1bae6863c7b178789fef871a533f17ap-2,
    0x1.79ap-1
  },
  { // Entry 47
    -0x1.b7fcec2565ee77fbd36d69837dd95420p1,
    0x1.7a17944879f04p-4
  },
  { // Entry 48
    0x1.95c01a410a1af7ffffffff18ac20bc4fp0,
    0x1.8000000756038p1
  },
  { // Entry 49
    -0x1.b5a2a91024a237fc250d48b7dfc575f6p6,
    0x1.81a6a65785de5p-110
  },
  { // Entry 50
    -0x1.5b2c3da19723a80db6a0480592812599p0,
    0x1.9p-2
  },
  { // Entry 51
    -0x1.9596d761c3c1f000942a87960c4e6acap2,
    0x1.954p-7
  },
  { // Entry 52
    -0x1.361f7a0f40acf80008a3cdbb56ef43a3p-2,
    0x1.9f0d1c4a85df8p-1
  },
  { // Entry 53
    -0x1.a64a14ea31ff27ffffc6e0491c00ece0p1,
    0x1.a01f56d5c8bf5p-4
  },
  { // Entry 54
    0x1.36bda7028a6c18000436ccebd654b112p3,
    0x1.a2f4704a7b7fcp9
  },
  { // Entry 55
    -0x1.9162c8a7c89d6fff3b61696cc0cb7b08p2,
    0x1.a82p-7
  },
  { // Entry 56
    -0x1.3df5f27f08238fff3d930b0aa7b67e19p0,
    0x1.b0ec3b0ec3b0cp-2
  },
  { // Entry 57
    0x1.c20a0d80f7dc7000c26cf4f5584981e6p0,
    0x1.b0ec3b0ec3b0cp1
  },
  { // Entry 58
    0x1.f32d6c73fe4eb00000998f802fd894a2p2,
    0x1.bd9cec1c72c90p7
  },
  { // Entry 59
    -0x1.4f575b7d4160880182c6f69306d03c28p-3,
    0x1.c910ef0d6d89fp-1
  },
  { // Entry 60
    -0x1.4f278abffb110801a3d7edcb79ee5f32p-3,
    0x1.c91854af9ee26p-1
  },
  { // Entry 61
    -0x1.285378da90d7e7fb008eedf0a10fba48p-3,
    0x1.cf243ff1971a1p-1
  },
  { // Entry 62
    0x1.b74949020f785800105ca3140afb53b5p-1,
    0x1.d00000080p0
  },
  { // Entry 63
    -0x1.020fbb4ae01c67fa85f5128eef800678p-3,
    0x1.d52db96328edcp-1
  },
  { // Entry 64
    0x1.730a8d241efbb7fffff32ce95a694993p1,
    0x1.dd4d6407c04c0p2
  },
  { // Entry 65
    -0x1.7d06d263cf06e8013519197ee311d70dp-4,
    0x1.e007446d5317ap-1
  },
  { // Entry 66
    -0x1.651a043e59908801518f9ad8a730b006p-4,
    0x1.e1f9cfe4da365p-1
  },
  { // Entry 67
    -0x1.c315ace83f6d87ffd47ee348821be931p-5,
    0x1.ecd393ee2a22dp-1
  },
  { // Entry 68
    -0x1.c1a2dd30e92c97fe1e8a8927bca88d09p-5,
    0x1.ece30a99708f3p-1
  },
  { // Entry 69
    -0x1.31811414c9f457fedb339a2a59aa6a15p-5,
    0x1.f2ef441966b20p-1
  },
  { // Entry 70
    -0x1.ff54d4e01906700082476686f339feb0p-6,
    0x1.f50b068c69ab9p-1
  },
  { // Entry 71
    -0x1.fe4764e025a7a8010db1b6cf13da17afp-6,
    0x1.f510bcafa535bp-1
  },
  { // Entry 72
    -0x1.e9c8fb8a7a8ff9f9d482d43f89c910f1p-6,
    0x1.f58p-1
  },
  { // Entry 73
    -0x1.cff929eee46f28012d55ba72f9106a3fp-6,
    0x1.f60c45b178d4dp-1
  },
  { // Entry 74
    -0x1.cfbe0973d009a801f32a0b405f64c8fbp-6,
    0x1.f60d8730dc09ap-1
  },
  { // Entry 75
    -0x1.aef13de1197f92a24897297a335df9e7p-6,
    0x1.f6cp-1
  },
  { // Entry 76
    -0x1.a2551c8f2ac46800ba85b1a1eae0a6e2p-6,
    0x1.f704add85e4a5p-1
  },
  { // Entry 77
    -0x1.a21fbdfed5c5a801e2269de517fa7ab6p-6,
    0x1.f705d098ffd9dp-1
  },
  { // Entry 78
    -0x1.a0b920176bda5800c044f6f904f1595cp-6,
    0x1.f70d7261c2ba0p-1
  },
  { // Entry 79
    -0x1.c587cdb2b5cc67cae4990a6eaf50ba8cp-9,
    0x1.fec603682f6b8p-1
  },
  { // Entry 80
    -0x1.7c16ffe1cccb47d5379db27f7b490df5p-9,
    0x1.fef8ce70306d5p-1
  },
  { // Entry 81
    -0x1.71b0ea42e4e818440ecc7e467e125d9cp-9,
    0x1.ff0000000000cp-1
  },
  { // Entry 82
    -0x1.71b0ea42c98838d39811a1f869da817dp-9,
    0x1.ff0000000013bp-1
  },
  { // Entry 83
    -0x1.fe3672e0fc0b17be54e4caf20434a198p-10,
    0x1.ff4f4b00a4f8ep-1
  },
  { // Entry 84
    -0x1.f914d523f178576eeb72527f2b70a29cp-10,
    0x1.ff5111a810580p-1
  },
  { // Entry 85
    -0x1.f914d523ee66777286ccfd4913235594p-10,
    0x1.ff5111a810591p-1
  },
  { // Entry 86
    -0x1.de7e861144ac97832a4e3a5d92856809p-10,
    0x1.ff5a457a5e13ep-1
  },
  { // Entry 87
    -0x1.b6d5736af0ac97d260200b6dea2e4c1bp-10,
    0x1.ff67fffffffffp-1
  },
  { // Entry 88
    -0x1.54c6cf781fa087d33241ec17c4837255p-10,
    0x1.ff89f2f328ed2p-1
  },
  { // Entry 89
    -0x1.fb243353a93b57621a8538f059d9ae9cp-11,
    0x1.ffa826070f4cbp-1
  },
  { // Entry 90
    -0x1.b82668250050d778d8993a10e828c390p-11,
    0x1.ffb3bffffffffp-1
  },
  { // Entry 91
    -0x1.c0050ccaf8b8980002bd379e2a6c6214p2,
    0x1.ffe3fffffc050p-8
  },
  { // Entry 92
    -0x1.7d4120671257680005a86d606dcf2f32p-14,
    0x1.fff7bdf17bdefp-1
  },
  { // Entry 93
    -0x1.018000b8aaf5a80007b2db4c192253cbp10,
    0x1.fffbfffff5ep-1031
  },
  { // Entry 94
    -0x1.14ff72b62bdf4ffe64fb34d59dd51e74p-18,
    0x1.ffff9ffffffffp-1
  },
  { // Entry 95
    -0x1.f8000171548d6801817dc6695b1d7bb1p5,
    0x1.ffffcp-64
  },
  { // Entry 96
    -0x1.fe4a9a023f0577fdff3db84b62d9f2eap-21,
    0x1.ffffe9e4b0628p-1
  },
  { // Entry 97
    -0x1.fa4ac0aba3c2a7fc024396607228ba9dp-21,
    0x1.ffffea110b39dp-1
  },
  { // Entry 98
    -0x1.d6a5b47f4af0f7fd4f300c0b6918c63fp-21,
    0x1.ffffeb9c5b2d8p-1
  },
  { // Entry 99
    -0x1.715477c9d1f81923f8738f56fafb397bp-29,
    0x1.ffffffeffffffp-1
  },
  { // Entry 100
    -0x1.886a76622be3cab6d2103fbee1307674p-36,
    0x1.ffffffffddfffp-1
  },
  { // Entry 101
    -0x1.1500ca1283b5a7fbb9fa255a6b5e382bp-37,
    0x1.fffffffff3fffp-1
  },
  { // Entry 102
    -0x1.8000000000b8b0007b35bf2c5e4202cep1,
    0x1.fffffffffdfffp-4
  },
  { // Entry 103
    -0x1.00000000005c58003d9adf962f210167p2,
    0x1.fffffffffdfffp-5
  },
  { // Entry 104
    -0x1.40000000005c58003d9adf962f210167p2,
    0x1.fffffffffdfffp-6
  },
  { // Entry 105
    -0x1.c0000000005c58003d9adf962f210167p2,
    0x1.fffffffffdfffp-8
  },
  { // Entry 106
    0x1.7fffffffff474fff84ca40d3a1bdfd31p1,
    0x1.fffffffffdfffp2
  },
  { // Entry 107
    -0x1.9f7f051d0f361814496a13788aa1cd5fp-50,
    0x1.ffffffffffff7p-1
  },
  { // Entry 108
    -0x1.000000000000126e8d1ea7de883e83ddp-1,
    0x1.6a09e667f3bccp-1
  },
  { // Entry 109
    -0x1.5614640c6fbc486cb295b10f8abd6939p-2,
    0x1.962b5f9438d25p-1
  },
  { // Entry 110
    -0x1.7b67e3d8e1879c50407e8e09ca62d7c2p-3,
    0x1.c24cd8c07de7ep-1
  },
  { // Entry 111
    -0x1.9cab985fe1d8d99581e09a95c3fac8e5p-5,
    0x1.ee6e51ecc2fd7p-1
  },
  { // Entry 112
    0x1.2ae04a51c9bc0b1821ec386516792b26p-4,
    0x1.0d47e58c84098p0
  },
  { // Entry 113
    0x1.7e235191cc46bfaed961bbad6075fcacp-3,
    0x1.2358a222a6944p0
  },
  { // Entry 114
    0x1.2aebb4eed34bf42bc5448a189070885ap-2,
    0x1.39695eb8c91f0p0
  },
  { // Entry 115
    0x1.8f6e7fe9764c2e91cb4ffe5f0bc8c5bdp-2,
    0x1.4f7a1b4eeba9cp0
  },
  { // Entry 116
    0x1.ed89a2dc1bb787ab7102598199c4314ep-2,
    0x1.658ad7e50e348p0
  },
  { // Entry 117
    0x1.2300d01a02b0f4c423375f5f27dc7268p-1,
    0x1.7b9b947b30bf4p0
  },
  { // Entry 118
    0x1.4cbcd1db0cd52626c88c135def6fe9adp-1,
    0x1.91ac5111534a0p0
  },
  { // Entry 119
    0x1.743d53168a525134e8343eebcf59fe0ep-1,
    0x1.a7bd0da775d4cp0
  },
  { // Entry 120
    0x1.99bc604e5748bb53276e45341eb98a06p-1,
    0x1.bdcdca3d985f8p0
  },
  { // Entry 121
    0x1.bd6b9ae6661c8790715131587a707f63p-1,
    0x1.d3de86d3baea4p0
  },
  { // Entry 122
    0x1.df75c6b861b93599aaeb3776b6013c7dp-1,
    0x1.e9ef4369dd750p0
  },
  { // Entry 123
    0x1.ffffffffffffa3aae26b51f401dccee2p-1,
    0x1.ffffffffffffcp0
  },
  { // Entry 124
    -0x1.000000000000126e8d1ea7de883e83ddp-1,
    0x1.6a09e667f3bccp-1
  },
  { // Entry 125
    -0x1.733246b9a317f0bca830a0c588c3277bp-2,
    0x1.8e3e170bf282dp-1
  },
  { // Entry 126
    -0x1.e54e37a9c4bd980cfe450419c6f883fcp-3,
    0x1.b27247aff148ep-1
  },
  { // Entry 127
    -0x1.f19dcbcf827de4f7d32b492b04a24c27p-4,
    0x1.d6a67853f00efp-1
  },
  { // Entry 128
    -0x1.dd88a259f451a87b03861bb7688f43cep-7,
    0x1.fadaa8f7eed50p-1
  },
  { // Entry 129
    0x1.5c01a39fbd67e68597bbe1ac26c6be25p-4,
    0x1.0f876ccdf6cd9p0
  },
  { // Entry 130
    0x1.6cb0f6865c8e97c69cfca0255e6776bap-3,
    0x1.21a1851ff630ap0
  },
  { // Entry 131
    0x1.0fe8572e5293c2a44ea258726691bcdep-2,
    0x1.33bb9d71f593bp0
  },
  { // Entry 132
    0x1.64594d130cfbbf489ca3faaa8e6ee937p-2,
    0x1.45d5b5c3f4f6cp0
  },
  { // Entry 133
    0x1.b439310b4187ea516fa4708c4226a66dp-2,
    0x1.57efce15f459dp0
  },
  { // Entry 134
    0x1.ffffffffffffdb22e5c2b042ef82f844p-2,
    0x1.6a09e667f3bccp0
  },
  { // Entry 135
    -0x1.a8ff971810a5e1817fd3b7d7e5d148bbp-2,
    0x1.8p-1
  },
  { // Entry 136
    -0x1.1c31ddd1b3bdb7e45c68feca52877fddp-2,
    0x1.a666666666666p-1
  },
  { // Entry 137
    -0x1.374d65d9e60937e1e9c3af53f2460781p-3,
    0x1.cccccccccccccp-1
  },
  { // Entry 138
    -0x1.2b38505f8a2a84910fe2def6e099c1a4p-5,
    0x1.f333333333332p-1
  },
  { // Entry 139
    0x1.20508f547ede543575d3d1c5271c8aebp-4,
    0x1.0ccccccccccccp0
  },
  { // Entry 140
    0x1.5c01a39fbd67d5d476c5408b1c684536p-3,
    0x1.1ffffffffffffp0
  },
  { // Entry 141
    0x1.0d58e42b1da11244cfd82a2743f07a46p-2,
    0x1.3333333333332p0
  },
  { // Entry 142
    0x1.66e8c01641ed632aa3e56de7648499cdp-2,
    0x1.4666666666665p0
  },
  { // Entry 143
    0x1.bb59b5fafc553e2891d2d31fea53fcb0p-2,
    0x1.5999999999998p0
  },
  { // Entry 144
    0x1.059cccf99870a58ae5bee787b5da3e26p-1,
    0x1.6cccccccccccbp0
  },
  { // Entry 145
    0x1.2b803473f7acd1b12c5db00c0f9d85f7p-1,
    0x1.7fffffffffffep0
  },
  { // Entry 146
    0.0,
    0x1.0p0
  },
  { // Entry 147
    0x1.199b728cb9d0c325536aa229a8894fd2p-3,
    0x1.199999999999ap0
  },
  { // Entry 148
    0x1.0d58e42b1da1ac2801254c3b38d1f6e5p-2,
    0x1.3333333333334p0
  },
  { // Entry 149
    0x1.83988d0c1f611efc28e37b6de8f0d25ep-2,
    0x1.4cccccccccccep0
  },
  { // Entry 150
    0x1.f113baed305e266df10e8a16d5d1b604p-2,
    0x1.6666666666668p0
  },
  { // Entry 151
    0x1.2b803473f7ad4ccd53ce981c057004fdp-1,
    0x1.8000000000002p0
  },
  { // Entry 152
    0x1.5b2c3da19723ed4d8ccfca8e89888f01p-1,
    0x1.999999999999cp0
  },
  { // Entry 153
    0x1.87f42b97294a21112b6763a4c5b15c5ep-1,
    0x1.b333333333336p0
  },
  { // Entry 154
    0x1.b22ca689867e189efbc280384c02430cp-1,
    0x1.cccccccccccd0p0
  },
  { // Entry 155
    0x1.da1c9885a0c428156893856b99d4ce5ap-1,
    0x1.e66666666666ap0
  },
  { // Entry 156
    0x1.p0,
    0x1.0p1
  },
  { // Entry 157
    0x1.90p6,
    0x1.0p100
  },
  { // Entry 158
    0x1.908ccdb9465ce86192a9b55114d444a7p6,
    0x1.199999999999ap100
  },
  { // Entry 159
    0x1.910d58e42b1da1ac2801254c3b38d1f6p6,
    0x1.3333333333334p100
  },
  { // Entry 160
    0x1.9183988d0c1f611efc28e37b6de8f0d2p6,
    0x1.4cccccccccccep100
  },
  { // Entry 161
    0x1.91f113baed305e266df10e8a16d5d1b6p6,
    0x1.6666666666668p100
  },
  { // Entry 162
    0x1.92570068e7ef5a999aa79d30380ae009p6,
    0x1.8000000000002p100
  },
  { // Entry 163
    0x1.92b6587b432e47da9b199f951d13111ep6,
    0x1.999999999999cp100
  },
  { // Entry 164
    0x1.930fe8572e5294422256cec7498b62b8p6,
    0x1.b333333333336p100
  },
  { // Entry 165
    0x1.9364594d130cfc313df7850070980486p6,
    0x1.cccccccccccd0p100
  },
  { // Entry 166
    0x1.93b439310b4188502ad1270ad733a99cp6,
    0x1.e66666666666ap100
  },
  { // Entry 167
    0x1.94p6,
    0x1.0p101
  },
  { // Entry 168
    0x1.90p7,
    0x1.0p200
  },
  { // Entry 169
    0x1.904666dca32e7430c954daa88a6a2253p7,
    0x1.199999999999ap200
  },
  { // Entry 170
    0x1.9086ac72158ed0d6140092a61d9c68fbp7,
    0x1.3333333333334p200
  },
  { // Entry 171
    0x1.90c1cc46860fb08f7e1471bdb6f47869p7,
    0x1.4cccccccccccep200
  },
  { // Entry 172
    0x1.90f889dd76982f1336f887450b6ae8dbp7,
    0x1.6666666666668p200
  },
  { // Entry 173
    0x1.912b803473f7ad4ccd53ce981c057004p7,
    0x1.8000000000002p200
  },
  { // Entry 174
    0x1.915b2c3da19723ed4d8ccfca8e89888fp7,
    0x1.999999999999cp200
  },
  { // Entry 175
    0x1.9187f42b97294a21112b6763a4c5b15cp7,
    0x1.b333333333336p200
  },
  { // Entry 176
    0x1.91b22ca689867e189efbc280384c0243p7,
    0x1.cccccccccccd0p200
  },
  { // Entry 177
    0x1.91da1c9885a0c428156893856b99d4cep7,
    0x1.e66666666666ap200
  },
  { // Entry 178
    0x1.92p7,
    0x1.0p201
  },
  { // Entry 179
    0x1.f4p9,
    0x1.0p1000
  },
  { // Entry 180
    0x1.f41199b728cb9d0c325536aa229a8894p9,
    0x1.199999999999ap1000
  },
  { // Entry 181
    0x1.f421ab1c8563b435850024a987671a3ep9,
    0x1.3333333333334p1000
  },
  { // Entry 182
    0x1.f4307311a183ec23df851c6f6dbd1e1ap9,
    0x1.4cccccccccccep1000
  },
  { // Entry 183
    0x1.f43e22775da60bc4cdbe21d142daba36p9,
    0x1.6666666666668p1000
  },
  { // Entry 184
    0x1.f44ae00d1cfdeb533354f3a607015c01p9,
    0x1.8000000000002p1000
  },
  { // Entry 185
    0x1.f456cb0f6865c8fb536333f2a3a26223p9,
    0x1.999999999999cp1000
  },
  { // Entry 186
    0x1.f461fd0ae5ca5288444ad9d8e9316c57p9,
    0x1.b333333333336p1000
  },
  { // Entry 187
    0x1.f46c8b29a2619f8627bef0a00e130090p9,
    0x1.cccccccccccd0p1000
  },
  { // Entry 188
    0x1.f47687262168310a055a24e15ae67533p9,
    0x1.e66666666666ap1000
  },
  { // Entry 189
    0x1.f480p9,
    0x1.0p1001
  },
  { // Entry 190
    -0x1.715481dd5c5d93663255eca7ba82aeb6p-20,
    0x1.ffffep-1
  },
  { // Entry 191
    -0x1.71547c180a27f362d17a1f59be1bb55dp-21,
    0x1.fffffp-1
  },
  { // Entry 192
    0.0,
    0x1.0p0
  },
  { // Entry 193
    0x1.7154708d66755d9fe119ed1e85c13f40p-21,
    0x1.0000080p0
  },
  { // Entry 194
    0x1.71546ac814f867d7a99ac240f177d35fp-20,
    0x1.00001p0
  },
  { // Entry 195
    -0x1.715476559ad8ce249f3237b562a13af0p-30,
    0x1.fffffff80p-1
  },
  { // Entry 196
    -0x1.71547654298457cc21b07cded2333ea6p-31,
    0x1.fffffffc0p-1
  },
  { // Entry 197
    0.0,
    0x1.0p0
  },
  { // Entry 198
    0x1.7154765146db6b26b150b9ea12c16a1ap-31,
    0x1.000000020p0
  },
  { // Entry 199
    0x1.7154764fd586f4d9be72b1a943d27a16p-30,
    0x1.000000040p0
  },
  { // Entry 200
    -0x1.71547652b8e88bb2a66c90adb569ed7cp-40,
    0x1.fffffffffe0p-1
  },
  { // Entry 201
    -0x1.71547652b88c369511be286039f5fb20p-41,
    0x1.ffffffffff0p-1
  },
  { // Entry 202
    0.0,
    0x1.0p0
  },
  { // Entry 203
    0x1.71547652b7d38c59e862106f7e37730ap-41,
    0x1.00000000008p0
  },
  { // Entry 204
    0x1.71547652b777373c53b460cc3decdcc6p-40,
    0x1.00000000010p0
  },
  { // Entry 205
    -0x1.71547652b8300fa20bda54a6d61b2f2ap-50,
    0x1.ffffffffffff8p-1
  },
  { // Entry 206
    -0x1.71547652b82ff88cc4752923d23e6580p-51,
    0x1.ffffffffffffcp-1
  },
  { // Entry 207
    0.0,
    0x1.0p0
  },
  { // Entry 208
    0x1.71547652b82fca6235aad21dd60f75dep-51,
    0x1.0000000000002p0
  },
  { // Entry 209
    0x1.71547652b82fb34cee45a69addbd4fe6p-50,
    0x1.0000000000004p0
  },
  { // Entry 210
    0x1.fffffffffffffffa3aae26b51f40630cp9,
    0x1.fffffffffffffp1023
  },
  { // Entry 211
    -0x1.0c80p10,
    0x1.0p-1074
  },
  { // Entry 212
    -0x1.00000000000033138899b7a32401fb1cp-1,
    0x1.6a09e667f3bcbp-1
  },
  { // Entry 213
    -0x1.000000000000126e8d1ea7de883e83ddp-1,
    0x1.6a09e667f3bccp-1
  },
  { // Entry 214
    -0x1.ffffffffffffe39323473033dbd8c22ap-2,
    0x1.6a09e667f3bcdp-1
  },
  { // Entry 215
    0x1.ffffffffffff99d8eecc90b9b7fc09c7p-2,
    0x1.6a09e667f3bcbp0
  },
  { // Entry 216
    0x1.ffffffffffffdb22e5c2b042ef82f844p-2,
    0x1.6a09e667f3bccp0
  },
  { // Entry 217
    0x1.0000000000000e366e5c67e612139eeap-1,
    0x1.6a09e667f3bcdp0
  },
  { // Entry 218
    -0x1.0000000000000b8aa3b295c17f39e677p0,
    0x1.fffffffffffffp-2
  },
  { // Entry 219
    -0x1.p0,
    0x1.0p-1
  },
  { // Entry 220
    -0x1.ffffffffffffd1d57135a8fa054264d4p-1,
    0x1.0000000000001p-1
  },
  { // Entry 221
    -0x1.a8ff971810a61f0f938c2bdfe202d351p-2,
    0x1.7ffffffffffffp-1
  },
  { // Entry 222
    -0x1.a8ff971810a5e1817fd3b7d7e5d148bbp-2,
    0x1.8p-1
  },
  { // Entry 223
    -0x1.a8ff971810a5a3f36c1b43cfec30544cp-2,
    0x1.8000000000001p-1
  },
  { // Entry 224
    0x1.2b803473f7acf0783639ea100efe9657p-1,
    0x1.7ffffffffffffp0
  },
  { // Entry 225
    0x1.2b803473f7ad0f3f401624140d175ba2p-1,
    0x1.8p0
  },
  { // Entry 226
    0x1.2b803473f7ad2e0649f25e1809e7d5d9p-1,
    0x1.8000000000001p0
  },
  { // Entry 227
    0x1.ebccc1098ad858c1fcb8223ebc3a2d89p-9,
    0x1.00aaaaaaaaaaap0
  },
  { // Entry 228
    0x1.ebccc1098b06649e343f78ac72257de7p-9,
    0x1.00aaaaaaaaaabp0
  },
  { // Entry 229
    0x1.ebccc1098b34707a6bc6cf17493ced63p-9,
    0x1.00aaaaaaaaaacp0
  },
  { // Entry 230
    0x1.fffffffffffff4755c4d6a3e80c61988p0,
    0x1.fffffffffffffp1
  },
  { // Entry 231
    0x1.p1,
    0x1.0p2
  },
  { // Entry 232
    0x1.0000000000000b8aa3b295c17eaf66cap1,
    0x1.0000000000001p2
  },
  { // Entry 233
    0x1.ffffffffffffe8eab89ad47d018c3311p-1,
    0x1.fffffffffffffp0
  },
  { // Entry 234
    0x1.p0,
    0x1.0p1
  },
  { // Entry 235
    0x1.000000000000171547652b82fd5ecd95p0,
    0x1.0000000000001p1
  },
  { // Entry 236
    -0x1.71547652b82fe73ccee9488191df220fp-53,
    0x1.fffffffffffffp-1
  },
  { // Entry 237
    0.0,
    0x1.0p0
  },
  { // Entry 238
    0x1.71547652b82fd5ecd95d67df53a9dd50p-52,
    0x1.0000000000001p0
  },
  { // Entry 239
    -0x1.0000000000000b8aa3b295c17f39e677p0,
    0x1.fffffffffffffp-2
  },
  { // Entry 240
    -0x1.p0,
    0x1.0p-1
  },
  { // Entry 241
    -0x1.ffffffffffffd1d57135a8fa054264d4p-1,
    0x1.0000000000001p-1
  },
  { // Entry 242
    -0x1.00000000000005c551d94ae0bf9cf33bp1,
    0x1.fffffffffffffp-3
  },
  { // Entry 243
    -0x1.p1,
    0x1.0p-2
  },
  { // Entry 244
    -0x1.ffffffffffffe8eab89ad47d02a1326ap0,
    0x1.0000000000001p-2
  },
  { // Entry 245
    -0x1.80000000000005c551d94ae0bf9cf33bp1,
    0x1.fffffffffffffp-4
  },
  { // Entry 246
    -0x1.80p1,
    0x1.0p-3
  },
  { // Entry 247
    -0x1.7ffffffffffff4755c4d6a3e81509935p1,
    0x1.0000000000001p-3
  },
  { // Entry 248
    -0x1.00000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-5
  },
  { // Entry 249
    -0x1.p2,
    0x1.0p-4
  },
  { // Entry 250
    -0x1.fffffffffffff4755c4d6a3e81509935p1,
    0x1.0000000000001p-4
  },
  { // Entry 251
    -0x1.40000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-6
  },
  { // Entry 252
    -0x1.40p2,
    0x1.0p-5
  },
  { // Entry 253
    -0x1.3ffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-5
  },
  { // Entry 254
    -0x1.80000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-7
  },
  { // Entry 255
    -0x1.80p2,
    0x1.0p-6
  },
  { // Entry 256
    -0x1.7ffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-6
  },
  { // Entry 257
    -0x1.c0000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-8
  },
  { // Entry 258
    -0x1.c0p2,
    0x1.0p-7
  },
  { // Entry 259
    -0x1.bffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-7
  },
  { // Entry 260
    -0x1.0000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-9
  },
  { // Entry 261
    -0x1.p3,
    0x1.0p-8
  },
  { // Entry 262
    -0x1.fffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-8
  },
  { // Entry 263
    -0x1.2000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-10
  },
  { // Entry 264
    -0x1.20p3,
    0x1.0p-9
  },
  { // Entry 265
    -0x1.1ffffffffffffd1d57135a8fa054264dp3,
    0x1.0000000000001p-9
  },
  { // Entry 266
    -0x1.4000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-11
  },
  { // Entry 267
    -0x1.40p3,
    0x1.0p-10
  },
  { // Entry 268
    -0x1.3ffffffffffffd1d57135a8fa054264dp3,
    0x1.0000000000001p-10
  },
  { // Entry 269
    -0x1.a000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-14
  },
  { // Entry 270
    -0x1.a0p3,
    0x1.0p-13
  },
  { // Entry 271
    -0x1.9ffffffffffffd1d57135a8fa054264dp3,
    0x1.0000000000001p-13
  },
  { // Entry 272
    -0x1.a000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-14
  },
  { // Entry 273
    -0x1.a0p3,
    0x1.0p-13
  },
  { // Entry 274
    -0x1.9ffffffffffffd1d57135a8fa054264dp3,
    0x1.0000000000001p-13
  },
  { // Entry 275
    -0x1.80000000000005c551d94ae0bf9cf33bp1,
    0x1.fffffffffffffp-4
  },
  { // Entry 276
    -0x1.80p1,
    0x1.0p-3
  },
  { // Entry 277
    -0x1.7ffffffffffff4755c4d6a3e81509935p1,
    0x1.0000000000001p-3
  },
  { // Entry 278
    -0x1.8a8980abfbd38fec8261ce5ac7b2b316p-3,
    0x1.bffffffffffffp-1
  },
  { // Entry 279
    -0x1.8a8980abfbd32666a9b7e2df60d2bdc6p-3,
    0x1.cp-1
  },
  { // Entry 280
    -0x1.8a8980abfbd2bce0d10df763fdb79032p-3,
    0x1.c000000000001p-1
  },
  { // Entry 281
    -0x1.00000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-5
  },
  { // Entry 282
    -0x1.p2,
    0x1.0p-4
  },
  { // Entry 283
    -0x1.fffffffffffff4755c4d6a3e81509935p1,
    0x1.0000000000001p-4
  },
  { // Entry 284
    -0x1.7d60496cfbb58b6d8d05c60c1e4defa0p-4,
    0x1.dffffffffffffp-1
  },
  { // Entry 285
    -0x1.7d60496cfbb4c673b4511f8c2b4e4fb7p-4,
    0x1.ep-1
  },
  { // Entry 286
    -0x1.7d60496cfbb40179db9c790c3edf8c5cp-4,
    0x1.e000000000001p-1
  },
  { // Entry 287
    -0x1.40000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-6
  },
  { // Entry 288
    -0x1.40p2,
    0x1.0p-5
  },
  { // Entry 289
    -0x1.3ffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-5
  },
  { // Entry 290
    -0x1.77394c9d958ed31cc5d7c5bf657ce7c7p-5,
    0x1.effffffffffffp-1
  },
  { // Entry 291
    -0x1.77394c9d958d55de5c380fe0871d757fp-5,
    0x1.fp-1
  },
  { // Entry 292
    -0x1.77394c9d958bd89ff2985a01b50a5933p-5,
    0x1.f000000000001p-1
  },
  { // Entry 293
    -0x1.80000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-7
  },
  { // Entry 294
    -0x1.80p2,
    0x1.0p-6
  },
  { // Entry 295
    -0x1.7ffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-6
  },
  { // Entry 296
    -0x1.743ee861f35851c7beb5800ff025220ap-6,
    0x1.f7fffffffffffp-1
  },
  { // Entry 297
    -0x1.743ee861f3556365483611f7c0bf059fp-6,
    0x1.f80p-1
  },
  { // Entry 298
    -0x1.743ee861f3527502d1b6a3dfa92b465cp-6,
    0x1.f800000000001p-1
  },
  { // Entry 299
    -0x1.c0000000000002e2a8eca5705fce799dp2,
    0x1.fffffffffffffp-8
  },
  { // Entry 300
    -0x1.c0p2,
    0x1.0p-7
  },
  { // Entry 301
    -0x1.bffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-7
  },
  { // Entry 302
    -0x1.72c7ba20f73846a992511c7918df1e3ep-7,
    0x1.fbfffffffffffp-1
  },
  { // Entry 303
    -0x1.72c7ba20f73275b5d184a2c615b70ad4p-7,
    0x1.fc0p-1
  },
  { // Entry 304
    -0x1.72c7ba20f72ca4c210b8291341746042p-7,
    0x1.fc00000000001p-1
  },
  { // Entry 305
    -0x1.0000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-9
  },
  { // Entry 306
    -0x1.p3,
    0x1.0p-8
  },
  { // Entry 307
    -0x1.fffffffffffffa3aae26b51f40a84c9ap2,
    0x1.0000000000001p-8
  },
  { // Entry 308
    -0x1.720d9c06a84180a8de11db415a9c19bfp-8,
    0x1.fdfffffffffffp-1
  },
  { // Entry 309
    -0x1.720d9c06a835ea6ef18f977e5d8a37abp-8,
    0x1.fe0p-1
  },
  { // Entry 310
    -0x1.720d9c06a82a5435050d53bbbd8733d9p-8,
    0x1.fe00000000001p-1
  },
  { // Entry 311
    -0x1.2000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-10
  },
  { // Entry 312
    -0x1.20p3,
    0x1.0p-9
  },
  { // Entry 313
    -0x1.1ffffffffffffd1d57135a8fa054264dp3,
    0x1.0000000000001p-9
  },
  { // Entry 314
    -0x1.71b0ea42e614c339acd1274e85c99f12p-9,
    0x1.fefffffffffffp-1
  },
  { // Entry 315
    -0x1.71b0ea42e5fda261dbbd1a498f533398p-9,
    0x1.ff0p-1
  },
  { // Entry 316
    -0x1.71b0ea42e5e6818a0aa90d455240385fp-9,
    0x1.ff00000000001p-1
  },
  { // Entry 317
    -0x1.4000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-11
  },
  { // Entry 318
    -0x1.40p3,
    0x1.0p-10
  },
  { // Entry 319
    -0x1.3ffffffffffffd1d57135a8fa054264dp3,
    0x1.0000000000001p-10
  },
  { // Entry 320
    -0x1.7182a894b6ca8f7bca8c2f767eabc572p-10,
    0x1.ff7ffffffffffp-1
  },
  { // Entry 321
    -0x1.7182a894b69c595f7920cea1619c6e57p-10,
    0x1.ff8p-1
  },
  { // Entry 322
    -0x1.7182a894b66e234327b56dcdb69a7d21p-10,
    0x1.ff80000000001p-1
  },
  { // Entry 323
    -0x1.a000000000000171547652b82fe73ccep3,
    0x1.fffffffffffffp-14
  },
  { // Entry 324
    -0x1.a0p3,
    0x1.0p-13
  },
  { // Entry 325
    -0x1.9ffffffffffffd1d57135a8fa054264dp3,
    0x1.0000000000001p-13
  },
  { // Entry 326
    -0x1.715a3bc35aaead4b7ce65d43632af0adp-13,
    0x1.ffeffffffffffp-1
  },
  { // Entry 327
    -0x1.715a3bc3593d4d4a2a239745f6427420p-13,
    0x1.fffp-1
  },
  { // Entry 328
    -0x1.715a3bc357cbed48d760d15414b65d0dp-13,
    0x1.fff0000000001p-1
  },
  { // Entry 329
    HUGE_VAL,
    HUGE_VAL
  },
  { // Entry 330
    0x1.fffffffffffffffa3aae26b51f40630cp9,
    0x1.fffffffffffffp1023
  },
  { // Entry 331
    0x1.fffffffffffffff4755c4d6a3e8097eep9,
    0x1.ffffffffffffep1023
  },
  { // Entry 332
    0x1.a6c873498ddf71a36f477a776fb34e4bp0,
    0x1.921fb54442d18p1
  },
  { // Entry 333
    0x1.4d90e6931bbee346de8ef4eedf669c96p-1,
    0x1.921fb54442d18p0
  },
  { // Entry 334
    0x1.71547652b82fd5ecd95d67df53a9dd50p-52,
    0x1.0000000000001p0
  },
  { // Entry 335
    0.0,
    0x1.0p0
  },
  { // Entry 336
    -0x1.71547652b82fe73ccee9488191df220fp-53,
    0x1.fffffffffffffp-1
  },
  { // Entry 337
    -0x1.64de32d9c882397242e216224132c6d2p-2,
    0x1.921fb54442d18p-1
  },
  { // Entry 338
    -0x1.fefffffffffffff4755c4d6a3e815099p9,
    0x1.0000000000001p-1022
  },
  { // Entry 339
    -0x1.ffp9,
    0x1.0p-1022
  },
  { // Entry 340
    -0x1.ff0000000000000b8aa3b295c17f6811p9,
    0x1.ffffffffffffep-1023
  },
  { // Entry 341
    -0x1.ff000000000000171547652b82ff88ccp9,
    0x1.ffffffffffffcp-1023
  },
  { // Entry 342
    -0x1.0c40p10,
    0x1.0p-1073
  },
  { // Entry 343
    -0x1.0c80p10,
    0x1.0p-1074
  },
  { // Entry 344
    -HUGE_VAL,
    0.0
  },
  { // Entry 345
    -HUGE_VAL,
    -0.0
  },
  { // Entry 346
    0x1.f4p6,
    0x1.0p125
  },
  { // Entry 347
    -0x1.fcp6,
    0x1.0p-127
  },
  { // Entry 348
    0x1.p0,
    0x1.0p1
  },
  { // Entry 349
    0x1.p1,
    0x1.0p2
  },
  { // Entry 350
    -0x1.p0,
    0x1.0p-1
  }
};
