package org.seasar.s2jdbcmock;

import org.seasar.extension.jdbc.AutoDelete;
import org.seasar.extension.jdbc.AutoInsert;
import org.seasar.extension.jdbc.AutoSelect;
import org.seasar.extension.jdbc.AutoUpdate;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.SqlSelect;
import org.seasar.extension.jdbc.exception.NoIdPropertyRuntimeException;
import org.seasar.extension.jdbc.manager.JdbcManagerImpl;

public class MockJdbcManager extends JdbcManagerImpl {

	public <T> AutoSelect<T> from(Class<T> baseClass) {
		return new MockAutoSelect<T>(this, baseClass).maxRows(maxRows)
				.fetchSize(fetchSize).queryTimeout(queryTimeout);
	}

	public <T> SqlSelect<T> selectBySql(Class<T> baseClass, String sql,
			Object... params) {
		return new MockSqlSelect<T>(this, baseClass, sql, params)
				.maxRows(maxRows).fetchSize(fetchSize)
				.queryTimeout(queryTimeout);
	}

	public <T> AutoInsert<T> insert(final T entity) {
		return new MockAutoInsert<T>(this, entity).queryTimeout(queryTimeout);
	}

	@Override
	public <T> AutoUpdate<T> update(T entity) {
		final EntityMeta entityMeta = entityMetaFactory.getEntityMeta(entity
				.getClass());
		if (entityMeta.getIdPropertyMetaList().isEmpty()) {
			throw new NoIdPropertyRuntimeException("ESSR0761",
					entityMeta.getName());
		}
		return new MockAutoUpdate<T>(this, entity).queryTimeout(queryTimeout);
	}

	@Override
	public <T> AutoDelete<T> delete(final T entity) {
		final EntityMeta entityMeta = entityMetaFactory.getEntityMeta(entity
				.getClass());
		if (entityMeta.getIdPropertyMetaList().isEmpty()) {
			throw new NoIdPropertyRuntimeException("ESSR0762",
					entityMeta.getName());
		}
		return new MockAutoDelete<T>(this, entity).queryTimeout(queryTimeout);
	}

}
