<html>
<head>
<%@include file="/WEB-INF/view/common/header.jsp" %>
<title>rdiff-backup-browser</title>
</head>
<body>
<h1>rdiff-backup-browser</h1>

<ul>
  <c:forEach var="backupDir" items="${backupDirList}" varStatus="s">
    <li class="${s.index % 2 == 0 ? 'odd' : 'even'}">
      <div class="operation">
        <a href="javascript:void(0);" onclick="GB_showCenter('History', '${pageContext.request.contextPath}/history/?root=${f:u(backupDir.directory)}', 400, 600);">History</a>
        |
        <a href="${pageContext.request.contextPath}/edit/?id=${backupDir.id}">Edit</a>
        |
        <a href="javascript:void(0);" onclick="removeBackupDir('${f:h(backupDir.directory)}', ${f:u(backupDir.id)});">Remove</a>
      </div>
      <a href="${pageContext.request.contextPath}/browse/?root=${f:u(backupDir.directory)}">
        <img src="${pageContext.request.contextPath}/images/package.png"> ${f:h(backupDir.directory)}
      </a>
      <div class="description">
        ${f:h(backupDir.description)}
      </div>
    </li>
  </c:forEach>
</ul>

<s:form styleId="removeForm" action="index/remove/">
  <html:hidden property="id"/>
</s:form>

<s:form>
  <h2>Add backup directory</h2>
  <table>
    <tr>
      <th>Directory:</th>
      <td>
        <html:text property="directory" size="40"></html:text>
        <html:errors property="directory"/>
      </td>
    </tr>
    <tr>
      <th>Description:</th>
      <td>
        <html:text property="description" size="60"></html:text>
        <html:errors property="description"/>
      </td>
    </tr>
  </table>
  <s:submit property="add" value="Add" ></s:submit>
</s:form>

<script type="text/javascript">
function removeBackupDir(dir, id){
	if(confirm('Removes ' + dir + ', OK?')){
		var form = document.getElementById('removeForm');
		form.id.value = id;
		form.submit();
	}
}
</script>

</body>
</html>