package code.util

import javax.servlet._
import http.HttpServletRequest

/**
 * HttpServletRequestを[[code.util.RequestUtil]]にセットするためのフィルタ。
 */
class RequestFilter extends Filter {

  override def init(filterConfig: FilterConfig){
  }

  override def doFilter(servletRequest: ServletRequest, servletResponse: ServletResponse, filterChain: FilterChain){
    RequestUtil.setRequest(servletRequest.asInstanceOf[HttpServletRequest])
    try {
      filterChain.doFilter(servletRequest, servletResponse)
    }
    finally {
      RequestUtil.removeRequest()
    }
  }

  override def destroy(){
  }

}
