package jp.sf.amateras.functions.utils;

import java.util.LinkedHashMap;
import java.util.Map;

import junit.framework.TestCase;

public class StringUtilsTest extends TestCase {

	public void testEscapeHtml() {
		assertEquals("", StringUtils.escapeHtml(null));
		assertEquals("&lt;a href=&#034;&#034;&gt;", StringUtils.escapeHtml("<a href=\"\">"));
	}

	public void testUrlEncodeString() {
		assertEquals("", StringUtils.urlEncode(null));
		assertEquals("%E3%81%82%E3%81%84%E3%81%86%E3%81%88%E3%81%8A", StringUtils.urlEncode("あいうえお"));
	}

	public void testUrlEncodeStringString() {
		assertEquals("%82%A0%82%A2%82%A4%82%A6%82%A8", StringUtils.urlEncode("あいうえお", "Windows-31J"));
	}

	public void testConvertLineSeparator() {
		assertEquals("", StringUtils.convertLineSeparator(null));
		assertEquals("あいうえお<br />かきくけこ",
				StringUtils.convertLineSeparator("あいうえお\nかきくけこ"));
	}

	public void testConvertWhitespace() {
		assertEquals("", StringUtils.convertWhitespace(null));
		assertEquals("あいうえお &nbsp;&nbsp;かきくけこ",
				StringUtils.convertWhitespace("あいうえお   かきくけこ"));
	}

	public void testMask() {
		assertEquals("", StringUtils.mask(null, '*'));
		assertEquals("********", StringUtils.mask("password", '*'));
	}

	public void testCut() {
		assertEquals("", StringUtils.cut(null, 1));
		assertEquals("abc", StringUtils.cut("abcdef", 3));
		assertEquals("abcdef", StringUtils.cut("abcdef", 7));
	}
	
	public void testConvertURL(){
		assertEquals("", StringUtils.convertURL(null));
		assertEquals("<a href=\"http://www.google.co.jp\">http://www.google.co.jp</a>で検索", 
				StringUtils.convertURL("http://www.google.co.jpで検索"));
	}
	
	public void testMap2queryString_01(){
		Map<String, Object> map = new LinkedHashMap<String, Object>();
		map.put("name", "Naoki Takezoe");
		map.put("country", "Japan");
		
		String query = StringUtils.map2queryString(map);
		assertEquals("name=Naoki+Takezoe&country=Japan", query);
	}
	
	public void testMap2queryString_02(){
		Map<String, Object> map = new LinkedHashMap<String, Object>();
		map.put("name", "Naoki Takezoe");
		map.put("country", "日本");
		
		String query = StringUtils.map2queryString(map, "UTF-8");
		assertEquals("name=Naoki+Takezoe&country=%E6%97%A5%E6%9C%AC", query);
	}
	
	public void testMap2queryString_03(){
		Map<String, Object> map = new LinkedHashMap<String, Object>();
		map.put("name", "Naoki Takezoe");
		map.put("programming", new Object[]{"Java", "Perl"});
		
		String query = StringUtils.map2queryString(map, "UTF-8");
		assertEquals("name=Naoki+Takezoe&programming=Java&programming=Perl", query);
	}

	public void testMap2queryString_04(){
		assertEquals("", StringUtils.map2queryString(null));
	}
	
	public void testEscapeJavaScript(){
		assertEquals("", StringUtils.escapeJavaScript(null));
		assertEquals("aa\\'bb", StringUtils.escapeJavaScript("aa'bb"));
		assertEquals("aa\\r\\nbb", StringUtils.escapeJavaScript("aa\r\nbb"));
		assertEquals("aa\\t\\bbb", StringUtils.escapeJavaScript("aa\t\bbb"));
		assertEquals("aa\\\\bbb", StringUtils.escapeJavaScript("aa\\bbb"));
	}
}
