/*
 * Copyright 2004-2009 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.struts.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * URLかどうかを検証するためのアノテーションです。
 * 
 * @author higa
 * 
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
@Validator("url")
public @interface UrlType {

    /**
     * すべてのスキームを許可するかどうかです。
     * 
     */
    boolean allowallschemes() default false;

    /**
     * ダブルスラッシュ（//）を許可するかどうかです。
     * 
     */
    boolean allow2slashes() default false;

    /**
     * 分割を許可するかどうかです。
     * 
     */
    boolean nofragments() default false;

    /**
     * 許可するスキームを（カンマ）で指定します。
     * 
     */
    String schemes() default "http,https,ftp";

    /**
     * メッセージです。
     * 
     */
    Msg msg() default @Msg(key = "errors.url");

    /**
     * メッセージの最初の引数です。
     * 
     */
    Arg arg0() default @Arg(key = "");

    /**
     * 検証の対象となるメソッド名を指定します。 複数ある場合はカンマで区切ります。
     * 
     */
    String target() default "";
}