/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomUtils {
    private static SecureRandom secureRandom;
    private static Random random;
    private static volatile boolean seeded;
    static /* synthetic */ Class class$java$lang$System;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SecureRandom getSecureRandom() {
        block8: {
            if (secureRandom != null) {
                return secureRandom;
            }
            try {
                secureRandom = SecureRandom.getInstance("SHA1PRNG");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
                            byte[] seed = sr.generateSeed(20);
                            SecureRandom secureRandom = secureRandom;
                            synchronized (secureRandom) {
                                secureRandom.setSeed(seed);
                                seeded = true;
                            }
                        }
                        catch (NoSuchAlgorithmException e) {
                            RandomUtils.warn("SecureRandom", e);
                        }
                    }
                };
                Thread t = new Thread(runnable);
                t.setDaemon(true);
                t.start();
                Thread.yield();
                try {
                    t.join(400L);
                }
                catch (InterruptedException e) {
                    RandomUtils.warn("InterruptedException", e);
                }
                if (seeded) break block8;
                byte[] seed = RandomUtils.generateAlternativeSeed();
                SecureRandom secureRandom = RandomUtils.secureRandom;
                synchronized (secureRandom) {
                    RandomUtils.secureRandom.setSeed(seed);
                }
            }
            catch (NoSuchAlgorithmException e) {
                RandomUtils.warn("SecureRandom", e);
                secureRandom = new SecureRandom();
            }
        }
        return secureRandom;
    }

    private static byte[] generateAlternativeSeed() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            out.writeLong(System.currentTimeMillis());
            try {
                Method m = (class$java$lang$System == null ? (class$java$lang$System = RandomUtils.class$("java.lang.System")) : class$java$lang$System).getMethod("nanoTime", new Class[0]);
                if (m != null) {
                    Object o = m.invoke(null, (Object[])null);
                    out.writeUTF(o.toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            out.writeInt(new Object().hashCode());
            Runtime runtime = Runtime.getRuntime();
            out.writeLong(runtime.freeMemory());
            out.writeLong(runtime.maxMemory());
            out.writeLong(runtime.totalMemory());
            try {
                out.writeUTF(System.getProperties().toString());
            }
            catch (Exception e) {
                RandomUtils.warn("generateAlternativeSeed", e);
            }
            try {
                String hostName = InetAddress.getLocalHost().getHostName();
                out.writeUTF(hostName);
                InetAddress[] list = InetAddress.getAllByName(hostName);
                for (int i = 0; i < list.length; ++i) {
                    out.write(list[i].getAddress());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int j = 0; j < 16; ++j) {
                int i = 0;
                long end = System.currentTimeMillis();
                while (end == System.currentTimeMillis()) {
                    ++i;
                }
                out.writeInt(i);
            }
            out.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            RandomUtils.warn("generateAlternativeSeed", e);
            return new byte[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSecureLong() {
        SecureRandom sr;
        SecureRandom secureRandom = sr = RandomUtils.getSecureRandom();
        synchronized (secureRandom) {
            return sr.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSecureBytes(int len) {
        SecureRandom sr;
        if (len <= 0) {
            len = 1;
        }
        byte[] buff = new byte[len];
        SecureRandom secureRandom = sr = RandomUtils.getSecureRandom();
        synchronized (secureRandom) {
            sr.nextBytes(buff);
        }
        return buff;
    }

    public static int nextInt(int max) {
        return random.nextInt(max);
    }

    private static void warn(String s, Throwable t) {
        System.out.println("RandomUtils warning: " + s);
        if (t != null) {
            t.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        random = new Random();
    }
}

