/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.util.Cache;
import org.h2.util.CacheObject;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class RowList {
    private final Session session;
    private ObjectArray list = new ObjectArray();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private DataPage rowBuff;
    private Cache cache;
    private ObjectArray lobs;
    private int memory;
    private int maxMemory;
    private boolean written;
    private boolean readUncached;

    public RowList(Session session) {
        this.session = session;
        if (SysProperties.DEFAULT_MAX_OPERATION_MEMORY > 0 && session.getDatabase().isPersistent()) {
            this.maxMemory = session.getDatabase().getMaxOperationMemory();
        }
    }

    private void writeRow(DataPage buff, Row r) throws SQLException {
        buff.checkCapacity(1 + buff.getIntLen() * 6);
        buff.writeByte((byte)1);
        buff.writeInt(r.getMemorySize());
        buff.writeInt(r.getColumnCount());
        buff.writeInt(r.getPos());
        buff.writeInt(r.getDeleted() ? 1 : 0);
        buff.writeInt(r.getSessionId());
        buff.writeInt(r.getStorageId());
        for (int i = 0; i < r.getColumnCount(); ++i) {
            ValueLob lob;
            Value v = r.getValue(i);
            if ((v.getType() == 16 || v.getType() == 15) && (lob = (ValueLob)v).getSmall() == null && lob.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = new ObjectArray();
                }
                this.lobs.add(lob);
            }
            buff.checkCapacity(buff.getValueLen(v));
            buff.writeValue(v);
        }
    }

    private void writeAllRows() throws SQLException {
        if (this.file == null) {
            Database db = this.session.getDatabase();
            this.cache = db.getDataFile().getCache();
            String fileName = db.createTempFile();
            this.file = db.openFile(fileName, "rw", false);
            this.file.autoDelete();
            this.file.seek(48L);
            this.rowBuff = DataPage.create((DataHandler)db, 512);
            this.file.seek(48L);
        }
        DataPage buff = this.rowBuff;
        this.initBuffer(buff);
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0 && buff.length() > 4096) {
                this.flushBuffer(buff);
                this.initBuffer(buff);
            }
            Row r = (Row)this.list.get(i);
            this.writeRow(buff, r);
        }
        this.flushBuffer(buff);
        this.list.clear();
        this.memory = 0;
    }

    private void initBuffer(DataPage buff) {
        buff.reset();
        buff.writeInt(0);
    }

    private void flushBuffer(DataPage buff) throws SQLException {
        buff.checkCapacity(1);
        buff.writeByte((byte)0);
        buff.fillAligned();
        buff.setInt(0, buff.length() / 16);
        buff.updateChecksum();
        this.file.write(buff.getBytes(), 0, buff.length());
    }

    public void add(Row r) throws SQLException {
        this.list.add(r);
        this.memory += r.getMemorySize();
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() throws SQLException {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(DataPage buff) throws SQLException {
        CacheObject found;
        if (buff.readByte() == 0) {
            return null;
        }
        int memory = buff.readInt();
        int columnCount = buff.readInt();
        int pos = buff.readInt();
        if (this.readUncached) {
            pos = 0;
        }
        boolean deleted = buff.readInt() == 1;
        int sessionId = buff.readInt();
        int storageId = buff.readInt();
        Value[] values = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            ValueLob lob;
            Value v = buff.readValue();
            if (v.isLinked() && (lob = (ValueLob)v).getTableId() == 0) {
                this.session.unlinkAtCommit(v);
            }
            values[i] = v;
        }
        if (pos != 0 && (found = this.cache.find(pos)) != null) {
            return (Row)found;
        }
        Row row = new Row(values, memory);
        row.setPos(pos);
        row.setDeleted(deleted);
        row.setSessionId(sessionId);
        row.setStorageId(storageId);
        return row;
    }

    public Row next() throws SQLException {
        Row r;
        if (this.file == null) {
            r = (Row)this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                DataPage buff = this.rowBuff;
                buff.reset();
                int min = 16;
                this.file.readFully(buff.getBytes(), 0, min);
                int len = buff.readInt() * 16;
                buff.checkCapacity(len);
                if (len - min > 0) {
                    this.file.readFully(buff.getBytes(), min, len - min);
                }
                buff.check(len);
                int i = 0;
                while ((r = this.readRow(buff)) != null) {
                    this.list.add(r);
                    ++i;
                }
            }
            ++this.index;
            r = (Row)this.list.get(this.listIndex++);
        }
        return r;
    }

    public int size() {
        return this.size;
    }

    public void invalidateCache() {
        this.readUncached = true;
    }

    public void close() {
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

