/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.fulltext.IndexInfo;
import org.h2.util.ObjectUtils;

public class FullTextSettings {
    private static HashMap settings = new HashMap();
    private HashSet ignoreList = new HashSet();
    private HashMap words = new HashMap();
    private HashMap indexes = new HashMap();
    private PreparedStatement prepSelectMapByWordId;
    private PreparedStatement prepSelectRowById;

    private FullTextSettings() {
    }

    HashSet getIgnoreList() {
        return this.ignoreList;
    }

    public HashMap getWordList() {
        return this.words;
    }

    IndexInfo getIndexInfo(long indexId) {
        return (IndexInfo)this.indexes.get(ObjectUtils.getLong(indexId));
    }

    void addIndexInfo(IndexInfo index) {
        this.indexes.put(ObjectUtils.getLong(index.id), index);
    }

    public String convertWord(String word) {
        if (this.ignoreList.contains(word = word.toUpperCase())) {
            return null;
        }
        return word;
    }

    static FullTextSettings getInstance(Connection conn) throws SQLException {
        String path = FullTextSettings.getIndexPath(conn);
        FullTextSettings setting = (FullTextSettings)settings.get(path);
        if (setting == null) {
            setting = new FullTextSettings();
            settings.put(path, setting);
        }
        return setting;
    }

    private static String getIndexPath(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("CALL IFNULL(DATABASE_PATH(), 'MEM:' || DATABASE())");
        rs.next();
        String path = rs.getString(1);
        if ("MEM:UNNAMED".equals(path)) {
            throw new SQLException("FULLTEXT", "Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        rs.close();
        return path;
    }

    public PreparedStatement getPrepSelectMapByWordId() {
        return this.prepSelectMapByWordId;
    }

    public void setPrepSelectMapByWordId(PreparedStatement prepSelectMapByWordId) {
        this.prepSelectMapByWordId = prepSelectMapByWordId;
    }

    public PreparedStatement getPrepSelectRowById() {
        return this.prepSelectRowById;
    }

    public void setPrepSelectRowById(PreparedStatement prepSelectRowById) {
        this.prepSelectRowById = prepSelectRowById;
    }
}

