/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConstraintReferential
extends Constraint {
    public static final int RESTRICT = 0;
    public static final int CASCADE = 1;
    public static final int SET_DEFAULT = 2;
    public static final int SET_NULL = 3;
    private int deleteAction;
    private int updateAction;
    private Table refTable;
    private Index index;
    private Index refIndex;
    private boolean indexOwner;
    private boolean refIndexOwner;
    protected IndexColumn[] columns;
    protected IndexColumn[] refColumns;
    private String deleteSQL;
    private String updateSQL;
    private boolean skipOwnTable;

    public ConstraintReferential(Schema schema, int id, String name, Table table) {
        super(schema, id, name, table);
    }

    public String getConstraintType() {
        return "REFERENTIAL";
    }

    private void appendAction(StringBuffer buff, int action) {
        switch (action) {
            case 1: {
                buff.append("CASCADE");
                break;
            }
            case 2: {
                buff.append("SET DEFAULT");
                break;
            }
            case 3: {
                buff.append("SET NULL");
                break;
            }
            default: {
                throw Message.getInternalError("action=" + action);
            }
        }
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQLForCopy(table, this.refTable, quotedName, true);
    }

    public String getCreateSQLForCopy(Table table, Table refTable, String quotedName, boolean internalIndex) {
        StringBuffer buff = new StringBuffer();
        buff.append("ALTER TABLE ");
        String mainTable = table.getSQL();
        buff.append(mainTable);
        buff.append(" ADD CONSTRAINT ");
        buff.append(quotedName);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        IndexColumn[] cols = this.columns;
        IndexColumn[] refCols = this.refColumns;
        buff.append(" FOREIGN KEY(");
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(cols[i].getSQL());
        }
        buff.append(")");
        if (internalIndex && this.indexOwner && table == this.table) {
            buff.append(" INDEX ");
            buff.append(this.index.getSQL());
        }
        buff.append(" REFERENCES ");
        String quotedRefTable = this.table == this.refTable ? table.getSQL() : refTable.getSQL();
        buff.append(quotedRefTable);
        buff.append("(");
        for (int i = 0; i < refCols.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(refCols[i].getSQL());
        }
        buff.append(")");
        if (internalIndex && this.refIndexOwner && table == this.table) {
            buff.append(" INDEX ");
            buff.append(this.refIndex.getSQL());
        }
        if (this.deleteAction != 0) {
            buff.append(" ON DELETE ");
            this.appendAction(buff, this.deleteAction);
        }
        if (this.updateAction != 0) {
            buff.append(" ON UPDATE ");
            this.appendAction(buff, this.updateAction);
        }
        buff.append(" NOCHECK");
        return buff.toString();
    }

    public String getShortDescription() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append(": ");
        buff.append(this.table.getSQL());
        buff.append(" FOREIGN KEY(");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columns[i].getSQL());
        }
        buff.append(")");
        buff.append(" REFERENCES ");
        buff.append(this.refTable.getSQL());
        buff.append("(");
        for (i = 0; i < this.refColumns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.refColumns[i].getSQL());
        }
        buff.append(")");
        return buff.toString();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.refTable, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] cols) {
        this.columns = cols;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setRefColumns(IndexColumn[] refCols) {
        this.refColumns = refCols;
    }

    public IndexColumn[] getRefColumns() {
        return this.refColumns;
    }

    public void setRefTable(Table refTable) {
        this.refTable = refTable;
        if (refTable.getTemporary()) {
            this.setTemporary(true);
        }
    }

    public void setIndex(Index index, boolean isOwner) {
        this.index = index;
        this.indexOwner = isOwner;
    }

    public void setRefIndex(Index refIndex, boolean isRefOwner) {
        this.refIndex = refIndex;
        this.refIndexOwner = isRefOwner;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeConstraint(this);
        this.refTable.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        if (this.refIndexOwner) {
            this.refTable.removeIndexOrTransferOwnership(session, this.refIndex);
        }
        this.database.removeMeta(session, this.getId());
        this.refTable = null;
        this.index = null;
        this.refIndex = null;
        this.columns = null;
        this.refColumns = null;
        this.deleteSQL = null;
        this.updateSQL = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table t, Row oldRow, Row newRow) throws SQLException {
        if (!this.database.getReferentialIntegrity()) {
            return;
        }
        if (!this.table.getCheckForeignKeyConstraints() || !this.refTable.getCheckForeignKeyConstraints()) {
            return;
        }
        if (t == this.table && !this.skipOwnTable) {
            this.checkRowOwnTable(session, newRow);
        }
        if (t == this.refTable) {
            this.checkRowRefTable(session, oldRow, newRow);
        }
    }

    private void checkRowOwnTable(Session session, Row newRow) throws SQLException {
        int refIdx;
        Column refCol;
        Value v;
        int i;
        if (newRow == null) {
            return;
        }
        boolean containsNull = false;
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            int idx = this.columns[i2].column.getColumnId();
            Value v2 = newRow.getValue(idx);
            if (v2 != ValueNull.INSTANCE) continue;
            containsNull = true;
            break;
        }
        if (containsNull) {
            return;
        }
        if (this.refTable == this.table) {
            boolean self = true;
            for (i = 0; i < this.columns.length; ++i) {
                int idx = this.columns[i].column.getColumnId();
                v = newRow.getValue(idx);
                refCol = this.refColumns[i].column;
                refIdx = refCol.getColumnId();
                Value r = newRow.getValue(refIdx);
                if (this.database.areEqual(r, v)) continue;
                self = false;
                break;
            }
            if (self) {
                return;
            }
        }
        Row check = this.refTable.getTemplateRow();
        for (i = 0; i < this.columns.length; ++i) {
            int idx = this.columns[i].column.getColumnId();
            v = newRow.getValue(idx);
            refCol = this.refColumns[i].column;
            refIdx = refCol.getColumnId();
            check.setValue(refIdx, v.convertTo(refCol.getType()));
        }
        if (!this.found(session, this.refIndex, check)) {
            throw Message.getSQLException(23002, this.getShortDescription());
        }
    }

    private boolean found(Session session, Index index, SearchRow check) throws SQLException {
        index.getTable().lock(session, false, false);
        Cursor cursor = index.find(session, check, check);
        while (cursor.next()) {
            SearchRow found = cursor.getSearchRow();
            Column[] cols = index.getColumns();
            boolean allEqual = true;
            for (int i = 0; i < this.columns.length && i < cols.length; ++i) {
                Value f;
                int idx = cols[i].getColumnId();
                Value c = check.getValue(idx);
                if (this.database.compareTypeSave(c, f = found.getValue(idx)) == 0) continue;
                allEqual = false;
                break;
            }
            if (!allEqual) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(Row oldRow, Row newRow) throws SQLException {
        return this.refIndex.compareRows(oldRow, newRow) == 0;
    }

    private void checkRow(Session session, Row oldRow) throws SQLException {
        int idx;
        int refIdx;
        Column refCol;
        int i;
        if (this.refTable == this.table) {
            boolean self = true;
            for (i = 0; i < this.columns.length; ++i) {
                refCol = this.refColumns[i].column;
                refIdx = refCol.getColumnId();
                Value v = oldRow.getValue(refIdx);
                idx = this.columns[i].column.getColumnId();
                Value r = oldRow.getValue(idx);
                if (this.database.areEqual(r, v)) continue;
                self = false;
                break;
            }
            if (self) {
                return;
            }
        }
        SearchRow check = this.table.getTemplateSimpleRow(false);
        for (i = 0; i < this.columns.length; ++i) {
            refCol = this.refColumns[i].column;
            refIdx = refCol.getColumnId();
            Column col = this.columns[i].column;
            idx = col.getColumnId();
            Value v = oldRow.getValue(refIdx).convertTo(col.getType());
            check.setValue(idx, v);
        }
        if (this.found(session, this.index, check)) {
            throw Message.getSQLException(23003, this.getShortDescription());
        }
    }

    private void checkRowRefTable(Session session, Row oldRow, Row newRow) throws SQLException {
        if (oldRow == null) {
            return;
        }
        if (newRow != null && this.isEqual(oldRow, newRow)) {
            return;
        }
        if (newRow == null) {
            if (this.deleteAction == 0) {
                this.checkRow(session, oldRow);
            } else {
                int i = this.deleteAction == 1 ? 0 : this.columns.length;
                Prepared deleteCommand = this.getDelete(session);
                this.setWhere(deleteCommand, i, oldRow);
                this.updateWithSkipCheck(deleteCommand);
            }
        } else if (this.updateAction == 0) {
            this.checkRow(session, oldRow);
        } else {
            Prepared updateCommand = this.getUpdate(session);
            if (this.updateAction == 1) {
                ObjectArray params = updateCommand.getParameters();
                for (int i = 0; i < this.columns.length; ++i) {
                    Parameter param = (Parameter)params.get(i);
                    Column refCol = this.refColumns[i].column;
                    param.setValue(newRow.getValue(refCol.getColumnId()));
                }
            }
            this.setWhere(updateCommand, this.columns.length, oldRow);
            this.updateWithSkipCheck(updateCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithSkipCheck(Prepared prep) throws SQLException {
        try {
            this.skipOwnTable = true;
            prep.update();
        }
        finally {
            this.skipOwnTable = false;
        }
    }

    void setWhere(Prepared command, int pos, Row row) {
        for (int i = 0; i < this.refColumns.length; ++i) {
            int idx = this.refColumns[i].column.getColumnId();
            Value v = row.getValue(idx);
            ObjectArray params = command.getParameters();
            Parameter param = (Parameter)params.get(pos + i);
            param.setValue(v);
        }
    }

    public int getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(Session session, int action) throws SQLException {
        if (action == this.deleteAction) {
            return;
        }
        if (this.deleteAction != 0) {
            throw Message.getSQLException(90045, "ON DELETE");
        }
        this.deleteAction = action;
        StringBuffer buff = new StringBuffer();
        if (action == 1) {
            buff.append("DELETE FROM ");
            buff.append(this.table.getSQL());
        } else {
            this.appendUpdate(buff);
        }
        this.appendWhere(buff);
        this.deleteSQL = buff.toString();
    }

    private Prepared getUpdate(Session session) throws SQLException {
        return this.prepare(session, this.updateSQL, this.updateAction);
    }

    private Prepared getDelete(Session session) throws SQLException {
        return this.prepare(session, this.deleteSQL, this.deleteAction);
    }

    public int getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(Session session, int action) throws SQLException {
        if (action == this.updateAction) {
            return;
        }
        if (this.updateAction != 0) {
            throw Message.getSQLException(90045, "ON UPDATE");
        }
        this.updateAction = action;
        StringBuffer buff = new StringBuffer();
        this.appendUpdate(buff);
        this.appendWhere(buff);
        this.updateSQL = buff.toString();
    }

    private Prepared prepare(Session session, String sql, int action) throws SQLException {
        Prepared command = session.prepare(sql);
        if (action != 1) {
            ObjectArray params = command.getParameters();
            for (int i = 0; i < this.columns.length; ++i) {
                Value value;
                Column column = this.columns[i].column;
                Parameter param = (Parameter)params.get(i);
                if (action == 3) {
                    value = ValueNull.INSTANCE;
                } else {
                    Expression expr = column.getDefaultExpression();
                    if (expr == null) {
                        throw Message.getSQLException(90056, column.getName());
                    }
                    value = expr.getValue(session);
                }
                param.setValue(value);
            }
        }
        return command;
    }

    private void appendUpdate(StringBuffer buff) {
        buff.append("UPDATE ");
        buff.append(this.table.getSQL());
        buff.append(" SET ");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(" , ");
            }
            Column column = this.columns[i].column;
            buff.append(Parser.quoteIdentifier(column.getName()));
            buff.append("=?");
        }
    }

    private void appendWhere(StringBuffer buff) {
        buff.append(" WHERE ");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            Column column = this.columns[i].column;
            buff.append(Parser.quoteIdentifier(column.getName()));
            buff.append("=?");
        }
    }

    public Table getRefTable() {
        return this.refTable;
    }

    public boolean usesIndex(Index idx) {
        return idx == this.index || idx == this.refIndex;
    }

    public void setIndexOwner(Index index) {
        if (this.index == index) {
            this.indexOwner = true;
        } else if (this.refIndex == index) {
            this.refIndexOwner = true;
        } else {
            throw Message.getInternalError();
        }
    }

    public boolean containsColumn(Column col) {
        int i;
        for (i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].column != col) continue;
            return true;
        }
        for (i = 0; i < this.refColumns.length; ++i) {
            if (this.refColumns[i].column != col) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return false;
    }

    public void checkExistingData(Session session) throws SQLException {
        int i;
        if (session.getDatabase().isStarting()) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("SELECT 1 FROM (SELECT ");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columns[i].getSQL());
        }
        buff.append(" FROM ");
        buff.append(this.table.getSQL());
        buff.append(" WHERE ");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            buff.append(this.columns[i].getSQL());
            buff.append(" IS NOT NULL ");
        }
        buff.append(" ORDER BY ");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columns[i].getSQL());
        }
        buff.append(") C WHERE NOT EXISTS(SELECT 1 FROM ");
        buff.append(this.refTable.getSQL());
        buff.append(" P WHERE ");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            buff.append("C.");
            buff.append(this.columns[i].getSQL());
            buff.append("=");
            buff.append("P.");
            buff.append(this.refColumns[i].getSQL());
        }
        buff.append(")");
        String sql = buff.toString();
        LocalResult r = session.prepare(sql).query(1);
        if (r.next()) {
            throw Message.getSQLException(23002, this.getShortDescription());
        }
    }
}

